/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionListener;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.profile.IDPCache;

public class IDPSessionListener
implements SessionListener {
    public void sessionInvalidated(Object session) {
        block10: {
            String classMethod = "IDPSessionListener.sessionInvalidated: ";
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "Entering ...");
            }
            if (session == null) {
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message(classMethod + "Session is null.");
                }
                return;
            }
            try {
                SessionProvider sessionProvider = SessionManager.getProvider();
                String[] values = sessionProvider.getProperty(session, "SAML2IDPSessionIndex");
                if (values == null || values.length == 0) {
                    if (SAML2Utils.debug.messageEnabled()) {
                        SAML2Utils.debug.message(classMethod + "No sessionIndex stored in session.");
                    }
                    return;
                }
                String sessionIndex = values[0];
                if (sessionIndex == null || sessionIndex.length() == 0) {
                    if (SAML2Utils.debug.messageEnabled()) {
                        SAML2Utils.debug.message(classMethod + "No sessionIndex stored in session.");
                    }
                    return;
                }
                IDPCache.idpSessionsByIndices.remove(sessionIndex);
                IDPCache.authnContextCache.remove(sessionIndex);
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message(classMethod + "cleaned up the IDP session cache for a session" + " expiring or being destroyed: sessionIndex=" + sessionIndex);
                }
            }
            catch (SessionException e) {
                if (!SAML2Utils.debug.warningEnabled()) break block10;
                SAML2Utils.debug.warning(classMethod + "invalid or expired session.", (Throwable)((Object)e));
            }
        }
    }
}

