/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustDescriptor;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.multiprotocol.MultiProtocolUtils;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.assertion.AttributeStatement;
import com.sun.identity.saml2.assertion.AudienceRestriction;
import com.sun.identity.saml2.assertion.AuthnContext;
import com.sun.identity.saml2.assertion.AuthnStatement;
import com.sun.identity.saml2.assertion.Conditions;
import com.sun.identity.saml2.assertion.EncryptedAssertion;
import com.sun.identity.saml2.assertion.EncryptedAttribute;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.assertion.Subject;
import com.sun.identity.saml2.assertion.SubjectConfirmation;
import com.sun.identity.saml2.assertion.SubjectConfirmationData;
import com.sun.identity.saml2.common.AccountUtils;
import com.sun.identity.saml2.common.NameIDInfo;
import com.sun.identity.saml2.common.NewBoolean;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.ecp.ECPFactory;
import com.sun.identity.saml2.ecp.ECPResponse;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.jaxb.metadata.AffiliationDescriptorType;
import com.sun.identity.saml2.jaxb.metadata.ArtifactResolutionServiceElement;
import com.sun.identity.saml2.jaxb.metadata.AssertionConsumerServiceElement;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.key.EncInfo;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.plugins.IDPAccountMapper;
import com.sun.identity.saml2.plugins.IDPAttributeMapper;
import com.sun.identity.saml2.plugins.IDPAuthnContextInfo;
import com.sun.identity.saml2.plugins.IDPAuthnContextMapper;
import com.sun.identity.saml2.plugins.IDPECPSessionMapper;
import com.sun.identity.saml2.profile.DiscoveryBootstrap;
import com.sun.identity.saml2.profile.DoManageNameID;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.IDPSession;
import com.sun.identity.saml2.profile.IDPSessionCopy;
import com.sun.identity.saml2.profile.IDPSessionListener;
import com.sun.identity.saml2.profile.NameIDandSPpair;
import com.sun.identity.saml2.protocol.Artifact;
import com.sun.identity.saml2.protocol.AuthnRequest;
import com.sun.identity.saml2.protocol.NameIDPolicy;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.Response;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.saml2.protocol.StatusCode;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPMessage;

public class IDPSSOUtil {
    public static final String NAMEID_FORMAT = "SAML2NameIDFormat";
    public static final String NULL = "null";
    public static SAML2MetaManager metaManager = null;
    public static CircleOfTrustManager cotManager = null;
    static IDPSessionListener sessionListener = new IDPSessionListener();
    static SessionProvider sessionProvider = null;

    public static void doSSOFederate(HttpServletRequest request, HttpServletResponse response, AuthnRequest authnReq, String spEntityID, String idpMetaAlias, String nameIDFormat, String relayState) throws SAML2Exception {
        IDPSSOUtil.doSSOFederate(request, response, authnReq, spEntityID, idpMetaAlias, nameIDFormat, relayState, null);
    }

    public static void doSSOFederate(HttpServletRequest request, HttpServletResponse response, AuthnRequest authnReq, String spEntityID, String idpMetaAlias, String nameIDFormat, String relayState, Object newSession) throws SAML2Exception {
        Object session;
        String classMethod;
        block17: {
            classMethod = "IDPSSOUtil.doSSOFederate: ";
            session = null;
            if (newSession != null) {
                session = newSession;
            } else {
                try {
                    session = sessionProvider.getSession(request);
                }
                catch (SessionException se) {
                    if (!SAML2Utils.debug.warningEnabled()) break block17;
                    SAML2Utils.debug.warning(classMethod + "No session yet.");
                }
            }
        }
        String authnRequestStr = null;
        if (authnReq != null) {
            authnRequestStr = authnReq.toXMLString();
        }
        String[] logdata = new String[]{spEntityID, idpMetaAlias, authnRequestStr};
        LogUtil.access(Level.INFO, "RECEIVED_AUTHN_REQUEST", logdata, session);
        String idpEntityID = null;
        String realm = null;
        try {
            if (metaManager == null) {
                SAML2Utils.debug.error(classMethod + "Unable to get meta manager.");
                throw new SAML2Exception(SAML2Utils.bundle.getString("errorMetaManager"));
            }
            idpEntityID = metaManager.getEntityByMetaAlias(idpMetaAlias);
            if (idpEntityID == null || idpEntityID.trim().length() == 0) {
                SAML2Utils.debug.error(classMethod + "Unable to get IDP Entity ID from meta.");
                String[] data = new String[]{idpEntityID};
                LogUtil.error(Level.INFO, "INVALID_IDP", data, session);
                throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            }
            realm = SAML2MetaUtils.getRealmByMetaAlias(idpMetaAlias);
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error(classMethod + "Unable to get IDP Entity ID from meta.");
            String[] data = new String[]{idpMetaAlias};
            LogUtil.error(Level.INFO, "IDP_METADATA_ERROR", data, session);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        if (authnReq == null) {
            Issuer issuer = AssertionFactory.getInstance().createIssuer();
            issuer.setValue(spEntityID);
            if (!SAML2Utils.isSourceSiteValid(issuer, realm, idpEntityID)) {
                if (SAML2Utils.debug.warningEnabled()) {
                    SAML2Utils.debug.warning(classMethod + "The remote provider is not valid.");
                }
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidReceiver"));
            }
        }
        if (authnReq == null && session == null) {
            try {
                IDPSSOUtil.redirectAuthentication(request, response, authnReq, null, realm, idpEntityID);
            }
            catch (IOException ioe) {
                SAML2Utils.debug.error(classMethod + "Unable to redirect to authentication.", (Throwable)ioe);
                try {
                    response.sendError(500, SAML2Utils.bundle.getString("UnableToRedirectToAuth"));
                }
                catch (IOException ie) {
                    SAML2Utils.debug.error(classMethod + "I/O error", (Throwable)ie);
                }
            }
            return;
        }
        IDPSSOUtil.sendResponseToACS(request, response, session, authnReq, spEntityID, idpEntityID, idpMetaAlias, realm, nameIDFormat, relayState);
    }

    public static void sendResponseToACS(HttpServletRequest request, HttpServletResponse response, Object session, AuthnRequest authnReq, String spEntityID, String idpEntityID, String idpMetaAlias, String realm, String nameIDFormat, String relayState) throws SAML2Exception {
        StringBuffer returnedBinding = new StringBuffer();
        String acsURL = IDPSSOUtil.getACSurl(spEntityID, realm, authnReq, request, returnedBinding);
        String acsBinding = returnedBinding.toString();
        if (acsURL == null || acsURL.trim().length() == 0) {
            SAML2Utils.debug.error("IDPSSOUtil.sendResponseToACS: no ACS URL found.");
            String[] data = new String[]{idpMetaAlias};
            LogUtil.error(Level.INFO, "NO_ACS_URL", data, session);
            throw new SAML2Exception(SAML2Utils.bundle.getString("UnableTofindACSURL"));
        }
        if (acsBinding == null || acsBinding.trim().length() == 0) {
            SAML2Utils.debug.error("IDPSSOUtil.sendResponseToACS: no return binding found.");
            String[] data = new String[]{idpMetaAlias};
            LogUtil.error(Level.INFO, "NO_RETURN_BINDING", data, session);
            throw new SAML2Exception(SAML2Utils.bundle.getString("UnableTofindBinding"));
        }
        String affiliationID = request.getParameter("affiliationID");
        Response res = IDPSSOUtil.getResponse(session, authnReq, spEntityID, idpEntityID, realm, nameIDFormat, acsURL, affiliationID);
        if (res == null) {
            SAML2Utils.debug.error("IDPSSOUtil.sendResponseToACS: response is null");
            String errorMsg = SAML2Utils.bundle.getString("UnableToCreateAssertion");
            if (authnReq == null) {
                throw new SAML2Exception(errorMsg);
            }
            res = SAML2Utils.getErrorResponse(authnReq, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, errorMsg, idpEntityID);
        } else {
            try {
                String[] values = new String[]{idpMetaAlias};
                sessionProvider.setProperty(session, "IDPMetaAlias", values);
            }
            catch (SessionException e) {
                SAML2Utils.debug.error("IDPSSOUtil.sendResponseToACS: error setting idpMetaAlias into the session: ", (Throwable)((Object)e));
            }
        }
        if (res != null) {
            MultiProtocolUtils.addFederationProtocol(session, "saml2");
            if (IDPSSOUtil.setCOTCookie(request, response, acsBinding, spEntityID, idpEntityID, idpMetaAlias, realm, relayState, acsURL, res, session)) {
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("IDPSSOUtil.sendResponseToACS: Redirected to set COT cookie.");
                }
                return;
            }
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("IDPSSOUtil.sendResponseToACS: Doesn't set COT cookie.");
                SAML2Utils.debug.message("IDPSSOUtil.sendResponseToACS: Response is:  " + res.toXMLString());
            }
        } else {
            SAML2Utils.debug.error("IDPSSOUtil.sendResponseToACS: error response is null");
            throw new SAML2Exception(SAML2Utils.bundle.getString("UnableToCreateErrorResponse"));
        }
        IDPSSOUtil.sendResponse(response, acsBinding, spEntityID, idpEntityID, idpMetaAlias, realm, relayState, acsURL, res, session);
    }

    private static boolean setCOTCookie(HttpServletRequest request, HttpServletResponse response, String acsBinding, String spEntityID, String idpEntityID, String idpMetaAlias, String realm, String relayState, String acsURL, Response res, Object session) {
        String classMethod = "IDPSSOUtil.setCOTCookie: ";
        String writerURL = IDPSSOUtil.getWriterURL(realm, idpEntityID, spEntityID);
        if (writerURL == null) {
            return false;
        }
        ArrayList<Object> cacheList = new ArrayList<Object>(9);
        cacheList.add(0, acsBinding);
        cacheList.add(1, spEntityID);
        cacheList.add(2, idpEntityID);
        cacheList.add(3, idpMetaAlias);
        cacheList.add(4, realm);
        cacheList.add(5, relayState);
        cacheList.add(6, acsURL);
        cacheList.add(7, res);
        cacheList.add(8, session);
        String cachedResID = SAML2Utils.generateIDWithServerID();
        IDPCache.responseCache.put((Object)cachedResID, cacheList);
        StringBuffer retURLSB = new StringBuffer(100);
        retURLSB.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(request.getRequestURI()).append("?").append("resInfoID").append("=").append(cachedResID);
        String retURL = URLEncDec.encode((String)retURLSB.toString());
        StringBuffer redirectURLSB = new StringBuffer(200);
        redirectURLSB.append(writerURL);
        if (writerURL.indexOf("?") > 0) {
            redirectURLSB.append("&");
        } else {
            redirectURLSB.append("?");
        }
        redirectURLSB.append("_saml_idp").append("=").append(idpEntityID).append("&").append("RelayState").append("=").append(retURL);
        String redirectURL = redirectURLSB.toString();
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "Writer redirect URL: " + redirectURL);
        }
        try {
            response.sendRedirect(redirectURL);
            return true;
        }
        catch (IOException ioe) {
            SAML2Utils.debug.error(classMethod + "Unable to send redirect: ", (Throwable)ioe);
            return false;
        }
    }

    public static void sendResponse(HttpServletResponse response, String cachedResID) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.sendResponse: ";
        ArrayList cacheList = (ArrayList)IDPCache.responseCache.remove((Object)cachedResID);
        if (cacheList == null || cacheList.size() != 9) {
            SAML2Utils.debug.error(classMethod + "unable to get response information from cache.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("UnableToGetResponseInfoFromCache"));
        }
        String acsBinding = (String)cacheList.get(0);
        String spEntityID = (String)cacheList.get(1);
        String idpEntityID = (String)cacheList.get(2);
        String idpMetaAlias = (String)cacheList.get(3);
        String realm = (String)cacheList.get(4);
        String relayState = (String)cacheList.get(5);
        String acsURL = (String)cacheList.get(6);
        Response res = (Response)cacheList.get(7);
        Object session = cacheList.get(8);
        IDPSSOUtil.sendResponse(response, acsBinding, spEntityID, idpEntityID, idpMetaAlias, realm, relayState, acsURL, res, session);
    }

    public static void sendResponse(HttpServletResponse response, String acsBinding, String spEntityID, String idpEntityID, String idpMetaAlias, String realm, String relayState, String acsURL, Response res, Object session) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.sendResponse: ";
        String nameIDString = SAML2Utils.getNameIDStringFromResponse(res);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("NameID", nameIDString);
        if (acsBinding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            IDPSSOUtil.signAndEncryptResponseComponents(realm, spEntityID, idpEntityID, res, true);
            String resMsg = res.toXMLString(true, true);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "SAML Response content :\n" + resMsg);
            }
            String encodedResMsg = SAML2Utils.encodeForPOST(resMsg);
            String[] logdata1 = new String[]{spEntityID, idpMetaAlias, resMsg};
            LogUtil.access(Level.INFO, "POST_RESPONSE", logdata1, session, props);
            try {
                SAML2Utils.postToTarget(response, "SAMLResponse", encodedResMsg, "RelayState", relayState, acsURL);
            }
            catch (Exception e) {
                SAML2Utils.debug.error(classMethod + "postToTarget failed.", (Throwable)e);
                String[] data = new String[]{acsURL};
                LogUtil.error(Level.INFO, "POST_TO_TARGET_FAILED", data, session, props);
                throw new SAML2Exception(SAML2Utils.bundle.getString("postToTargetFailed"));
            }
        } else if (acsBinding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact")) {
            IDPSSOUtil.sendResponseArtifact(response, idpEntityID, spEntityID, realm, acsURL, relayState, res, session, props);
        } else if (acsBinding.equals("urn:oasis:names:tc:SAML:2.0:bindings:PAOS")) {
            IDPSSOUtil.signAndEncryptResponseComponents(realm, spEntityID, idpEntityID, res, true);
            IDPSSOUtil.sendResponseECP(response, idpEntityID, realm, acsURL, res);
        } else {
            SAML2Utils.debug.error(classMethod + "unsupported return binding.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("UnSupportedReturnBinding"));
        }
    }

    public static Response getResponse(Object session, AuthnRequest authnReq, String recipientEntityID, String idpEntityID, String realm, String nameIDFormat, String acsURL, String affiliationID) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.getResponse: ";
        Response res = ProtocolFactory.getInstance().createResponse();
        ArrayList<Assertion> assertionList = new ArrayList<Assertion>();
        Assertion assertion = IDPSSOUtil.getAssertion(session, authnReq, recipientEntityID, idpEntityID, realm, nameIDFormat, acsURL, affiliationID);
        if (assertion == null) {
            SAML2Utils.debug.error(classMethod + "Unable to get Assertion.");
            return null;
        }
        assertionList.add(assertion);
        res.setAssertion(assertionList);
        res.setID(SAML2Utils.generateID());
        if (authnReq != null) {
            res.setInResponseTo(authnReq.getID());
        }
        res.setVersion("2.0");
        res.setIssueInstant(new Date());
        Status status = ProtocolFactory.getInstance().createStatus();
        if (status == null) {
            return null;
        }
        StatusCode statusCode = ProtocolFactory.getInstance().createStatusCode();
        if (statusCode == null) {
            return null;
        }
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        status.setStatusCode(statusCode);
        res.setStatus(status);
        Issuer issuer = AssertionFactory.getInstance().createIssuer();
        issuer.setValue(idpEntityID);
        res.setIssuer(issuer);
        res.setDestination(acsURL);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Assertion getAssertion(Object session, AuthnRequest authnReq, String recipientEntityID, String idpEntityID, String realm, String nameIDFormat, String acsURL, String affiliationID) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.getAssertion: ";
        Assertion assertion = AssertionFactory.getInstance().createAssertion();
        assertion.setID(SAML2Utils.generateID());
        assertion.setVersion("2.0");
        assertion.setIssueInstant(new Date());
        Issuer issuer = AssertionFactory.getInstance().createIssuer();
        issuer.setValue(idpEntityID);
        assertion.setIssuer(issuer);
        ArrayList<AuthnStatement> statementList = new ArrayList<AuthnStatement>();
        NewBoolean isNewSessionIndex = new NewBoolean();
        AuthnStatement authnStatement = IDPSSOUtil.getAuthnStatement(session, isNewSessionIndex, authnReq, idpEntityID, realm);
        if (authnStatement == null) {
            return null;
        }
        String sessionIndex = authnStatement.getSessionIndex();
        IDPSession idpSession = null;
        if (isNewSessionIndex.getValue()) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "This is a new IDP session with sessionIndex=" + sessionIndex + ", and sessionID=" + sessionProvider.getSessionID(session));
            }
            if ((idpSession = (IDPSession)IDPCache.idpSessionsBySessionID.get(sessionProvider.getSessionID(session))) == null) {
                idpSession = new IDPSession(session);
            }
            IDPCache.idpSessionsByIndices.put(sessionIndex, idpSession);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "a new IDP session has been saved in cache, " + "with sessionIndex=" + sessionIndex);
            }
            try {
                sessionProvider.addListener(session, sessionListener);
            }
            catch (SessionException e) {
                SAML2Utils.debug.error(classMethod + "Unable to add session listener.");
            }
        } else {
            idpSession = (IDPSession)IDPCache.idpSessionsByIndices.get(sessionIndex);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "This is an existing IDP session with sessionIndex=" + sessionIndex + ", and sessionID=" + sessionProvider.getSessionID(idpSession.getSession()));
            }
        }
        statementList.add(authnStatement);
        AttributeStatement attrStatement = IDPSSOUtil.getAttributeStatement(session, idpEntityID, recipientEntityID, realm);
        if (attrStatement != null) {
            ArrayList<AttributeStatement> attrStatementList = new ArrayList<AttributeStatement>();
            attrStatementList.add(attrStatement);
            assertion.setAttributeStatements(attrStatementList);
        }
        int effectiveTime = IDPSSOUtil.getEffectiveTime(realm, idpEntityID);
        int notBeforeSkewTime = IDPSSOUtil.getNotBeforeSkewTime(realm, idpEntityID);
        NewBoolean isNewFederation = new NewBoolean();
        Subject subject = IDPSSOUtil.getSubject(session, authnReq, acsURL, nameIDFormat, isNewFederation, realm, idpEntityID, recipientEntityID, effectiveTime, affiliationID);
        String spEntityID = null;
        spEntityID = authnReq != null ? authnReq.getIssuer().getValue() : recipientEntityID;
        NameIDandSPpair pair = new NameIDandSPpair(subject.getNameID(), spEntityID);
        Hashtable hashtable = IDPCache.idpSessionsByIndices;
        synchronized (hashtable) {
            List list = idpSession.getNameIDandSPpairs();
            if (isNewFederation.getValue()) {
                list.add(pair);
            } else {
                String id = null;
                id = authnReq != null ? authnReq.getIssuer().getValue() : spEntityID;
                int n = list.size();
                NameIDandSPpair p = null;
                for (int i = 0; i < n && !(p = (NameIDandSPpair)list.get(i)).getSPEntityID().equals(id); ++i) {
                    p = null;
                }
                if (p == null) {
                    list.add(pair);
                }
            }
        }
        assertion.setAuthnStatements(statementList);
        assertion.setSubject(subject);
        Conditions conditions = IDPSSOUtil.getConditions(recipientEntityID, notBeforeSkewTime, effectiveTime);
        assertion.setConditions(conditions);
        String discoBootstrapEnabled = IDPSSOUtil.getAttributeValueFromIDPSSOConfig(realm, idpEntityID, "discoveryBootstrappingEnabled");
        if (discoBootstrapEnabled != null && discoBootstrapEnabled.equalsIgnoreCase("true")) {
            ArrayList<AttributeStatement> attrStatementList = assertion.getAttributeStatements();
            if (attrStatementList == null) {
                attrStatementList = new ArrayList<AttributeStatement>();
                assertion.setAttributeStatements(attrStatementList);
            }
            DiscoveryBootstrap bootstrap = new DiscoveryBootstrap(session, subject, authnStatement.getAuthnContext().getAuthnContextClassRef(), spEntityID, realm);
            attrStatementList.add(bootstrap.getBootstrapStatement());
            assertion.setAdvice(bootstrap.getCredentials());
        }
        if (IDPSSOUtil.assertionCacheEnabled(realm, idpEntityID)) {
            Object object;
            String userName = null;
            try {
                userName = sessionProvider.getPrincipalName(session);
            }
            catch (SessionException se) {
                SAML2Utils.debug.error(classMethod + "Unable to get principal name from the session.", (Throwable)((Object)se));
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSSOToken"));
            }
            ArrayList<Assertion> assertions = (ArrayList<Assertion>)IDPCache.assertionCache.get((Object)userName);
            if (assertions == null) {
                object = IDPCache.assertionCache;
                synchronized (object) {
                    assertions = (List)IDPCache.assertionCache.get((Object)userName);
                    if (assertions == null) {
                        assertions = new ArrayList<Assertion>();
                        IDPCache.assertionCache.put((Object)userName, assertions);
                    }
                }
            }
            object = assertions;
            synchronized (object) {
                assertions.add(assertion);
            }
            IDPCache.assertionByIDCache.put((Object)assertion.getID(), (Object)assertion);
        }
        try {
            long sessionExpireTime = System.currentTimeMillis() + sessionProvider.getTimeLeft(session) * 1000L;
            if (SAML2Utils.failOver) {
                SAML2Utils.jmq.save(sessionIndex, new IDPSessionCopy((IDPSession)IDPCache.idpSessionsByIndices.get(sessionIndex)), sessionExpireTime);
            }
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SAVE IDPSession!");
            }
        }
        catch (Exception e) {
            SAML2Utils.debug.error("DB error!");
        }
        return assertion;
    }

    private static AuthnStatement getAuthnStatement(Object session, NewBoolean isNewSessionIndex, AuthnRequest authnReq, String idpEntityID, String realm) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.getAuthnStatement: ";
        AuthnStatement authnStatement = AssertionFactory.getInstance().createAuthnStatement();
        Date authInstant = null;
        try {
            String[] values = sessionProvider.getProperty(session, "authInstant");
            if (values != null && values.length != 0 && values[0] != null && values[0].length() != 0) {
                authInstant = DateUtils.stringToDate((String)values[0]);
            }
        }
        catch (Exception e) {
            SAML2Utils.debug.error(classMethod + "exception retrieving info from the session: ", (Throwable)e);
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorGettingAuthnStatement"));
        }
        if (authInstant == null) {
            authInstant = new Date();
        }
        authnStatement.setAuthnInstant(authInstant);
        String authLevel = null;
        try {
            String[] values = sessionProvider.getProperty(session, "AuthLevel");
            if (values != null && values.length != 0 && values[0] != null && values[0].length() != 0) {
                authLevel = values[0];
            }
        }
        catch (Exception e) {
            SAML2Utils.debug.error(classMethod + "exception retrieving auth level info from the session: ", (Throwable)e);
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorGettingAuthnStatement"));
        }
        IDPAuthnContextMapper idpAuthnContextMapper = IDPSSOUtil.getIDPAuthnContextMapper(realm, idpEntityID);
        AuthnContext authnContext = idpAuthnContextMapper.getAuthnContextFromAuthLevel(authLevel, realm, idpEntityID);
        authnStatement.setAuthnContext(authnContext);
        String sessionIndex = IDPSSOUtil.getSessionIndex(session);
        if (sessionIndex == null) {
            sessionIndex = SAML2Utils.generateIDWithServerID();
            try {
                String[] values = new String[]{sessionIndex};
                sessionProvider.setProperty(session, "SAML2IDPSessionIndex", values);
            }
            catch (SessionException e) {
                SAML2Utils.debug.error(classMethod + "error setting session index into the session: ", (Throwable)((Object)e));
                throw new SAML2Exception(SAML2Utils.bundle.getString("errorGettingAuthnStatement"));
            }
            isNewSessionIndex.setValue(true);
        } else {
            isNewSessionIndex.setValue(false);
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "SessionIndex (in AuthnStatement) =" + sessionIndex);
        }
        if (sessionIndex != null) {
            HashSet<AuthnContext> authContextSet = (HashSet<AuthnContext>)IDPCache.authnContextCache.get(sessionIndex);
            if (authContextSet == null || authContextSet.isEmpty()) {
                authContextSet = new HashSet<AuthnContext>();
            }
            authContextSet.add(authnContext);
            IDPCache.authnContextCache.put(sessionIndex, authContextSet);
            authnStatement.setSessionIndex(sessionIndex);
        }
        return authnStatement;
    }

    private static AttributeStatement getAttributeStatement(Object session, String idpEntityID, String recipientEntityID, String realm) throws SAML2Exception {
        IDPAttributeMapper idpAttrMapper = IDPSSOUtil.getIDPAttributeMapper(realm, idpEntityID);
        List attributes = idpAttrMapper.getAttributes(session, idpEntityID, recipientEntityID, realm);
        if (attributes == null || attributes.isEmpty()) {
            return null;
        }
        AttributeStatement attrStatement = AssertionFactory.getInstance().createAttributeStatement();
        attrStatement.setAttribute(attributes);
        return attrStatement;
    }

    static IDPAttributeMapper getIDPAttributeMapper(String realm, String idpEntityID) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.getIDPAttributeMapper: ";
        String idpAttributeMapperName = null;
        IDPAttributeMapper idpAttributeMapper = null;
        try {
            idpAttributeMapperName = IDPSSOUtil.getAttributeValueFromIDPSSOConfig(realm, idpEntityID, "idpAttributeMapper");
            if (idpAttributeMapperName == null) {
                idpAttributeMapperName = "com.sun.identity.saml2.plugins.DefaultIDPAttributeMapper";
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message(classMethod + "use " + "com.sun.identity.saml2.plugins.DefaultIDPAttributeMapper");
                }
            }
            if ((idpAttributeMapper = (IDPAttributeMapper)IDPCache.idpAttributeMapperCache.get(idpAttributeMapperName)) == null) {
                idpAttributeMapper = (IDPAttributeMapper)Class.forName(idpAttributeMapperName).newInstance();
                IDPCache.idpAttributeMapperCache.put(idpAttributeMapperName, idpAttributeMapper);
            } else if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "got the IDPAttributeMapper from cache");
            }
        }
        catch (Exception ex) {
            SAML2Utils.debug.error(classMethod + "Unable to get IDP Attribute Mapper.", (Throwable)ex);
            throw new SAML2Exception(ex);
        }
        return idpAttributeMapper;
    }

    static IDPAuthnContextMapper getIDPAuthnContextMapper(String realm, String idpEntityID) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.getIDPAuthnContextMapper: ";
        String idpAuthnContextMapperName = null;
        IDPAuthnContextMapper idpAuthnContextMapper = null;
        try {
            idpAuthnContextMapperName = IDPSSOUtil.getAttributeValueFromIDPSSOConfig(realm, idpEntityID, "idpAuthncontextMapper");
            if (idpAuthnContextMapperName == null) {
                idpAuthnContextMapperName = "com.sun.identity.saml2.plugins.DefaultIDPAuthnContextMapper";
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message(classMethod + "use " + "com.sun.identity.saml2.plugins.DefaultIDPAuthnContextMapper");
                }
            }
            if ((idpAuthnContextMapper = (IDPAuthnContextMapper)IDPCache.idpAuthnContextMapperCache.get(idpAuthnContextMapperName)) == null) {
                idpAuthnContextMapper = (IDPAuthnContextMapper)Class.forName(idpAuthnContextMapperName).newInstance();
                IDPCache.idpAuthnContextMapperCache.put(idpAuthnContextMapperName, idpAuthnContextMapper);
            } else if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "got the IDPAuthnContextMapper from cache");
            }
        }
        catch (Exception ex) {
            SAML2Utils.debug.error(classMethod + "Unable to get IDP AuthnContext Mapper.", (Throwable)ex);
            throw new SAML2Exception(ex);
        }
        return idpAuthnContextMapper;
    }

    static IDPECPSessionMapper getIDPECPSessionMapper(String realm, String idpEntityID) throws SAML2Exception {
        String idpECPSessionMapperName = null;
        IDPECPSessionMapper idpECPSessionMapper = null;
        try {
            idpECPSessionMapperName = IDPSSOUtil.getAttributeValueFromIDPSSOConfig(realm, idpEntityID, "idpECPSessionMapper");
            if (idpECPSessionMapperName == null) {
                idpECPSessionMapperName = "com.sun.identity.saml2.plugins.DefaultIDPECPSessionMapper";
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("IDPSSOUtil.getIDPECPSessionMapper: use com.sun.identity.saml2.plugins.DefaultIDPECPSessionMapper");
                }
            }
            if ((idpECPSessionMapper = (IDPECPSessionMapper)IDPCache.idpECPSessionMapperCache.get(idpECPSessionMapperName)) == null) {
                idpECPSessionMapper = (IDPECPSessionMapper)Class.forName(idpECPSessionMapperName).newInstance();
                IDPCache.idpECPSessionMapperCache.put(idpECPSessionMapperName, idpECPSessionMapper);
            } else if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("IDPSSOUtil.getIDPECPSessionMapper: got the IDPECPSessionMapper from cache");
            }
        }
        catch (Exception ex) {
            SAML2Utils.debug.error("IDPSSOUtil.getIDPECPSessionMapper: Unable to get IDPECPSessionMapper.", (Throwable)ex);
            throw new SAML2Exception(ex);
        }
        return idpECPSessionMapper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Subject getSubject(Object session, AuthnRequest authnReq, String acsURL, String nameIDFormat, NewBoolean isNewFederation, String realm, String idpEntityID, String recipientEntityID, int effectiveTime, String affiliationID) throws SAML2Exception {
        SubjectConfirmation sc;
        SPSSODescriptorElement spsso;
        String classMethod = "IDPSSOUtil.getSubject: ";
        Subject subject = AssertionFactory.getInstance().createSubject();
        String userName = null;
        try {
            userName = sessionProvider.getPrincipalName(session);
        }
        catch (SessionException se) {
            SAML2Utils.debug.error(classMethod + "Unable to get principal name from the session.", (Throwable)((Object)se));
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSSOToken"));
        }
        boolean allowCreate = true;
        String remoteEntityID = null;
        String spNameQualifier = null;
        boolean isAffiliation = false;
        if (authnReq != null) {
            remoteEntityID = authnReq.getIssuer().getValue();
            NameIDPolicy nameIDPolicy = authnReq.getNameIDPolicy();
            if (nameIDPolicy != null) {
                AffiliationDescriptorType affiDesc;
                allowCreate = nameIDPolicy.isAllowCreate();
                spNameQualifier = nameIDPolicy.getSPNameQualifier();
                if (spNameQualifier != null && (affiDesc = metaManager.getAffiliationDescriptor(realm, spNameQualifier)) != null) {
                    if (!affiDesc.getAffiliateMember().contains(remoteEntityID)) throw new SAML2Exception(SAML2Utils.bundle.getString("spNotAffiliationMember"));
                    isAffiliation = true;
                    remoteEntityID = spNameQualifier;
                }
            }
        } else if (affiliationID != null) {
            AffiliationDescriptorType affiDesc = metaManager.getAffiliationDescriptor(realm, affiliationID);
            if (affiDesc == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("affiliationNotFound"));
            }
            if (!affiDesc.getAffiliateMember().contains(recipientEntityID)) throw new SAML2Exception(SAML2Utils.bundle.getString("spNotAffiliationMember"));
            isAffiliation = true;
            remoteEntityID = affiliationID;
            spNameQualifier = affiliationID;
        } else {
            remoteEntityID = recipientEntityID;
            spNameQualifier = recipientEntityID;
        }
        if ((spsso = metaManager.getSPSSODescriptor(realm, recipientEntityID)) == null) {
            String[] data = new String[]{recipientEntityID};
            LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        IDPSSODescriptorElement idpsso = metaManager.getIDPSSODescriptor(realm, idpEntityID);
        if (idpsso == null) {
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "IDP_METADATA_ERROR", data, null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        nameIDFormat = SAML2Utils.verifyNameIDFormat(nameIDFormat, spsso, idpsso);
        NameIDInfo nameIDInfo = null;
        NameID nameID = null;
        boolean isTransient = nameIDFormat.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        if (!isTransient) {
            String userID = null;
            try {
                userID = sessionProvider.getPrincipalName(session);
            }
            catch (SessionException se) {
                SAML2Utils.debug.error(classMethod + "Unable to get principal name from the session.", (Throwable)((Object)se));
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSSOToken"));
            }
            nameIDInfo = AccountUtils.getAccountFederation(userID, idpEntityID, remoteEntityID);
            if (nameIDInfo != null) {
                nameID = nameIDInfo.getNameID();
                if (nameIDFormat.equals(nameID.getFormat())) {
                    isNewFederation.setValue(false);
                } else {
                    AccountUtils.removeAccountFederation(nameIDInfo, userID);
                    DoManageNameID.removeIDPFedSession(remoteEntityID);
                    nameID = null;
                }
            }
        }
        if (nameID == null) {
            IDPAccountMapper idpAccountMapper = SAML2Utils.getIDPAccountMapper(realm, idpEntityID);
            nameID = idpAccountMapper.getNameID(session, idpEntityID, spNameQualifier, realm, nameIDFormat);
            if (!isTransient && allowCreate) {
                nameIDInfo = SAML2Utils.isDualRole(idpEntityID, realm) ? new NameIDInfo(idpEntityID, remoteEntityID, nameID, "DualRole", false) : new NameIDInfo(idpEntityID, remoteEntityID, nameID, "IDPRole", isAffiliation);
                AccountUtils.setAccountFederation(nameIDInfo, userName);
            }
            if (!isTransient) {
                isNewFederation.setValue(true);
            } else {
                isNewFederation.setValue(false);
            }
        }
        subject.setNameID(nameID);
        String inResponseTo = null;
        if (authnReq != null) {
            inResponseTo = authnReq.getID();
        }
        if ((sc = IDPSSOUtil.getSubjectConfirmation(inResponseTo, acsURL, effectiveTime)) == null) {
            SAML2Utils.debug.error(classMethod + "Unable to get subject confirmation");
            throw new SAML2Exception(SAML2Utils.bundle.getString("noSubjectConfirmation"));
        }
        ArrayList<SubjectConfirmation> list = new ArrayList<SubjectConfirmation>();
        list.add(sc);
        subject.setSubjectConfirmation(list);
        return subject;
    }

    private static SubjectConfirmation getSubjectConfirmation(String inResponseTo, String acsURL, int effectiveTime) throws SAML2Exception {
        SubjectConfirmation sc = AssertionFactory.getInstance().createSubjectConfirmation();
        sc.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SubjectConfirmationData scd = AssertionFactory.getInstance().createSubjectConfirmationData();
        scd.setRecipient(acsURL);
        if (inResponseTo != null) {
            scd.setInResponseTo(inResponseTo);
        }
        Date date = new Date();
        date.setTime(date.getTime() + (long)(effectiveTime * 1000));
        scd.setNotOnOrAfter(date);
        sc.setSubjectConfirmationData(scd);
        return sc;
    }

    protected static Conditions getConditions(String audienceEntityID, int notBeforeSkewTime, int effectiveTime) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.getConditions: ";
        Conditions conditions = AssertionFactory.getInstance().createConditions();
        Date date = new Date();
        date.setTime(date.getTime() - (long)(notBeforeSkewTime * 1000));
        conditions.setNotBefore(date);
        date = new Date();
        date.setTime(date.getTime() + (long)(effectiveTime * 1000));
        conditions.setNotOnOrAfter(date);
        ArrayList<AudienceRestriction> list = new ArrayList<AudienceRestriction>();
        AudienceRestriction ar = IDPSSOUtil.getAudienceRestriction(audienceEntityID);
        if (ar == null) {
            SAML2Utils.debug.error(classMethod + "Unable to get Audience Restriction");
            throw new SAML2Exception(SAML2Utils.bundle.getString("noAudienceRestriction"));
        }
        list.add(ar);
        conditions.setAudienceRestrictions(list);
        return conditions;
    }

    private static AudienceRestriction getAudienceRestriction(String audienceEntityID) throws SAML2Exception {
        AudienceRestriction ar = AssertionFactory.getInstance().createAudienceRestriction();
        if (audienceEntityID != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(audienceEntityID);
            ar.setAudience(list);
        }
        return ar;
    }

    public static String getACSurl(String spEntityID, String realm, AuthnRequest authnReq, HttpServletRequest request, StringBuffer rBinding) throws SAML2Exception {
        String acsURL = null;
        String acsBinding = null;
        if (authnReq != null) {
            acsURL = authnReq.getAssertionConsumerServiceURL();
            acsBinding = authnReq.getProtocolBinding();
        } else {
            acsBinding = request.getParameter("binding");
        }
        if (acsBinding != null && !acsBinding.startsWith("urn:oasis:names:tc:SAML:2.0:bindings:")) {
            acsBinding = "urn:oasis:names:tc:SAML:2.0:bindings:" + acsBinding;
        }
        if (acsURL == null || acsURL.length() == 0) {
            StringBuffer returnedBinding = new StringBuffer();
            if (acsBinding != null && acsBinding.trim().length() != 0) {
                acsURL = IDPSSOUtil.getACSurlFromMetaByBinding(spEntityID, realm, acsBinding, returnedBinding);
            } else {
                Integer acsIndexInteger;
                int acsIndex = 0;
                if (authnReq != null && ((acsIndex = (acsIndexInteger = authnReq.getAssertionConsumerServiceIndex()).intValue()) < 0 || acsIndex > 65535)) {
                    acsIndex = 0;
                }
                acsURL = IDPSSOUtil.getACSurlFromMetaByIndex(spEntityID, realm, acsIndex, returnedBinding);
            }
            acsBinding = returnedBinding.toString();
        }
        rBinding.append(acsBinding);
        return acsURL;
    }

    public static String getACSurlFromMetaByBinding(String spEntityID, String realm, String desiredBinding, StringBuffer returnedBinding) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.getACSurlFromMetaByBinding: ";
        SPSSODescriptorElement spSSODescriptorElement = null;
        if (metaManager == null) {
            SAML2Utils.debug.error(classMethod + "Unable to get meta manager.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorMetaManager"));
        }
        try {
            spSSODescriptorElement = metaManager.getSPSSODescriptor(realm, spEntityID);
            if (spSSODescriptorElement == null) {
                SAML2Utils.debug.error(classMethod + "Unable to get SP SSO Descriptor from meta.");
                String[] data = new String[]{spEntityID};
                LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            }
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error(classMethod + "Unable to get SP SSO Descriptor from meta.");
            String[] data = new String[]{spEntityID};
            LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        List acsList = spSSODescriptorElement.getAssertionConsumerService();
        String acsURL = null;
        String binding = null;
        String defaultAcsURL = null;
        String defaultBinding = null;
        String firstAcsURL = null;
        String firstBinding = null;
        AssertionConsumerServiceElement acs = null;
        for (int i = 0; i < acsList.size(); ++i) {
            acs = (AssertionConsumerServiceElement)acsList.get(i);
            binding = acs.getBinding();
            if (binding.equals(desiredBinding)) {
                acsURL = acs.getLocation();
                break;
            }
            if (acs.isIsDefault()) {
                defaultAcsURL = acs.getLocation();
                defaultBinding = acs.getBinding();
            }
            if (i != 0) continue;
            firstAcsURL = acs.getLocation();
            firstBinding = acs.getBinding();
        }
        if (acsURL == null || acsURL.length() == 0) {
            acsURL = defaultAcsURL;
            if (acsURL == null || acsURL.length() == 0) {
                acsURL = firstAcsURL;
                if (acsURL == null || acsURL.length() == 0) {
                    acsURL = null;
                    SAML2Utils.debug.error(classMethod + "Unable to get valid Assertion " + "Consumer Service URL");
                    return null;
                }
                returnedBinding.append(firstBinding);
            } else {
                returnedBinding.append(defaultBinding);
            }
        } else {
            returnedBinding.append(binding);
        }
        return acsURL;
    }

    public static String getACSurlFromMetaByIndex(String spEntityID, String realm, int acsIndex, StringBuffer returnedBinding) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.getACSurlFromMetaByIndex: ";
        SPSSODescriptorElement spSSODescriptorElement = null;
        if (metaManager == null) {
            SAML2Utils.debug.error(classMethod + "Unable to get meta manager.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorMetaManager"));
        }
        try {
            spSSODescriptorElement = metaManager.getSPSSODescriptor(realm, spEntityID);
            if (spSSODescriptorElement == null) {
                SAML2Utils.debug.error(classMethod + "Unable to get SP SSO Descriptor from meta.");
                String[] data = new String[]{spEntityID};
                LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            }
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error(classMethod + "Unable to get SP SSO Descriptor from meta.");
            String[] data = new String[]{spEntityID};
            LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        List acsList = spSSODescriptorElement.getAssertionConsumerService();
        String acsURL = null;
        String binding = null;
        String defaultAcsURL = null;
        String defaultBinding = null;
        String firstAcsURL = null;
        String firstBinding = null;
        AssertionConsumerServiceElement acs = null;
        for (int i = 0; i < acsList.size(); ++i) {
            acs = (AssertionConsumerServiceElement)acsList.get(i);
            int index = acs.getIndex();
            binding = acs.getBinding();
            if (index == acsIndex) {
                acsURL = acs.getLocation();
                binding = acs.getBinding();
                break;
            }
            if (acs.isIsDefault()) {
                defaultAcsURL = acs.getLocation();
                defaultBinding = acs.getBinding();
            }
            if (i != 0) continue;
            firstAcsURL = acs.getLocation();
            firstBinding = acs.getBinding();
        }
        if (acsURL == null || acsURL.length() == 0) {
            acsURL = defaultAcsURL;
            if (acsURL == null || acsURL.length() == 0) {
                acsURL = firstAcsURL;
                if (acsURL == null || acsURL.length() == 0) {
                    acsURL = null;
                    SAML2Utils.debug.error(classMethod + "Unable to get valid Assertion " + "Consumer Service URL");
                    return null;
                }
                returnedBinding.append(firstBinding);
            } else {
                returnedBinding.append(defaultBinding);
            }
        } else {
            returnedBinding.append(binding);
        }
        return acsURL;
    }

    public static void sendResponseArtifact(HttpServletResponse response, String idpEntityID, String spEntityID, String realm, String acsURL, String relayState, Response res, Object session, Map props) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.sendResponseArtifact: ";
        IDPSSODescriptorElement idpSSODescriptorElement = null;
        try {
            idpSSODescriptorElement = metaManager.getIDPSSODescriptor(realm, idpEntityID);
            if (idpSSODescriptorElement == null) {
                SAML2Utils.debug.error(classMethod + "Unable to get IDP SSO Descriptor from meta.");
                String[] data = new String[]{idpEntityID};
                LogUtil.error(Level.INFO, "IDP_METADATA_ERROR", data, session, props);
                throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            }
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error(classMethod + "Unable to get IDP SSO Descriptor from meta.");
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "IDP_METADATA_ERROR", data, session, props);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        ArtifactResolutionServiceElement ars = (ArtifactResolutionServiceElement)idpSSODescriptorElement.getArtifactResolutionService().get(0);
        if (ars == null) {
            SAML2Utils.debug.error(classMethod + "Unable to get ArtifactResolutionServiceElement from meta.");
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "IDP_METADATA_ERROR", data, session, props);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        Artifact art = null;
        try {
            art = ProtocolFactory.getInstance().createArtifact(null, ars.getIndex(), SAML2Utils.generateSourceID(idpEntityID), SAML2Utils.generateMessageHandleWithServerID());
        }
        catch (SAML2Exception se) {
            SAML2Utils.debug.error(classMethod + "Unable to create artifact: ", (Throwable)((Object)se));
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "CANNOT_CREATE_ARTIFACT", data, session, props);
            try {
                response.sendError(500, SAML2Utils.bundle.getString("errorCreateArtifact"));
            }
            catch (IOException ioe) {
                SAML2Utils.debug.error(classMethod + "I/O rrror", (Throwable)ioe);
            }
            return;
        }
        String artStr = art.getArtifactValue();
        try {
            IDPCache.responsesByArtifacts.put((Object)artStr, (Object)res);
            long expireTime = IDPSSOUtil.getValidTimeofResponse(realm, idpEntityID, res);
            if (SAML2Utils.failOver) {
                SAML2Utils.jmq.save(artStr, res.toXMLString(true, true), expireTime);
            }
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "Save Response to DB!");
            }
            String messageEncoding = SAML2Utils.getAttributeValueFromSSOConfig(realm, spEntityID, "SPRole", "responseArtifactMessageEncoding");
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "messageEncoding = " + messageEncoding);
                SAML2Utils.debug.message(classMethod + "artStr = " + artStr);
            }
            if (messageEncoding != null && messageEncoding.equals("FORM")) {
                String[] logdata = new String[]{idpEntityID, realm, acsURL};
                LogUtil.access(Level.INFO, "SEND_ARTIFACT", logdata, session, props);
                SAML2Utils.postToTarget(response, "SAMLart", artStr, "RelayState", relayState, acsURL);
            } else {
                String redirectURL = acsURL + "?SAMLart=" + URLEncDec.encode((String)artStr);
                if (relayState != null && relayState.trim().length() != 0) {
                    redirectURL = redirectURL + "&RelayState=" + URLEncDec.encode((String)relayState);
                }
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message(classMethod + "Redirect URL = " + redirectURL);
                }
                String[] logdata = new String[]{idpEntityID, realm, redirectURL};
                LogUtil.access(Level.INFO, "SEND_ARTIFACT", logdata, session, props);
                response.sendRedirect(redirectURL);
            }
        }
        catch (IOException ioe) {
            SAML2Utils.debug.error(classMethod + "Unable to send redirect: ", (Throwable)ioe);
        }
        catch (Exception e) {
            SAML2Utils.debug.error("DB Error!");
        }
    }

    public static void sendResponseECP(HttpServletResponse response, String idpEntityID, String realm, String acsURL, Response res) throws SAML2Exception {
        ECPFactory ecpFactory = ECPFactory.getInstance();
        ECPResponse ecpResponse = ecpFactory.createECPResponse();
        ecpResponse.setMustUnderstand(Boolean.TRUE);
        ecpResponse.setActor("http://schemas.xmlsoap.org/soap/actor/next");
        ecpResponse.setAssertionConsumerServiceURL(acsURL);
        String header = ecpResponse.toXMLString(true, true);
        String body = res.toXMLString(true, true);
        try {
            SOAPMessage reply = SAML2Utils.createSOAPMessage(header, body);
            String[] logdata = new String[]{idpEntityID, realm, acsURL, ""};
            if (LogUtil.isAccessLoggable(Level.FINE)) {
                logdata[3] = SAML2Utils.soapMessageToString(reply);
            }
            LogUtil.access(Level.INFO, "SEND_ECP_RESPONSE", logdata, null);
            if (reply.saveRequired()) {
                reply.saveChanges();
            }
            response.setStatus(200);
            SAML2Utils.putHeaders(reply.getMimeHeaders(), response);
            ServletOutputStream os = response.getOutputStream();
            reply.writeTo((OutputStream)os);
            os.flush();
        }
        catch (Exception ex) {
            SAML2Utils.debug.error("IDPSSOUtil.sendResponseECP", (Throwable)ex);
            String[] data = new String[]{idpEntityID, realm, acsURL};
            LogUtil.error(Level.INFO, "SEND_ECP_RESPONSE_FAILED", data, null);
            try {
                response.sendError(500, ex.getMessage());
            }
            catch (IOException ioex) {
                SAML2Utils.debug.error("IDPSSOUtil.sendResponseECP", (Throwable)ioex);
            }
        }
    }

    public static String getSessionIndex(Object session) {
        String classMethod = "IDPSSOUtil.getSessionIndex: ";
        if (session == null) {
            return null;
        }
        String[] values = null;
        try {
            values = sessionProvider.getProperty(session, "SAML2IDPSessionIndex");
        }
        catch (SessionException e) {
            SAML2Utils.debug.error(classMethod + "error retrieving session index from the session: ", (Throwable)((Object)e));
            values = null;
        }
        if (values == null || values.length == 0) {
            return null;
        }
        String index = values[0];
        if (index == null || index.length() == 0) {
            return null;
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "Returning sessionIndex=" + index);
        }
        return index;
    }

    public static String getAuthenticationServiceURL(String realm, String hostEntityId, HttpServletRequest request) {
        String classMethod = "IDPSSOUtil.getAuthenticationServiceURL: ";
        String authUrl = IDPSSOUtil.getAttributeValueFromIDPSSOConfig(realm, hostEntityId, "AuthUrl");
        if (authUrl == null || authUrl.trim().length() == 0) {
            String uri;
            String deploymentURI = uri = request.getRequestURI();
            int firstSlashIndex = uri.indexOf("/");
            int secondSlashIndex = uri.indexOf("/", firstSlashIndex + 1);
            if (secondSlashIndex != -1) {
                deploymentURI = uri.substring(0, secondSlashIndex);
            }
            StringBuffer sb = new StringBuffer(100);
            sb.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(deploymentURI).append("/UI/Login?realm=").append(realm);
            authUrl = sb.toString();
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "auth url=:" + authUrl);
        }
        return authUrl;
    }

    private static String getAttributeValueFromIDPSSOConfig(String realm, String hostEntityId, String attrName) {
        String classMethod = "IDPSSOUtil.getAttributeValueFromIDPSSOConfig: ";
        String result = null;
        try {
            IDPSSOConfigElement config = metaManager.getIDPSSOConfig(realm, hostEntityId);
            Map attrs = SAML2MetaUtils.getAttributes(config);
            List value = (List)attrs.get(attrName);
            if (value != null && value.size() != 0) {
                result = (String)value.get(0);
            }
        }
        catch (SAML2MetaException sme) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "get IDPSSOConfig failed:", (Throwable)((Object)sme));
            }
            result = null;
        }
        return result;
    }

    static void redirectAuthentication(HttpServletRequest request, HttpServletResponse response, AuthnRequest authnReq, String reqID, String realm, String idpEntityID) throws SAML2Exception, IOException {
        String classMethod = "IDPSSOUtil.redirectAuthentication: ";
        StringBuffer newURL = new StringBuffer(IDPSSOUtil.getAuthenticationServiceURL(realm, idpEntityID, request));
        IDPAuthnContextMapper idpAuthnContextMapper = IDPSSOUtil.getIDPAuthnContextMapper(realm, idpEntityID);
        IDPAuthnContextInfo info = idpAuthnContextMapper.getIDPAuthnContextInfo(authnReq, idpEntityID, realm);
        Set authnTypeAndValues = info.getAuthnTypeAndValues();
        if (authnTypeAndValues != null && !authnTypeAndValues.isEmpty()) {
            Iterator iter = authnTypeAndValues.iterator();
            StringBuffer authSB = new StringBuffer((String)iter.next());
            while (iter.hasNext()) {
                authSB.append("&");
                authSB.append((String)iter.next());
            }
            if (newURL.indexOf("?") == -1) {
                newURL.append("?");
            } else {
                newURL.append("&");
            }
            newURL.append(authSB.toString());
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "authString=" + authSB.toString());
            }
        }
        if (newURL.indexOf("?") == -1) {
            newURL.append("?goto=");
        } else {
            newURL.append("&goto=");
        }
        String gotoURL = request.getRequestURL().toString();
        String gotoQuery = request.getQueryString();
        if (gotoQuery != null) {
            gotoURL = gotoURL + "?" + gotoQuery;
            if (reqID != null) {
                gotoURL = gotoURL + "&ReqID=" + reqID;
            }
        } else if (reqID != null) {
            gotoURL = gotoURL + "?ReqID=" + reqID;
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "gotoURL=" + gotoURL);
        }
        newURL.append(URLEncDec.encode((String)gotoURL));
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "New URL for authentication: " + newURL.toString());
        }
        response.sendRedirect(newURL.toString());
    }

    static void signAssertion(String realm, String idpEntityID, Assertion assertion) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.signAssertion: ";
        KeyProvider kp = KeyUtil.getKeyProviderInstance();
        if (kp == null) {
            SAML2Utils.debug.error(classMethod + "Unable to get a key provider instance.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullKeyProvider"));
        }
        String idpSignCertAlias = SAML2Utils.getSigningCertAlias(realm, idpEntityID, "IDPRole");
        if (idpSignCertAlias == null) {
            SAML2Utils.debug.error(classMethod + "Unable to get the hosted IDP signing certificate alias.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
        assertion.sign(kp.getPrivateKey(idpSignCertAlias), kp.getX509Certificate(idpSignCertAlias));
    }

    static void signAndEncryptResponseComponents(String realm, String spEntityID, String idpEntityID, Response res, boolean signAssertion) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.signAndEncryptResponseComponents: ";
        boolean toEncryptAssertion = false;
        boolean toEncryptNameID = false;
        boolean toEncryptAttribute = false;
        if (res == null) {
            return;
        }
        List assertions = res.getAssertion();
        if (assertions == null || assertions.size() == 0) {
            return;
        }
        Assertion assertion = (Assertion)assertions.get(0);
        String wantAssertionEncrypted = SAML2Utils.getAttributeValueFromSSOConfig(realm, spEntityID, "SPRole", "wantAssertionEncrypted");
        boolean bl = toEncryptAssertion = wantAssertionEncrypted != null && wantAssertionEncrypted.equals("true");
        if (!toEncryptAssertion) {
            String wantNameIDEncrypted = SAML2Utils.getAttributeValueFromSSOConfig(realm, spEntityID, "SPRole", "wantNameIDEncrypted");
            toEncryptNameID = wantNameIDEncrypted != null && wantNameIDEncrypted.equals("true");
            String wantAttributeEncrypted = SAML2Utils.getAttributeValueFromSSOConfig(realm, spEntityID, "SPRole", "wantAttributeEncrypted");
            boolean bl2 = toEncryptAttribute = wantAttributeEncrypted != null && wantAttributeEncrypted.equals("true");
        }
        if (!(toEncryptAssertion || toEncryptNameID || toEncryptAttribute)) {
            if (signAssertion) {
                IDPSSOUtil.signAssertion(realm, idpEntityID, assertion);
                ArrayList<Assertion> assertionList = new ArrayList<Assertion>();
                assertionList.add(assertion);
                res.setAssertion(assertionList);
            }
            return;
        }
        SPSSODescriptorElement spSSODescriptorElement = null;
        if (metaManager == null) {
            SAML2Utils.debug.error(classMethod + "Unable to get meta manager.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorMetaManager"));
        }
        try {
            spSSODescriptorElement = metaManager.getSPSSODescriptor(realm, spEntityID);
            if (spSSODescriptorElement == null) {
                SAML2Utils.debug.error(classMethod + "Unable to get SP SSO Descriptor from meta.");
                String[] data = new String[]{spEntityID};
                LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            }
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error(classMethod + "Unable to get SP SSO Descriptor from meta.");
            String[] data = new String[]{spEntityID};
            LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        EncInfo encInfo = KeyUtil.getEncInfo(spSSODescriptorElement, spEntityID, "SPRole");
        if (encInfo == null) {
            SAML2Utils.debug.error(classMethod + "failed to get service provider encryption key info.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("UnableToFindEncryptKeyInfo"));
        }
        if (toEncryptAssertion) {
            EncryptedAssertion encryptedAssertion;
            if (signAssertion) {
                IDPSSOUtil.signAssertion(realm, idpEntityID, assertion);
            }
            if ((encryptedAssertion = assertion.encrypt(encInfo.getWrappingKey(), encInfo.getDataEncAlgorithm(), encInfo.getDataEncStrength(), spEntityID)) == null) {
                SAML2Utils.debug.error(classMethod + "failed to encrypt the assertion.");
                throw new SAML2Exception(SAML2Utils.bundle.getString("FailedToEncryptAssertion"));
            }
            ArrayList<EncryptedAssertion> assertionList = new ArrayList<EncryptedAssertion>();
            assertionList.add(encryptedAssertion);
            res.setEncryptedAssertion(assertionList);
            res.setAssertion(new ArrayList());
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "Assertion encrypted.");
            }
        } else {
            if (toEncryptNameID) {
                Subject subject = assertion.getSubject();
                if (subject == null) {
                    return;
                }
                NameID nameID = subject.getNameID();
                if (nameID == null) {
                    return;
                }
                EncryptedID encryptedNameID = nameID.encrypt(encInfo.getWrappingKey(), encInfo.getDataEncAlgorithm(), encInfo.getDataEncStrength(), spEntityID);
                if (encryptedNameID == null) {
                    SAML2Utils.debug.error(classMethod + "failed to encrypt the NameID.");
                    throw new SAML2Exception(SAML2Utils.bundle.getString("FailedToEncryptNameID"));
                }
                subject.setEncryptedID(encryptedNameID);
                subject.setNameID(null);
                assertion.setSubject(subject);
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message(classMethod + "NameID encrypted.");
                }
            }
            if (toEncryptAttribute) {
                List attributeStatements = assertion.getAttributeStatements();
                if (attributeStatements == null || attributeStatements.size() == 0) {
                    return;
                }
                int asSize = attributeStatements.size();
                ArrayList<AttributeStatement> stmts = new ArrayList<AttributeStatement>();
                for (int i = 0; i < asSize; ++i) {
                    AttributeStatement attributeStatement = (AttributeStatement)attributeStatements.get(i);
                    List attributes = attributeStatement.getAttribute();
                    if (attributes == null || attributes.size() == 0) {
                        return;
                    }
                    int aSize = attributes.size();
                    ArrayList<EncryptedAttribute> eaList = new ArrayList<EncryptedAttribute>();
                    for (int j = 0; j < aSize; ++j) {
                        Attribute attribute = (Attribute)attributes.get(j);
                        EncryptedAttribute encryptedAttribute = attribute.encrypt(encInfo.getWrappingKey(), encInfo.getDataEncAlgorithm(), encInfo.getDataEncStrength(), spEntityID);
                        if (encryptedAttribute == null) {
                            SAML2Utils.debug.error(classMethod + "failed to encrypt the Attribute.");
                            throw new SAML2Exception(SAML2Utils.bundle.getString("FailedToEncryptAttribute"));
                        }
                        eaList.add(encryptedAttribute);
                    }
                    attributeStatement.setEncryptedAttribute(eaList);
                    attributeStatement.setAttribute(new ArrayList());
                    stmts.add(attributeStatement);
                }
                assertion.setAttributeStatements(stmts);
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message(classMethod + "Attribute encrypted.");
                }
            }
            if (signAssertion) {
                IDPSSOUtil.signAssertion(realm, idpEntityID, assertion);
            }
            ArrayList<Assertion> assertionList = new ArrayList<Assertion>();
            assertionList.add(assertion);
            res.setAssertion(assertionList);
        }
    }

    private static String getWriterURL(String realm, String idpEntityID, String spEntityID) {
        String writerURL;
        block11: {
            String classMethod = "IDPSSOUtil.getWriterURL: ";
            writerURL = null;
            try {
                String cotName;
                CircleOfTrustDescriptor cotDescriptor;
                List spCOTList;
                List idpCOTList;
                IDPSSOConfigElement idpEntityCfg = metaManager.getIDPSSOConfig(realm, idpEntityID);
                Map idpConfigAttrsMap = null;
                if (idpEntityCfg != null) {
                    idpConfigAttrsMap = SAML2MetaUtils.getAttributes(idpEntityCfg);
                }
                if ((idpCOTList = (List)idpConfigAttrsMap.get("cotlist")) == null || idpCOTList.size() == 0) {
                    return null;
                }
                SPSSOConfigElement spEntityCfg = metaManager.getSPSSOConfig(realm, spEntityID);
                Map spConfigAttrsMap = null;
                if (spEntityCfg != null) {
                    spConfigAttrsMap = SAML2MetaUtils.getAttributes(spEntityCfg);
                }
                if ((spCOTList = (List)spConfigAttrsMap.get("cotlist")) == null || spCOTList.size() == 0) {
                    return null;
                }
                idpCOTList.retainAll(spCOTList);
                for (int i = 0; i < idpCOTList.size() && ((writerURL = (cotDescriptor = cotManager.getCircleOfTrust(realm, cotName = (String)idpCOTList.get(i))).getSAML2WriterServiceURL()) == null || writerURL.trim().length() == 0); ++i) {
                }
            }
            catch (COTException ce) {
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message(classMethod + "Error retreiving of " + "circle of trust", (Throwable)((Object)ce));
                }
            }
            catch (SAML2Exception se) {
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message(classMethod + "Not able to getting writer URL : ", (Throwable)((Object)se));
                }
            }
            catch (Exception e) {
                if (!SAML2Utils.debug.messageEnabled()) break block11;
                SAML2Utils.debug.message(classMethod + "Not able to getting writer URL : ", (Throwable)e);
            }
        }
        return writerURL;
    }

    protected static int getEffectiveTime(String realm, String idpEntityID) {
        int effectiveTime = 600;
        String effectiveTimeStr = IDPSSOUtil.getAttributeValueFromIDPSSOConfig(realm, idpEntityID, "assertionEffectiveTime");
        if (effectiveTimeStr != null) {
            try {
                effectiveTime = Integer.parseInt(effectiveTimeStr);
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("IDPSSOUtil.getEffectiveTime: got effective time from config:" + effectiveTime);
                }
            }
            catch (NumberFormatException nfe) {
                SAML2Utils.debug.error("IDPSSOUtil.getEffectiveTime: Failed to get assertion effective time from IDP SSO config: ", (Throwable)nfe);
                effectiveTime = 600;
            }
        }
        return effectiveTime;
    }

    protected static int getNotBeforeSkewTime(String realm, String idpEntityID) {
        String classMethod = "IDPSSOUtil.getNotBeforeSkewTime:";
        int notBeforeSkewTime = 600;
        String skewTimeStr = IDPSSOUtil.getAttributeValueFromIDPSSOConfig(realm, idpEntityID, "assertionNotBeforeTimeSkew");
        if (skewTimeStr != null) {
            try {
                notBeforeSkewTime = Integer.parseInt(skewTimeStr);
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message(classMethod + "got NotBefore skew time from config:" + notBeforeSkewTime);
                }
            }
            catch (NumberFormatException nfe) {
                SAML2Utils.debug.error(classMethod + "IDP SSO config: ", (Throwable)nfe);
                notBeforeSkewTime = 600;
            }
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "NotBefore Skew time :" + notBeforeSkewTime);
        }
        return notBeforeSkewTime;
    }

    private static boolean assertionCacheEnabled(String realm, String idpEntityID) {
        String enabled = SAML2Utils.getAttributeValueFromSSOConfig(realm, idpEntityID, "IDPRole", "assertionCacheEnabled");
        return "true".equalsIgnoreCase(enabled);
    }

    public static byte[] stringToByteArray(String input) {
        char[] chars = input.toCharArray();
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static long getValidTimeofResponse(String realm, String idpEntityID, Response response) throws SAML2Exception {
        List assertions;
        int timeskew = 300;
        String timeskewStr = IDPSSOUtil.getAttributeValueFromIDPSSOConfig(realm, idpEntityID, "assertionTimeSkew");
        if (timeskewStr != null && timeskewStr.trim().length() > 0 && (timeskew = Integer.parseInt(timeskewStr)) < 0) {
            timeskew = 300;
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("timeskew = " + timeskew);
        }
        if ((assertions = response.getAssertion()) == null || assertions.size() == 0) {
            throw new SAML2Exception("nullAssertion");
        }
        Assertion assertion = (Assertion)assertions.get(0);
        Conditions cond = assertion.getConditions();
        if (cond == null) {
            throw new SAML2Exception("nullConditions");
        }
        Date notOnOrAfter = cond.getNotOnOrAfter();
        long ret = notOnOrAfter.getTime() + (long)(timeskew * 1000);
        if (notOnOrAfter == null || ret < System.currentTimeMillis()) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("Time in Assertion  is invalid.");
            }
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidTimeOnResponse"));
        }
        return ret;
    }

    static {
        try {
            metaManager = new SAML2MetaManager();
            cotManager = new CircleOfTrustManager();
        }
        catch (COTException ce) {
            SAML2Utils.debug.error("Error retreiving circle of trust");
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error("Error retrieving metadata", (Throwable)((Object)sme));
        }
        try {
            sessionProvider = SessionManager.getProvider();
        }
        catch (SessionException se) {
            SAML2Utils.debug.error("IDPSSOUtil static block: Error getting SessionProvider.", (Throwable)((Object)se));
        }
    }
}

