/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.common.PeriodicCleanUpMap;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.assertion.Subject;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.plugins.SAML2IDPFinder;
import com.sun.identity.saml2.profile.AuthnRequestInfo;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.IDPSSOUtil;
import com.sun.identity.saml2.profile.IDPSession;
import com.sun.identity.saml2.profile.IDPSingleLogout;
import com.sun.identity.saml2.profile.LogoutUtil;
import com.sun.identity.saml2.profile.ResponseInfo;
import com.sun.identity.saml2.profile.SAML2SessionPartner;
import com.sun.identity.saml2.profile.SPCache;
import com.sun.identity.saml2.profile.SPSSOFederate;
import com.sun.identity.saml2.profile.SPSingleLogout;
import com.sun.identity.saml2.protocol.AuthnRequest;
import com.sun.identity.saml2.protocol.LogoutRequest;
import com.sun.identity.saml2.protocol.LogoutResponse;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.Response;
import com.sun.identity.saml2.protocol.Scoping;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class IDPProxyUtil {
    private static SAML2IDPFinder proxyFinder = null;
    private static SAML2MetaManager sm = null;
    private static Debug debug = SAML2Utils.debug;
    private static SessionProvider sessionProvider = null;

    public static String getPreferredIDP(AuthnRequest authnRequest, String hostedEntityId, String realm, HttpServletRequest request, HttpServletResponse response) throws SAML2Exception {
        List idpProviderIDs = proxyFinder.getPreferredIDP(authnRequest, hostedEntityId, realm, request, response);
        if (idpProviderIDs == null || idpProviderIDs.isEmpty()) {
            return null;
        }
        return (String)idpProviderIDs.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendProxyAuthnRequest(AuthnRequest authnRequest, String preferredIDP, SPSSODescriptorElement spSSODescriptor, String hostedEntityId, HttpServletRequest request, HttpServletResponse response, String realm, String relayState, String binding) throws SAML2Exception, IOException {
        String classMethod = "IDPProxyUtil.sendProxyAuthnRequest: ";
        AuthnRequest newAuthnRequest = IDPProxyUtil.getNewAuthnRequest(hostedEntityId, preferredIDP, realm, authnRequest);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "New Authentication request:" + newAuthnRequest.toXMLString());
        }
        String requestID = newAuthnRequest.getID();
        IDPCache.authnRequestCache.put((Object)requestID, (Object)newAuthnRequest);
        IDPCache.proxySPDescCache.put(requestID, spSSODescriptor);
        IDPCache.proxySPAuthnReqCache.put(requestID, authnRequest);
        IDPCache.idDestnCache.put(requestID, preferredIDP);
        String targetURL = null;
        SPSSODescriptorElement localDescriptor = null;
        SPSSOConfigElement localDescriptorConfig = null;
        IDPSSODescriptorElement idpDescriptor = null;
        try {
            idpDescriptor = IDPSSOUtil.metaManager.getIDPSSODescriptor(realm, preferredIDP);
            List ssoServiceList = idpDescriptor.getSingleSignOnService();
            targetURL = SPSSOFederate.getSSOURL(ssoServiceList, binding);
            localDescriptor = IDPSSOUtil.metaManager.getSPSSODescriptor(realm, hostedEntityId);
            localDescriptorConfig = IDPSSOUtil.metaManager.getSPSSOConfig(realm, hostedEntityId);
        }
        catch (SAML2MetaException e) {
            SAML2Utils.debug.error(classMethod, (Throwable)((Object)e));
            throw new SAML2Exception(e.getMessage());
        }
        if (targetURL == null) {
            SAML2Utils.debug.error(classMethod + "Single Sign-on service " + "is not found for the proxying IDP.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("ssoServiceNotFoundIDPProxy"));
        }
        boolean signingNeeded = idpDescriptor != null && idpDescriptor.isWantAuthnRequestsSigned() || localDescriptor != null && localDescriptor.isAuthnRequestsSigned();
        String relayStateID = null;
        if (relayState != null && relayState.length() > 0) {
            relayStateID = SPSSOFederate.getRelayStateID(relayState, authnRequest.getID());
        }
        if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            if (signingNeeded) {
                String certAlias = SPSSOFederate.getParameter(SAML2MetaUtils.getAttributes(localDescriptorConfig), "signingCertAlias");
                SPSSOFederate.signAuthnRequest(certAlias, newAuthnRequest);
            }
            String authXMLString = newAuthnRequest.toXMLString(true, true);
            String encodedReqMsg = SAML2Utils.encodeForPOST(authXMLString);
            SAML2Utils.postToTarget(response, "SAMLRequest", encodedReqMsg, "RelayState", relayStateID, targetURL);
        } else {
            String authReqXMLString = newAuthnRequest.toXMLString(true, true);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + " AuthnRequest: " + authReqXMLString);
            }
            String encodedXML = SAML2Utils.encodeForRedirect(authReqXMLString);
            StringBuffer queryString = new StringBuffer().append("SAMLRequest").append("=").append(encodedXML);
            if (relayStateID != null && relayStateID.length() > 0) {
                queryString.append("&").append("RelayState").append("=").append(URLEncDec.encode((String)relayStateID));
            }
            StringBuffer redirectURL = new StringBuffer().append(targetURL).append("?");
            if (signingNeeded) {
                String certAlias = SPSSOFederate.getParameter(SAML2MetaUtils.getAttributes(localDescriptorConfig), "signingCertAlias");
                String signedQueryStr = SPSSOFederate.signQueryString(queryString.toString(), certAlias);
                redirectURL.append(signedQueryStr);
            } else {
                redirectURL.append(queryString);
            }
            response.sendRedirect(redirectURL.toString());
        }
        String[] data = new String[]{targetURL};
        LogUtil.access(Level.INFO, "REDIRECT_TO_SP", data, null);
        AuthnRequestInfo reqInfo = new AuthnRequestInfo(request, response, realm, hostedEntityId, preferredIDP, newAuthnRequest, relayState, null);
        PeriodicCleanUpMap periodicCleanUpMap = SPCache.requestHash;
        synchronized (periodicCleanUpMap) {
            SPCache.requestHash.put((Object)requestID, (Object)reqInfo);
        }
    }

    private static AuthnRequest getNewAuthnRequest(String hostedEntityId, String idpEntityID, String realm, AuthnRequest origRequest) throws SAML2Exception {
        String classMethod = "IDPProxyUtil.getNewAuthnRequest: ";
        try {
            AuthnRequest newRequest = ProtocolFactory.getInstance().createAuthnRequest();
            String requestID = SAML2Utils.generateID();
            if (requestID == null || requestID.length() == 0) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("cannotGenerateID"));
            }
            newRequest.setID(requestID);
            IDPSSODescriptorElement idpDescriptor = IDPSSOUtil.metaManager.getIDPSSODescriptor(realm, idpEntityID);
            SPSSODescriptorElement localDescriptor = IDPSSOUtil.metaManager.getSPSSODescriptor(realm, hostedEntityId);
            List ssoServiceList = idpDescriptor.getSingleSignOnService();
            String dest = SPSSOFederate.getSSOURL(ssoServiceList, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            newRequest.setDestination(dest);
            newRequest.setConsent(origRequest.getConsent());
            newRequest.setIsPassive(origRequest.isPassive());
            newRequest.setForceAuthn(origRequest.isForceAuthn());
            newRequest.setAttributeConsumingServiceIndex(origRequest.getAttributeConsumingServiceIndex());
            newRequest.setAssertionConsumerServiceIndex(origRequest.getAssertionConsumerServiceIndex());
            String protocolBinding = origRequest.getProtocolBinding();
            newRequest.setProtocolBinding(protocolBinding);
            OrderedSet acsSet = SPSSOFederate.getACSUrl(localDescriptor, protocolBinding);
            String acsURL = (String)acsSet.get(0);
            newRequest.setAssertionConsumerServiceURL(acsURL);
            Issuer issuer = AssertionFactory.getInstance().createIssuer();
            issuer.setValue(hostedEntityId);
            newRequest.setIssuer(issuer);
            newRequest.setNameIDPolicy(origRequest.getNameIDPolicy());
            newRequest.setRequestedAuthnContext(origRequest.getRequestedAuthnContext());
            newRequest.setExtensions(origRequest.getExtensions());
            newRequest.setIssueInstant(new Date());
            newRequest.setVersion("2.0");
            Scoping scoping = origRequest.getScoping();
            if (scoping != null) {
                Scoping newScoping = ProtocolFactory.getInstance().createScoping();
                Integer proxyCountInt = scoping.getProxyCount();
                int proxyCount = 1;
                if (proxyCountInt != null) {
                    proxyCount = scoping.getProxyCount();
                    newScoping.setProxyCount(new Integer(proxyCount - 1));
                }
                newScoping.setIDPList(scoping.getIDPList());
                newRequest.setScoping(newScoping);
            }
            return newRequest;
        }
        catch (Exception ex) {
            SAML2Utils.debug.error(classMethod + "Error in creating new authn request.", (Throwable)ex);
            throw new SAML2Exception(ex);
        }
    }

    public static boolean isIDPProxyEnabled(AuthnRequest authnRequest, String realm) throws SAML2Exception {
        Boolean enabledString;
        Scoping scoping = authnRequest.getScoping();
        if (scoping == null) {
            return false;
        }
        Integer proxyCountInt = scoping.getProxyCount();
        int proxyCount = 0;
        proxyCount = proxyCountInt == null ? 1 : proxyCountInt;
        if (proxyCount <= 0) {
            return false;
        }
        SPSSOConfigElement spConfig = IDPSSOUtil.metaManager.getSPSSOConfig(realm, authnRequest.getIssuer().getValue());
        Map spConfigAttrsMap = null;
        if (spConfig != null) {
            spConfigAttrsMap = SAML2MetaUtils.getAttributes(spConfig);
        }
        if ((enabledString = SPSSOFederate.getAttrValueFromMap(spConfigAttrsMap, "enableIDPProxy")) == null) {
            return false;
        }
        return enabledString;
    }

    public static boolean isIDPProxyEnabled(String requestID) {
        if (IDPCache.proxySPDescCache != null && !IDPCache.proxySPDescCache.isEmpty()) {
            return IDPCache.proxySPDescCache.containsKey(requestID);
        }
        return false;
    }

    private static void sendProxyResponse(HttpServletRequest request, HttpServletResponse response, String requestID, String idpMetaAlias, Object newSess, String nameIDFormat) throws SAML2Exception {
        String classMethod = "IDPProxyUtil.sendProxyResponse: ";
        AuthnRequest origRequest = null;
        origRequest = (AuthnRequest)IDPCache.proxySPAuthnReqCache.get(requestID);
        if (SAML2Utils.debug.messageEnabled()) {
            try {
                SAML2Utils.debug.message(classMethod + origRequest.toXMLString());
            }
            catch (Exception ex) {
                SAML2Utils.debug.error(classMethod + "toString(): Failed.", (Throwable)ex);
            }
        }
        IDPCache.proxySPAuthnReqCache.remove(requestID);
        SPSSODescriptorElement proxyDescriptor = null;
        proxyDescriptor = (SPSSODescriptorElement)IDPCache.proxySPDescCache.get(requestID);
        IDPCache.proxySPDescCache.remove(requestID);
        String proxySPEntityId = origRequest.getIssuer().getValue();
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + ":Original requesting service provider id:" + proxySPEntityId);
        }
        IDPCache.spSessionPartnerBySessionID.put(sessionProvider.getSessionID(newSess), proxySPEntityId);
        String relayState = (String)IDPCache.relayStateCache.get((Object)origRequest.getID());
        IDPSSOUtil.doSSOFederate(request, response, origRequest, origRequest.getIssuer().getValue(), idpMetaAlias, nameIDFormat, relayState, newSess);
    }

    public static void generateProxyResponse(HttpServletRequest request, HttpServletResponse response, String metaAlias, ResponseInfo respInfo, Object newSession) throws SAML2Exception {
        Response saml2Resp = respInfo.getResponse();
        String requestID = saml2Resp.getInResponseTo();
        String nameidFormat = IDPProxyUtil.getNameIDFormat(saml2Resp);
        if (nameidFormat != null && SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("NAME ID Format= " + nameidFormat);
        }
        IDPProxyUtil.sendProxyResponse(request, response, requestID, metaAlias, newSession, nameidFormat);
    }

    private static String getNameIDFormat(Response res) {
        if (res == null) {
            return null;
        }
        List assertions = res.getAssertion();
        if (assertions == null || assertions.size() == 0) {
            return null;
        }
        Assertion assertion = (Assertion)assertions.get(0);
        Subject subject = assertion.getSubject();
        if (subject == null) {
            return null;
        }
        NameID nameID = subject.getNameID();
        if (nameID == null) {
            return null;
        }
        String format = nameID.getFormat();
        return format;
    }

    public static void initiateSPLogoutRequest(HttpServletRequest request, HttpServletResponse response, String partner, String spMetaAlias, String realm, LogoutRequest logoutReq, SOAPMessage msg, IDPSession idpSession, String binding, String relayState) {
        Object ssoToken = idpSession.getSession();
        try {
            if (ssoToken == null) {
                response.sendError(400, SAML2Utils.bundle.getString("nullSSOToken"));
                return;
            }
            String[] values = SessionManager.getProvider().getProperty(ssoToken, "spMetaAlias");
            String metaAlias = null;
            if (values != null && values.length > 0) {
                metaAlias = values[0];
            }
            if (metaAlias == null) {
                metaAlias = spMetaAlias;
            }
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("spMetaAlias", metaAlias);
            paramsMap.put("idpEntityID", partner);
            paramsMap.put("role", "SPRole");
            paramsMap.put("binding", binding);
            String dest = IDPProxyUtil.getLocation(realm, partner, binding);
            if (dest == null || dest.equals("")) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("sloResponseServiceLocationNotfound"));
            }
            paramsMap.put("Destination", dest);
            paramsMap.put("Consent", request.getParameter("Consent"));
            paramsMap.put("Extension", request.getParameter("Extension"));
            if (relayState != null) {
                paramsMap.put("RelayState", relayState);
            }
            idpSession.removeSessionPartner(partner);
            SPSingleLogout.initiateLogoutRequest(request, response, binding, paramsMap, logoutReq, msg, ssoToken);
        }
        catch (SAML2Exception sse) {
            SAML2Utils.debug.error("Error sending Logout Request ", (Throwable)((Object)sse));
            try {
                response.sendError(400, SAML2Utils.bundle.getString("LogoutRequestCreationError"));
            }
            catch (Exception se) {
                SAML2Utils.debug.error("IDPProxyUtil.initiateSPLogoutRequest: ", (Throwable)se);
            }
            return;
        }
        catch (Exception e) {
            SAML2Utils.debug.error("Error initializing Request ", (Throwable)e);
            try {
                response.sendError(400, SAML2Utils.bundle.getString("LogoutRequestCreationError"));
            }
            catch (Exception mme) {
                SAML2Utils.debug.error("IDPProxyUtil.initiateSPLogoutRequest: ", (Throwable)mme);
            }
            return;
        }
    }

    public static String getLocation(String realm, String idpEntityID, String binding) {
        try {
            String location = null;
            IDPSSODescriptorElement idpsso = sm.getIDPSSODescriptor(realm, idpEntityID);
            if (idpsso == null) {
                String[] data = new String[]{idpEntityID};
                LogUtil.error(Level.INFO, "IDP_METADATA_ERROR", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            }
            List slosList = idpsso.getSingleLogoutService();
            if (slosList == null) {
                String[] data = new String[]{idpEntityID};
                LogUtil.error(Level.INFO, "SLO_NOT_FOUND", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("sloServiceListNotfound"));
            }
            location = LogoutUtil.getSLOServiceLocation(slosList, binding);
            if (SAML2Utils.debug.messageEnabled() && location != null && !location.equals("")) {
                SAML2Utils.debug.message("Location URL: " + location);
            }
            return location;
        }
        catch (SAML2Exception se) {
            return null;
        }
    }

    public static List getSessionPartners(HttpServletRequest request) {
        try {
            Object tmpsession = sessionProvider.getSession(request);
            String tokenID = sessionProvider.getSessionID(tmpsession);
            IDPSession idpSession = null;
            if (tokenID != null && !tokenID.equals("")) {
                idpSession = (IDPSession)IDPCache.idpSessionsBySessionID.get(tokenID);
            }
            List partners = null;
            if (idpSession != null) {
                partners = idpSession.getSessionPartners();
            }
            if (SAML2Utils.debug.messageEnabled() && partners != null && !partners.isEmpty()) {
                Iterator iter = partners.iterator();
                while (iter.hasNext()) {
                    SAML2SessionPartner partner = (SAML2SessionPartner)iter.next();
                    if (!SAML2Utils.debug.messageEnabled()) continue;
                    SAML2Utils.debug.message("SESSION PARTNER's Provider ID:  " + partner.getPartner());
                }
            }
            return partners;
        }
        catch (SessionException se) {
            return null;
        }
    }

    public static void sendProxyLogoutRequest(HttpServletRequest request, HttpServletResponse response, LogoutRequest logoutReq, List partners, String binding, String relayState) {
        try {
            Object tmpsession = sessionProvider.getSession(request);
            String tokenID = sessionProvider.getSessionID(tmpsession);
            IDPSession idpSession = null;
            if (tokenID != null && !tokenID.equals("")) {
                idpSession = (IDPSession)IDPCache.idpSessionsBySessionID.get(tokenID);
            }
            Iterator iter = partners.iterator();
            SAML2SessionPartner partner = (SAML2SessionPartner)iter.next();
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("CURRENT PARTNER's provider ID: " + partner.getPartner());
                SAML2Utils.debug.message("Starting IDP proxy logout.");
            }
            String metaAlias = SAML2MetaUtils.getMetaAliasByUri(request.getRequestURI());
            String realm = SAML2Utils.getRealm(SAML2MetaUtils.getRealmByMetaAlias(metaAlias));
            String party = partner.getPartner();
            idpSession.removeSessionPartner(party);
            IDPProxyUtil.initiateSPLogoutRequest(request, response, party, metaAlias, realm, logoutReq, null, idpSession, binding, relayState);
        }
        catch (SessionException se) {
            SAML2Utils.debug.error("sendProxyLogoutRequest: ", (Throwable)((Object)se));
        }
    }

    public static void sendProxyLogoutResponse(HttpServletResponse response, String originatingRequestID, Map infoMap, String remoteEntity, String binding) throws SAML2Exception {
        String entityID = (String)infoMap.get("entityid");
        if (entityID == null || entityID.equals("")) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullIDPEntityID"));
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("Proxy IDP EntityID=" + entityID);
        }
        LogoutResponse logoutRes = LogoutUtil.generateResponse(null, originatingRequestID, SAML2Utils.createIssuer(entityID), "/", "IDPRole", remoteEntity);
        String location = IDPSingleLogout.getSingleLogoutLocation(remoteEntity, "/", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("Proxy to: " + location);
        }
        String relayState = (String)infoMap.get("RelayState");
        LogoutUtil.sendSLOResponse(response, logoutRes, location, relayState, "/", entityID, "IDPRole", remoteEntity, binding);
    }

    public static void sendProxyLogoutRequestSOAP(HttpServletRequest request, HttpServletResponse response, SOAPMessage msg, List partners, IDPSession idpSession) {
        Iterator iter = partners.iterator();
        SAML2SessionPartner partner = (SAML2SessionPartner)iter.next();
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("CURRENT PARTNER's provider ID: " + partner.getPartner());
            SAML2Utils.debug.message("Starting IDP proxy logout.");
        }
        String metaAlias = SAML2MetaUtils.getMetaAliasByUri(request.getRequestURI());
        String realm = SAML2Utils.getRealm(SAML2MetaUtils.getRealmByMetaAlias(metaAlias));
        String party = partner.getPartner();
        idpSession.removeSessionPartner(party);
        IDPProxyUtil.initiateSPLogoutRequest(request, response, party, metaAlias, realm, null, msg, idpSession, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", null);
    }

    public static Map getSessionPartners(SOAPMessage message) {
        try {
            IDPSession idpSession;
            HashMap<String, Object> sessMap = new HashMap<String, Object>();
            Element reqElem = SAML2Utils.getSamlpElement(message, "LogoutRequest");
            LogoutRequest logoutReq = ProtocolFactory.getInstance().createLogoutRequest(reqElem);
            List siList = logoutReq.getSessionIndex();
            int numSI = 0;
            if (siList != null) {
                numSI = siList.size();
                if (debug.messageEnabled()) {
                    debug.message("Number of session indices in the logout request is " + numSI);
                }
            }
            String sessionIndex = (String)siList.get(0);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("getSessionPartners: SessionIndex= " + sessionIndex);
            }
            if ((idpSession = (IDPSession)IDPCache.idpSessionsByIndices.get(sessionIndex)) == null) {
                return sessMap;
            }
            sessMap.put("SessionIndex", sessionIndex);
            sessMap.put("IDPSESSION", idpSession);
            Object session = idpSession.getSession();
            String tokenId = sessionProvider.getSessionID(session);
            IDPSession newIdpSession = (IDPSession)IDPCache.idpSessionsBySessionID.get(tokenId);
            List partners = null;
            if (newIdpSession != null) {
                partners = newIdpSession.getSessionPartners();
            }
            if (SAML2Utils.debug.messageEnabled() && partners != null && !partners.isEmpty()) {
                Iterator iter = partners.iterator();
                while (iter.hasNext()) {
                    SAML2SessionPartner partner = (SAML2SessionPartner)iter.next();
                    if (!SAML2Utils.debug.messageEnabled()) continue;
                    SAML2Utils.debug.message("SESSION PARTNER's Provider ID:  " + partner.getPartner());
                }
            }
            sessMap.put("PARTNERS", partners);
            return sessMap;
        }
        catch (SAML2Exception se) {
            SAML2Utils.debug.error("getSessionPartners: ", (Throwable)((Object)se));
            return null;
        }
    }

    public static void sendProxyLogoutResponseBySOAP(SOAPMessage reply, HttpServletResponse resp) {
        try {
            if (reply.saveRequired()) {
                reply.saveChanges();
            }
            resp.setStatus(200);
            SAML2Utils.putHeaders(reply.getMimeHeaders(), resp);
            ServletOutputStream os = resp.getOutputStream();
            reply.writeTo((OutputStream)os);
            os.flush();
        }
        catch (SOAPException se) {
            SAML2Utils.debug.error("sendProxyLogoutResponseBySOAP: ", (Throwable)se);
        }
        catch (IOException ie) {
            SAML2Utils.debug.error("sendProxyLogoutResponseBySOAP: ", (Throwable)ie);
        }
    }

    public static void sendIDPInitProxyLogoutRequest(HttpServletRequest request, HttpServletResponse response, LogoutResponse logoutResponse, String location, String spEntityID, String idpEntityID, String binding) throws SAML2Exception {
        try {
            Object tmpsession = sessionProvider.getSession(request);
            String tokenID = sessionProvider.getSessionID(tmpsession);
            String metaAlias = SAML2MetaUtils.getMetaAliasByUri(request.getRequestURI());
            String realm = SAML2Utils.getRealm(SAML2MetaUtils.getRealmByMetaAlias(metaAlias));
            String logoutAll = request.getParameter("logoutAll");
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            IDPSSOConfigElement config = sm.getIDPSSOConfig("/", spEntityID);
            paramsMap.put("metaAlias", config.getMetaAlias());
            paramsMap.put("role", "IDPRole");
            paramsMap.put("binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            paramsMap.put("Destination", request.getParameter("Destination"));
            paramsMap.put("Consent", request.getParameter("Consent"));
            paramsMap.put("Extension", request.getParameter("Extension"));
            HashMap<String, Object> logoutResponseMap = new HashMap<String, Object>();
            if (logoutResponse != null) {
                logoutResponseMap.put("LogoutResponse", logoutResponse);
            }
            if (location != null && !location.equals("")) {
                logoutResponseMap.put("Location", location);
            }
            if (spEntityID != null && !spEntityID.equals("")) {
                logoutResponseMap.put("spEntityID", spEntityID);
            }
            if (idpEntityID != null && !idpEntityID.equals("")) {
                logoutResponseMap.put("idpEntityID", idpEntityID);
            }
            paramsMap.put("LogoutMap", logoutResponseMap);
            if (logoutAll != null) {
                paramsMap.put("logoutAll", logoutAll);
            }
            IDPSingleLogout.initiateLogoutRequest(request, response, binding, paramsMap);
        }
        catch (SessionException se) {
            SAML2Utils.debug.error("sendIDPInitProxyLogoutRequest: ", (Throwable)((Object)se));
        }
    }

    public static List getSPSessionPartners(HttpServletRequest request) {
        try {
            Object tmpsession = sessionProvider.getSession(request);
            String tokenID = sessionProvider.getSessionID(tmpsession);
            String pid = null;
            if (tokenID != null && !tokenID.equals("")) {
                pid = (String)IDPCache.spSessionPartnerBySessionID.get(tokenID);
            }
            ArrayList<String> partners = null;
            if (pid != null && !pid.equals("")) {
                partners = new ArrayList<String>();
                SAML2Utils.debug.message("SP SESSION PARTNER's Provider ID:  " + pid);
                partners.add(pid);
            }
            return partners;
        }
        catch (SessionException se) {
            return null;
        }
    }

    static {
        try {
            sm = new SAML2MetaManager();
            sessionProvider = SessionManager.getProvider();
            String proxyFinderClass = SystemConfigurationUtil.getProperty("com.sun.identity.saml2.idpproxy", "com.sun.identity.saml2.plugins.SAML2IDPProxyImpl");
            Class<?> proxyClass = Class.forName(proxyFinderClass);
            proxyFinder = (SAML2IDPFinder)proxyClass.newInstance();
        }
        catch (Exception ex) {
            SAML2Utils.debug.error("IDPSSOFederate:Static Init Failed", (Throwable)ex);
        }
    }
}

