/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.assertion.AttributeStatement;
import com.sun.identity.saml2.assertion.Conditions;
import com.sun.identity.saml2.assertion.EncryptedAssertion;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.assertion.Subject;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.assertion.AttributeElement;
import com.sun.identity.saml2.jaxb.assertion.AttributeValueElement;
import com.sun.identity.saml2.jaxb.entityconfig.AttributeAuthorityConfigElement;
import com.sun.identity.saml2.jaxb.metadata.AttributeAuthorityDescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.AttributeServiceElement;
import com.sun.identity.saml2.jaxb.metadataextquery.AttributeQueryDescriptorElement;
import com.sun.identity.saml2.key.EncInfo;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.plugins.AttributeAuthorityMapper;
import com.sun.identity.saml2.profile.IDPSSOUtil;
import com.sun.identity.saml2.protocol.AttributeQuery;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.Response;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.saml2.protocol.StatusCode;
import com.sun.identity.saml2.xmlenc.EncManager;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class AttributeQueryUtil {
    static KeyProvider keyProvider = KeyUtil.getKeyProviderInstance();
    static Hashtable attrAuthorityMapperCache = new Hashtable();
    static DataStoreProvider dsProvider = null;
    static SAML2MetaManager metaManager = SAML2Utils.getSAML2MetaManager();

    private AttributeQueryUtil() {
    }

    public static Response sendAttributeQuery(AttributeQuery attrQuery, String attrAuthorityEntityID, String realm, String attrQueryProfile, String attrProfile, String binding) throws SAML2Exception {
        AttributeAuthorityDescriptorElement aad = null;
        try {
            aad = metaManager.getAttributeAuthorityDescriptor(realm, attrAuthorityEntityID);
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error("AttributeQueryUtil.sendAttributeQuery:", (Throwable)((Object)sme));
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        if (aad == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("attrAuthorityNotFound"));
        }
        if (binding == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("unsupportedBinding"));
        }
        String location = AttributeQueryUtil.findLocation(aad, binding, attrQueryProfile, attrProfile);
        if (location == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("attrAuthorityNotFound"));
        }
        if (binding.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
            AttributeQueryUtil.signAttributeQuery(attrQuery, realm, false);
            return AttributeQueryUtil.sendAttributeQuerySOAP(attrQuery, location, attrAuthorityEntityID, aad);
        }
        throw new SAML2Exception(SAML2Utils.bundle.getString("unsupportedBinding"));
    }

    public static Response processAttributeQuery(AttributeQuery attrQuery, HttpServletRequest request, HttpServletResponse response, String attrAuthorityEntityID, String realm, String attrQueryProfileAlias) throws SAML2Exception {
        AttributeAuthorityMapper attrAuthorityMapper = AttributeQueryUtil.getAttributeAuthorityMapper(realm, attrAuthorityEntityID, attrQueryProfileAlias);
        String attrQueryProfile = AttributeQueryUtil.getAttributeQueryProfile(attrQueryProfileAlias);
        try {
            attrAuthorityMapper.authenticateRequester(request, response, attrQuery, attrAuthorityEntityID, realm);
        }
        catch (SAML2Exception se) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AttributeQueryUtil.processAttributeQuery: ", (Throwable)((Object)se));
            }
            return SAML2Utils.getErrorResponse(attrQuery, "urn:oasis:names:tc:SAML:2.0:status:Requester", null, se.getMessage(), null);
        }
        try {
            attrAuthorityMapper.validateAttributeQuery(request, response, attrQuery, attrAuthorityEntityID, realm);
        }
        catch (SAML2Exception se) {
            SAML2Utils.debug.error("AttributeQueryUtil.processAttributeQuery:", (Throwable)((Object)se));
            return SAML2Utils.getErrorResponse(attrQuery, "urn:oasis:names:tc:SAML:2.0:status:Requester", null, se.getMessage(), null);
        }
        Issuer issuer = attrQuery.getIssuer();
        String requesterEntityID = issuer.getValue();
        AttributeAuthorityDescriptorElement aad = null;
        try {
            aad = metaManager.getAttributeAuthorityDescriptor(realm, attrAuthorityEntityID);
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error("AttributeQueryUtil.processAttributeQuery:", (Throwable)((Object)sme));
            return SAML2Utils.getErrorResponse(attrQuery, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, SAML2Utils.bundle.getString("metaDataError"), null);
        }
        if (aad == null) {
            return SAML2Utils.getErrorResponse(attrQuery, "urn:oasis:names:tc:SAML:2.0:status:Requester", null, SAML2Utils.bundle.getString("attrAuthorityNotFound"), null);
        }
        Object identity = null;
        try {
            identity = attrAuthorityMapper.getIdentity(request, response, attrQuery, attrAuthorityEntityID, realm);
        }
        catch (SAML2Exception se) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AttributeQueryUtil.processAttributeQuery: ", (Throwable)((Object)se));
            }
            return SAML2Utils.getErrorResponse(attrQuery, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", se.getMessage(), null);
        }
        if (identity == null) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AttributeQueryUtil.processAttributeQuery: unable to find identity.");
            }
            return SAML2Utils.getErrorResponse(attrQuery, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", null, null);
        }
        List desiredAttrs = attrQuery.getAttributes();
        try {
            desiredAttrs = AttributeQueryUtil.verifyDesiredAttributes(aad.getAttribute(), desiredAttrs);
        }
        catch (SAML2Exception se) {
            return SAML2Utils.getErrorResponse(attrQuery, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:InvalidAttrNameOrValue", null, null);
        }
        List attributes = attrAuthorityMapper.getAttributes(identity, attrQuery, attrAuthorityEntityID, realm);
        attributes = AttributeQueryUtil.filterAttributes(attributes, desiredAttrs);
        ProtocolFactory protocolFactory = ProtocolFactory.getInstance();
        Response samlResp = protocolFactory.createResponse();
        ArrayList<Object> assertionList = new ArrayList<Object>();
        Assertion assertion = null;
        try {
            assertion = AttributeQueryUtil.getAssertion(attrQuery, attrAuthorityEntityID, requesterEntityID, realm, attrQueryProfileAlias, attributes);
        }
        catch (SAML2Exception se) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AttributeQueryUtil.processAttributeQuery:", (Throwable)((Object)se));
            }
            return SAML2Utils.getErrorResponse(attrQuery, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, se.getMessage(), null);
        }
        if (attrQueryProfileAlias.equals("x509Subject")) {
            EncryptedID encryptedID = attrQuery.getSubject().getEncryptedID();
            if (encryptedID != null) {
                EncryptedAssertion encryptedAssertion = null;
                try {
                    AttributeQueryUtil.signAssertion(assertion, realm, attrAuthorityEntityID, false);
                    encryptedAssertion = AttributeQueryUtil.encryptAssertion(assertion, encryptedID, attrAuthorityEntityID, requesterEntityID, realm, attrQueryProfileAlias);
                }
                catch (SAML2Exception se) {
                    if (SAML2Utils.debug.messageEnabled()) {
                        SAML2Utils.debug.message("AttributeQueryUtil.processAttributeQuery:", (Throwable)((Object)se));
                    }
                    return SAML2Utils.getErrorResponse(attrQuery, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, se.getMessage(), null);
                }
                assertionList.add(encryptedAssertion);
                samlResp.setEncryptedAssertion(assertionList);
            } else {
                assertionList.add(assertion);
                samlResp.setAssertion(assertionList);
            }
        } else {
            assertionList.add(assertion);
            samlResp.setAssertion(assertionList);
        }
        samlResp.setID(SAML2Utils.generateID());
        samlResp.setInResponseTo(attrQuery.getID());
        samlResp.setVersion("2.0");
        samlResp.setIssueInstant(new Date());
        Status status = protocolFactory.createStatus();
        StatusCode statusCode = protocolFactory.createStatusCode();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        status.setStatusCode(statusCode);
        samlResp.setStatus(status);
        Issuer respIssuer = AssertionFactory.getInstance().createIssuer();
        respIssuer.setValue(attrAuthorityEntityID);
        samlResp.setIssuer(respIssuer);
        AttributeQueryUtil.signResponse(samlResp, attrAuthorityEntityID, realm, false);
        return samlResp;
    }

    public static String getAttributeQueryProfile(String attrQueryProfileAlias) {
        if (attrQueryProfileAlias == null) {
            return null;
        }
        if (attrQueryProfileAlias.equals("default")) {
            return "urn:oasis:names:tc:SAML:2.0:profiles:query";
        }
        if (attrQueryProfileAlias.equals("x509Subject")) {
            return "urn:oasis:names:tc:SAML:2.0:profiles:query:attribute:X509";
        }
        return null;
    }

    private static void signAttributeQuery(AttributeQuery attrQuery, String realm, boolean includeCert) throws SAML2Exception {
        String requesterEntityID = attrQuery.getIssuer().getValue();
        String alias = SAML2Utils.getSigningCertAlias(realm, requesterEntityID, "AttrQueryRole");
        PrivateKey signingKey = keyProvider.getPrivateKey(alias);
        if (signingKey == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
        X509Certificate signingCert = null;
        if (includeCert) {
            signingCert = keyProvider.getX509Certificate(alias);
        }
        if (signingKey != null) {
            attrQuery.sign(signingKey, signingCert);
        }
    }

    public static void validateEntityRequester(AttributeQuery attrQuery, String attrAuthorityEntityID, String realm) throws SAML2Exception {
        Issuer issuer = attrQuery.getIssuer();
        String format = issuer.getFormat();
        if (format == null || format.length() == 0 || format.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified") || format.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            String requestedEntityID = issuer.getValue();
            if (!SAML2Utils.isSourceSiteValid(issuer, realm, attrAuthorityEntityID)) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("attrQueryIssuerInvalid"));
            }
        } else {
            throw new SAML2Exception(SAML2Utils.bundle.getString("attrQueryIssuerInvalid"));
        }
    }

    public static void verifyAttrQuerySignature(AttributeQuery attrQuery, String attrAuthorityEntityID, String realm) throws SAML2Exception {
        if (!attrQuery.isSigned()) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("attrQueryNotSigned"));
        }
        String requestedEntityID = attrQuery.getIssuer().getValue();
        AttributeQueryDescriptorElement attrqDesc = metaManager.getAttributeQueryDescriptor(realm, requestedEntityID);
        if (attrqDesc == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("attrQueryIssuerNotFound"));
        }
        X509Certificate signingCert = KeyUtil.getVerificationCert(attrqDesc, requestedEntityID, "AttrQueryRole");
        if (signingCert != null) {
            boolean valid = attrQuery.isSignatureValid(signingCert);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AttributeQueryUtil.verifyAttributeQuery: Signature validity is : " + valid);
            }
            if (!valid) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignatureAttrQuery"));
            }
        } else {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
    }

    public static String getIdentityFromDataStoreX509Subject(AttributeQuery attrQuery, String attrAuthorityEntityID, String realm) throws SAML2Exception {
        Subject subject = attrQuery.getSubject();
        NameID nameID = null;
        EncryptedID encryptedID = subject.getEncryptedID();
        if (encryptedID != null) {
            String alias = SAML2Utils.getEncryptionCertAlias(realm, attrAuthorityEntityID, "AttrAuthRole");
            PrivateKey privateKey = keyProvider.getPrivateKey(alias);
            nameID = encryptedID.decrypt(privateKey);
        } else {
            nameID = subject.getNameID();
        }
        if (!"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName".equals(nameID.getFormat())) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("unsupportedAttrQuerySubjectNameID"));
        }
        String mappingAttrName = AttributeQueryUtil.getAttributeValueFromAttrAuthorityConfig(realm, attrAuthorityEntityID, "x509SubjectDataStoreAttrName");
        if (mappingAttrName == null || mappingAttrName.length() == 0) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("x509SubjectMappingNotConfigured"));
        }
        String x509SubjectDN = nameID.getValue();
        HashMap attrMap = new HashMap();
        HashSet<String> values = new HashSet<String>();
        values.add(x509SubjectDN);
        attrMap.put(mappingAttrName, values);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("AttributeQueryUtil.getIdentityFromDataStoreX509Subject: mappingAttrName = " + mappingAttrName + ", X509 subject DN = " + x509SubjectDN);
        }
        try {
            return dsProvider.getUserID(realm, attrMap);
        }
        catch (DataStoreProviderException dse) {
            SAML2Utils.debug.error("AttributeQueryUtil.getIdentityFromDataStoreX509Subject:", (Throwable)((Object)dse));
            throw new SAML2Exception(dse.getMessage());
        }
    }

    public static String getIdentityFromDataStore(AttributeQuery attrQuery, String attrAuthorityEntityID, String realm) throws SAML2Exception {
        Subject subject = attrQuery.getSubject();
        NameID nameID = null;
        EncryptedID encryptedID = subject.getEncryptedID();
        if (encryptedID != null) {
            String alias = SAML2Utils.getEncryptionCertAlias(realm, attrAuthorityEntityID, "AttrAuthRole");
            PrivateKey privateKey = keyProvider.getPrivateKey(alias);
            nameID = encryptedID.decrypt(privateKey);
        } else {
            nameID = subject.getNameID();
        }
        if (!SAML2Utils.isPersistentNameID(nameID)) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("unsupportedAttrQuerySubjectNameID"));
        }
        String requestedEntityID = attrQuery.getIssuer().getValue();
        try {
            return dsProvider.getUserID(realm, SAML2Utils.getNameIDKeyMap(nameID, attrAuthorityEntityID, requestedEntityID, realm, "IDPRole"));
        }
        catch (DataStoreProviderException dse) {
            SAML2Utils.debug.error("AttributeQueryUtil.getIdentityFromDataStore:", (Throwable)((Object)dse));
            throw new SAML2Exception(dse.getMessage());
        }
    }

    public static List getUserAttributes(String userId, AttributeQuery attrQuery, String attrAuthorityEntityID, String realm) throws SAML2Exception {
        Map valueMap;
        ArrayList<Attribute> attributes;
        Map configMap;
        block13: {
            String requestedEntityID = attrQuery.getIssuer().getValue();
            configMap = SAML2Utils.getConfigAttributeMap(realm, requestedEntityID, "SPRole");
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AttributeQueryUtil.getUserAttributes: remote SP attribute map = " + configMap);
            }
            if (configMap == null || configMap.isEmpty()) {
                configMap = SAML2Utils.getConfigAttributeMap(realm, attrAuthorityEntityID, "IDPRole");
                if (configMap == null || configMap.isEmpty()) {
                    if (SAML2Utils.debug.messageEnabled()) {
                        SAML2Utils.debug.message("AttributeQueryUtil.getUserAttributes:Configuration map is not defined.");
                    }
                    return null;
                }
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("AttributeQueryUtil.getUserAttributes: hosted IDP attribute map=" + configMap);
                }
            }
            attributes = new ArrayList<Attribute>();
            HashSet localAttributes = new HashSet();
            localAttributes.addAll(configMap.values());
            valueMap = null;
            try {
                valueMap = dsProvider.getAttributes(userId, localAttributes);
            }
            catch (DataStoreProviderException dse) {
                if (!SAML2Utils.debug.warningEnabled()) break block13;
                SAML2Utils.debug.warning("AttributeQueryUtil.getUserAttributes:", (Throwable)((Object)dse));
            }
        }
        Iterator iter = configMap.keySet().iterator();
        while (iter.hasNext()) {
            String samlAttribute = (String)iter.next();
            String localAttribute = (String)configMap.get(samlAttribute);
            String[] localAttributeValues = null;
            if (valueMap != null && !valueMap.isEmpty()) {
                Set values = (Set)valueMap.get(localAttribute);
                if (values == null || values.isEmpty()) {
                    if (SAML2Utils.debug.messageEnabled()) {
                        SAML2Utils.debug.message("AttributeQueryUtil.getUserAttributes: user profile does not have value for " + localAttribute);
                    }
                } else {
                    localAttributeValues = values.toArray(new String[values.size()]);
                }
            }
            if (localAttributeValues == null || localAttributeValues.length == 0) {
                if (!SAML2Utils.debug.messageEnabled()) continue;
                SAML2Utils.debug.message("AttributeQueryUtil.getUserAttributes: user does not have " + localAttribute);
                continue;
            }
            attributes.add(SAML2Utils.getSAMLAttribute(samlAttribute, localAttributeValues));
        }
        return attributes;
    }

    private static void signResponse(Response response, String attrAuthorityEntityID, String realm, boolean includeCert) throws SAML2Exception {
        String alias = SAML2Utils.getSigningCertAlias(realm, attrAuthorityEntityID, "AttrAuthRole");
        PrivateKey signingKey = keyProvider.getPrivateKey(alias);
        if (signingKey == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
        X509Certificate signingCert = null;
        if (includeCert) {
            signingCert = keyProvider.getX509Certificate(alias);
        }
        if (signingKey != null) {
            response.sign(signingKey, signingCert);
        }
    }

    private static Assertion getAssertion(AttributeQuery attrQuery, String attrAuthorityEntityID, String requesterEntityID, String realm, String attrQueryProfileAlias, List attributes) throws SAML2Exception {
        AssertionFactory assertionFactory = AssertionFactory.getInstance();
        Assertion assertion = assertionFactory.createAssertion();
        assertion.setID(SAML2Utils.generateID());
        assertion.setVersion("2.0");
        assertion.setIssueInstant(new Date());
        Issuer issuer = assertionFactory.createIssuer();
        issuer.setValue(attrAuthorityEntityID);
        assertion.setIssuer(issuer);
        Subject subjectQ = attrQuery.getSubject();
        Subject subject = assertionFactory.createSubject();
        subject.setEncryptedID(subjectQ.getEncryptedID());
        subject.setNameID(subjectQ.getNameID());
        subject.setBaseID(subjectQ.getBaseID());
        subject.setSubjectConfirmation(subjectQ.getSubjectConfirmation());
        assertion.setSubject(subject);
        if (attributes != null && !attributes.isEmpty()) {
            AttributeStatement attrStatement = assertionFactory.createAttributeStatement();
            attrStatement.setAttribute(attributes);
            ArrayList<AttributeStatement> attrStatementList = new ArrayList<AttributeStatement>();
            attrStatementList.add(attrStatement);
            assertion.setAttributeStatements(attrStatementList);
        }
        int effectiveTime = IDPSSOUtil.getEffectiveTime(realm, attrAuthorityEntityID);
        int notBeforeSkewTime = IDPSSOUtil.getNotBeforeSkewTime(realm, attrAuthorityEntityID);
        Conditions conditions = IDPSSOUtil.getConditions(requesterEntityID, notBeforeSkewTime, effectiveTime);
        assertion.setConditions(conditions);
        return assertion;
    }

    private static void signAssertion(Assertion assertion, String realm, String attrAuthorityEntityID, boolean includeCert) throws SAML2Exception {
        String alias = SAML2Utils.getSigningCertAlias(realm, attrAuthorityEntityID, "AttrAuthRole");
        PrivateKey signingKey = keyProvider.getPrivateKey(alias);
        X509Certificate signingCert = null;
        if (includeCert) {
            signingCert = keyProvider.getX509Certificate(alias);
        }
        if (signingKey != null) {
            assertion.sign(signingKey, signingCert);
        }
    }

    private static EncryptedAssertion encryptAssertion(Assertion assertion, EncryptedID encryptedID, String attrAuthorityEntityID, String requesterEntityID, String realm, String attrQueryProfileAlias) throws SAML2Exception {
        String alias = SAML2Utils.getEncryptionCertAlias(realm, attrAuthorityEntityID, "AttrAuthRole");
        PrivateKey privateKey = keyProvider.getPrivateKey(alias);
        SecretKey secretKey = EncManager.getEncInstance().getSecretKey(encryptedID.toXMLString(true, true), privateKey);
        AttributeQueryDescriptorElement aqd = metaManager.getAttributeQueryDescriptor(realm, requesterEntityID);
        EncInfo encInfo = KeyUtil.getEncInfo(aqd, requesterEntityID, "AttrQueryRole");
        Element el = EncManager.getEncInstance().encrypt(assertion.toXMLString(true, true), encInfo.getWrappingKey(), secretKey, encInfo.getDataEncAlgorithm(), encInfo.getDataEncStrength(), requesterEntityID, "EncryptedAssertion");
        return AssertionFactory.getInstance().createEncryptedAssertion(el);
    }

    private static List verifyDesiredAttributes(List supportedAttrs, List desiredAttrs) throws SAML2Exception {
        if (supportedAttrs == null || supportedAttrs.isEmpty()) {
            return desiredAttrs;
        }
        if (desiredAttrs == null || desiredAttrs.isEmpty()) {
            return AttributeQueryUtil.convertAttributes(supportedAttrs);
        }
        Iterator iterD = desiredAttrs.iterator();
        while (iterD.hasNext()) {
            Attribute attrD = (Attribute)iterD.next();
            boolean isAttrValid = false;
            Iterator iterS = supportedAttrs.iterator();
            while (iterS.hasNext()) {
                AttributeElement attrS = (AttributeElement)iterS.next();
                if (!AttributeQueryUtil.isSameAttribute(attrD, attrS)) continue;
                if (AttributeQueryUtil.isValueValid(attrD, attrS)) {
                    isAttrValid = true;
                    break;
                }
                throw new SAML2Exception("Attribute value not suppoted");
            }
            if (isAttrValid) {
                iterS.remove();
                continue;
            }
            throw new SAML2Exception("Attribute name not suppoted");
        }
        return desiredAttrs;
    }

    private static List convertAttributes(List jaxbAttrs) throws SAML2Exception {
        ArrayList<Attribute> resultAttrs = new ArrayList<Attribute>();
        Iterator iter = jaxbAttrs.iterator();
        while (iter.hasNext()) {
            AttributeElement jaxbAttr = (AttributeElement)iter.next();
            Attribute attr = AssertionFactory.getInstance().createAttribute();
            attr.setName(jaxbAttr.getName());
            attr.setNameFormat(jaxbAttr.getNameFormat());
            attr.setFriendlyName(jaxbAttr.getFriendlyName());
            List jaxbValues = jaxbAttr.getAttributeValue();
            if (jaxbValues != null && !jaxbValues.isEmpty()) {
                ArrayList newValues = new ArrayList();
                Iterator iterV = jaxbValues.iterator();
                while (iterV.hasNext()) {
                    AttributeValueElement jaxbValeu = (AttributeValueElement)iter.next();
                    List content = jaxbValeu.getContent();
                    if (content == null || content.isEmpty()) continue;
                    newValues.add(content.get(0));
                }
                if (!newValues.isEmpty()) {
                    attr.setAttributeValueString(newValues);
                }
            }
            resultAttrs.add(attr);
        }
        return resultAttrs;
    }

    private static List filterAttributes(List attributes, List desiredAttrs) {
        if (attributes == null || attributes.isEmpty()) {
            return attributes;
        }
        if (desiredAttrs == null || desiredAttrs.isEmpty()) {
            return attributes;
        }
        ArrayList<Attribute> returnAttributes = new ArrayList<Attribute>();
        if (desiredAttrs != null && !desiredAttrs.isEmpty()) {
            Iterator iterD = desiredAttrs.iterator();
            block0: while (iterD.hasNext()) {
                Attribute attrD = (Attribute)iterD.next();
                Iterator iter = attributes.iterator();
                while (iter.hasNext()) {
                    Attribute attr = (Attribute)iter.next();
                    if (!AttributeQueryUtil.isSameAttribute(attr, attrD)) continue;
                    if ((attr = AttributeQueryUtil.filterAttributeValues(attr, attrD)) != null) {
                        returnAttributes.add(attr);
                    }
                    iter.remove();
                    continue block0;
                }
            }
        }
        return returnAttributes;
    }

    private static boolean isSameAttribute(Attribute attr1, Attribute attr2) {
        if (!attr1.getName().equals(attr2.getName())) {
            return false;
        }
        String nameFormat1 = attr1.getNameFormat();
        if (nameFormat1 == null) {
            return attr2.getNameFormat() == null;
        }
        return nameFormat1.equals(attr2.getNameFormat());
    }

    private static Attribute filterAttributeValues(Attribute attr, Attribute desiredAttr) {
        List valuesD = desiredAttr.getAttributeValueString();
        if (valuesD == null || valuesD.isEmpty()) {
            return attr;
        }
        List values = attr.getAttributeValueString();
        if (values == null || values.isEmpty()) {
            return null;
        }
        ArrayList<String> newValuesD = new ArrayList<String>();
        Iterator iter = valuesD.iterator();
        while (iter.hasNext()) {
            String valueD = (String)iter.next();
            if (!values.contains(valueD)) continue;
            newValuesD.add(valueD);
        }
        if (newValuesD.isEmpty()) {
            return null;
        }
        if (newValuesD.size() == valuesD.size()) {
            return desiredAttr;
        }
        try {
            Attribute newAttr = AssertionFactory.getInstance().createAttribute();
            newAttr.setName(desiredAttr.getName());
            newAttr.setNameFormat(desiredAttr.getNameFormat());
            newAttr.setFriendlyName(desiredAttr.getFriendlyName());
            newAttr.setAnyAttribute(desiredAttr.getAnyAttribute());
            newAttr.setAttributeValueString(newValuesD);
            return newAttr;
        }
        catch (SAML2Exception se) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AttributeQueryUtil.filterAttributeValues:", (Throwable)((Object)se));
            }
            return null;
        }
    }

    private static boolean isSameAttribute(Attribute attr1, AttributeElement attr2) {
        if (!attr1.getName().equals(attr2.getName())) {
            return false;
        }
        String nameFormat1 = attr1.getNameFormat();
        if (nameFormat1 == null) {
            return attr2.getNameFormat() == null;
        }
        return nameFormat1.equals(attr2.getNameFormat());
    }

    private static boolean isValueValid(Attribute desiredAttr, AttributeElement supportedAttr) {
        List valuesD = desiredAttr.getAttributeValueString();
        if (valuesD == null || valuesD.isEmpty()) {
            return true;
        }
        List attrValuesS = supportedAttr.getAttributeValue();
        if (attrValuesS == null || attrValuesS.isEmpty()) {
            return true;
        }
        ArrayList valuesS = new ArrayList();
        Iterator iter = attrValuesS.iterator();
        while (iter.hasNext()) {
            AttributeValueElement attrValueElem = (AttributeValueElement)iter.next();
            valuesS.addAll(attrValueElem.getContent());
        }
        try {
            return valuesS.containsAll(valuesD);
        }
        catch (Exception ex) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AttributeQueryUtil.isValueValid:", (Throwable)ex);
            }
            return false;
        }
    }

    private static Response sendAttributeQuerySOAP(AttributeQuery attrQuery, String attributeServiceURL, String attrAuthorityEntityID, AttributeAuthorityDescriptorElement aad) throws SAML2Exception {
        String attrQueryXMLString = attrQuery.toXMLString(true, true);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("AttributeQueryUtil.sendAttributeQuerySOAP: attrQueryXMLString = " + attrQueryXMLString);
            SAML2Utils.debug.message("AttributeQueryUtil.sendAttributeQuerySOAP: attributeServiceURL = " + attributeServiceURL);
        }
        SOAPMessage resMsg = null;
        try {
            resMsg = SAML2Utils.sendSOAPMessage(attrQueryXMLString, attributeServiceURL);
        }
        catch (SOAPException se) {
            SAML2Utils.debug.error("AttributeQueryUtil.sendAttributeQuerySOAP: ", (Throwable)se);
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorSendingAttributeQuery"));
        }
        Element respElem = SAML2Utils.getSamlpElement(resMsg, "Response");
        Response response = ProtocolFactory.getInstance().createResponse(respElem);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("AttributeQueryUtil.sendAttributeQuerySOAP: response = " + response.toXMLString(true, true));
        }
        AttributeQueryUtil.verifyResponse(response, attrQuery, attrAuthorityEntityID, aad);
        return response;
    }

    private static void verifyResponse(Response response, AttributeQuery attrQuery, String attrAuthorityEntityID, AttributeAuthorityDescriptorElement aad) throws SAML2Exception {
        String attrQueryID = attrQuery.getID();
        if (attrQueryID != null && !attrQueryID.equals(response.getInResponseTo())) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidInResponseToAttrQuery"));
        }
        Issuer respIssuer = response.getIssuer();
        if (respIssuer == null) {
            return;
        }
        if (!attrAuthorityEntityID.equals(respIssuer.getValue())) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("responseIssuerMismatch"));
        }
        if (!response.isSigned()) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("responseNotSigned"));
        }
        X509Certificate signingCert = KeyUtil.getVerificationCert(aad, attrAuthorityEntityID, "AttrAuthRole");
        if (signingCert != null) {
            boolean valid = response.isSignatureValid(signingCert);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AttributeQueryUtil.verifyResponse: Signature validity is : " + valid);
            }
            if (!valid) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignatureOnResponse"));
            }
        } else {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
    }

    private static String findLocation(AttributeAuthorityDescriptorElement aad, String binding, String attrQueryProfile, String attrProfile) {
        List attrProfiles = aad.getAttributeProfile();
        if (attrProfiles == null || attrProfiles.isEmpty() ? attrProfile != null : !attrProfiles.contains(attrProfile)) {
            return null;
        }
        List attrServices = aad.getAttributeService();
        Iterator iter = attrServices.iterator();
        while (iter.hasNext()) {
            AttributeServiceElement attrService = (AttributeServiceElement)iter.next();
            if (!AttributeQueryUtil.isValidAttributeService(binding, attrService, attrQueryProfile)) continue;
            return attrService.getLocation();
        }
        return null;
    }

    private static boolean isValidAttributeService(String binding, AttributeServiceElement attrService, String attrQueryProfile) {
        if (!binding.equalsIgnoreCase(attrService.getBinding())) {
            return false;
        }
        if (attrQueryProfile == null) {
            return false;
        }
        return attrQueryProfile.equals("urn:oasis:names:tc:SAML:2.0:profiles:query") || "urn:oasis:names:tc:SAML:2.0:profiles:query:attribute:X509".equals(attrQueryProfile) && attrService.isSupportsX509Query();
    }

    static AttributeAuthorityMapper getAttributeAuthorityMapper(String realm, String attrAuthorityEntityID, String attrQueryProfileAlias) throws SAML2Exception {
        String attrAuthorityMapperName = null;
        AttributeAuthorityMapper attrAuthorityMapper = null;
        try {
            attrAuthorityMapperName = AttributeQueryUtil.getAttributeValueFromAttrAuthorityConfig(realm, attrAuthorityEntityID, attrQueryProfileAlias + "_" + "attributeAuthorityMapper");
            if (attrAuthorityMapperName == null) {
                attrAuthorityMapperName = "com.sun.identity.saml2.plugins.DefaultAttributeAuthorityMapper";
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("AttributeQueryUtil.getAttributeAuthorityMapper: use " + attrAuthorityMapperName);
                }
            }
            if ((attrAuthorityMapper = (AttributeAuthorityMapper)attrAuthorityMapperCache.get(attrAuthorityMapperName)) == null) {
                attrAuthorityMapper = (AttributeAuthorityMapper)Class.forName(attrAuthorityMapperName).newInstance();
                attrAuthorityMapperCache.put(attrAuthorityMapperName, attrAuthorityMapper);
            } else if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AttributeQueryUtil.getAttributeAuthorityMapper: got the AttributeAuthorityMapper from cache");
            }
        }
        catch (Exception ex) {
            SAML2Utils.debug.error("AttributeQueryUtil.getAttributeAuthorityMapper: Unable to get IDP Attribute Mapper.", (Throwable)ex);
            throw new SAML2Exception(ex);
        }
        return attrAuthorityMapper;
    }

    private static String getAttributeValueFromAttrAuthorityConfig(String realm, String attrAuthorityEntityID, String attrName) {
        try {
            AttributeAuthorityConfigElement config = metaManager.getAttributeAuthorityConfig(realm, attrAuthorityEntityID);
            Map attrs = SAML2MetaUtils.getAttributes(config);
            String value = null;
            List values = (List)attrs.get(attrName);
            if (values != null && !values.isEmpty()) {
                value = ((String)values.iterator().next()).trim();
            }
            return value;
        }
        catch (SAML2MetaException sme) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AttributeQueryUtil.getAttributeValueFromAttrAuthorityConfig: get AttributeAuthorityConfig failed", (Throwable)((Object)sme));
            }
            return null;
        }
    }

    static {
        try {
            dsProvider = SAML2Utils.getDataStoreProvider();
        }
        catch (SAML2Exception se) {
            SAML2Utils.debug.error("AttributeQueryUtil.static:", (Throwable)((Object)se));
        }
    }
}

