/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.plugins;

import com.sun.identity.liberty.ws.util.ProviderManager;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.key.EncInfo;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import java.security.Key;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Element;

public class SAML2ProviderManager
implements ProviderManager {
    private static SAML2MetaManager metaManager = SAML2Utils.getSAML2MetaManager();

    public boolean containsProvider(String providerID) {
        EntityDescriptorElement ed = null;
        try {
            ed = metaManager.getEntityDescriptor("/", providerID);
        }
        catch (SAML2MetaException smex) {
            SAML2Utils.debug.error("SAML2ProviderManager.containsProvider:", (Throwable)((Object)smex));
        }
        return ed != null;
    }

    public boolean isAffiliationMember(String providerID, String affID) {
        return false;
    }

    public boolean isNameIDEncryptionEnabled(String providerID) {
        List values;
        BaseConfigType config = null;
        try {
            config = metaManager.getSPSSOConfig("/", providerID);
            if (config == null) {
                config = metaManager.getIDPSSOConfig("/", providerID);
            }
        }
        catch (SAML2MetaException smex) {
            SAML2Utils.debug.error("SAML2ProviderManager.isNameIDEncryptionEnabled:", (Throwable)((Object)smex));
        }
        if (config == null) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SAML2ProviderManager.isNameIDEncryptionEnabled:config not found.");
            }
            return false;
        }
        String wantEncrypted = null;
        Map attrMap = SAML2MetaUtils.getAttributes(config);
        if (attrMap != null && !attrMap.isEmpty() && (values = (List)attrMap.get("wantNameIDEncrypted")) != null && !values.isEmpty()) {
            wantEncrypted = (String)values.get(0);
        }
        return wantEncrypted != null && wantEncrypted.equalsIgnoreCase("true");
    }

    public Key getEncryptionKey(String providerID) {
        EncInfo encInfo = this.getEncInfo(providerID);
        return encInfo == null ? null : encInfo.getWrappingKey();
    }

    public int getEncryptionKeyStrength(String providerID) {
        EncInfo encInfo = this.getEncInfo(providerID);
        return encInfo == null ? 0 : encInfo.getDataEncStrength();
    }

    public String getEncryptionKeyAlgorithm(String providerID) {
        EncInfo encInfo = this.getEncInfo(providerID);
        return encInfo == null ? null : encInfo.getDataEncAlgorithm();
    }

    public PrivateKey getDecryptionKey(String providerID) {
        BaseConfigType providerConfig = null;
        try {
            providerConfig = metaManager.getSPSSOConfig("/", providerID);
            if (providerConfig == null) {
                providerConfig = metaManager.getIDPSSOConfig("/", providerID);
            }
        }
        catch (SAML2MetaException smex) {
            SAML2Utils.debug.error("SAML2ProviderManager.getDecryptionKey", (Throwable)((Object)smex));
        }
        if (providerConfig == null) {
            return null;
        }
        return KeyUtil.getDecryptionKey(providerConfig);
    }

    public String getSigningKeyAlias(String providerID) {
        BaseConfigType config = null;
        try {
            config = metaManager.getSPSSOConfig("/", providerID);
            if (config == null) {
                config = metaManager.getIDPSSOConfig("/", providerID);
            }
        }
        catch (SAML2MetaException smex) {
            SAML2Utils.debug.error("SAML2ProviderManager.getSigningKeyAlias:", (Throwable)((Object)smex));
        }
        if (config == null) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SAML2ProviderManager.getSigningKeyAlias:config not found.");
            }
            return null;
        }
        return KeyUtil.getSigningCertAlias(config);
    }

    private EncInfo getEncInfo(String providerID) {
        Element ssod = null;
        try {
            ssod = metaManager.getSPSSODescriptor("/", providerID);
            if (ssod == null) {
                ssod = metaManager.getIDPSSODescriptor("/", providerID);
            }
        }
        catch (SAML2MetaException smex) {
            SAML2Utils.debug.error("SAML2ProviderManager.getEncInfo:", (Throwable)((Object)smex));
        }
        if (ssod == null) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SAML2ProviderManager.getEncInfo: Descriptor not found.");
            }
            return null;
        }
        return KeyUtil.getEncInfo(ssod, providerID, "SPRole");
    }
}

