/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.plugins;

import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.plugins.DefaultAttributeMapper;
import com.sun.identity.saml2.plugins.SPAttributeMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultSPAttributeMapper
extends DefaultAttributeMapper
implements SPAttributeMapper {
    public DefaultSPAttributeMapper() {
        debug.message("DefaultSPAttributeMapper.constructor");
    }

    public Map getAttributes(List attributes, String userID, String hostEntityID, String remoteEntityID, String realm) throws SAML2Exception {
        if (attributes == null || attributes.size() == 0) {
            throw new SAML2Exception(bundle.getString("nullAttributes"));
        }
        if (hostEntityID == null) {
            throw new SAML2Exception(bundle.getString("nullHostEntityID"));
        }
        if (realm == null) {
            throw new SAML2Exception(bundle.getString("nullRealm"));
        }
        try {
            Map configMap = this.getConfigAttributeMap(realm, hostEntityID, "SPRole");
            if (configMap == null || configMap.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("DefaultSPAttributeMapper.getAttr:Configuration map is not defined.");
                }
                return null;
            }
            if (debug.messageEnabled()) {
                debug.message("DefaultSPAttributeMapper.getAttr:hosted SP attribute map = " + configMap);
            }
            HashMap map = new HashMap();
            Iterator iter = attributes.iterator();
            while (iter.hasNext()) {
                Attribute attribute = (Attribute)iter.next();
                HashSet values = new HashSet();
                values.addAll(attribute.getAttributeValueString());
                String attributeName = attribute.getName();
                if ("*".equals((String)configMap.get("*"))) {
                    map.put(attributeName, values);
                    continue;
                }
                String localAttribute = (String)configMap.get(attributeName);
                if (localAttribute == null || localAttribute.length() <= 0) continue;
                map.put(localAttribute, values);
            }
            return map;
        }
        catch (SAML2Exception se) {
            debug.error("DefaultSPAccountMapper.getAttributes:MetaException", (Throwable)((Object)se));
            throw new SAML2Exception(se.getMessage());
        }
    }
}

