/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.plugins;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.AuthnContext;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.plugins.IDPAuthnContextInfo;
import com.sun.identity.saml2.plugins.IDPAuthnContextMapper;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.protocol.AuthnRequest;
import com.sun.identity.saml2.protocol.RequestedAuthnContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class DefaultIDPAuthnContextMapper
implements IDPAuthnContextMapper {
    public static SAML2MetaManager metaManager = SAML2Utils.getSAML2MetaManager();
    private static String DEFAULT = "default";

    public IDPAuthnContextInfo getIDPAuthnContextInfo(AuthnRequest authnRequest, String idpEntityID, String realm) throws SAML2Exception {
        String classMethod = "DefaultIDPAuthnContextMapper.getIDPAuthnContextInfo: ";
        LinkedHashMap classRefSchemesMap = null;
        if (IDPCache.classRefSchemesHash != null) {
            classRefSchemesMap = (Map)IDPCache.classRefSchemesHash.get(idpEntityID + "|" + realm);
        }
        if (classRefSchemesMap == null || classRefSchemesMap.isEmpty()) {
            this.updateAuthnContextMapping(realm, idpEntityID);
            classRefSchemesMap = (Map)IDPCache.classRefSchemesHash.get(idpEntityID + "|" + realm);
            if (classRefSchemesMap == null) {
                classRefSchemesMap = new LinkedHashMap();
            }
        }
        String classRef = null;
        Set authTypeAndValues = null;
        RequestedAuthnContext requestedAuthnContext = null;
        if (authnRequest != null) {
            requestedAuthnContext = authnRequest.getRequestedAuthnContext();
        }
        if (requestedAuthnContext != null) {
            List requestedClassRefs = requestedAuthnContext.getAuthnContextClassRef();
            String comparison = requestedAuthnContext.getComparison();
            Iterator iter = classRefSchemesMap.keySet().iterator();
            while (iter.hasNext()) {
                String tmpClassRef = (String)iter.next();
                if (!this.isAuthnContextMatching(requestedClassRefs, tmpClassRef, comparison, realm, idpEntityID)) continue;
                authTypeAndValues = (Set)classRefSchemesMap.get(tmpClassRef);
                classRef = tmpClassRef;
                break;
            }
            if (classRef == null) {
                return null;
            }
        } else {
            authTypeAndValues = (Set)classRefSchemesMap.get(DEFAULT);
            classRef = (String)IDPCache.defaultClassRefHash.get(idpEntityID + "|" + realm);
            if (classRef == null) {
                classRef = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
            }
        }
        AuthnContext authnContext = AssertionFactory.getInstance().createAuthnContext();
        authnContext.setAuthnContextClassRef(classRef);
        IDPAuthnContextInfo info = new IDPAuthnContextInfo(authnContext, authTypeAndValues);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "\nreturned AuthnContextClassRef=" + classRef + "\nauthTypeAndValues=" + authTypeAndValues);
        }
        return info;
    }

    public AuthnContext getAuthnContextFromAuthLevel(String authLevel, String realm, String idpEntityID) throws SAML2Exception {
        HashMap classRefLevelMap;
        String classRef;
        block9: {
            classRef = null;
            classRefLevelMap = null;
            if (IDPCache.classRefLevelHash != null) {
                classRefLevelMap = (Map)IDPCache.classRefLevelHash.get(idpEntityID + "|" + realm);
            }
            if (classRefLevelMap == null || classRefLevelMap.isEmpty()) {
                this.updateAuthnContextMapping(realm, idpEntityID);
                classRefLevelMap = (Map)IDPCache.classRefLevelHash.get(idpEntityID + "|" + realm);
                if (classRefLevelMap == null) {
                    classRefLevelMap = new HashMap();
                }
            }
            if (authLevel != null && authLevel.length() != 0) {
                try {
                    int level = Integer.parseInt(authLevel);
                    Iterator iter = classRefLevelMap.keySet().iterator();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        Integer value = (Integer)classRefLevelMap.get(key);
                        if (value == null || level != value) continue;
                        classRef = key;
                        break;
                    }
                }
                catch (NumberFormatException ne) {
                    if (!SAML2Utils.debug.messageEnabled()) break block9;
                    SAML2Utils.debug.message("DefaultIDPAuthnContextMapper.getAuthnContextFromLevel: input authLevel is not valid.", (Throwable)ne);
                }
            }
        }
        if (classRef == null && (classRef = (String)IDPCache.defaultClassRefHash.get(idpEntityID + "|" + realm)) == null) {
            classRef = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("DefaultIDPAuthnContext.getClassRefFromLevel: authLevel=" + authLevel + ", classRef=" + classRef + ", classRefLevelMap=" + classRefLevelMap);
        }
        AuthnContext result = AssertionFactory.getInstance().createAuthnContext();
        result.setAuthnContextClassRef(classRef);
        return result;
    }

    public boolean isAuthnContextMatching(List requestedACClassRefs, String acClassRef, String comparison, String realm, String idpEntityID) {
        HashMap acClassRefLevelMap = null;
        if (IDPCache.classRefLevelHash != null) {
            acClassRefLevelMap = (Map)IDPCache.classRefLevelHash.get(idpEntityID + "|" + realm);
        }
        if (acClassRefLevelMap == null || acClassRefLevelMap.isEmpty()) {
            this.updateAuthnContextMapping(realm, idpEntityID);
            acClassRefLevelMap = (Map)IDPCache.classRefLevelHash.get(idpEntityID + "|" + realm);
            if (acClassRefLevelMap == null) {
                acClassRefLevelMap = new HashMap();
            }
        }
        return SAML2Utils.isAuthnContextMatching(requestedACClassRefs, acClassRef, comparison, acClassRefLevelMap);
    }

    private void updateAuthnContextMapping(String realm, String idpEntityID) {
        List values = SAML2Utils.getAllAttributeValueFromSSOConfig(realm, idpEntityID, "IDPRole", "idpAuthncontextClassrefMapping");
        LinkedHashMap<String, Integer> classRefLevelMap = new LinkedHashMap<String, Integer>();
        String defaultClassRef = null;
        LinkedHashMap classRefSchemesMap = new LinkedHashMap();
        if (values != null && values.size() != 0) {
            for (int i = 0; i < values.size(); ++i) {
                StringTokenizer st;
                boolean isDefault = false;
                String value = ((String)values.get(i)).trim();
                if (value.endsWith("|" + DEFAULT)) {
                    value = value.substring(0, value.length() - DEFAULT.length());
                    isDefault = true;
                }
                if (!(st = new StringTokenizer(value, "|")).hasMoreTokens()) continue;
                String classRef = st.nextToken().trim();
                HashSet<String> authTypeAndValues = new HashSet<String>();
                if (st.hasMoreTokens()) {
                    block14: {
                        String level = st.nextToken();
                        if (level.indexOf("=") == -1) {
                            try {
                                Integer authLevel = new Integer(level);
                                classRefLevelMap.put(classRef, authLevel);
                                if (isDefault && !classRefLevelMap.containsKey(DEFAULT)) {
                                    classRefLevelMap.put(DEFAULT, authLevel);
                                    defaultClassRef = classRef;
                                }
                                break block14;
                            }
                            catch (NumberFormatException nfe) {
                                if (SAML2Utils.debug.messageEnabled()) {
                                    SAML2Utils.debug.message("DefaultIDPAuthnContextMapper.getACClassRefLevelMap:", (Throwable)nfe);
                                }
                                break block14;
                            }
                        }
                        if (level.trim().length() != 0) {
                            authTypeAndValues.add(level);
                        }
                    }
                    while (st.hasMoreTokens()) {
                        String authTypeAndValue = st.nextToken().trim();
                        if (authTypeAndValue.length() == 0) continue;
                        authTypeAndValues.add(authTypeAndValue);
                    }
                }
                classRefSchemesMap.put(classRef, authTypeAndValues);
                if (!isDefault) continue;
                classRefSchemesMap.put(DEFAULT, authTypeAndValues);
            }
        }
        String key = idpEntityID + "|" + realm;
        if (!classRefSchemesMap.isEmpty()) {
            IDPCache.classRefSchemesHash.put(key, classRefSchemesMap);
        }
        if (!classRefLevelMap.isEmpty()) {
            IDPCache.classRefLevelHash.put(key, classRefLevelMap);
        }
        if (defaultClassRef != null) {
            IDPCache.defaultClassRefHash.put(key, defaultClassRef);
        }
    }
}

