/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.plugins;

import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.plugins.DefaultAccountMapper;
import com.sun.identity.saml2.plugins.IDPAccountMapper;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.IDPSSOUtil;
import com.sun.identity.saml2.profile.IDPSession;
import com.sun.identity.saml2.profile.NameIDandSPpair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultIDPAccountMapper
extends DefaultAccountMapper
implements IDPAccountMapper {
    public DefaultIDPAccountMapper() {
        debug.message("DefaultIDPAccountMapper.constructor");
        this.role = "IDPRole";
    }

    public NameID getNameID(Object session, String hostEntityID, String remoteEntityID, String realm, String nameIDFormat) throws SAML2Exception {
        String userID = null;
        try {
            SessionProvider sessionProv = SessionManager.getProvider();
            userID = sessionProv.getPrincipalName(session);
        }
        catch (SessionException se) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSSOToken"));
        }
        String nameIDValue = null;
        if (nameIDFormat.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:transient")) {
            List list;
            IDPSession idpSession;
            String sessionIndex = IDPSSOUtil.getSessionIndex(session);
            if (sessionIndex != null && (idpSession = (IDPSession)IDPCache.idpSessionsByIndices.get(sessionIndex)) != null && (list = idpSession.getNameIDandSPpairs()) != null && !list.isEmpty()) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    NameIDandSPpair pair = (NameIDandSPpair)iter.next();
                    if (!pair.getSPEntityID().equals(remoteEntityID)) continue;
                    nameIDValue = pair.getNameID().getValue();
                    break;
                }
            }
            if (nameIDValue == null && (nameIDValue = this.getNameIDValueFromUserProfile(realm, hostEntityID, userID, nameIDFormat)) == null) {
                nameIDValue = SAML2Utils.createNameIdentifier();
            }
        } else {
            nameIDValue = this.getNameIDValueFromUserProfile(realm, hostEntityID, userID, nameIDFormat);
            if (nameIDValue == null) {
                if (nameIDFormat.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent")) {
                    nameIDValue = SAML2Utils.createNameIdentifier();
                } else {
                    throw new SAML2Exception(bundle.getString("unableToGenerateNameIDValue"));
                }
            }
        }
        NameID nameID = AssertionFactory.getInstance().createNameID();
        nameID.setValue(nameIDValue);
        nameID.setFormat(nameIDFormat);
        nameID.setNameQualifier(hostEntityID);
        nameID.setSPNameQualifier(remoteEntityID);
        nameID.setSPProvidedID(null);
        return nameID;
    }

    public String getIdentity(NameID nameID, String hostEntityID, String remoteEntityID, String realm) throws SAML2Exception {
        if (nameID == null) {
            return null;
        }
        if (hostEntityID == null) {
            throw new SAML2Exception(bundle.getString("nullHostEntityID"));
        }
        if (remoteEntityID == null) {
            throw new SAML2Exception(bundle.getString("nullRemoteEntityID"));
        }
        if (realm == null) {
            throw new SAML2Exception(bundle.getString("nullRealm"));
        }
        if (debug.messageEnabled()) {
            debug.message("DefaultIDPAccountMapper.getIdentity: realm = " + realm + ", hostEntityID = " + hostEntityID + ", remoteEntityID = " + remoteEntityID);
        }
        try {
            return dsProvider.getUserID(realm, SAML2Utils.getNameIDKeyMap(nameID, hostEntityID, remoteEntityID, realm, this.role));
        }
        catch (DataStoreProviderException dse) {
            debug.error("DefaultIDPAccountMapper.getIdentity(NameIDMappingRequest): ", (Throwable)((Object)dse));
            throw new SAML2Exception(dse.getMessage());
        }
    }

    protected String getNameIDValueFromUserProfile(String realm, String hostEntityID, String userID, String nameIDFormat) {
        String nameIDValue;
        block4: {
            nameIDValue = null;
            Map formatAttrMap = this.getFormatAttributeMap(realm, hostEntityID);
            String attrName = (String)formatAttrMap.get(nameIDFormat);
            if (attrName != null) {
                try {
                    Set attrValues = dsProvider.getAttribute(userID, attrName);
                    if (attrValues != null && !attrValues.isEmpty()) {
                        nameIDValue = (String)attrValues.iterator().next();
                    }
                }
                catch (DataStoreProviderException dspe) {
                    if (!debug.warningEnabled()) break block4;
                    debug.warning("DefaultIDPAccountMapper.getNameIDValueFromUserProfile:", (Throwable)((Object)dspe));
                }
            }
        }
        return nameIDValue;
    }

    private Map getFormatAttributeMap(String realm, String hostEntityID) {
        String key = hostEntityID + "|" + realm;
        HashMap<String, String> formatAttributeMap = (HashMap<String, String>)IDPCache.formatAttributeHash.get(key);
        if (formatAttributeMap != null) {
            return formatAttributeMap;
        }
        formatAttributeMap = new HashMap<String, String>();
        List values = SAML2Utils.getAllAttributeValueFromSSOConfig(realm, hostEntityID, this.role, "nameIDFormatMap");
        if (values != null && !values.isEmpty()) {
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                String value = (String)iter.next();
                int index = value.indexOf(61);
                if (index == -1) continue;
                String format = value.substring(0, index).trim();
                String attrName = value.substring(index + 1).trim();
                if (format.length() == 0 || attrName.length() == 0) continue;
                formatAttributeMap.put(format, attrName);
            }
        }
        IDPCache.formatAttributeHash.put(key, formatAttributeMap);
        return formatAttributeMap;
    }
}

