/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.plugins;

import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.protocol.ManageNameIDRequest;
import com.sun.identity.shared.debug.Debug;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class DefaultAccountMapper {
    protected static Debug debug = SAML2Utils.debug;
    protected static ResourceBundle bundle = SAML2Utils.bundle;
    protected static DataStoreProvider dsProvider = null;
    protected static SAML2MetaManager metaManager = null;
    protected static final String IDP = "IDPRole";
    protected static final String SP = "SPRole";
    protected String role = null;
    protected static KeyProvider keyProvider = KeyUtil.getKeyProviderInstance();

    public DefaultAccountMapper() {
        debug.message("DefaultAccountMapper.constructor: ");
    }

    public String getIdentity(ManageNameIDRequest manageNameIDRequest, String hostEntityID, String realm) throws SAML2Exception {
        if (manageNameIDRequest == null) {
            throw new SAML2Exception(bundle.getString("nullManageIDRequest"));
        }
        if (hostEntityID == null) {
            throw new SAML2Exception(bundle.getString("nullHostEntityID"));
        }
        if (realm == null) {
            throw new SAML2Exception(bundle.getString("nullRealm"));
        }
        NameID nameID = null;
        EncryptedID encryptedID = manageNameIDRequest.getEncryptedID();
        if (encryptedID != null) {
            String alias = SAML2Utils.getEncryptionCertAlias(realm, hostEntityID, this.role);
            PrivateKey privateKey = keyProvider.getPrivateKey(alias);
            nameID = encryptedID.decrypt(privateKey);
        } else {
            nameID = manageNameIDRequest.getNameID();
        }
        String remoteEntityID = manageNameIDRequest.getIssuer().getValue();
        if (debug.messageEnabled()) {
            debug.message("DefaultAccountMapper.getIdentity(ManageNameIDReq) realm = " + realm + " hostEntityID = " + hostEntityID);
        }
        try {
            return dsProvider.getUserID(realm, SAML2Utils.getNameIDKeyMap(nameID, hostEntityID, remoteEntityID, realm, this.role));
        }
        catch (DataStoreProviderException dse) {
            debug.error("DefaultAccountMapper.getIdentity(MNIRequest,): DataStoreProviderException", (Throwable)((Object)dse));
            throw new SAML2Exception(dse.getMessage());
        }
    }

    protected String getAttribute(String realm, String entityID, String attributeName) {
        if (realm == null || entityID == null || attributeName == null) {
            if (debug.messageEnabled()) {
                debug.message("DefaultAccountMapper.getAttribute: null input parameters.");
            }
            return null;
        }
        try {
            BaseConfigType config = null;
            config = this.role.equals(IDP) ? metaManager.getIDPSSOConfig(realm, entityID) : metaManager.getSPSSOConfig(realm, entityID);
            Map attributes = SAML2MetaUtils.getAttributes(config);
            if (attributes == null || attributes.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("DefaultAccountMapper.getAttribute: attribute configuration is not defined for Entity " + entityID + " realm =" + realm + " role=" + this.role);
                }
                return null;
            }
            List list = (List)attributes.get(attributeName);
            if (list != null && list.size() > 0) {
                return (String)list.iterator().next();
            }
            if (debug.messageEnabled()) {
                debug.message("DefaultSPAccountMapper.getAttribute: " + attributeName + " is not configured.");
            }
            return null;
        }
        catch (SAML2MetaException sme) {
            if (debug.warningEnabled()) {
                debug.warning("DefaultSPAccountMapper.getAttribute:Meta Exception", (Throwable)((Object)sme));
            }
            return null;
        }
    }

    static {
        try {
            dsProvider = SAML2Utils.getDataStoreProvider();
            metaManager = new SAML2MetaManager();
        }
        catch (Exception se) {
            debug.error("DefaultAccountMapper.static intialization failed", (Throwable)se);
        }
    }
}

