/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.meta;

import com.sun.identity.saml2.jaxb.entityconfig.AttributeType;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.ObjectFactory;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.shared.debug.Debug;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;

public class SAML2COTUtils {
    private static Debug debug = SAML2MetaUtils.debug;

    public void updateEntityConfig(String realm, String name, String entityId) throws SAML2MetaException, JAXBException {
        String classMethod = "SAML2COTUtils.updateEntityConfig: ";
        SAML2MetaManager metaManager = new SAML2MetaManager();
        ObjectFactory objFactory = new ObjectFactory();
        EntityDescriptorElement edes = metaManager.getEntityDescriptor(realm, entityId);
        if (edes == null) {
            debug.error(classMethod + "No such entity: " + entityId);
            Object[] data = new String[]{realm, entityId};
            throw new SAML2MetaException("entityid_invalid", data);
        }
        EntityConfigElement eConfig = metaManager.getEntityConfig(realm, entityId);
        if (eConfig == null) {
            BaseConfigType bctype = null;
            AttributeType atype = objFactory.createAttributeType();
            atype.setName("cotlist");
            atype.getValue().add(name);
            EntityConfigElement ele = objFactory.createEntityConfigElement();
            ele.setEntityID(entityId);
            ele.setHosted(false);
            List ll = ele.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig();
            if (SAML2MetaUtils.getSPSSODescriptor(edes) != null) {
                bctype = objFactory.createSPSSOConfigElement();
                bctype.getAttribute().add(atype);
                ll.add(bctype);
            }
            if (SAML2MetaUtils.getIDPSSODescriptor(edes) != null) {
                bctype = objFactory.createIDPSSOConfigElement();
                bctype.getAttribute().add(atype);
                ll.add(bctype);
            }
            if (SAML2MetaUtils.getPolicyEnforcementPointDescriptor(edes) != null) {
                bctype = objFactory.createXACMLAuthzDecisionQueryConfigElement();
                bctype.getAttribute().add(atype);
                ll.add(bctype);
            }
            if (SAML2MetaUtils.getPolicyDecisionPointDescriptor(edes) != null) {
                bctype = objFactory.createXACMLPDPConfigElement();
                bctype.getAttribute().add(atype);
                ll.add(bctype);
            }
            metaManager.setEntityConfig(realm, ele);
        } else {
            List elist = eConfig.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig();
            Iterator iter = elist.iterator();
            while (iter.hasNext()) {
                boolean foundCOT = false;
                BaseConfigType bConfig = (BaseConfigType)iter.next();
                List list = bConfig.getAttribute();
                Iterator iter2 = list.iterator();
                while (iter2.hasNext()) {
                    AttributeType avp = (AttributeType)iter2.next();
                    if (!avp.getName().trim().equalsIgnoreCase("cotlist")) continue;
                    foundCOT = true;
                    List avpl = avp.getValue();
                    if (!avpl.isEmpty() && this.containsValue(avpl, name)) continue;
                    avpl.add(name);
                    metaManager.setEntityConfig(realm, eConfig);
                    break;
                }
                if (foundCOT) continue;
                AttributeType atype = objFactory.createAttributeType();
                atype.setName("cotlist");
                atype.getValue().add(name);
                list.add(atype);
                metaManager.setEntityConfig(realm, eConfig);
            }
        }
    }

    private boolean containsValue(List list, String name) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).trim().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void removeFromEntityConfig(String realm, String name, String entityId) throws SAML2MetaException, JAXBException {
        String classMethod = "SAML2COTUtils.removeFromEntityConfig: ";
        SAML2MetaManager metaManager = new SAML2MetaManager();
        EntityDescriptorElement edes = metaManager.getEntityDescriptor(realm, entityId);
        if (edes == null) {
            debug.error(classMethod + "No such entity: " + entityId);
            Object[] data = new String[]{realm, entityId};
            throw new SAML2MetaException("entityid_invalid", data);
        }
        EntityConfigElement eConfig = metaManager.getEntityConfig(realm, entityId);
        if (eConfig != null) {
            List elist = eConfig.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig();
            Iterator iter = elist.iterator();
            block0: while (iter.hasNext()) {
                BaseConfigType bConfig = (BaseConfigType)iter.next();
                List list = bConfig.getAttribute();
                Iterator iter2 = list.iterator();
                while (iter2.hasNext()) {
                    List avpl;
                    AttributeType avp = (AttributeType)iter2.next();
                    if (!avp.getName().trim().equalsIgnoreCase("cotlist") || (avpl = avp.getValue()) == null || avpl.isEmpty() || !this.containsValue(avpl, name)) continue;
                    avpl.remove(name);
                    metaManager.setEntityConfig(realm, eConfig);
                    continue block0;
                }
            }
        }
    }
}

