/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.common;

import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.saml2.common.NameIDInfo;
import com.sun.identity.saml2.common.NameIDInfoKey;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AccountUtils {
    private static final String DELIM = "|";
    private static final String NAMEID_INFO_ATTRIBUTE = "com.sun.identity.saml2.nameidinfo.attribute";
    private static final String NAMEID_INFO_KEY_ATTRIBUTE = "com.sun.identity.saml2.nameidinfokey.attribute";
    static SAML2MetaManager metaManager = null;

    public static NameIDInfo getAccountFederation(String userID, String hostEntityID, String remoteEntityID) throws SAML2Exception {
        SAML2Utils.debug.message("AccountUtils.getAccountFederation:");
        if (userID == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullUserID"));
        }
        if (hostEntityID == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullHostEntityID"));
        }
        if (remoteEntityID == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullRemoteEntityID"));
        }
        try {
            Set set = SAML2Utils.getDataStoreProvider().getAttribute(userID, AccountUtils.getNameIDInfoAttribute());
            if (set == null || set.isEmpty()) {
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("AccountUtils.getAccountFederation : user does not have any account federations.");
                }
                return null;
            }
            String filter = hostEntityID + DELIM + remoteEntityID + DELIM;
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AccountUtils.getAccountFederation:  filter = " + filter + " userID = " + userID);
            }
            String info = null;
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                String value = (String)iter.next();
                if (!value.startsWith(filter)) continue;
                info = value;
                break;
            }
            if (info == null) {
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("AccountUtils.getAccountFederation : user does not have account federation  corresponding to =" + filter);
                }
                return null;
            }
            return NameIDInfo.parse(info);
        }
        catch (DataStoreProviderException dse) {
            SAML2Utils.debug.error("AccountUtils.readAccountFederationInfo: DataStoreProviderException", (Throwable)((Object)dse));
            throw new SAML2Exception(dse.getMessage());
        }
    }

    public static void setAccountFederation(NameIDInfo info, String userID) throws SAML2Exception {
        SAML2Utils.debug.message("AccountUtils.setAccountFederation:");
        if (info == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullNameIDInfo"));
        }
        if (userID == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullUserID"));
        }
        NameIDInfoKey infoKey = new NameIDInfoKey(info.getNameIDValue(), info.getHostEntityID(), info.getRemoteEntityID());
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("AccountUtils.setAccountFederation: info to be set:" + info.toValueString() + "," + "infoKey to be set:" + infoKey.toValueString());
        }
        String filter = info.getHostEntityID() + DELIM + info.getRemoteEntityID() + DELIM;
        try {
            String nameIDInfoAttr = AccountUtils.getNameIDInfoAttribute();
            String nameIDInfoKeyAttr = AccountUtils.getNameIDInfoKeyAttribute();
            HashSet<String> set = new HashSet<String>();
            set.add(nameIDInfoAttr);
            set.add(nameIDInfoKeyAttr);
            HashMap map = new HashMap();
            Map existMap = SAML2Utils.getDataStoreProvider().getAttributes(userID, set);
            if (existMap == null || existMap.isEmpty()) {
                HashSet<String> set1 = new HashSet<String>();
                set1.add(infoKey.toValueString());
                map.put(nameIDInfoKeyAttr, set1);
                HashSet<String> set2 = new HashSet<String>();
                set2.add(info.toValueString());
                map.put(nameIDInfoAttr, set2);
            } else {
                HashSet<String> set1 = (HashSet<String>)existMap.get(nameIDInfoAttr);
                if (set1 != null) {
                    Iterator iter1 = set1.iterator();
                    while (iter1.hasNext()) {
                        String value = (String)iter1.next();
                        if (!value.startsWith(filter)) continue;
                        iter1.remove();
                    }
                } else {
                    set1 = new HashSet<String>();
                }
                set1.add(info.toValueString());
                map.put(nameIDInfoAttr, set1);
                HashSet<String> set2 = (HashSet<String>)existMap.get(nameIDInfoKeyAttr);
                if (set2 != null) {
                    Iterator iter2 = set2.iterator();
                    while (iter2.hasNext()) {
                        String value = (String)iter2.next();
                        if (!value.startsWith(filter)) continue;
                        iter2.remove();
                    }
                } else {
                    set2 = new HashSet<String>();
                }
                set2.add(infoKey.toValueString());
                map.put(nameIDInfoKeyAttr, set2);
            }
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AccountUtils.setAccountFederation:  set fedinfo " + map + " userID = " + userID);
            }
            SAML2Utils.getDataStoreProvider().setAttributes(userID, map);
        }
        catch (DataStoreProviderException dse) {
            SAML2Utils.debug.error("SAML2Utils.setAccountFederation: DataStoreProviderException", (Throwable)((Object)dse));
            throw new SAML2Exception(dse.getMessage());
        }
    }

    public static boolean removeAccountFederation(NameIDInfo info, String userID) throws SAML2Exception {
        SAML2Utils.debug.message("AccountUtils.removeAccountFederation:");
        if (info == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullNameIDInfo"));
        }
        if (userID == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullUserID"));
        }
        try {
            Set existingFed = SAML2Utils.getDataStoreProvider().getAttribute(userID, AccountUtils.getNameIDInfoAttribute());
            Set existingInfoKey = SAML2Utils.getDataStoreProvider().getAttribute(userID, AccountUtils.getNameIDInfoKeyAttribute());
            if (existingFed == null || existingFed.isEmpty()) {
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("AccountUtils.removeAccountFederation: user does not have account federation infos.");
                }
                return false;
            }
            String infoValue = info.toValueString();
            String infoKeyValue = info.getNameIDInfoKey().toValueString();
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AccountUtils.removeAccountFederation: info to be removed:" + infoValue + "user=" + userID + "infoKeyValue = " + infoKeyValue);
            }
            if (existingFed.contains(infoValue)) {
                existingFed.remove(infoValue);
                if (existingInfoKey != null && existingInfoKey.contains(infoKeyValue)) {
                    existingInfoKey.remove(infoKeyValue);
                }
                HashMap<String, Set> map = new HashMap<String, Set>();
                map.put(AccountUtils.getNameIDInfoAttribute(), existingFed);
                map.put(AccountUtils.getNameIDInfoKeyAttribute(), existingInfoKey);
                SAML2Utils.getDataStoreProvider().setAttributes(userID, map);
                return true;
            }
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AccountUtils.removeAccountFederation: account federation info not found.");
            }
            return false;
        }
        catch (DataStoreProviderException dse) {
            SAML2Utils.debug.error("SAML2Utils.removeAccountFederation: DataStoreProviderException", (Throwable)((Object)dse));
            throw new SAML2Exception(dse.getMessage());
        }
    }

    public static String getNameIDInfoAttribute() {
        return SystemPropertiesManager.get((String)NAMEID_INFO_ATTRIBUTE, (String)"sun-fm-saml2-nameid-info");
    }

    public static String getNameIDInfoKeyAttribute() {
        return SystemPropertiesManager.get((String)NAMEID_INFO_KEY_ATTRIBUTE, (String)"sun-fm-saml2-nameid-infokey");
    }

    static {
        try {
            metaManager = new SAML2MetaManager();
        }
        catch (SAML2MetaException se) {
            SAML2Utils.debug.error("Unable to obtain Meta Manager.", (Throwable)((Object)se));
        }
    }
}

