/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.ProxyRestriction;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProxyRestrictionImpl
implements ProxyRestriction {
    private int count;
    private boolean isMutable = true;
    private List audiences = new ArrayList();
    public static final String PROXY_RESTRICTION_ELEMENT = "ProxyRestriction";
    public static final String COUNT_ATTR = "Count";
    public static final String AUDIENCE_ELEMENT = "Audience";

    public ProxyRestrictionImpl() {
    }

    public ProxyRestrictionImpl(String xml) throws SAML2Exception {
        Document document = XMLUtils.toDOMDocument((String)xml, (Debug)SAML2SDKUtils.debug);
        if (document == null) {
            SAML2SDKUtils.debug.error("ProxyRestrictionImpl.processElement(): invalid XML input");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public ProxyRestrictionImpl(Element element) throws SAML2Exception {
        this.processElement(element);
        this.makeImmutable();
    }

    private void processElement(Element element) throws SAML2Exception {
        NodeList nodes;
        int numOfNodes;
        if (element == null) {
            SAML2SDKUtils.debug.error("ProxyRestrictionImpl.processElement(): invalid root element");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            SAML2SDKUtils.debug.error("ProxyRestrictionImpl.processElement(): local name missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_local_name"));
        }
        if (!elemName.equals(PROXY_RESTRICTION_ELEMENT)) {
            SAML2SDKUtils.debug.error("ProxyRestrictionImpl.processElement(): invalid local name " + elemName);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_local_name"));
        }
        String attrValue = element.getAttribute(COUNT_ATTR);
        if (attrValue != null && attrValue.trim().length() != 0) {
            try {
                this.setCount(Integer.parseInt(attrValue));
            }
            catch (NumberFormatException e) {
                SAML2SDKUtils.debug.error("ProxyRestrictionImpl.processElement(): count is not an integer " + attrValue);
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_count_number"));
            }
        }
        if ((numOfNodes = (nodes = element.getChildNodes()).getLength()) < 1) {
            return;
        }
        for (int nextElem = 0; nextElem < numOfNodes; ++nextElem) {
            String childName;
            Node child = nodes.item(nextElem);
            if (child.getNodeType() != 1 || (childName = child.getLocalName()) == null) continue;
            if (childName.equals(AUDIENCE_ELEMENT)) {
                this.audiences.add(XMLUtils.getElementValue((Element)((Element)child)));
                continue;
            }
            SAML2SDKUtils.debug.error("AudienceRestrictionImpl.processElement(): unexpected subelement " + childName);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("unexpected_subelement"));
        }
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        if (this.count < 0) {
            SAML2SDKUtils.debug.error("AudienceRestrictionImpl.setCount(): count is negative");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("negative_count_number"));
        }
        this.count = value;
    }

    public List getAudience() {
        return this.audiences;
    }

    public void setAudience(List audiences) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.audiences = audiences;
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        StringBuffer sb = new StringBuffer(2000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        if (includeNSPrefix) {
            appendNS = "saml:";
        }
        sb.append("<").append(appendNS).append(PROXY_RESTRICTION_ELEMENT).append(NS);
        if (this.count >= 0) {
            sb.append(" ").append(COUNT_ATTR).append("=\"").append(this.count).append("\"");
        }
        sb.append(">\n");
        int length = 0;
        if (this.audiences != null && (length = this.audiences.size()) > 0) {
            for (int i = 0; i < length; ++i) {
                String au = (String)this.audiences.get(i);
                sb.append("<").append(appendNS).append(AUDIENCE_ELEMENT).append(">").append(au).append("</").append(appendNS).append(AUDIENCE_ELEMENT).append(">\n");
            }
        }
        sb.append("</").append(appendNS).append(PROXY_RESTRICTION_ELEMENT).append(">\n");
        return sb.toString();
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public void makeImmutable() {
        if (this.isMutable) {
            if (this.audiences != null) {
                this.audiences = Collections.unmodifiableList(this.audiences);
            }
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }
}

