/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.assertion.EncryptedAttribute;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.xmlenc.EncManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeImpl
implements Attribute {
    private List attrValues = null;
    private List valueStrings = null;
    private String name = null;
    private String nameFormat = null;
    private String friendlyName = null;
    private Map anyMap = null;
    private boolean mutable = true;

    private String validateAndGetAttributeValue(String value) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument((String)value, (Debug)SAML2SDKUtils.debug);
        if (doc == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AttributeImpl.validateAttributeValue: could not obtain AttributeValue element.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        Element element = doc.getDocumentElement();
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AttributeImpl.validateAttributeValue: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = element.getLocalName();
        if (tag == null || !tag.equals("AttributeValue")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AttributeImpl.validateAttributeValue: not AttributeValue.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        return XMLUtils.getChildrenValue((Element)element);
    }

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AttributeImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = element.getLocalName();
        if (tag == null || !tag.equals("Attribute")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AttributeImpl.parseElement: not Attribute.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        NamedNodeMap atts = element.getAttributes();
        if (atts != null) {
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attr = (Attr)atts.item(i);
                String attrName = attr.getName();
                String attrValue = attr.getValue().trim();
                if (attrName.equals("Name")) {
                    this.name = attrValue;
                    continue;
                }
                if (attrName.equals("NameFormat")) {
                    this.nameFormat = attrValue;
                    continue;
                }
                if (attrName.equals("FriendlyName")) {
                    this.friendlyName = attrValue;
                    continue;
                }
                if (attrValue.equals("urn:oasis:names:tc:SAML:2.0:assertion")) continue;
                if (this.anyMap == null) {
                    this.anyMap = new HashMap();
                }
                this.anyMap.put(attrName, attrValue);
            }
        }
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("AttributeValue")) {
                if (this.attrValues == null) {
                    this.attrValues = new ArrayList();
                }
                this.attrValues.add(XMLUtils.print((Node)child));
                if (this.valueStrings == null) {
                    this.valueStrings = new ArrayList();
                }
                this.valueStrings.add(XMLUtils.getChildrenValue((Element)((Element)child)));
                continue;
            }
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("Attributempl.parseElement: Invalid element:" + childName);
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidElement"));
        }
        if (this.name == null || this.name.trim().length() == 0) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AttributeImpl.parseElement: missing Name attribute.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingAttribute"));
        }
        if (this.attrValues != null) {
            this.attrValues = Collections.unmodifiableList(this.attrValues);
        }
        if (this.valueStrings != null) {
            this.valueStrings = Collections.unmodifiableList(this.valueStrings);
        }
        if (this.anyMap != null) {
            this.anyMap = Collections.unmodifiableMap(this.anyMap);
        }
        this.mutable = false;
    }

    public AttributeImpl() {
    }

    public AttributeImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public AttributeImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(doc.getDocumentElement());
    }

    public void makeImmutable() {
        if (this.mutable) {
            if (this.attrValues != null) {
                this.attrValues = Collections.unmodifiableList(this.attrValues);
            }
            if (this.valueStrings != null) {
                this.valueStrings = Collections.unmodifiableList(this.valueStrings);
            }
            if (this.anyMap != null) {
                this.anyMap = Collections.unmodifiableMap(this.anyMap);
            }
            this.mutable = false;
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public List getAttributeValue() {
        return this.attrValues;
    }

    public void setAttributeValue(List value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        if (value != null) {
            Iterator iter = value.iterator();
            this.attrValues = new ArrayList();
            this.valueStrings = new ArrayList();
            while (iter.hasNext()) {
                String attr = (String)iter.next();
                this.valueStrings.add(this.validateAndGetAttributeValue(attr));
                this.attrValues.add(attr);
            }
        } else {
            this.attrValues = null;
            this.valueStrings = null;
        }
    }

    public List getAttributeValueString() {
        return this.valueStrings;
    }

    public void setAttributeValueString(List value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        if (value != null) {
            this.attrValues = new ArrayList();
            this.valueStrings = new ArrayList();
            Iterator iter = value.iterator();
            while (iter.hasNext()) {
                String attr = (String)iter.next();
                this.attrValues.add("<saml:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">" + attr + "</saml:AttributeValue>");
                this.valueStrings.add(attr);
            }
        } else {
            this.attrValues = null;
            this.valueStrings = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.name = value;
    }

    public String getNameFormat() {
        return this.nameFormat;
    }

    public void setNameFormat(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.nameFormat = value;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.friendlyName = value;
    }

    public Map getAnyAttribute() {
        return this.anyMap;
    }

    public void setAnyAttribute(Map value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.anyMap = value;
    }

    public EncryptedAttribute encrypt(Key recipientPublicKey, String dataEncAlgorithm, int dataEncStrength, String recipientEntityID) throws SAML2Exception {
        Element el = EncManager.getEncInstance().encrypt(this.toXMLString(true, true), recipientPublicKey, dataEncAlgorithm, dataEncStrength, recipientEntityID, "EncryptedAttribute");
        return AssertionFactory.getInstance().createEncryptedAttribute(el);
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws SAML2Exception {
        if (this.name == null || this.name.trim().length() == 0) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AttributeImpl.toXMLString: missing Attribute Name.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingAttribute"));
        }
        StringBuffer result = new StringBuffer(1000);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        result.append("<").append(prefix).append("Attribute").append(uri).append(" Name=\"").append(this.name).append("\"");
        if (this.nameFormat != null && this.nameFormat.trim().length() != 0) {
            result.append(" NameFormat=\"").append(this.nameFormat).append("\"");
        }
        if (this.friendlyName != null && this.friendlyName.trim().length() != 0) {
            result.append(" FriendlyName=\"").append(this.friendlyName).append("\"");
        }
        if (this.anyMap != null) {
            Iterator keyIter = this.anyMap.keySet().iterator();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                String value = (String)this.anyMap.get(key);
                if (value == null) {
                    value = "";
                }
                result.append(" ").append(key).append("=\"").append(value).append("\"");
            }
        }
        result.append(">");
        if (this.attrValues != null) {
            Iterator iter = this.attrValues.iterator();
            while (iter.hasNext()) {
                result.append((String)iter.next());
            }
        }
        result.append("</").append(prefix).append("Attribute>");
        return result.toString();
    }
}

