/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.AssertionIDRef;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AssertionIDRefImpl
implements AssertionIDRef {
    private String value;
    private boolean mutable = true;

    public AssertionIDRefImpl() {
    }

    public AssertionIDRefImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public AssertionIDRefImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2Utils.debug);
        if (doc == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(doc.getDocumentElement());
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("objectImmutable"));
        }
        this.value = value;
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws SAML2Exception {
        if (this.value == null || this.value.trim().length() == 0) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AssertionIDRefImpl.toXMLString: AssertionIDRef value is null or empty.");
            }
            throw new SAML2Exception(SAML2Utils.bundle.getString("emptyElementValue"));
        }
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        return "<" + prefix + "AssertionIDRef" + uri + ">" + this.value + "</" + prefix + "AssertionIDRef" + ">";
    }

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            SAML2Utils.debug.message("AssertionIDRefImpl.parseElement: Input is null.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullInput"));
        }
        String tag = element.getLocalName();
        if (!"AssertionIDRef".equals(tag)) {
            SAML2Utils.debug.message("AssertionIDRefImpl.parseElement: Element local name is not AssertionIDRef.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("wrongInput"));
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (int i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("AssertionIDRefImpl.parseElement: AssertionIDRef can't have child element.");
                }
                throw new SAML2Exception(SAML2Utils.bundle.getString("wrongInput"));
            }
        }
        this.value = XMLUtils.getElementValue((Element)element);
        if (this.value == null || this.value.trim().length() == 0) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AssertionIDRefImpl.parseElement: AssertionIDRef value is null or empty.");
            }
            throw new SAML2Exception(SAML2Utils.bundle.getString("emptyElementValue"));
        }
        this.mutable = false;
    }
}

