/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.servlet;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.common.LogUtils;
import com.sun.identity.saml.common.SAMLCertUtils;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequestVersionTooHighException;
import com.sun.identity.saml.common.SAMLRequestVersionTooLowException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.Query;
import com.sun.identity.saml.protocol.Request;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLSOAPReceiver
extends HttpServlet {
    private static MessageFactory msgFactory = null;
    private static SAMLConstants sc = null;
    public static String localSAMLServiceID = null;

    public void init(ServletConfig config) throws ServletException {
        String localServerProtocol = SystemConfigurationUtil.getProperty("com.iplanet.am.server.protocol");
        String localServer = SystemConfigurationUtil.getProperty("com.iplanet.am.server.host");
        String localServerPort = SystemConfigurationUtil.getProperty("com.iplanet.am.server.port");
        localSAMLServiceID = localServerProtocol + "://" + localServer + ":" + localServerPort;
        super.init(config);
        try {
            msgFactory = MessageFactory.newInstance();
        }
        catch (SOAPException ex) {
            String message = SAMLUtils.bundle.getString("missingSoapMessageFactory");
            SAMLUtils.debug.error(message, (Throwable)ex);
            String[] data = new String[]{SAMLUtils.bundle.getString("missingSoapMessageFactory")};
            LogUtils.error(Level.INFO, "SOAP_MESSAGE_FACTORY_ERROR", data);
            throw new ServletException(ex.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (SAMLUtils.getMaxContentLength() != 0) {
            int length = req.getContentLength();
            if (length == -1) {
                throw new ServletException(SAMLUtils.bundle.getString("unknownLength"));
            }
            if (length > SAMLUtils.getMaxContentLength()) {
                if (!SAMLUtils.debug.messageEnabled()) throw new ServletException(SAMLUtils.bundle.getString("largeContentLength"));
                SAMLUtils.debug.message("content length too large" + length);
                throw new ServletException(SAMLUtils.bundle.getString("largeContentLength"));
            }
        }
        String remoteAddr = req.getRemoteAddr();
        Set partnerSourceID = null;
        partnerSourceID = SAMLSOAPReceiver.checkCaller(req, resp);
        if (partnerSourceID != null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message(" got request from a trusted server, processing it now..");
            }
            try {
                MimeHeaders mimeHeaders = SAMLUtils.getMimeHeaders(req);
                ServletInputStream sInputStream = req.getInputStream();
                SOAPMessage soapMessage = msgFactory.createMessage(mimeHeaders, (InputStream)sInputStream);
                SOAPMessage soapMessageReply = null;
                soapMessageReply = this.onMessage(req, resp, soapMessage, partnerSourceID);
                if (soapMessageReply == null) return;
                if (soapMessageReply.saveRequired()) {
                    soapMessageReply.saveChanges();
                }
                if (this.containsFault(soapMessageReply)) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Contains a SOAPFault!");
                    }
                    resp.setStatus(500);
                } else {
                    resp.setStatus(200);
                }
                SAMLUtils.setMimeHeaders(soapMessageReply.getMimeHeaders(), resp);
                ServletOutputStream sOutputStream = resp.getOutputStream();
                soapMessageReply.writeTo((OutputStream)sOutputStream);
                sOutputStream.flush();
                return;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            SAMLUtils.debug.error("Error message from SOAP Receiver:" + remoteAddr + " is untrusted site");
            String[] data = new String[]{SAMLUtils.bundle.getString("untrustedSite"), remoteAddr};
            LogUtils.error(Level.INFO, "UNTRUSTED_SITE", data);
            resp.sendError(403);
        }
    }

    private boolean containsFault(SOAPMessage msg) {
        try {
            SOAPPart sp = msg.getSOAPPart();
            SOAPEnvelope se = sp.getEnvelope();
            SOAPBody sb = se.getBody();
            return sb.hasFault();
        }
        catch (Exception e) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Error in containFault!");
            }
            return false;
        }
    }

    private SOAPMessage onMessage(HttpServletRequest req, HttpServletResponse servletResp, SOAPMessage message, Set partnerSourceID) {
        try {
            String childName;
            Document doc;
            block11: {
                block10: {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("OnMessage called in receiving servlet");
                    }
                    ByteArrayOutputStream bop = new ByteArrayOutputStream();
                    message.writeTo((OutputStream)bop);
                    ByteArrayInputStream bin = new ByteArrayInputStream(bop.toByteArray());
                    doc = XMLUtils.toDOMDocument((InputStream)bin, (Debug)SAMLUtils.debug);
                    Element root = doc.getDocumentElement();
                    String rootName = doc.getDocumentElement().getLocalName();
                    if (rootName == null || rootName.length() == 0) {
                        SAMLUtils.debug.error("Local name of the SOAPElement in  the SOAPMessage passed seems to be missing");
                        return this.FormSOAPError(servletResp, "Client", "nullInput", "LocalNameMissing");
                    }
                    if (!rootName.equals("Envelope")) break block10;
                    if (root.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) break block11;
                }
                SAMLUtils.debug.error("SOAPReceiver: Could not parse SOAPMessage, either root element is not Envelope or invalid name space or prefix");
                return this.FormSOAPError(servletResp, "Client", "invalidElement", "envelopeInvalid");
            }
            NodeList nl = doc.getChildNodes();
            int length = nl.getLength();
            if (length <= 0) {
                SAMLUtils.debug.error("SOAPReceiver: Message does not have body");
                return this.FormSOAPError(servletResp, "Client", "missingBody", null);
            }
            Node child = null;
            for (int i = 0; !(i >= length || (child = nl.item(i)).getNodeType() == 1 && (childName = child.getLocalName()).equals("Body")); ++i) {
            }
            Element body = (Element)child;
            Response resp = this.extractProcessRequest(req, body, partnerSourceID);
            if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signresponse")).booleanValue()) {
                resp.signXML();
            }
            return this.FormMessageResponse(servletResp, resp);
        }
        catch (Exception e) {
            SAMLUtils.debug.error("Error in processing Request", (Throwable)e);
            return this.FormSOAPError(servletResp, "Server", "cannotProcessRequest", null);
        }
    }

    private Response extractProcessRequest(HttpServletRequest servletReq, Element body, Set partnerSourceID) {
        String[] data;
        String[] data2;
        String[] data3;
        String remoteAddr;
        Response retResponse = null;
        String respID = SAMLUtils.generateID();
        String inResponseTo = null;
        ArrayList contents = new ArrayList();
        String message = null;
        String recipient = remoteAddr = servletReq.getRemoteAddr();
        String invalidRespPrefix = SAMLUtils.bundle.getString("invalidRequestLogMessage") + " " + remoteAddr + ": ";
        String respPrefix = SAMLUtils.bundle.getString("responseLogMessage") + " " + remoteAddr + ": ";
        NodeList nl = body.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:protocol", "Request");
        int length = nl.getLength();
        if (length == 0) {
            SAMLUtils.debug.error("SOAPReceiver: Body does not have a Request");
            message = SAMLUtils.bundle.getString("missingRequest");
            try {
                Status status = new Status(new StatusCode("samlp:Requester"), message, null);
                retResponse = new Response(respID, inResponseTo, status, recipient, contents);
            }
            catch (SAMLException se) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + se.getMessage());
            }
            String[] data4 = new String[]{invalidRespPrefix, retResponse.toString()};
            LogUtils.error(Level.INFO, "INVALID_REQUEST", data4);
            return retResponse;
        }
        boolean foundRequest = false;
        AbstractRequest req = null;
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1 || !child.getLocalName().equals("Request")) continue;
            try {
                req = new Request((Element)child);
                SAMLUtils.debug.message("found request ");
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message(" Received Request:" + ((Request)req).toString());
                }
                data3 = new String[]{SAMLUtils.bundle.getString("requestLogMessage") + " " + remoteAddr, ((Request)req).toString()};
                LogUtils.access(Level.FINE, "SOAP_REQUEST_MESSAGE", data3);
                inResponseTo = req.getRequestID();
                foundRequest = true;
                break;
            }
            catch (SAMLRequesterException ss) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("SOAPReceiver:setting status to samlp:Requester " + ss.getMessage());
                }
                message = new String(ss.getMessage());
                try {
                    Status status = new Status(new StatusCode("samlp:Requester"), message, null);
                    retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                }
                catch (SAMLException se) {
                    SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + se.getMessage());
                }
                String[] data5 = new String[]{invalidRespPrefix, retResponse.toString()};
                LogUtils.error(Level.INFO, "INVALID_REQUEST", data5);
                return retResponse;
            }
            catch (SAMLRequestVersionTooHighException sv) {
                String mesg = new String(sv.getMessage());
                StringTokenizer tok1 = new StringTokenizer(mesg, "|");
                inResponseTo = tok1.nextToken();
                message = tok1.nextToken();
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("SOAPReceiver:setting status to samlp:VersionMismatch " + message);
                }
                try {
                    Status status = new Status(new StatusCode("samlp:RequestVersionTooHigh"), message, null);
                    retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                }
                catch (SAMLException se) {
                    SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + se.getMessage());
                }
                String[] data6 = new String[]{invalidRespPrefix, retResponse.toString()};
                LogUtils.error(Level.INFO, "INVALID_REQUEST", data6);
                return retResponse;
            }
            catch (SAMLRequestVersionTooLowException sv) {
                String mesg = new String(sv.getMessage());
                StringTokenizer tok1 = new StringTokenizer(mesg, "|");
                inResponseTo = tok1.nextToken();
                message = tok1.nextToken();
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("SOAPReceiver:setting status to samlp:VersionMismatch " + message);
                }
                try {
                    Status status = new Status(new StatusCode("samlp:RequestVersionTooLow"), message, null);
                    retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                }
                catch (SAMLException se) {
                    SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + se.getMessage());
                }
                String[] data7 = new String[]{invalidRespPrefix, retResponse.toString()};
                LogUtils.error(Level.INFO, "INVALID_REQUEST", data7);
                return retResponse;
            }
            catch (Exception e) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("SOAPReceiver:setting status to samlp:Responder " + e.getMessage());
                }
                message = new String(e.getMessage());
                try {
                    Status status = new Status(new StatusCode("samlp:Responder"), message, null);
                    retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                }
                catch (SAMLException se) {
                    SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + se.getMessage());
                }
                String[] data8 = new String[]{invalidRespPrefix, retResponse.toString()};
                LogUtils.error(Level.INFO, "INVALID_REQUEST", data8);
                return retResponse;
            }
        }
        if (!foundRequest) {
            SAMLUtils.debug.error("SOAPReceiver: Body does not have a Request");
            message = SAMLUtils.bundle.getString("missingRequest");
            try {
                Status status = new Status(new StatusCode("samlp:Requester"), message, null);
                retResponse = new Response(respID, inResponseTo, status, recipient, contents);
            }
            catch (SAMLException se) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + se.getMessage());
            }
            String[] data9 = new String[]{invalidRespPrefix, retResponse.toString()};
            LogUtils.error(Level.INFO, "INVALID_REQUEST", data9);
            return retResponse;
        }
        if (!req.isSignatureValid()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SOAPReceiver: couldn't verify the signature on Request.");
            }
            message = SAMLUtils.bundle.getString("cannotVerifyRequest");
            try {
                Status status = new Status(new StatusCode("samlp:Requester"), message, null);
                retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                retResponse.setMajorVersion(req.getMajorVersion());
                retResponse.setMinorVersion(req.getMinorVersion());
            }
            catch (SAMLException se) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)((Object)se));
                data2 = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data2);
            }
            String[] data10 = new String[]{respPrefix, retResponse.toString()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", data10);
            return retResponse;
        }
        int reqType = ((Request)req).getContentType();
        if (reqType == -1) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SOAPReceiver:Found element in the request which are not supported");
            }
            message = SAMLUtils.bundle.getString("unsupportedElement");
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), message, null);
                retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                retResponse.setMajorVersion(req.getMajorVersion());
                retResponse.setMinorVersion(req.getMinorVersion());
            }
            catch (SAMLException se) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)((Object)se));
                data3 = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data3);
            }
            data2 = new String[]{respPrefix, retResponse.toString()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", data2);
            return retResponse;
        }
        List respondWith = req.getRespondWith();
        if (!this.parseRespondWith(respondWith)) {
            SAMLUtils.debug.error("SOAPReceiver:Supported statements are not present in the RespondWith element.");
            message = SAMLUtils.bundle.getString("unsupportedStatement");
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), message, null);
                retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                retResponse.setMajorVersion(req.getMajorVersion());
                retResponse.setMinorVersion(req.getMinorVersion());
            }
            catch (SAMLException se) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)((Object)se));
                String[] data11 = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data11);
            }
            data3 = new String[]{respPrefix, retResponse.toString()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", data3);
            return retResponse;
        }
        AssertionManager am = null;
        try {
            am = AssertionManager.getInstance();
        }
        catch (SAMLException se) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SOAPReceiver: Cannot instantiate AssertionManager");
            }
            message = se.getMessage();
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), message, null);
                retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                retResponse.setMajorVersion(req.getMajorVersion());
                retResponse.setMinorVersion(req.getMinorVersion());
            }
            catch (SAMLException sse) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)((Object)sse));
                String[] data12 = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data12);
            }
            String[] data13 = new String[]{respPrefix, retResponse.toString()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", data13);
            return retResponse;
        }
        List artifacts = null;
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        if (reqType == 3) {
            artifacts = ((Request)req).getAssertionArtifact();
            length = artifacts.size();
            for (int j = 0; j < length; ++j) {
                AssertionArtifact art = (AssertionArtifact)artifacts.get(j);
                if (this.isThisSiteID(art.getSourceID())) continue;
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("SOAPReceiver:Artifact has invalid SourceID");
                }
                message = SAMLUtils.bundle.getString("mismatchSourceID");
                try {
                    Status status = new Status(new StatusCode("samlp:Requester"), message, null);
                    retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                    retResponse.setMajorVersion(req.getMajorVersion());
                    retResponse.setMinorVersion(req.getMinorVersion());
                }
                catch (SAMLException ex) {
                    SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)((Object)ex));
                    String[] data14 = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
                    LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data14);
                }
                String[] data15 = new String[]{respPrefix, retResponse.toString()};
                LogUtils.access(Level.INFO, "SENDING_RESPONSE", data15);
                return retResponse;
            }
            for (int i = 0; i < length; ++i) {
                AssertionArtifact artifact = (AssertionArtifact)artifacts.get(i);
                Assertion assertion = null;
                try {
                    assertion = am.getAssertion(artifact, partnerSourceID);
                }
                catch (SAMLException se) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SOAPReceiver: could not find matching assertion");
                    }
                    message = se.getMessage();
                    try {
                        Status status = new Status(new StatusCode("samlp:Success"), message, null);
                        retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                        retResponse.setMajorVersion(req.getMajorVersion());
                        retResponse.setMinorVersion(req.getMinorVersion());
                    }
                    catch (SAMLException sse) {
                        SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)((Object)sse));
                        String[] data16 = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
                        LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data16);
                    }
                    String[] data17 = new String[]{respPrefix, retResponse.toString()};
                    LogUtils.access(Level.INFO, "SENDING_RESPONSE", data17);
                    return retResponse;
                }
                if (assertion == null) continue;
                assertions.add(i, assertion);
            }
        } else if (reqType == 2) {
            List assertionIdRefs = ((Request)req).getAssertionIDReference();
            length = assertionIdRefs.size();
            for (int i = 0; i < length; ++i) {
                AssertionIDReference aidRef = (AssertionIDReference)assertionIdRefs.get(i);
                Assertion assertion = null;
                try {
                    assertion = am.getAssertion(aidRef, partnerSourceID);
                }
                catch (SAMLException se) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SOAPReceiver: could not find matching assertion");
                    }
                    message = se.getMessage();
                    try {
                        Status status = new Status(new StatusCode("samlp:Success"), message, null);
                        retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                        retResponse.setMajorVersion(req.getMajorVersion());
                        retResponse.setMinorVersion(req.getMinorVersion());
                    }
                    catch (SAMLException sse) {
                        SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)((Object)sse));
                        String[] data18 = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
                        LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data18);
                    }
                    String[] data19 = new String[]{respPrefix, retResponse.toString()};
                    LogUtils.access(Level.INFO, "SENDING_RESPONSE", data19);
                    return retResponse;
                }
                if (assertion == null) continue;
                assertions.add(i, assertion);
            }
        } else if (reqType == 0 || reqType == 1 || reqType == 4) {
            Query query = ((Request)req).getQuery();
            if (query != null) {
                Assertion assertion = null;
                try {
                    assertion = am.getAssertion(query, (String)partnerSourceID.iterator().next());
                }
                catch (SAMLException se) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SOAPReceiver: could not find matching assertion");
                    }
                    message = se.getMessage();
                    try {
                        Status status = new Status(new StatusCode("samlp:Success"), message, null);
                        retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                        retResponse.setMajorVersion(req.getMajorVersion());
                        retResponse.setMinorVersion(req.getMinorVersion());
                    }
                    catch (SAMLException sse) {
                        SAMLUtils.debug.error("SOAPReceiver:Fatal  error, cannot create status or  response", (Throwable)((Object)sse));
                        String[] data20 = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
                        LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data20);
                    }
                    String[] data21 = new String[]{respPrefix, retResponse.toString()};
                    LogUtils.access(Level.INFO, "SENDING_RESPONSE", data21);
                    return retResponse;
                }
                if (assertion != null) {
                    assertions.add(assertion);
                }
            }
        } else {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SOAPReceiver:Request contents has element which is not supported at this time");
            }
            message = SAMLUtils.bundle.getString("unsupportedElement");
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), message, null);
                retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                retResponse.setMajorVersion(req.getMajorVersion());
                retResponse.setMinorVersion(req.getMinorVersion());
            }
            catch (SAMLException se) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)((Object)se));
                String[] data22 = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data22);
            }
            String[] data23 = new String[]{respPrefix, retResponse.toString()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", data23);
            return retResponse;
        }
        int assertionSize = assertions.size();
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("found " + assertionSize + " assertions.");
        }
        for (int i = 0; i < assertionSize; ++i) {
            Response resp = this.validateStatements((Assertion)assertions.get(i), respondWith, contents, i, respID, inResponseTo, recipient);
            if (resp == null) continue;
            String[] data24 = new String[]{respPrefix, retResponse.toString()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", data24);
            retResponse.setMajorVersion(req.getMajorVersion());
            retResponse.setMinorVersion(req.getMinorVersion());
            return resp;
        }
        if (reqType == 3) {
            if (contents.size() == artifacts.size()) {
                message = null;
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("SOAPReceiver: Matching Assertion found");
                }
                try {
                    Status status = new Status(new StatusCode("samlp:Success"), message, null);
                    retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                    retResponse.setMajorVersion(req.getMajorVersion());
                    retResponse.setMinorVersion(req.getMinorVersion());
                }
                catch (SAMLException se) {
                    SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)((Object)se));
                    data = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
                    LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data);
                }
                String[] data25 = new String[]{respPrefix, retResponse.toString()};
                LogUtils.access(Level.FINE, "SENDING_RESPONSE", data25);
                return retResponse;
            }
            message = SAMLUtils.bundle.getString("unequalMatch");
            try {
                Status status = new Status(new StatusCode("samlp:Success"), message, null);
                retResponse = new Response(respID, inResponseTo, status, recipient, contents);
                retResponse.setMajorVersion(req.getMajorVersion());
                retResponse.setMinorVersion(req.getMinorVersion());
            }
            catch (SAMLException se) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)((Object)se));
                data = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data);
            }
            String[] data26 = new String[]{respPrefix, retResponse.toString()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", data26);
            return retResponse;
        }
        try {
            Status status = new Status(new StatusCode("samlp:Success"), message, null);
            retResponse = new Response(respID, inResponseTo, status, recipient, contents);
            retResponse.setMajorVersion(req.getMajorVersion());
            retResponse.setMinorVersion(req.getMinorVersion());
        }
        catch (SAMLException se) {
            SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)((Object)se));
            data = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
            LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data);
        }
        if (LogUtils.isAccessLoggable(Level.FINER)) {
            String[] data27 = new String[]{respPrefix, retResponse.toString()};
            LogUtils.access(Level.FINER, "SENDING_RESPONSE", data27);
        } else {
            String[] data28 = new String[]{respPrefix, retResponse.getResponseID()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", data28);
        }
        return retResponse;
    }

    private SOAPMessage FormSOAPError(HttpServletResponse resp, String faultCode, String faultString, String detail) {
        SOAPMessage msg = null;
        SOAPEnvelope envelope = null;
        SOAPFault sf = null;
        SOAPBody body = null;
        DetailEntry se = null;
        try {
            msg = msgFactory.createMessage();
            envelope = msg.getSOAPPart().getEnvelope();
            body = envelope.getBody();
            sf = body.addFault();
            sf.setFaultCode(faultCode);
            sf.setFaultString(SAMLUtils.bundle.getString(faultString));
            if (detail != null && detail.length() != 0) {
                Detail det = sf.addDetail();
                se = det.addDetailEntry(envelope.createName("Problem"));
                se.addAttribute(envelope.createName("details"), SAMLUtils.bundle.getString(detail));
            }
        }
        catch (SOAPException e) {
            SAMLUtils.debug.error("FormSOAPError:", (Throwable)e);
            String[] data = new String[]{SAMLUtils.bundle.getString("soapFaultError")};
            LogUtils.error(Level.INFO, "SOAP_FAULT_ERROR", data);
            resp.setStatus(500);
        }
        return msg;
    }

    private SOAPMessage FormMessageResponse(HttpServletResponse servletResp, Response resp) {
        SOAPMessage msg = null;
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.addHeader("Content-Type", "text/xml");
        StringBuffer envBegin = new StringBuffer(100);
        envBegin.append("<").append("soap-env").append(":Envelope").append(" ").append("xmlns:").append("soap-env").append("=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\">").append("\n");
        envBegin.append("<").append("soap-env").append(":Body>").append("\n");
        StringBuffer envEnd = new StringBuffer(100);
        envEnd.append("</").append("soap-env").append(":Body>").append("\n");
        envEnd.append("</").append("soap-env").append(":Envelope>").append("\n");
        try {
            StringBuffer sb = new StringBuffer(300);
            sb.append(envBegin).append(resp.toString()).append(envEnd);
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("response created is: " + sb.toString());
            }
            ByteArrayOutputStream bop = new ByteArrayOutputStream();
            bop.write(sb.toString().getBytes("UTF-8"));
            msg = msgFactory.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(bop.toByteArray()));
        }
        catch (Exception e) {
            SAMLUtils.debug.error("could not build response:" + e.getMessage());
            servletResp.setStatus(500);
            return this.FormSOAPError(servletResp, "Server", "cannotBuildResponse", "cannotVerifyIdentity");
        }
        return msg;
    }

    private Response validateStatements(Assertion assertion, List respondWith, List contents, int index, String respID, String inResponseTo, String recipient) {
        String message = null;
        Set statements = assertion.getStatement();
        int length = statements.size();
        Response retResponse = null;
        Status status = null;
        if (statements.isEmpty() || length == 0) {
            SAMLUtils.debug.error("SOAPReceiver: Assertion found does not have any statements in it");
            message = SAMLUtils.bundle.getString("missingStatement");
            try {
                status = new Status(new StatusCode("samlp:Responder"), message, null);
                retResponse = new Response(respID, inResponseTo, status, recipient, contents);
            }
            catch (SAMLException se) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)((Object)se));
                String[] data = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data);
            }
            return retResponse;
        }
        boolean mismatchError = false;
        if (respondWith.size() == 0) {
            contents.add(index, assertion);
        } else {
            boolean bl = mismatchError = !this.checkAgainstRespondWith(respondWith, statements);
            if (!mismatchError) {
                contents.add(index, assertion);
            }
        }
        if (mismatchError) {
            SAMLUtils.debug.error("SOAPReceiver: Assertion does not  meet respondWith criteria in the received Request");
            message = SAMLUtils.bundle.getString("mismatchRespondWith");
            try {
                status = new Status(new StatusCode("samlp:Success"), message, null);
                return new Response(respID, inResponseTo, status, recipient, contents);
            }
            catch (SAMLException se) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error,  cannot create status or response", (Throwable)((Object)se));
                String[] data = new String[]{SAMLUtils.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", data);
            }
        }
        return null;
    }

    private boolean parseRespondWith(List respondWith) {
        Iterator it = respondWith.iterator();
        while (it.hasNext()) {
            String respWith = (String)it.next();
            int index = respWith.indexOf(":");
            if (index == -1 || index == 0) {
                return false;
            }
            if (respWith.endsWith(":AuthenticationStatement") || respWith.endsWith(":AuthorizationDecisionStatement") || respWith.endsWith(":AttributeStatement")) continue;
            return false;
        }
        return true;
    }

    private boolean checkAgainstRespondWith(List respondWith, Set statements) {
        boolean stFound = false;
        Iterator itSt = statements.iterator();
        while (itSt.hasNext()) {
            stFound = false;
            Statement st = (Statement)itSt.next();
            Iterator it = respondWith.iterator();
            while (it.hasNext()) {
                String respWith = (String)it.next();
                SAMLUtils.debug.message("matching respondWith element:" + respWith);
                switch (st.getStatementType()) {
                    case 1: {
                        if (!respWith.endsWith(":AuthenticationStatement")) break;
                        SAMLUtils.debug.message("matching auth st");
                        stFound = true;
                        break;
                    }
                    case 2: {
                        if (!respWith.endsWith(":AuthorizationDecisionStatement")) break;
                        SAMLUtils.debug.message("matching authz st");
                        stFound = true;
                        break;
                    }
                    case 3: {
                        if (!respWith.endsWith(":AttributeStatement")) break;
                        SAMLUtils.debug.message("matching attrib st");
                        stFound = true;
                    }
                }
                if (!stFound) continue;
                SAMLUtils.debug.message("match found");
                break;
            }
            if (stFound) continue;
            SAMLUtils.debug.message("mismatch found");
            return false;
        }
        return true;
    }

    protected static Set checkCaller(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String certOrIP = null;
        Set partnerSourceID = null;
        String remoteAddr = req.getRemoteAddr();
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("caller's IP:" + remoteAddr);
        }
        X509Certificate[] allCerts = null;
        if (req.isSecure()) {
            try {
                allCerts = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
            }
            catch (Exception e) {
                SAMLUtils.debug.error("SAMLSOAPReceiver: Exception", (Throwable)e);
            }
        }
        if (allCerts == null || allCerts.length == 0) {
            certOrIP = remoteAddr;
        } else {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLSOAPReceiver: got all certs from HttpServletRequest =" + allCerts.length);
            }
            X509Certificate thecert = allCerts[0];
            SAMLCertUtils.CertEntry foundCertEntry = null;
            foundCertEntry = SAMLCertUtils.getMatchingCertEntry(thecert);
            if (foundCertEntry != null) {
                certOrIP = foundCertEntry.getNickName();
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Found matching nickname:" + certOrIP);
                }
            }
        }
        partnerSourceID = SAMLSOAPReceiver.getPartnerSourceID(certOrIP);
        if (partnerSourceID == null || partnerSourceID.isEmpty()) {
            return null;
        }
        return partnerSourceID;
    }

    private static Set getPartnerSourceID(String certOrIP) {
        Map partnerMap = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (partnerMap != null) {
            HashSet<String> sidSet = new HashSet<String>();
            Set partnerSet = partnerMap.entrySet();
            Iterator it = partnerSet.iterator();
            Set hostSet = null;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                SAMLServiceManager.SOAPEntry partnerEntry = (SAMLServiceManager.SOAPEntry)entry.getValue();
                hostSet = partnerEntry.getHostSet();
                if (hostSet == null || !hostSet.contains(certOrIP)) continue;
                sidSet.add((String)entry.getKey());
                if (!SAMLUtils.debug.messageEnabled()) continue;
                SAMLUtils.debug.message("getPartnerSourceID: found a matching sid=" + Base64.encode((byte[])SAMLUtils.stringToByteArray((String)entry.getKey())));
            }
            return sidSet;
        }
        return null;
    }

    private boolean isThisSiteID(String sourceID) {
        return ((String)SAMLServiceManager.getAttribute("mysiteid")).equals(sourceID);
    }
}

