/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.servlet;

import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.common.LogUtils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAMLAwareServlet
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request == null || response == null) {
            String[] data = new String[]{SAMLUtils.bundle.getString("nullInputParameter")};
            LogUtils.error(Level.INFO, "NULL_PARAMETER", data);
            response.sendError(500, SAMLUtils.bundle.getString("nullInputParameter"));
            return;
        }
        SAMLUtils.checkHTTPContentLength(request);
        String TargetUrl = request.getParameter((String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier"));
        String SamlArt = request.getParameter((String)SAMLServiceManager.getAttribute("iplanet-am-saml-artifact-name"));
        if (TargetUrl == null || TargetUrl.length() == 0) {
            String[] data = new String[]{SAMLUtils.bundle.getString("missingTargetSite")};
            LogUtils.error(Level.INFO, "MISSING_TARGET", data);
            response.sendError(500, SAMLUtils.bundle.getString("invalidConfig"));
            return;
        }
        response.setContentType("text/html; charset=UTF-8");
        if (SamlArt == null || SamlArt.length() == 0) {
            this.IntersiteTransfer(request, response, TargetUrl);
        } else {
            this.ArtifactHandler(request, response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    private List createArtifact(Object sso, String target, String targetUrl, String version) throws SAMLException {
        if (sso == null || target == null || target.length() == 0 || version == null || version.length() == 0) {
            throw new SAMLException(SAMLUtils.bundle.getString("createArtifactError"));
        }
        ArrayList<String> artifactList = new ArrayList<String>();
        AssertionManager assertManager = AssertionManager.getInstance();
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            AssertionArtifact artifact = assertManager.createAssertionArtifact(sessionProvider.getSessionID(sso), target, targetUrl, version);
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionArtifact id = " + artifact.toString());
            }
            String artid = artifact.getAssertionArtifact();
            artifactList.add(artid);
        }
        catch (SessionException se) {
            SAMLUtils.debug.error("Couldn't get SessionProvider.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullSessionProvider"));
        }
        return artifactList;
    }

    private void IntersiteTransfer(HttpServletRequest request, HttpServletResponse response, String target) throws IOException, ServletException {
        StringBuffer sb;
        String targetName;
        Object ssoToken;
        URL theTarget = new URL(target);
        String theHost = theTarget.getHost();
        int thePort = theTarget.getPort();
        if (theHost == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.error("SAMLAwareServlet:IntersiteTransfer:Failed to get host name of target URL.");
            }
            response.sendError(500, SAMLUtils.bundle.getString("missingTargetHost"));
            return;
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("TargetUrl Host = " + theHost + " Port= " + thePort);
        }
        SAMLServiceManager.SiteEntry thisSite = null;
        Set trustedserver = (Set)SAMLServiceManager.getAttribute("iplanet-am-saml-trusted-server-list");
        if (trustedserver == null) {
            response.sendError(500, SAMLUtils.bundle.getString("nullTrustedSite"));
            return;
        }
        Iterator iter = trustedserver.iterator();
        while (iter.hasNext()) {
            String key = null;
            int portNum = 0;
            SAMLServiceManager.SiteEntry se = (SAMLServiceManager.SiteEntry)iter.next();
            key = se.getHostName();
            portNum = se.getPort();
            if (portNum != -1) {
                if (theHost.indexOf(key) == -1 || thePort == -1 || thePort != portNum) continue;
                thisSite = se;
                break;
            }
            if (theHost.indexOf(key) == -1) continue;
            thisSite = se;
        }
        if (thisSite != null) {
            ssoToken = null;
            boolean loggedIn = false;
            try {
                SessionProvider sessionProvider = SessionManager.getProvider();
                ssoToken = sessionProvider.getSession(request);
                if (ssoToken != null && sessionProvider.isValid(ssoToken)) {
                    loggedIn = true;
                }
            }
            catch (SessionException se) {
                SAMLUtils.debug.message("Invalid SSO!");
            }
            if (!loggedIn) {
                response.sendRedirect(SAMLUtils.getLoginRedirectURL(request));
                return;
            }
            List artis = new ArrayList();
            try {
                artis = this.createArtifact(ssoToken, thisSite.getSourceID(), target, thisSite.getVersion());
            }
            catch (SAMLException se) {
                SAMLUtils.debug.error("IntersiteTransfer:Failed to create AssertionArtifact(s)");
                response.sendError(500, se.getMessage());
                return;
            }
            targetName = (String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier");
            String artifactName = (String)SAMLServiceManager.getAttribute("iplanet-am-saml-artifact-name");
            iter = artis.iterator();
            sb = new StringBuffer(1000);
            String samltmp = null;
            while (iter.hasNext()) {
                samltmp = URLEncDec.encode((String)((String)iter.next()));
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Encoded SAML AssertionArtifact " + samltmp);
                }
                sb.append("&").append(artifactName).append("=").append(samltmp);
            }
        } else {
            String[] data = new String[]{SAMLUtils.bundle.getString("targetForbidden"), target};
            LogUtils.error(Level.INFO, "TARGET_FORBIDDEN", data);
            response.sendError(403, SAMLUtils.bundle.getString("targetForbidden") + " " + target);
            return;
        }
        String redirecto = thisSite.getSAMLUrl() + "?" + targetName + "=" + URLEncDec.encode((String)target) + sb.toString();
        response.setStatus(302);
        response.setHeader("Location", redirecto);
        String[] data = new String[]{SAMLUtils.bundle.getString("redirectTo"), target, redirecto};
        LogUtils.access(Level.FINE, "REDIRECT_TO_URL", data, ssoToken);
        response.sendRedirect(redirecto);
    }

    private void ArtifactHandler(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Object authSubject = null;
        String targeturl = request.getParameter((String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier"));
        String artifactName = (String)SAMLServiceManager.getAttribute("iplanet-am-saml-artifact-name");
        String[] arti = request.getParameterValues(artifactName);
        List assts = null;
        Map attrMap = null;
        try {
            Map sessionAttr = SAMLUtils.processArtifact(arti, targeturl);
            Object token = SAMLUtils.generateSession(request, response, sessionAttr);
        }
        catch (Exception ex) {
            SAMLUtils.debug.error("generateSession: ", (Throwable)ex);
            String[] data = new String[]{SAMLUtils.bundle.getString("failedCreateSSOToken")};
            LogUtils.error(Level.INFO, "FAILED_TO_CREATE_SSO_TOKEN", data);
            response.sendError(500, SAMLUtils.bundle.getString("failedCreateSSOToken"));
            return;
        }
        String[] data = new String[]{SAMLUtils.bundle.getString("accessGranted")};
        LogUtils.access(Level.INFO, "ACCESS_GRANTED", data);
        if (SAMLUtils.postYN(targeturl)) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("POST to target:" + targeturl);
            }
            SAMLUtils.postToTarget(response, assts, targeturl, attrMap);
        } else {
            response.sendRedirect(targeturl);
        }
    }
}

