/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.plugins;

import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.plugins.NameIdentifierMapper;
import com.sun.identity.shared.xml.XMLUtils;

public class DefaultNameIdentifierMapper
implements NameIdentifierMapper {
    public NameIdentifier getNameIdentifier(Object session, String sourceID, String destID) throws SAMLException {
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("DefaultNameIdentifierMapper.getNameIdentifier: sourceID = " + sourceID + ", destID = " + destID);
        }
        try {
            String nameQualifier = XMLUtils.escapeSpecialCharacters((String)SessionManager.getProvider().getProperty(session, "Organization")[0]);
            String name = XMLUtils.escapeSpecialCharacters((String)SessionManager.getProvider().getPrincipalName(session));
            return new NameIdentifier(name, nameQualifier);
        }
        catch (SessionException sx) {
            SAMLUtils.debug.error("DefaultNameIdentifierMapper.getNameIdentifier: Invalid Session ", (Throwable)((Object)sx));
            return null;
        }
        catch (Exception ex) {
            SAMLUtils.debug.error("DefaultNameIdentifierMapper.getNameIdentifier:", (Throwable)ex);
            return null;
        }
    }
}

