/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.plugins;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.plugin.datastore.DataStoreProviderManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeDesignator;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.plugins.AttributeMapper;
import com.sun.identity.saml.plugins.PartnerAccountMapper;
import com.sun.identity.saml.protocol.AttributeQuery;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultAttributeMapper
implements AttributeMapper {
    public String getSSOTokenID(AttributeQuery query) {
        if (query == null) {
            return null;
        }
        SubjectConfirmation sc = query.getSubject().getSubjectConfirmation();
        if (sc == null) {
            return null;
        }
        if (!SAMLUtils.isCorrectConfirmationMethod(sc)) {
            return null;
        }
        Element scData = sc.getSubjectConfirmationData();
        return XMLUtils.getElementString((Element)scData);
    }

    public Assertion getSSOAssertion(AttributeQuery query) {
        if (query == null) {
            return null;
        }
        SubjectConfirmation sc = query.getSubject().getSubjectConfirmation();
        if (sc == null) {
            return null;
        }
        Element scData = sc.getSubjectConfirmationData();
        if (scData == null) {
            return null;
        }
        Assertion assertion = null;
        try {
            NodeList nl = scData.getChildNodes();
            Node child = null;
            int length = nl.getLength();
            for (int i = 0; i < length; ++i) {
                child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                try {
                    assertion = new Assertion((Element)child);
                    if (!SAMLUtils.isAuthNAssertion(assertion)) continue;
                    return assertion;
                }
                catch (SAMLException se) {
                    if (!SAMLUtils.debug.messageEnabled()) continue;
                    SAMLUtils.debug.message("DefaultAttributeMapper: SAMLException when trying to obtain Assertion:" + (Object)((Object)se));
                }
            }
        }
        catch (Exception e) {
            SAMLUtils.debug.error("DefaultAttributeMapper: Exception when parsing the SubjectConfirmationData:", (Throwable)e);
        }
        return null;
    }

    public List getAttributes(AttributeQuery query, String sourceID, Object token) throws SAMLException {
        if (query == null || sourceID == null || token == null) {
            SAMLUtils.debug.message("DefaultAttributeMapper: null input.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        Map entries = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        SAMLServiceManager.SOAPEntry destSite = (SAMLServiceManager.SOAPEntry)entries.get(sourceID);
        String name = null;
        PartnerAccountMapper paMapper = destSite.getPartnerAccountMapper();
        if (paMapper != null) {
            Map map = paMapper.getUser(query, sourceID);
            name = (String)map.get("name");
        }
        if (name == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("DefaultAttributeMapper: couldn't map the subject to a local user.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotMapSubject"));
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("user=" + name);
        }
        DataStoreProvider provider = null;
        try {
            DataStoreProviderManager.getInstance().getDataStoreProvider("saml");
        }
        catch (DataStoreProviderException de) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("DefaultAttributeMapper.getAttribute:", (Throwable)((Object)de));
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotMapSubject"));
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute attribute = null;
        ArrayList<Element> attrValues = null;
        String attrValueString = null;
        String attrName = null;
        Set valueSet = null;
        Iterator valueIter = null;
        List designators = query.getAttributeDesignator();
        if (designators == null || designators.isEmpty()) {
            String userAttrName = SystemConfigurationUtil.getProperty("userAttributeNameList");
            if (userAttrName == null || userAttrName.length() == 0) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("DefaultAttributeMapper: userAttributeNameList is not defined or empty.");
                }
                return attributes;
            }
            HashSet<String> attrNames = new HashSet<String>();
            StringTokenizer stk = new StringTokenizer(userAttrName, ",");
            while (stk.hasMoreTokens()) {
                attrNames.add(stk.nextToken().trim());
            }
            Map valueMap = null;
            try {
                valueMap = provider.getAttributes(name, attrNames);
            }
            catch (DataStoreProviderException ie) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("DefaultAttributeMapper: DataStoreProviderException:", (Throwable)((Object)ie));
                }
                throw new SAMLException(ie.getMessage());
            }
            Set keySet = valueMap.keySet();
            String keyName = null;
            Iterator keyIter = keySet.iterator();
            while (keyIter.hasNext()) {
                keyName = (String)keyIter.next();
                valueSet = (Set)valueMap.get(keyName);
                valueIter = valueSet.iterator();
                attrValues = new ArrayList();
                while (valueIter.hasNext()) {
                    attrValueString = SAMLUtils.makeStartElementTagXML("AttributeValue", true, true) + (String)valueIter.next() + SAMLUtils.makeEndElementTagXML("AttributeValue", true);
                    attrValues.add(XMLUtils.toDOMDocument((String)attrValueString, (Debug)SAMLUtils.debug).getDocumentElement());
                }
                if (attrValues.isEmpty()) continue;
                attribute = new Attribute(keyName, "urn:com:sun:identity:attrnamespace", attrValues);
                attributes.add(attribute);
            }
        } else {
            Iterator iter = designators.iterator();
            AttributeDesignator designator = null;
            while (iter.hasNext()) {
                designator = (AttributeDesignator)iter.next();
                attrName = designator.getAttributeName();
                try {
                    valueSet = provider.getAttribute(name, attrName);
                }
                catch (DataStoreProviderException ie) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("DefaultAttributeMapper: DataStoreProviderException:", (Throwable)((Object)ie));
                    }
                    throw new SAMLException(ie.getMessage());
                }
                valueIter = valueSet.iterator();
                attrValues = new ArrayList<Element>();
                while (valueIter.hasNext()) {
                    attrValueString = SAMLUtils.makeStartElementTagXML("AttributeValue", true, true) + (String)valueIter.next() + SAMLUtils.makeEndElementTagXML("AttributeValue", true);
                    attrValues.add(XMLUtils.toDOMDocument((String)attrValueString, (Debug)SAMLUtils.debug).getDocumentElement());
                }
                if (attrValues.isEmpty()) continue;
                attribute = new Attribute(attrName, designator.getAttributeNamespace(), attrValues);
                attributes.add(attribute);
            }
        }
        return attributes;
    }
}

