/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubjectConfirmation {
    static SAMLConstants sc;
    private Set _confirmationMethodList = Collections.synchronizedSet(new HashSet());
    private Element _subjectConfirmationData = null;
    private Element _keyInfo = null;

    public SubjectConfirmation(Element subjectConfirmationElement) throws SAMLException {
        Element elt = subjectConfirmationElement;
        String eltName = elt.getLocalName();
        if (eltName == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SubjectConfirmation: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (!eltName.equals("SubjectConfirmation")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SubjectConfirmation: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
        NodeList nl = elt.getChildNodes();
        int length = nl.getLength();
        for (int n = 0; n < length; ++n) {
            Node child = nl.item(n);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("ConfirmationMethod")) {
                this._confirmationMethodList.add(XMLUtils.getElementValue((Element)((Element)child)));
                continue;
            }
            if (childName.equals("SubjectConfirmationData")) {
                if (this._subjectConfirmationData != null) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("SubjectConfirmation: SubjectConfirmationData already parsed");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("moreElement"));
                }
                this._subjectConfirmationData = (Element)child;
                continue;
            }
            if (childName.equals("KeyInfo")) {
                if (this._keyInfo != null) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("SubjectConfirmation: KeyInfo already parsed");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("moreElement"));
                }
                this._keyInfo = (Element)child;
                continue;
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SubjectConfirmation: unsupported element KeyInfo in SubjectConfirmation");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("unsupportedElement"));
        }
        if (this._confirmationMethodList.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SubjectConfirmation: Mandatory element confirmation method missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
    }

    public SubjectConfirmation(String confirmationMethod) throws SAMLException {
        if (confirmationMethod == null || confirmationMethod.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SubjectConfirmation:  null confirmationMethod specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._confirmationMethodList.add(confirmationMethod);
    }

    public SubjectConfirmation(Set confirmationMethods) throws SAMLException {
        if (confirmationMethods.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SubjectConfirmation:  No confirmationMethods  in the Set");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._confirmationMethodList.addAll(confirmationMethods);
    }

    public boolean addConfirmationMethod(String confirmationMethod) {
        if (confirmationMethod == null || confirmationMethod.length() == 0) {
            return false;
        }
        this._confirmationMethodList.add(confirmationMethod);
        return true;
    }

    public SubjectConfirmation(Set confirmationMethods, Element subjectConfirmationData, Element keyInfo) throws SAMLException {
        if (confirmationMethods.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SubjectConfirmation:  No confirmationMethods  in the Set");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._confirmationMethodList.addAll(confirmationMethods);
        this._subjectConfirmationData = subjectConfirmationData;
        this._keyInfo = keyInfo;
    }

    public Set getConfirmationMethod() {
        return this._confirmationMethodList;
    }

    public Element getSubjectConfirmationData() {
        return this._subjectConfirmationData;
    }

    public boolean setSubjectConfirmationData(Element subjectConfirmationData) {
        if (subjectConfirmationData == null) {
            return false;
        }
        this._subjectConfirmationData = subjectConfirmationData;
        return true;
    }

    public boolean setSubjectConfirmationData(String scDataString) {
        if (scDataString == null) {
            return false;
        }
        StringBuffer sb = new StringBuffer(300);
        sb.append(SAMLUtilsCommon.makeStartElementTagXML("SubjectConfirmationData", true, true)).append(scDataString).append(SAMLUtilsCommon.makeEndElementTagXML("SubjectConfirmationData", true));
        try {
            this._subjectConfirmationData = XMLUtils.toDOMDocument((String)sb.toString().trim(), (Debug)SAMLUtilsCommon.debug).getDocumentElement();
        }
        catch (Exception e) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SubjectConfirmation: exception when setting scDataString.", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    public Element getKeyInfo() {
        return this._keyInfo;
    }

    public boolean setKeyInfo(Element keyInfo) {
        if (keyInfo != null) {
            this._keyInfo = keyInfo;
            return true;
        }
        return false;
    }

    public boolean equals(SubjectConfirmation subjectConfirmation) {
        boolean cmEqual = true;
        boolean scDataEqual = true;
        if (subjectConfirmation != null) {
            Set confMethods = subjectConfirmation.getConfirmationMethod();
            int passedSize = confMethods.size();
            if (passedSize != this._confirmationMethodList.size()) {
                cmEqual = false;
            } else {
                Iterator it = confMethods.iterator();
                while (it.hasNext()) {
                    String confMethodStr = (String)it.next();
                    if (this._confirmationMethodList.contains(confMethodStr)) continue;
                    cmEqual = false;
                    break;
                }
            }
            Element scData = subjectConfirmation.getSubjectConfirmationData();
            if (this._subjectConfirmationData != null) {
                if (scData == null) {
                    scDataEqual = false;
                } else {
                    String thisString = this.printSCData(this._subjectConfirmationData, true, true);
                    String passString = this.printSCData(scData, true, true);
                    scDataEqual = thisString.equals(passString);
                }
            } else if (scData != null) {
                scDataEqual = false;
            }
            return cmEqual && scDataEqual;
        }
        return false;
    }

    private String printSCData(Element scData, boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(1000);
        xml.append(SAMLUtilsCommon.makeStartElementTagXML("SubjectConfirmationData", includeNS, declareNS));
        NodeList nl = scData.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            xml.append(XMLUtils.print((Node)nl.item(i)));
        }
        xml.append(SAMLUtilsCommon.makeEndElementTagXML("SubjectConfirmationData", includeNS));
        return xml.toString();
    }

    public String toString() {
        String xml = this.toString(true, false);
        return xml;
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(3000);
        String o = SAMLUtilsCommon.makeStartElementTagXML("SubjectConfirmation", includeNS, declareNS);
        xml.append(o).append("\n");
        if (this._confirmationMethodList.size() > 0) {
            Iterator it = this._confirmationMethodList.iterator();
            while (it.hasNext()) {
                o = SAMLUtilsCommon.makeStartElementTagXML("ConfirmationMethod", includeNS, false);
                xml.append(o).append((String)it.next());
                o = SAMLUtilsCommon.makeEndElementTagXML("ConfirmationMethod", includeNS);
                xml.append(o);
            }
        }
        if (this._subjectConfirmationData != null) {
            xml.append(this.printSCData(this._subjectConfirmationData, includeNS, false));
        }
        if (this._keyInfo != null) {
            xml.append(XMLUtils.print((Node)this._keyInfo));
        }
        o = SAMLUtilsCommon.makeEndElementTagXML("SubjectConfirmation", includeNS);
        xml.append(o);
        return xml.toString();
    }
}

