/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthorityBinding {
    private String _binding = null;
    private String _location = null;
    private int _authorityKind = -1;

    public AuthorityBinding(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("AuthorityBinding: Input is null.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("AuthorityBinding")) {
            SAMLUtilsCommon.debug.message("AuthorityBinding: wrong input");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        int i = 0;
        NamedNodeMap atts = element.getAttributes();
        int attrCount = atts.getLength();
        for (i = 0; i < attrCount; ++i) {
            Node att = atts.item(i);
            if (att.getNodeType() != 2) continue;
            String attName = att.getLocalName();
            if (attName == null || attName.length() == 0) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("AuthorityBinding: Attribute Name is either null or empty.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
            }
            if (attName.equals("AuthorityKind")) {
                String kind = ((Attr)att).getValue().trim();
                if (kind == null || kind.length() == 0) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("AuthorityBinding: AuthorityKind is null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttributeValue"));
                }
                if (kind.equals("samlp:AuthenticationQuery")) {
                    this._authorityKind = 1;
                    continue;
                }
                if (kind.equals("samlp:AttributeQuery")) {
                    this._authorityKind = 2;
                    continue;
                }
                if (kind.equals("samlp:AuthorizationDecisionQuery")) {
                    this._authorityKind = 3;
                    continue;
                }
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("AuthorityBinding: The type of authority is illegal!");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
            }
            if (attName.equals("Binding")) {
                this._binding = ((Attr)att).getValue().trim();
                if (this._binding != null && this._binding.length() != 0) continue;
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("AuthorityBinding: Binding URI is null or empty.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttributeValue"));
            }
            if (!attName.equals("Location")) continue;
            this._location = ((Attr)att).getValue().trim();
            if (this._location != null && this._location.length() != 0) continue;
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorityBinding: Location URI is null or empty.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttributeValue"));
        }
        if (this._authorityKind == -1) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorityBinding: AuthorityKind is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        if (this._location == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorityBinding: Location is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        if (this._binding == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorityBinding: Binding is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("AuthorityBinding:  illegal input!");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
            }
        }
    }

    public AuthorityBinding(int authKind, String location, String binding) throws SAMLException {
        if (location == null || location.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorityBinding: The Location URI can not be null or empty!");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._location = location;
        if (binding == null || binding.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorityBinding: The binding URI can not be null or empty!");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._binding = binding;
        if (authKind < 1 || authKind > 3) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorityBinding:The type of authority is illegal!");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        this._authorityKind = authKind;
    }

    public String getLocation() {
        return this._location;
    }

    public String getBinding() {
        return this._binding;
    }

    public int getAuthorityKind() {
        return this._authorityKind;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer result = new StringBuffer(300);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        result.append("<").append(prefix).append("AuthorityBinding").append(uri).append(" AuthorityKind=\"");
        switch (this._authorityKind) {
            case 1: {
                result.append("samlp:AuthenticationQuery");
                break;
            }
            case 2: {
                result.append("samlp:AttributeQuery");
                break;
            }
            case 3: {
                result.append("samlp:AuthorizationDecisionQuery");
            }
        }
        result.append("\"").append(" Location=\"").append(this._location).append("\"").append(" Binding=\"").append(this._binding).append("\"").append(" />\n");
        return result.toString();
    }

    public static class AuthorityKindType {
        public static final int AUTHENTICATION = 1;
        public static final int ATTRIBUTE = 2;
        public static final int AUTHORIZATION = 3;
        public static final int NOT_SUPPORTED = -1;
    }
}

