/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.Condition;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AudienceRestrictionCondition
extends Condition {
    private SAMLConstants sc;
    private Vector _audience = new Vector();

    public AudienceRestrictionCondition(Element audienceRestrictionConditionElement) throws SAMLException {
        String type;
        Element elt = audienceRestrictionConditionElement;
        String eltName = elt.getLocalName();
        if (eltName == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AudienceRestrictionCondition: null condition ");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (!eltName.equals("AudienceRestrictionCondition") && !eltName.equals("Condition")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AudienceRestrictionCondition: unsupported condition ");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("unsupportedCondition"));
        }
        if (eltName.equals("Condition") && !(type = elt.getAttribute("xsi:type")).equals("AudienceRestrictionCondition")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AudienceRestrictionCondition: invalid condition");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
        NodeList nl = elt.getChildNodes();
        if (nl.getLength() <= 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AudienceRestrictionCondition: no Audience in this Element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("noElement"));
        }
        int length = nl.getLength();
        for (int n = 0; n < length; ++n) {
            Node child = nl.item(n);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("Audience")) {
                this._audience.add(XMLUtils.getElementValue((Element)((Element)child)));
                continue;
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AudienceRestrictionCondition:  invalid element found");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
    }

    public AudienceRestrictionCondition(List audience) throws SAMLException {
        if (audience.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AudienceRestrictionCondition:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._audience.addAll(audience);
    }

    public boolean addAudience(String audience) {
        if (audience != null && audience.length() != 0) {
            this._audience.add(audience);
            return true;
        }
        return false;
    }

    public boolean setAudience(List audience) {
        if (audience.isEmpty()) {
            return false;
        }
        this._audience.addAll(audience);
        return true;
    }

    public List getAudience() {
        return this._audience;
    }

    public boolean containsAudience(String audience) {
        if (audience != null && audience.length() != 0) {
            return this._audience.contains(audience);
        }
        return false;
    }

    public boolean removeAudience(String audience) {
        if (audience != null && audience.length() != 0) {
            this._audience.remove(audience);
            return true;
        }
        return false;
    }

    public String toString() {
        String xml = this.toString(true, false);
        return xml;
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(3000);
        String o = SAMLUtilsCommon.makeStartElementTagXML("AudienceRestrictionCondition", includeNS, declareNS);
        xml.append(o).append("\n");
        Iterator it = this._audience.iterator();
        while (it.hasNext()) {
            o = SAMLUtilsCommon.makeStartElementTagXML("Audience", includeNS, false);
            xml.append(o).append((String)it.next());
            o = SAMLUtilsCommon.makeEndElementTagXML("Audience", includeNS);
            xml.append(o);
        }
        o = SAMLUtilsCommon.makeEndElementTagXML("AudienceRestrictionCondition", includeNS);
        xml.append(o);
        return xml.toString();
    }

    public int evaluate() {
        return Condition.INDETERMINATE;
    }
}

