/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeDesignator {
    protected String _attributeName = null;
    protected String _attributeNameSpace = null;

    protected AttributeDesignator() {
    }

    public AttributeDesignator(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("AttributeDesignator: Input is null.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("AttributeDesignator")) {
            SAMLUtilsCommon.debug.message("AttributeDesignator: wrong input");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        int i = 0;
        NamedNodeMap atts = element.getAttributes();
        int attrCount = atts.getLength();
        for (i = 0; i < attrCount; ++i) {
            Node att = atts.item(i);
            if (att.getNodeType() != 2) continue;
            String attName = att.getLocalName();
            if (attName == null || attName.length() == 0) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("AttributeDesignator:Attribute Name is either null or empty.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
            }
            if (attName.equals("AttributeName")) {
                this._attributeName = ((Attr)att).getValue().trim();
                continue;
            }
            if (!attName.equals("AttributeNamespace")) continue;
            this._attributeNameSpace = ((Attr)att).getValue().trim();
        }
        if (this._attributeName == null || this._attributeName.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AttributeDesignator: AttributeName is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        if (this._attributeNameSpace == null || this._attributeNameSpace.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AttributeDesignator: AttributeNamespace is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("AttributeDesignator: illegal input!");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
            }
        }
    }

    public AttributeDesignator(String name, String nameSpace) throws SAMLException {
        if (name == null || name.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AttributeDesignator:AttributeName is required!");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._attributeName = name;
        if (nameSpace == null || nameSpace.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AttributeDesignator: AttributeNamespace is required!");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._attributeNameSpace = nameSpace;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public String getAttributeNamespace() {
        return this._attributeNameSpace;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer result = new StringBuffer(200);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        result.append("<").append(prefix).append("AttributeDesignator ").append(uri).append(" AttributeName=\"").append(this._attributeName).append("\" AttributeNamespace=\"").append(this._attributeNameSpace).append("\" />\n");
        return result.toString();
    }
}

