/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Element;

public class AssertionIDReference {
    protected String assertionID = null;

    public AssertionIDReference(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("AssertionIDReference: Input is null.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("AssertionIDReference")) {
            SAMLUtilsCommon.debug.message("AssertionIDReference: wrong input");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        this.assertionID = XMLUtils.getElementValue((Element)element);
        if (this.assertionID == null || this.assertionID.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AssertionIDReference is null.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElementValue"));
        }
    }

    public AssertionIDReference() {
        this.assertionID = SAMLUtils.generateAssertionID();
    }

    public AssertionIDReference(String id) {
        this.assertionID = id == null || id.length() == 0 ? SAMLUtils.generateAssertionID() : id;
    }

    public String getAssertionIDReference() {
        return this.assertionID;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer result = new StringBuffer(100);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        result.append("<").append(prefix).append("AssertionIDReference").append(uri).append(">").append(this.assertionID).append("</").append(prefix).append("AssertionIDReference>\n");
        return result.toString();
    }
}

