/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml;

import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.PeriodicGroupRunnable;
import com.sun.identity.common.ScheduleableGroupAction;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.common.SystemTimerPool;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.common.TimerPool;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.ArtifactStats;
import com.sun.identity.saml.AssertionManagerClient;
import com.sun.identity.saml.AssertionSSOTokenListener;
import com.sun.identity.saml.AssertionStats;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.AuthorizationDecisionStatement;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectLocality;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.LogUtils;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.plugins.ActionMapper;
import com.sun.identity.saml.plugins.AttributeMapper;
import com.sun.identity.saml.plugins.DefaultNameIdentifierMapper;
import com.sun.identity.saml.plugins.NameIdentifierMapper;
import com.sun.identity.saml.plugins.PartnerAccountMapper;
import com.sun.identity.saml.plugins.PartnerSiteAttributeMapper;
import com.sun.identity.saml.plugins.SiteAttributeMapper;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.AttributeQuery;
import com.sun.identity.saml.protocol.AuthenticationQuery;
import com.sun.identity.saml.protocol.AuthorizationDecisionQuery;
import com.sun.identity.saml.protocol.Query;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.stats.Stats;
import com.sun.identity.shared.stats.StatsListener;
import com.sun.identity.shared.xml.XMLUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.w3c.dom.Element;

public final class AssertionManager {
    public static Stats assStats;
    public static Stats artStats;
    private static AssertionStats assertionStats;
    private static ArtifactStats artifactStats;
    private static final String SUPER_USER = "com.sun.identity.authentication.super.user";
    private static String superUser;
    private static SessionProvider sessionProvider;
    private static long cleanUpInterval;
    private static long assertionTimeout;
    private static long artifactTimeout;
    private static long notBeforeSkew;
    private static AssertionManager instance;
    private static Map artEntryMap;
    private static Map idEntryMap;
    private static TaskRunnable assertionTimeoutRunnable;
    private static TaskRunnable artifactTimeoutRunnable;
    private static TaskRunnable goThroughRunnable;
    private static String assertionVersion;
    private static String protocolVersion;

    private AssertionManager() {
        idEntryMap = new HashMap();
        artEntryMap = new HashMap();
        try {
            assertionVersion = SystemConfigurationUtil.getProperty("com.sun.identity.saml.assertion.version");
            protocolVersion = SystemConfigurationUtil.getProperty("com.sun.identity.saml.protocol.version");
        }
        catch (Exception e) {
            assertionVersion = "1.0";
            protocolVersion = "1.0";
        }
        TimerPool timerPool = SystemTimerPool.getTimerPool();
        ScheduleableGroupAction assertionTimeoutAction = new ScheduleableGroupAction(){

            public void doGroupAction(Object obj) {
                AssertionManager.this.deleteAssertion((String)obj, null);
            }
        };
        assertionTimeoutRunnable = new PeriodicGroupRunnable(assertionTimeoutAction, cleanUpInterval, assertionTimeout, true);
        timerPool.schedule(assertionTimeoutRunnable, new Date((System.currentTimeMillis() + cleanUpInterval) / 1000L * 1000L));
        ScheduleableGroupAction artifactTimeoutAction = new ScheduleableGroupAction(){

            public void doGroupAction(Object obj) {
                AssertionManager.this.deleteAssertion(null, (String)obj);
            }
        };
        artifactTimeoutRunnable = new PeriodicGroupRunnable(artifactTimeoutAction, cleanUpInterval, artifactTimeout, true);
        timerPool.schedule(artifactTimeoutRunnable, new Date((System.currentTimeMillis() + cleanUpInterval) / 1000L * 1000L));
        goThroughRunnable = new GoThroughRunnable(cleanUpInterval);
        timerPool.schedule(goThroughRunnable, new Date((System.currentTimeMillis() + cleanUpInterval) / 1000L * 1000L));
        if (assStats.isEnabled()) {
            artifactStats = new ArtifactStats(artEntryMap);
            artStats.addStatsListener((StatsListener)artifactStats);
            assertionStats = new AssertionStats(idEntryMap);
            assStats.addStatsListener((StatsListener)assertionStats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssertionManager getInstance() throws SAMLException {
        if (instance == null) {
            Class clazz = AssertionManager.class;
            synchronized (clazz) {
                if (instance == null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Constructing a new instance of AssertionManager");
                    }
                    instance = new AssertionManager();
                }
            }
        }
        return instance;
    }

    public Assertion createAssertion(Object token) throws SAMLException {
        if (assertionVersion.equals("1.0")) {
            return this.createAssertion(token, null, "urn:oasis:names:tc:SAML:1.0:cm:artifact-01", 0);
        }
        if (assertionVersion.equals("1.1")) {
            return this.createAssertion(token, null, SAMLConstants.CONFIRMATION_METHOD_ARTIFACT, 1);
        }
        throw new SAMLException(SAMLUtils.bundle.getString("assertionVersionNotSupport"));
    }

    public Assertion createAssertion(Object token, List attributes) throws SAMLException {
        if (assertionVersion.equals("1.0")) {
            return this.createAssertion(token, attributes, "urn:oasis:names:tc:SAML:1.0:cm:artifact-01", 0);
        }
        if (assertionVersion.equals("1.1")) {
            return this.createAssertion(token, attributes, SAMLConstants.CONFIRMATION_METHOD_ARTIFACT, 1);
        }
        throw new SAMLException(SAMLUtils.bundle.getString("assertionVersionNotSupport"));
    }

    private Assertion createAssertion(Object token, List attributes, String confirmationMethod, int minorVersion) throws SAMLException {
        if (token == null) {
            SAMLUtils.debug.error("AssertionManager.createAssertion(id):input Session is null.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (sessionProvider == null) {
            throw new SAMLException(SAMLUtils.bundle.getString("nullSessionProvider"));
        }
        String id = sessionProvider.getSessionID(token);
        return this.createAssertion(id, null, null, attributes, confirmationMethod, minorVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssertionArtifact createAssertionArtifact(Assertion assertion, String destID) throws SAMLException {
        String[] data;
        if (assertion == null || destID == null || destID.length() == 0) {
            SAMLUtils.debug.error("AssertionManager.createAssertionArtifact(Assertion, String): null input.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        Map partner = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (partner == null || !partner.containsKey(destID)) {
            SAMLUtils.debug.error("AssertionManager.createAssertionArtifact:(Assertion, String): destID not in partner list.");
            throw new SAMLException(SAMLUtils.bundle.getString("destIDNotFound"));
        }
        String handle = SAMLUtils.generateAssertionHandle();
        if (handle == null) {
            SAMLUtils.debug.error("AssertionManager.createAssertionArtifact(Assertion,String): couldn't generate assertion handle.");
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
        }
        String sourceID = (String)SAMLServiceManager.getAttribute("mysiteid");
        AssertionArtifact art = new AssertionArtifact(sourceID, handle);
        String artString = art.getAssertionArtifact();
        String aID = assertion.getAssertionID();
        Entry entry = (Entry)idEntryMap.get(aID);
        if (entry == null && !this.validateNumberOfAssertions(idEntryMap)) {
            entry = new Entry(assertion, destID, artString, null);
            try {
                Map map = idEntryMap;
                synchronized (map) {
                    idEntryMap.put(aID, entry);
                }
                goThroughRunnable.addElement((Object)aID);
            }
            catch (Exception e) {
                SAMLUtils.debug.error("AssertionManager.createAssertionArtifact(Assertion,String): couldn't add to idEntryMap." + e);
                throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
            }
            if (LogUtils.isAccessLoggable(Level.FINER)) {
                data = new String[]{SAMLUtils.bundle.getString("assertionCreated"), assertion.toString(true, true)};
                LogUtils.access(Level.FINER, "ASSERTION_CREATED", data);
            } else {
                data = new String[]{SAMLUtils.bundle.getString("assertionCreated"), assertion.getAssertionID()};
                LogUtils.access(Level.INFO, "ASSERTION_CREATED", data);
            }
        } else {
            String preArtString = entry.getArtifactString();
            if (preArtString != null && artEntryMap.containsKey(preArtString)) {
                SAMLUtils.debug.error("AssertionManager.createAssertionArtifact(Asssertion, String): Artifact exists for the assertion.");
                throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
            }
            entry.setDestID(destID);
            entry.setArtifactString(artString);
        }
        try {
            ArtEntry oldEntry = null;
            Map map = artEntryMap;
            synchronized (map) {
                oldEntry = artEntryMap.put(artString, new ArtEntry(aID, System.currentTimeMillis() + artifactTimeout));
            }
            if (oldEntry != null) {
                artifactTimeoutRunnable.removeElement((Object)artString);
            }
            artifactTimeoutRunnable.addElement((Object)artString);
        }
        catch (Exception e) {
            SAMLUtils.debug.error("AssertionManager.createAssertionArtfact(Assertion,String): couldn't add artifact to the artEntryMap", (Throwable)e);
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
        }
        data = new String[]{SAMLUtils.bundle.getString("assertionArtifactCreated"), artString, aID};
        LogUtils.access(Level.INFO, "ASSERTION_ARTIFACT_CREATED", data);
        return art;
    }

    public Set getAssertions(Object token) throws SAMLException {
        if (token == null) {
            SAMLUtils.debug.error("AssertionManager.getAssertions(Object): input session is null.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!this.isSuperUser(token)) {
            SAMLUtils.debug.error("AssertionManager.getAssertions(Object): Session doesn't have the privilege.");
            throw new SAMLException(SAMLUtils.bundle.getString("noPrivilege"));
        }
        return idEntryMap.keySet();
    }

    private boolean isSuperUser(Object token) {
        block4: {
            try {
                if (sessionProvider == null) {
                    SAMLUtils.debug.error("SessionProvider is null.");
                    return false;
                }
                String userID = sessionProvider.getProperty(token, "sun.am.UniversalIdentifier")[0];
                if (superUser != null && superUser.length() > 0) {
                    return superUser.equalsIgnoreCase(userID);
                }
            }
            catch (Exception e) {
                if (!SAMLUtils.debug.messageEnabled()) break block4;
                SAMLUtils.debug.message("AssertionManager.isSuperUser:Exception: ", (Throwable)e);
            }
        }
        return false;
    }

    public Assertion getAssertion(String id) throws SAMLException {
        if (id == null || id.length() == 0) {
            SAMLUtils.debug.error("AssertionManager.getAssetion(String): id is null.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        AssertionIDReference idRef = new AssertionIDReference(id);
        return this.getAssertion(idRef, null, false);
    }

    public Set getAssertionArtifacts(Object token) throws SAMLException {
        if (token == null) {
            SAMLUtils.debug.error("AssertionManager.getAssertionArtifacts(Object token): input token is null.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!this.isSuperUser(token)) {
            SAMLUtils.debug.error("AssertionManager.getAssertionArtifacts(Object token): Session doesn't have the privilege.");
            throw new SAMLException(SAMLUtils.bundle.getString("noPrivilege"));
        }
        return artEntryMap.keySet();
    }

    public Assertion createSSOAssertion(String id, AssertionArtifact artifact, String destID, String targetUrl, String version) throws SAMLException {
        List attributes = null;
        Map partnerURLs = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        SAMLServiceManager.SOAPEntry partnerEntry = (SAMLServiceManager.SOAPEntry)partnerURLs.get(destID);
        if (partnerEntry != null) {
            try {
                PartnerSiteAttributeMapper pMapper = partnerEntry.getPartnerSiteAttributeMapper();
                if (sessionProvider == null) {
                    throw new SAMLException(SAMLUtils.bundle.getString("nullSessionProvider"));
                }
                Object userSession = sessionProvider.getSession(id);
                if (pMapper != null) {
                    attributes = pMapper.getAttributes(userSession, targetUrl);
                } else {
                    SiteAttributeMapper mapper = partnerEntry.getSiteAttributeMapper();
                    if (mapper != null) {
                        attributes = mapper.getAttributes(userSession);
                    }
                }
            }
            catch (SessionException ssoe) {
                SAMLUtils.debug.error("AssertionManager.createAssertion(id): exception retrieving info from the Session", (Throwable)((Object)ssoe));
                return null;
            }
        }
        if (artifact == null) {
            if (version.equals("1.1")) {
                return this.createAssertion(id, artifact, destID, attributes, "urn:oasis:names:tc:SAML:1.0:cm:bearer", 1);
            }
            return this.createAssertion(id, artifact, destID, attributes, "urn:oasis:names:tc:SAML:1.0:cm:bearer", 0);
        }
        if (version == null || version.equals("1.0")) {
            return this.createAssertion(id, artifact, destID, attributes, "urn:oasis:names:tc:SAML:1.0:cm:artifact-01", 0);
        }
        if (version.equals("1.1")) {
            return this.createAssertion(id, artifact, destID, attributes, SAMLConstants.CONFIRMATION_METHOD_ARTIFACT, 1);
        }
        SAMLUtils.debug.error("Input version " + version + " is not supported.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Assertion createAssertion(String id, AssertionArtifact artifact, String destID, List attributes, String confirmationMethod, int minorVersion) throws SAMLException {
        String[] data;
        Map map;
        Object oldEntry;
        String srcID;
        NameIdentifier ni;
        if (id == null || id.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.createAssertion(id):null input.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        this.validateNumberOfAssertions(idEntryMap);
        String authMethod = null;
        Date authInstant = null;
        Object token = null;
        String clientIP = null;
        try {
            if (sessionProvider == null) {
                throw new SAMLException(SAMLUtils.bundle.getString("nullSessionProvider"));
            }
            token = sessionProvider.getSession(id);
            authMethod = sessionProvider.getProperty(token, "authMethod")[0];
            String authSSOInstant = sessionProvider.getProperty(token, "authInstant")[0];
            authInstant = authSSOInstant == null || authSSOInstant.equals("") ? new Date() : DateUtils.stringToDate((String)authSSOInstant);
            try {
                InetAddress clientIPAddress = InetAddress.getByName(sessionProvider.getProperty(token, "ipaddress")[0]);
                clientIP = clientIPAddress.getHostAddress();
            }
            catch (Exception e) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.createAssertion(id):exception when obtaining client ip: ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            SAMLUtils.debug.error("AssertionManager.createAssertion(id): exception retrieving info from the Session: ", (Throwable)e);
            return null;
        }
        Map partnerURLs = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        SAMLServiceManager.SOAPEntry partnerEntry = (SAMLServiceManager.SOAPEntry)partnerURLs.get(destID);
        NameIdentifierMapper niMapper = null;
        if (partnerEntry != null) {
            niMapper = partnerEntry.getNameIdentifierMapper();
        }
        if (niMapper == null) {
            niMapper = new DefaultNameIdentifierMapper();
        }
        if ((ni = niMapper.getNameIdentifier(token, srcID = (String)SAMLServiceManager.getAttribute("mysiteid"), destID)) == null) {
            SAMLUtils.debug.error("AssertionManager.createAssertion(id): name identifier is null.");
            return null;
        }
        SubjectConfirmation subConfirmation = null;
        String artString = null;
        if (confirmationMethod != null && confirmationMethod.length() > 0) {
            subConfirmation = new SubjectConfirmation(confirmationMethod);
        } else if (artifact != null) {
            confirmationMethod = minorVersion == 0 ? "urn:oasis:names:tc:SAML:1.0:cm:artifact-01" : SAMLConstants.CONFIRMATION_METHOD_ARTIFACT;
            subConfirmation = new SubjectConfirmation(confirmationMethod);
        } else {
            subConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        }
        if (artifact != null) {
            artString = artifact.getAssertionArtifact();
        }
        Subject sub = new Subject(ni, subConfirmation);
        SubjectLocality subjLocality = null;
        if (clientIP != null && clientIP.length() != 0) {
            subjLocality = new SubjectLocality(clientIP, null);
        }
        HashSet<SubjectStatement> statements = new HashSet<SubjectStatement>();
        statements.add(new AuthenticationStatement(authMethod, authInstant, sub, subjLocality, null));
        if (attributes != null && !attributes.isEmpty()) {
            statements.add(new AttributeStatement(sub, attributes));
        }
        Date issueInstant = new Date();
        Date notBefore = new Date(issueInstant.getTime() - notBeforeSkew);
        Date notAfter = new Date(issueInstant.getTime() + assertionTimeout);
        Conditions cond = new Conditions(notBefore, notAfter);
        String issuer = (String)SAMLServiceManager.getAttribute("mysitename");
        Assertion assertion = new Assertion(null, issuer, issueInstant, cond, statements);
        assertion.setMinorVersion(minorVersion);
        String aIDString = assertion.getAssertionID();
        if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signassertion")).booleanValue()) {
            assertion.signXML();
        }
        Entry entry = new Entry(assertion, destID, artString, token);
        try {
            oldEntry = null;
            map = idEntryMap;
            synchronized (map) {
                oldEntry = idEntryMap.put(aIDString, entry);
            }
            if (oldEntry != null) {
                assertionTimeoutRunnable.removeElement((Object)aIDString);
            }
            assertionTimeoutRunnable.addElement((Object)aIDString);
        }
        catch (Exception e) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager: couldn't add to idEntryMap.", (Throwable)e);
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateAssertion"));
        }
        if (LogUtils.isAccessLoggable(Level.FINER)) {
            data = new String[]{SAMLUtils.bundle.getString("assertionCreated"), assertion.toString(true, true)};
            LogUtils.access(Level.FINER, "ASSERTION_CREATED", data);
        } else {
            data = new String[]{SAMLUtils.bundle.getString("assertionCreated"), aIDString};
            LogUtils.access(Level.INFO, "ASSERTION_CREATED", data);
        }
        if (artString != null) {
            try {
                oldEntry = null;
                map = artEntryMap;
                synchronized (map) {
                    oldEntry = artEntryMap.put(artString, new ArtEntry(aIDString, System.currentTimeMillis() + artifactTimeout));
                }
                if (oldEntry != null) {
                    artifactTimeoutRunnable.removeElement((Object)artString);
                }
                artifactTimeoutRunnable.addElement((Object)artString);
            }
            catch (Exception e) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager: couldn't add artifact to the artEntryMap.", (Throwable)e);
                }
                throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
            }
            data = new String[]{SAMLUtils.bundle.getString("assertionArtifactCreated"), artString, aIDString};
            LogUtils.access(Level.INFO, "ASSERTION_ARTIFACT_CREATED", data);
        }
        if (token != null) {
            AssertionSSOTokenListener listener = new AssertionSSOTokenListener(aIDString, artString);
            try {
                sessionProvider.addListener(token, listener);
            }
            catch (SessionException e) {
                SAMLUtils.debug.error("AssertionManager.createAssertion(id): Couldn't add listener to session:", (Throwable)((Object)e));
            }
            catch (UnsupportedOperationException uoe) {
                SAMLUtils.debug.warning("AssertionManager.createAssertion(id): Operation add listener to session not supported:", (Throwable)uoe);
            }
        }
        return assertion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteAssertion(String assertionID, String artifact) {
        ArtEntry artEntry = null;
        if (artifact != null) {
            artEntry = (ArtEntry)artEntryMap.remove(artifact);
            String[] data = new String[]{SAMLUtils.bundle.getString("assertionArtifactRemoved"), artifact};
            LogUtils.access(Level.FINE, "ASSERTION_ARTIFACT_REMOVED", data);
        }
        if (assertionID != null) {
            Entry entry = null;
            entry = (Entry)idEntryMap.remove(assertionID);
            if (entry != null) {
                String artString;
                String[] data = new String[]{SAMLUtils.bundle.getString("assertionRemoved"), assertionID};
                LogUtils.access(Level.FINE, "ASSERTION_REMOVED", data);
                if (artifact == null && (artString = entry.getArtifactString()) != null) {
                    Map map = artEntryMap;
                    synchronized (map) {
                        artEntryMap.remove(artString);
                    }
                    String[] data2 = new String[]{SAMLUtils.bundle.getString("assertionArtifactRemoved"), artifact};
                    LogUtils.access(Level.FINE, "ASSERTION_ARTIFACT_REMOVED", data2);
                }
            }
        } else if (artEntry != null && SAMLServiceManager.getRemoveAssertion()) {
            Map map = idEntryMap;
            synchronized (map) {
                idEntryMap.remove(artEntry.getAssertionID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Assertion getAssertion(AssertionArtifact artifact, Set destID, boolean destCheckFlag) throws SAMLException {
        Assertion assertion;
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("getAssertion(arti): destID set= " + Base64.encode((byte[])SAMLUtils.stringToByteArray((String)destID.iterator().next())));
        }
        String artString = artifact.getAssertionArtifact();
        String remoteUrl = SAMLUtils.getServerURL(artifact.getAssertionHandle());
        if (remoteUrl != null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid: calling another server in lb site:" + remoteUrl);
            }
            AssertionManagerClient amc = new AssertionManagerClient(SAMLUtils.getFullServiceURL(remoteUrl));
            return amc.getAssertion(artifact, destID);
        }
        String aIDString = null;
        long timeout = 0L;
        ArtEntry artEntry = (ArtEntry)artEntryMap.get(artString);
        if (artEntry == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid): no Assertion found corresponding to artifact.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("noMatchingAssertion"));
        }
        aIDString = artEntry.getAssertionID();
        if (aIDString == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid): no AssertionID found corresponding to artifact.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("noMatchingAssertion"));
        }
        timeout = artEntry.getExpireTime();
        if (System.currentTimeMillis() > timeout) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid): artifact timed out.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("artifactTimedOut"));
        }
        Entry entry = null;
        entry = (Entry)idEntryMap.get(aIDString);
        if (entry == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid): no Entry found corresponding to artifact.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("noMatchingAssertion"));
        }
        if (destCheckFlag) {
            String dest = entry.getDestID();
            if (dest == null) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid): no destID found corresponding to artifact.");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("noDestIDMatchingArtifact"));
            }
            if (destID == null || !destID.contains(dest)) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid): destinationID doesn't match.");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("destIDNotMatch"));
            }
        }
        if ((assertion = entry.getAssertion()) == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid): no Assertion found corresponding to aID.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("noMatchingAssertion"));
        }
        Map map = artEntryMap;
        synchronized (map) {
            artEntryMap.remove(artString);
        }
        artifactTimeoutRunnable.removeElement((Object)artString);
        String[] data = new String[]{SAMLUtils.bundle.getString("assertionArtifactVerified"), artString};
        LogUtils.access(Level.INFO, "ASSERTION_ARTIFACT_VERIFIED", data);
        if (SAMLServiceManager.getRemoveAssertion()) {
            Map map2 = idEntryMap;
            synchronized (map2) {
                idEntryMap.remove(aIDString);
            }
            assertionTimeoutRunnable.removeElement((Object)aIDString);
        }
        if (!assertion.isTimeValid()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager: assertion " + aIDString + " is expired.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("assertionTimeNotValid"));
        }
        return assertion;
    }

    public Assertion getAssertion(AssertionArtifact artifact, String destID) throws SAMLException {
        if (artifact == null || destID == null || destID.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager: input is null.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        HashSet<String> destSet = new HashSet<String>();
        destSet.add(destID);
        return this.getAssertion(artifact, destSet, true);
    }

    public Assertion getAssertion(AssertionArtifact artifact, Set destID) throws SAMLException {
        if (artifact == null || destID == null || destID.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager: input is null.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        return this.getAssertion(artifact, destID, true);
    }

    protected Assertion getAssertion(AssertionArtifact artifact) throws SAMLException {
        if (artifact == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager: input is null.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        return this.getAssertion(artifact, null, false);
    }

    public Assertion getAssertion(Query query, String destID) throws SAMLException {
        if (query == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion: input query is null.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        Assertion result = null;
        int queryType = query.getQueryType();
        if (queryType == 0) {
            result = this.getAuthenticationAssertion((AuthenticationQuery)query, destID);
        } else if (queryType == 1) {
            result = this.getAuthorizationDecisionAssertion((AuthorizationDecisionQuery)query, destID);
        } else if (queryType == 2) {
            result = this.getAttributeAssertion((AttributeQuery)query, destID);
        } else {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion: this type of query is not supported:" + queryType);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("queryNotSupported"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Assertion getAttributeAssertion(AttributeQuery query, String destID) throws SAMLException {
        String[] data;
        String aIDString;
        Assertion newAssertion;
        block37: {
            if (query == null) {
                return null;
            }
            if (destID == null || destID.length() == 0) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: missing destID.");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("missingDestID"));
            }
            this.validateNumberOfAssertions(idEntryMap);
            Map entries = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
            if (entries == null) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: empty partner URL list.");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("emptyPartnerURLList"));
            }
            SAMLServiceManager.SOAPEntry destSite = (SAMLServiceManager.SOAPEntry)entries.get(destID);
            AttributeMapper attrMapper = null;
            if (destSite == null || (attrMapper = destSite.getAttributeMapper()) == null) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: couldn't obtain AttributeMapper.");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("errorObtainAttributeMapper"));
            }
            Subject subject = query.getSubject();
            String tokenID = attrMapper.getSSOTokenID(query);
            Object token = null;
            String issuerName = (String)SAMLServiceManager.getAttribute("mysitename");
            if (tokenID != null) {
                try {
                    if (sessionProvider == null) {
                        throw new SAMLException(SAMLUtils.bundle.getString("nullSessionProvider"));
                    }
                    token = sessionProvider.getSession(tokenID);
                }
                catch (Exception e) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: invalid SSO token:", (Throwable)e);
                    }
                    throw new SAMLException(SAMLUtils.bundle.getString("invalidSSOToken"));
                }
            } else {
                Assertion assertion = attrMapper.getSSOAssertion(query);
                if (assertion == null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: couldn't find SSOAssertion in query.");
                    }
                    throw new SAMLException(SAMLUtils.bundle.getString("noSSOAssertion"));
                }
                if (!assertion.isSignatureValid()) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: SSOAssertion is signature invalid.");
                    }
                    throw new SAMLException(SAMLUtils.bundle.getString("assertionSignatureNotValid"));
                }
                if (!assertion.isTimeValid()) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: SSOAssertion is time invalid.");
                    }
                    throw new SAMLException(SAMLUtils.bundle.getString("assertionTimeNotValid"));
                }
                Iterator iter = assertion.getStatement().iterator();
                Statement statement = null;
                Subject ssoSubject = null;
                while (iter.hasNext()) {
                    statement = (Statement)iter.next();
                    if (statement.getStatementType() != 1) continue;
                    ssoSubject = ((AuthenticationStatement)statement).getSubject();
                    break;
                }
                if (ssoSubject == null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: missing AuthenticationStatement in SSOAssertion.");
                    }
                    throw new SAMLException(SAMLUtils.bundle.getString("noAuthNStatement"));
                }
                String issuer = assertion.getIssuer();
                String aID = assertion.getAssertionID();
                if (issuerName != null && issuerName.equals(issuer) && SAMLUtils.getServerURL(aID) == null) {
                    Entry entry;
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttrAssertion:this server is the issuer.");
                    }
                    if ((entry = (Entry)idEntryMap.get(aID)) != null && (token = entry.getSSOToken()) != null) {
                        this.verifySSOTokenAndNI(token, ssoSubject.getNameIdentifier());
                    }
                } else {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttrAssertion:this server is not the issuer.");
                    }
                    token = this.checkAssertionAndCreateSSOToken(assertion, null, ssoSubject);
                }
            }
            List attributes = attrMapper.getAttributes(query, destID, token);
            if (attributes == null || attributes.size() == 0) {
                return null;
            }
            HashSet<AttributeStatement> stmtSet = new HashSet<AttributeStatement>();
            stmtSet.add(new AttributeStatement(subject, attributes));
            Date issueInstant = new Date();
            Date notBefore = new Date(issueInstant.getTime() - notBeforeSkew);
            Date notAfter = new Date(issueInstant.getTime() + assertionTimeout);
            Conditions cond = new Conditions(notBefore, notAfter);
            newAssertion = new Assertion(null, issuerName, issueInstant, cond, stmtSet);
            if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signassertion")).booleanValue()) {
                newAssertion.signXML();
            }
            aIDString = newAssertion.getAssertionID();
            Entry newEntry = new Entry(newAssertion, destID, null, null);
            try {
                Entry oldEntry = null;
                Map map = idEntryMap;
                synchronized (map) {
                    oldEntry = idEntryMap.put(aIDString, newEntry);
                }
                if (oldEntry != null) {
                    assertionTimeoutRunnable.removeElement((Object)aIDString);
                }
                assertionTimeoutRunnable.addElement((Object)aIDString);
            }
            catch (Exception e) {
                if (!SAMLUtils.debug.messageEnabled()) break block37;
                SAMLUtils.debug.message("AssertionManager.getAttributeAssertion couldn't add assertion to the idEntryMap.", (Throwable)e);
            }
        }
        if (LogUtils.isAccessLoggable(Level.FINER)) {
            data = new String[]{SAMLUtils.bundle.getString("assertionCreated"), newAssertion.toString(true, true)};
            LogUtils.access(Level.FINER, "ASSERTION_CREATED", data);
        } else {
            data = new String[]{SAMLUtils.bundle.getString("assertionCreated"), aIDString};
            LogUtils.access(Level.INFO, "ASSERTION_CREATED", data);
        }
        return newAssertion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Assertion getAuthenticationAssertion(AuthenticationQuery query, String destID) throws SAMLException {
        String[] data;
        String am;
        NameIdentifier ni;
        if (query == null) {
            return null;
        }
        this.validateNumberOfAssertions(idEntryMap);
        Subject subject = query.getSubject();
        SubjectConfirmation sc = subject.getSubjectConfirmation();
        if (sc == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: missing SubjectConfirmation.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("missingSubjectConfirmation"));
        }
        if (!SAMLUtils.isCorrectConfirmationMethod(sc)) {
            throw new SAMLException(SAMLUtils.bundle.getString("wrongConfirmationMethodValue"));
        }
        Element scData = sc.getSubjectConfirmationData();
        if (scData == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: missing SubjectConfirmationData in the Subject.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("missingSubjectConfirmationData"));
        }
        String authMethod = null;
        Date authInstant = null;
        String nameQualifier = null;
        String name = null;
        Object token = null;
        String clientIP = null;
        try {
            if (sessionProvider == null) {
                throw new SAMLException(SAMLUtils.bundle.getString("nullSessionProvider"));
            }
            token = sessionProvider.getSession(XMLUtils.getElementString((Element)scData));
            authMethod = SAMLServiceManager.getAuthMethodURI(sessionProvider.getProperty(token, "AuthType")[0]);
            authInstant = DateUtils.stringToDate((String)sessionProvider.getProperty(token, "authInstant")[0]);
            nameQualifier = XMLUtils.escapeSpecialCharacters((String)sessionProvider.getProperty(token, "Organization")[0]);
            name = XMLUtils.escapeSpecialCharacters((String)sessionProvider.getPrincipalName(token));
            try {
                InetAddress clientIPAddress = InetAddress.getByName(sessionProvider.getProperty(token, "ipaddress")[0]);
                clientIP = clientIPAddress.getHostAddress();
            }
            catch (Exception e) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: exception when getting client ip.");
                }
            }
        }
        catch (Exception e) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: exception retrieving info from the SSOToken:", (Throwable)e);
            }
            throw new SAMLException(SAMLUtils.bundle.getString("wrongSubjectConfirmationData"));
        }
        if ((ni = subject.getNameIdentifier()) != null) {
            String niName = ni.getName();
            String niNameQualifier = ni.getNameQualifier();
            if (niName != null && !niName.equalsIgnoreCase(name) || niNameQualifier != null && !niNameQualifier.equalsIgnoreCase(nameQualifier)) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: NameIdentifier is different from info in SubjectConfirmation");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("wrongNameIdentifier"));
            }
        }
        if ((am = query.getAuthenticationMethod()) != null && am.length() != 0 && !am.equalsIgnoreCase(authMethod)) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: couldn't form an assertion matching the AuthenticationMethod in the query.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("authenticationMethodInQueryNotMatch"));
        }
        SubjectLocality subjLocality = null;
        if (clientIP != null && clientIP.length() != 0) {
            subjLocality = new SubjectLocality(clientIP, null);
        }
        AuthenticationStatement statement = new AuthenticationStatement(authMethod, authInstant, subject, subjLocality, null);
        Date issueInstant = new Date();
        Date notAfter = new Date(issueInstant.getTime() + assertionTimeout);
        Date notBefore = new Date(issueInstant.getTime() - notBeforeSkew);
        Conditions cond = new Conditions(notBefore, notAfter);
        String issuer = (String)SAMLServiceManager.getAttribute("mysitename");
        HashSet<AuthenticationStatement> statements = new HashSet<AuthenticationStatement>();
        statements.add(statement);
        Assertion assertion = new Assertion(null, issuer, issueInstant, cond, statements);
        if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signassertion")).booleanValue()) {
            assertion.signXML();
        }
        String aIDString = assertion.getAssertionID();
        Entry entry = new Entry(assertion, destID, null, token);
        try {
            Entry oldEntry = null;
            Map map = idEntryMap;
            synchronized (map) {
                oldEntry = idEntryMap.put(aIDString, entry);
            }
            if (oldEntry != null) {
                assertionTimeoutRunnable.removeElement((Object)aIDString);
            }
            assertionTimeoutRunnable.addElement((Object)aIDString);
        }
        catch (Exception e) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: couldn't add assertion to the idEntryMap.", (Throwable)e);
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateAssertion"));
        }
        if (LogUtils.isAccessLoggable(Level.FINER)) {
            data = new String[]{SAMLUtils.bundle.getString("assertionCreated"), assertion.toString(true, true)};
            LogUtils.access(Level.FINER, "ASSERTION_CREATED", data);
        } else {
            data = new String[]{SAMLUtils.bundle.getString("assertionCreated"), aIDString};
            LogUtils.access(Level.INFO, "ASSERTION_CREATED", data);
        }
        AssertionSSOTokenListener listener = new AssertionSSOTokenListener(aIDString);
        try {
            sessionProvider.addListener(token, listener);
        }
        catch (SessionException e) {
            SAMLUtils.debug.error("AssertionManager.getAuthNAssertion: Couldn't add listener to token:", (Throwable)((Object)e));
        }
        return assertion;
    }

    private Assertion getAuthorizationDecisionAssertion(AuthorizationDecisionQuery query, String destID) throws SAMLException {
        return this.getAuthorizationDecisionAssertion(query, destID, true);
    }

    private Assertion getAuthorizationDecisionAssertion(AuthorizationDecisionQuery query, String destID, boolean store) throws SAMLException {
        if (query == null) {
            return null;
        }
        if (destID == null || destID.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: missing destID.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("missingDestID"));
        }
        Map entries = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (entries == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: empty partnerURL list.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("emptyPartnerURLList"));
        }
        SAMLServiceManager.SOAPEntry destSite = (SAMLServiceManager.SOAPEntry)entries.get(destID);
        ActionMapper actionMapper = null;
        if (destSite == null || (actionMapper = destSite.getActionMapper()) == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: couldn't obtain ActionMapper.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("errorObtainActionMapper"));
        }
        Subject querySubject = query.getSubject();
        NameIdentifier queryNI = querySubject.getNameIdentifier();
        Object token = null;
        boolean existingToken = true;
        String tokenID = actionMapper.getSSOTokenID(query);
        if (tokenID != null) {
            try {
                if (sessionProvider == null) {
                    throw new SAMLException(SAMLUtils.bundle.getString("nullSessionProvider"));
                }
                token = sessionProvider.getSession(tokenID);
            }
            catch (Exception e) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: invalid SSO token:", (Throwable)e);
                }
                throw new SAMLException(SAMLUtils.bundle.getString("invalidSSOToken"));
            }
            this.verifySSOTokenAndNI(token, queryNI);
        } else {
            Map tokenMap;
            Assertion assertion = actionMapper.getSSOAssertion(query, destID);
            if (assertion != null && (token = (tokenMap = this.verifyAssertionAndGetSSOToken(querySubject, assertion)).get("true")) == null) {
                existingToken = false;
                token = tokenMap.get("false");
            }
        }
        if (token == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: Couldn't obtain ssotoken.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifySubject"));
        }
        Map map = actionMapper.getAuthorizationDecisions(query, token, destID);
        return this.getAuthorizationDecisionAssertion(query, destID, true, token, existingToken, map);
    }

    private Map verifyAssertionAndGetSSOToken(Subject querySubject, Assertion assertion) throws SAMLException {
        if (querySubject == null || assertion == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifyAssertionAndGetSSOToken: null input.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifySubject"));
        }
        if (!assertion.isSignatureValid()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifyAssertionAndGetSSOToken: SSOAssertion is signature invalid.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("assertionSignatureNotValid"));
        }
        if (!assertion.isTimeValid()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifyAssertionAndGetSSOToken: SSOAssertion is time invalid.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("assertionTimeNotValid"));
        }
        HashMap<String, Object> tokenMap = new HashMap<String, Object>();
        Object token = null;
        String issuerName = (String)SAMLServiceManager.getAttribute("mysitename");
        String issuer = assertion.getIssuer();
        String aID = assertion.getAssertionID();
        if (issuerName != null && issuerName.equals(issuer) && SAMLUtils.getServerURL(aID) == null) {
            Entry entry;
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthZAssertion:this server is the issuer.");
            }
            if ((entry = (Entry)idEntryMap.get(aID)) != null && (token = entry.getSSOToken()) != null) {
                this.verifySSOTokenAndNI(token, querySubject.getNameIdentifier());
                tokenMap.put("true", token);
                return tokenMap;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifyAssertionAndGetSSOToken: either not an AuthN assertion or token is not for this subject.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifySubject"));
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("AssertionManager.getAuthZAssertion:this server is not the issuer.");
        }
        Iterator iter = assertion.getStatement().iterator();
        Statement statement = null;
        AuthenticationStatement ssoStatement = null;
        while (iter.hasNext()) {
            statement = (Statement)iter.next();
            if (statement.getStatementType() != 1) continue;
            ssoStatement = (AuthenticationStatement)statement;
            break;
        }
        if (ssoStatement == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifyAssertionAndGetSSOToken:  missing AuthenticationStatement in SSOAssertion.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("noAuthNStatement"));
        }
        token = this.checkAssertionAndCreateSSOToken(assertion, (AuthenticationStatement)statement, querySubject);
        tokenMap.put("false", token);
        return tokenMap;
    }

    private void verifySSOTokenAndNI(Object token, NameIdentifier ni) throws SAMLException {
        String name = null;
        String nameQualifier = null;
        try {
            if (sessionProvider == null) {
                throw new SAMLException(SAMLUtils.bundle.getString("nullSessionProvider"));
            }
            name = XMLUtils.escapeSpecialCharacters((String)sessionProvider.getPrincipalName(token));
            nameQualifier = XMLUtils.escapeSpecialCharacters((String)sessionProvider.getProperty(token, "Organization")[0]);
        }
        catch (Exception e) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifySSOTokenAndNI: Session is not valid.", (Throwable)e);
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifySubject"));
        }
        if (ni == null) {
            return;
        }
        String niName = ni.getName();
        String niNameQualifier = ni.getNameQualifier();
        if (niName != null && !niName.equalsIgnoreCase(name) || niNameQualifier != null && !niNameQualifier.equalsIgnoreCase(nameQualifier)) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifySSOTokenAndNI: NameIdentifier is different from info in token.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("wrongNameIdentifier"));
        }
    }

    private Object checkAssertionAndCreateSSOToken(Assertion assertion, AuthenticationStatement statement, Subject subject) throws SAMLException {
        String issuer = assertion.getIssuer();
        SAMLServiceManager.SOAPEntry sourceSite = SAMLUtils.getSourceSite(issuer);
        if (sourceSite == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.checkAssertionAndCreateSSOToken: issuer is not on the partnerURL list.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifySubject"));
        }
        if (!(statement == null || subject != null && subject.equals(statement.getSubject()))) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifyAndGetSSOToken: wrong subject in evidence.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifySubject"));
        }
        return this.createTempSSOToken(assertion, subject, sourceSite);
    }

    private Object createTempSSOToken(Assertion assertion, Subject subject, SAMLServiceManager.SOAPEntry sourceSite) throws SAMLException {
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        assertions.add(assertion);
        String srcID = sourceSite.getSourceID();
        String name = null;
        String org = null;
        PartnerAccountMapper paMapper = sourceSite.getPartnerAccountMapper();
        if (paMapper != null) {
            Map map = paMapper.getUser(assertions, srcID, null);
            name = (String)map.get("name");
            org = (String)map.get("org");
        }
        if (org == null || name == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.createTempSSOToken: couldn't map the subject to a local user.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("cannotMapSubject"));
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("AssertionManager.createTempSSOToken: org = " + org + ", name = " + name);
        }
        Object token = null;
        try {
            HashMap<String, String> infoMap = new HashMap<String, String>();
            infoMap.put("realm", "/");
            infoMap.put("principalName", name);
            infoMap.put("AuthLevel", "0");
            token = SAMLUtils.generateSession(null, null, infoMap);
        }
        catch (Exception e) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManger.createTempSSOToken: Couldn't retrieve the ssotoken.", (Throwable)e);
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateAssertion"));
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Assertion getAuthorizationDecisionAssertion(AuthorizationDecisionQuery query, String destID, boolean store, Object token, boolean addListener, Map actionMap) throws SAMLException {
        int decision;
        if (actionMap == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: actionMap from ActionMapper is null.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("nullAuthZDecision"));
        }
        this.validateNumberOfAssertions(idEntryMap);
        List newActions = null;
        newActions = (List)actionMap.get("Permit");
        if (newActions != null) {
            decision = 1;
        } else {
            newActions = (List)actionMap.get("Deny");
            if (newActions != null) {
                decision = 2;
            } else {
                newActions = (List)actionMap.get("Indeterminate");
                if (newActions == null) {
                    newActions = query.getAction();
                }
                decision = 3;
            }
        }
        AuthorizationDecisionStatement statement = new AuthorizationDecisionStatement(query.getSubject(), query.getResource(), decision, newActions, query.getEvidence());
        Date issueInstant = new Date();
        Date notAfter = new Date(issueInstant.getTime() + assertionTimeout);
        Date notBefore = new Date(issueInstant.getTime() - notBeforeSkew);
        Conditions cond = new Conditions(notBefore, notAfter);
        String issuer = (String)SAMLServiceManager.getAttribute("mysitename");
        HashSet<AuthorizationDecisionStatement> statements = new HashSet<AuthorizationDecisionStatement>();
        statements.add(statement);
        Assertion assertion = new Assertion(null, issuer, issueInstant, cond, statements);
        if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signassertion")).booleanValue()) {
            assertion.signXML();
        }
        String aIDString = assertion.getAssertionID();
        if (store) {
            String[] data;
            Entry entry = null;
            if (addListener) {
                AssertionSSOTokenListener listener = new AssertionSSOTokenListener(aIDString);
                try {
                    if (sessionProvider == null) {
                        throw new SAMLException(SAMLUtils.bundle.getString("nullSessionProvider"));
                    }
                    sessionProvider.addListener(token, listener);
                }
                catch (SessionException e) {
                    SAMLUtils.debug.error("AssertionManager.getAuthNAssertion: Couldn't get listener to token:", (Throwable)((Object)e));
                }
            }
            entry = new Entry(assertion, destID, null, null);
            try {
                Entry oldEntry = null;
                Map map = idEntryMap;
                synchronized (map) {
                    oldEntry = idEntryMap.put(aIDString, entry);
                }
                if (oldEntry != null) {
                    assertionTimeoutRunnable.removeElement((Object)aIDString);
                }
                assertionTimeoutRunnable.addElement((Object)aIDString);
            }
            catch (Exception e) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: couldn't add assertion to the idAssertionMap.", (Throwable)e);
                }
                throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateAssertion"));
            }
            if (LogUtils.isAccessLoggable(Level.FINER)) {
                data = new String[]{SAMLUtils.bundle.getString("assertionCreated"), assertion.toString(true, true)};
                LogUtils.access(Level.FINER, "ASSERTION_CREATED", data);
            } else {
                data = new String[]{SAMLUtils.bundle.getString("assertionCreated"), aIDString};
                LogUtils.access(Level.INFO, "ASSERTION_CREATED", data);
            }
        }
        return assertion;
    }

    public Assertion getAssertion(AssertionIDReference idRef) throws SAMLException {
        return this.getAssertion(idRef, null, false);
    }

    public Assertion getAssertion(AssertionIDReference idRef, Object token) throws SAMLException {
        if (token == null) {
            SAMLUtils.debug.error("AssertionManager.getAssertion(idRef, token): input token is null.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!this.isSuperUser(token)) {
            SAMLUtils.debug.error("AssertionManager.getAssertion(idRef, token): Session doesn't have the privilege.");
            throw new SAMLException(SAMLUtils.bundle.getString("noPrivilege"));
        }
        return this.getAssertion(idRef, null, true);
    }

    public Assertion getAssertion(AssertionIDReference idRef, String destID) throws SAMLException {
        if (destID == null) {
            return this.getAssertion(idRef, null, false);
        }
        HashSet<String> destSet = new HashSet<String>();
        destSet.add(destID);
        return this.getAssertion(idRef, destSet, false);
    }

    public Assertion getAssertion(AssertionIDReference idRef, Set destID) throws SAMLException {
        return this.getAssertion(idRef, destID, false);
    }

    private Assertion getAssertion(AssertionIDReference idRef, Set destID, boolean useToken) throws SAMLException {
        String dest;
        String remoteUrl;
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("getAssertion(idRef): destID set=" + destID);
        }
        if (idRef == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(AssertionIDRef): null AssertionID.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        String aIDString = idRef.getAssertionIDReference();
        if (!useToken && (remoteUrl = SAMLUtils.getServerURL(aIDString)) != null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(idRef): calling another server in lb site:" + remoteUrl);
            }
            AssertionManagerClient amc = new AssertionManagerClient(SAMLUtils.getFullServiceURL(remoteUrl));
            return amc.getAssertion(idRef, destID);
        }
        Entry entry = (Entry)idEntryMap.get(aIDString);
        if (entry == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(AssertionIDRef): no matching assertion found in idEntryMap.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("noMatchingAssertion"));
        }
        Assertion assertion = entry.getAssertion();
        if (assertion == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(AssertionIDRef): no matching assertion found.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("noMatchingAssertion"));
        }
        if (!(useToken || (dest = entry.getDestID()) == null || destID != null && destID.contains(dest))) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(AssertionID): destID doesn't match.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("destIDNotMatch"));
        }
        if (!assertion.isTimeValid()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager: assertion " + aIDString + " is expired.");
            }
            throw new SAMLException("assertionTimeNotValid");
        }
        return assertion;
    }

    public AssertionArtifact createAssertionArtifact(String id, String destID) throws SAMLException {
        return this.createAssertionArtifact(id, destID, null, null);
    }

    public AssertionArtifact createAssertionArtifact(String id, String destID, String targetUrl, String version) throws SAMLException {
        if (id == null || destID == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager: null input for method createAssertionArtifact.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        Map partner = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (partner == null || !partner.containsKey(destID)) {
            SAMLUtils.debug.error("AssertionManager.createAssertionArtifact:(String, String): destID not in partner list.");
            throw new SAMLException(SAMLUtils.bundle.getString("destIDNotFound"));
        }
        String handle = SAMLUtils.generateAssertionHandle();
        if (handle == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.createAssertionArtifact: couldn't generate assertion handle.");
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
        }
        String sourceID = (String)SAMLServiceManager.getAttribute("mysiteid");
        AssertionArtifact art = new AssertionArtifact(sourceID, handle);
        Assertion assertion = this.createSSOAssertion(id, art, destID, targetUrl, version);
        try {
            StringTokenizer st;
            if (version != null && (st = new StringTokenizer(version, ".")).countTokens() == 2) {
                assertion.setMajorVersion(Integer.parseInt(st.nextToken().trim()));
                assertion.setMinorVersion(Integer.parseInt(st.nextToken().trim()));
            }
        }
        catch (NumberFormatException ne) {
            throw new SAMLException(ne.getMessage());
        }
        return art;
    }

    public int isAllowed(AuthorizationDecisionQuery authZQuery, String destID) {
        if (authZQuery == null) {
            SAMLUtils.debug.error("AssertionManager.isAllowed: null input.");
            return 3;
        }
        Assertion assertion = null;
        try {
            assertion = this.getAuthorizationDecisionAssertion(authZQuery, destID, false);
        }
        catch (SAMLException e) {
            SAMLUtils.debug.error("AssertionManager.isAllowed: exception thrown when trying to get an assertion from authZQuery. ", (Throwable)((Object)e));
            return 3;
        }
        if (assertion == null) {
            return 3;
        }
        Set statements = assertion.getStatement();
        if (statements != null && !statements.isEmpty()) {
            Iterator iter = statements.iterator();
            while (iter.hasNext()) {
                Statement statement = (Statement)iter.next();
                if (statement.getStatementType() != 2) continue;
                return ((AuthorizationDecisionStatement)statement).getDecision();
            }
            SAMLUtils.debug.error("AssertionManager.isAllowed: no authZstatement in assertion.");
            return 3;
        }
        SAMLUtils.debug.error("AssertionManager.isAllowed: no statements in assertion.");
        return 3;
    }

    boolean validateNumberOfAssertions(Map idEntryMap) throws SAMLResponderException {
        Integer maxNumber = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-assertion-max-number");
        int maxValue = maxNumber;
        if (maxValue != 0 && idEntryMap.size() > maxValue) {
            SAMLUtils.debug.error("AssertionManager.createAssertionArtifact(assertion,String): reached maxNumber of assertions.");
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
        }
        return false;
    }

    static {
        superUser = null;
        sessionProvider = null;
        assStats = Stats.getInstance((String)"amAssertionMap");
        artStats = Stats.getInstance((String)"amArtifactMap");
        superUser = SystemConfigurationUtil.getProperty(SUPER_USER);
        try {
            sessionProvider = SessionManager.getProvider();
        }
        catch (SessionException se) {
            SAMLUtils.debug.error("Static: Couldn't get SessionProvider.", (Throwable)((Object)se));
            sessionProvider = null;
        }
        cleanUpInterval = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-cleanup-interval") * 1000;
        artifactTimeout = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-artifact-timeout") * 1000;
        assertionTimeout = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-assertion-timeout") * 1000;
        notBeforeSkew = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-notbefore-timeskew") * 1000;
        instance = null;
        artEntryMap = null;
        idEntryMap = null;
        assertionVersion = null;
        protocolVersion = null;
    }

    private class GoThroughRunnable
    extends GeneralTaskRunnable {
        private Set keys = new HashSet();
        private long runPeriod;

        public GoThroughRunnable(long runPeriod) {
            this.runPeriod = runPeriod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addElement(Object obj) {
            Set set = this.keys;
            synchronized (set) {
                return this.keys.add(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeElement(Object obj) {
            Set set = this.keys;
            synchronized (set) {
                return this.keys.remove(obj);
            }
        }

        public boolean isEmpty() {
            return false;
        }

        public long getRunPeriod() {
            return this.runPeriod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long currentTime = System.currentTimeMillis();
            SAMLUtils.debug.message("Clean up runnable wakes up..");
            Set set = this.keys;
            synchronized (set) {
                Iterator keyIter = this.keys.iterator();
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager::CleanUpThread::number of assertions in IdEntryMap:" + idEntryMap.size());
                }
                while (keyIter.hasNext()) {
                    Assertion assertion;
                    String keyString = (String)keyIter.next();
                    Entry entry = (Entry)idEntryMap.get(keyString);
                    if (entry == null || (assertion = entry.getAssertion()) == null) continue;
                    if (assertion.getConditions() != null) {
                        if (assertion.isTimeValid()) continue;
                        keyIter.remove();
                        AssertionManager.this.deleteAssertion(keyString, null);
                        continue;
                    }
                    Date issueInstant = assertion.getIssueInstant();
                    Date notBefore = new Date(issueInstant.getTime() - notBeforeSkew);
                    Date notOnOrAfter = new Date(issueInstant.getTime() + assertionTimeout);
                    if (currentTime >= notBefore.getTime() && currentTime < notOnOrAfter.getTime()) continue;
                    keyIter.remove();
                    AssertionManager.this.deleteAssertion(keyString, null);
                }
            }
        }
    }

    private class ArtEntry {
        private String aID = null;
        private long expiretime = 0L;

        public ArtEntry(String aID, long expiretime) {
            this.aID = aID;
            this.expiretime = expiretime;
        }

        public String getAssertionID() {
            return this.aID;
        }

        public long getExpireTime() {
            return this.expiretime;
        }
    }

    private class Entry {
        private String destID = null;
        private String artString = null;
        private Object token = null;
        private Assertion assertion = null;

        public Entry(Assertion assertion, String destID, String artString, Object token) {
            this.assertion = assertion;
            this.destID = destID;
            this.artString = artString;
            this.token = token;
        }

        public Assertion getAssertion() {
            return this.assertion;
        }

        public String getDestID() {
            return this.destID;
        }

        public void setDestID(String newDestID) {
            this.destID = newDestID;
        }

        public String getArtifactString() {
            return this.artString;
        }

        public void setArtifactString(String newArtifactString) {
            this.artString = newArtifactString;
        }

        public Object getSSOToken() {
            return this.token;
        }
    }
}

