/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.plugin.configuration.impl;

import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationListener;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.shared.debug.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXBException;

public class FedletConfigurationImpl
implements ConfigurationInstance {
    private static final String COT_NAME = "cot-name";
    private static final String EXTENDED_XML_SUFFIX = "-extended.xml";
    private static final String COT_FILE_SUFFIX = ".cot";
    private static String fedletHomeDir;
    private static final String FEDLET_HOME_DIR = "com.sun.identity.fedlet.home";
    private String componentName = null;
    private static final String RESOURCE_BUNDLE = "fmConfigurationService";
    static Debug debug;
    private static Map cotMap;
    private static Map entityMap;

    public void init(String componentName, Object session) throws ConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("FedletConfigurationImpl.init: component=" + componentName);
        }
        this.componentName = componentName;
        fedletHomeDir = System.getProperty(FEDLET_HOME_DIR);
        if (fedletHomeDir == null || fedletHomeDir.trim().length() == 0) {
            fedletHomeDir = System.getProperty("user.home") + File.separator + "fedlet";
        }
        if (debug.messageEnabled()) {
            debug.message("FedletConfigurationImpl.init: fedlet home=" + fedletHomeDir);
        }
        this.initializeMetadataAndCOT();
        if (debug.messageEnabled()) {
            debug.message("FedletConfImpl entityMap: =" + entityMap.keySet());
            debug.message("FedletConfImpl cotMap: =" + cotMap.keySet());
        }
    }

    public Map getConfiguration(String realm, String configName) throws ConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("FedletConfigurationImpl.getConfiguration: componentName = " + this.componentName + ", realm = " + realm + ", configName = " + configName);
        }
        if ("SAML2".equals(this.componentName)) {
            return (Map)entityMap.get(configName);
        }
        if ("LIBCOT".equals(this.componentName)) {
            return (Map)cotMap.get(configName);
        }
        return null;
    }

    private void initializeMetadataAndCOT() {
        try {
            File homeDir = new File(fedletHomeDir);
            String[] files = homeDir.list();
            if (files == null || files.length == 0) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i];
                if (debug.messageEnabled()) {
                    debug.message("FedletConfigImpl.initMetaCOT: " + fileName);
                }
                if (fileName.endsWith(EXTENDED_XML_SUFFIX)) {
                    this.handleSAML2Metadata(fileName.substring(0, fileName.length() - EXTENDED_XML_SUFFIX.length()));
                    continue;
                }
                if (!fileName.endsWith(COT_FILE_SUFFIX)) continue;
                this.handleCOT(fileName.substring(0, fileName.length() - COT_FILE_SUFFIX.length()));
            }
        }
        catch (NullPointerException npe) {
            debug.error("FedletConfigurationImpl.processSAML2Metadata()", (Throwable)npe);
        }
        catch (SecurityException se) {
            debug.error("FedletConfigurationImpl.processSAML2Metadata()", (Throwable)se);
        }
    }

    private void handleSAML2Metadata(String fileName) {
        String metaXML;
        String metaFile = fedletHomeDir + File.separator + fileName + ".xml";
        if (debug.messageEnabled()) {
            debug.message("FedletConfigurationImpl.handleSAML2Metadata: metaFile=" + metaFile);
        }
        if ((metaXML = this.openFile(metaFile)) == null) {
            return;
        }
        String entityId = this.getEntityID(metaXML);
        if (entityId == null) {
            return;
        }
        HashMap map = new HashMap();
        HashSet<String> set = new HashSet<String>();
        set.add(metaXML);
        map.put("sun-fm-saml2-metadata", set);
        String extFile = fedletHomeDir + File.separator + fileName + EXTENDED_XML_SUFFIX;
        String extXML = this.openFile(extFile);
        if (extXML == null) {
            return;
        }
        set = new HashSet();
        set.add(extXML);
        map.put("sun-fm-saml2-entityconfig", set);
        entityMap.put(entityId, map);
        if (debug.messageEnabled()) {
            debug.message("FedletConfigurationImpl.handleSAML2Metadata: done processing entity " + entityId);
        }
    }

    private String getEntityID(String metaXML) {
        try {
            Object obj = SAML2MetaUtils.convertStringToJAXB(metaXML);
            if (obj instanceof EntityDescriptorElement) {
                return ((EntityDescriptorElement)obj).getEntityID();
            }
        }
        catch (JAXBException jaxbe) {
            debug.error("FedletConfigImpl.getEntityID: " + metaXML, (Throwable)jaxbe);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCOT(String fileName) {
        String cotFile = fedletHomeDir + File.separator + fileName + COT_FILE_SUFFIX;
        if (debug.messageEnabled()) {
            debug.message("FedletConfigurationImpl.handleCOT: cotFile=" + cotFile);
        }
        FileInputStream fis = null;
        try {
            Set cotName;
            fis = new FileInputStream(cotFile);
            Properties props = new Properties();
            props.load(fis);
            HashMap<String, Set> attrMap = new HashMap<String, Set>();
            if (props != null) {
                Enumeration<?> keys = props.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String vals = props.getProperty(key);
                    if (vals == null || vals.length() <= 0) continue;
                    attrMap.put(key, this.toValSet(key, vals));
                }
            }
            if ((cotName = (Set)attrMap.get(COT_NAME)) == null) {
                debug.error("FedletConfigImpl.handleCOT: null COT name in " + cotFile);
            } else {
                cotMap.put((String)cotName.iterator().next(), attrMap);
                if (debug.messageEnabled()) {
                    debug.message("FedletConfigurationImpl.handleCOT: done processing cot " + cotName);
                }
            }
        }
        catch (FileNotFoundException fnf) {
            debug.error("FedletConfigurationImpl.handleCOT: " + cotFile + " for component " + this.componentName, (Throwable)fnf);
        }
        catch (IOException ioe) {
            debug.error("FedletConfigurationImpl.getConfiguration:" + cotFile + " for component " + this.componentName, (Throwable)ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected Set toValSet(String attrName, String vals) {
        int j;
        HashSet<String> valset = new HashSet<String>();
        char[] valchars = vals.toCharArray();
        int i = 0;
        for (j = 0; j < valchars.length; ++j) {
            char c = valchars[j];
            if (c != ',') continue;
            if (i == j) {
                i = j + 1;
                continue;
            }
            String val = new String(valchars, i, j - i).trim();
            if (val.length() > 0) {
                val = this.decodeVal(val);
            }
            valset.add(val);
            i = j + 1;
        }
        if (j == valchars.length && i < j) {
            String val = new String(valchars, i, j - i).trim();
            if (val.length() > 0) {
                val = this.decodeVal(val);
            }
            valset.add(val);
        }
        return valset;
    }

    protected String decodeVal(String v) {
        char[] chars = v.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length);
        int i = 0;
        int lastIdx = 0;
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] != '%' || i + 2 >= chars.length || chars[i + 1] != '2') continue;
            if (lastIdx != i) {
                sb.append(chars, lastIdx, i - lastIdx);
            }
            if (chars[i + 2] == 'C') {
                sb.append(',');
            } else if (chars[i + 2] == '5') {
                sb.append('%');
            } else {
                sb.append(chars, i, 3);
            }
            lastIdx = (i += 2) + 1;
        }
        if (lastIdx != i) {
            sb.append(chars, lastIdx, i - lastIdx);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String openFile(String file) {
        BufferedReader br = null;
        try {
            String temp;
            br = new BufferedReader(new FileReader(file));
            StringBuffer sb = new StringBuffer(5000);
            while ((temp = br.readLine()) != null) {
                sb.append(temp);
            }
            String string = sb.toString();
            return string;
        }
        catch (FileNotFoundException fnf) {
            debug.error("FedletConfigurationImpl.getConfiguration: " + file + " for component " + this.componentName, (Throwable)fnf);
            String string = null;
            return string;
        }
        catch (IOException ioe) {
            debug.error("FedletConfigurationImpl.getConfiguration:" + file + " for component " + this.componentName, (Throwable)ioe);
            String string = null;
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void setConfiguration(String realm, String configName, Map avPairs) throws ConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("FedletConfigurationImpl.setConfiguration: componentName = " + this.componentName + ", realm = " + realm + ", configName = " + configName + ", avPairs = " + avPairs);
        }
        Object[] data = new String[]{this.componentName, realm};
        throw new ConfigurationException(RESOURCE_BUNDLE, "failedSetConfig", data);
    }

    public void createConfiguration(String realm, String configName, Map avPairs) throws ConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("FedletConfigurationImpl.createConfiguration: componentName = " + this.componentName + ", realm = " + realm + ", configName = " + configName + ", avPairs = " + avPairs);
        }
        Object[] data = new String[]{this.componentName, realm};
        throw new ConfigurationException(RESOURCE_BUNDLE, "failedCreateConfig", data);
    }

    public void deleteConfiguration(String realm, String configName, Set attributes) throws ConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("FedletConfigurationImpl.deleteConfiguration: componentName = " + this.componentName + ", realm = " + realm + ", configName = " + configName + ", attributes = " + attributes);
        }
        Object[] data = new String[]{this.componentName, realm};
        throw new ConfigurationException(RESOURCE_BUNDLE, "failedDeleteConfig", data);
    }

    public Set getAllConfigurationNames(String realm) throws ConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("FedletConfigurationImpl.getAllConfigurationNames: realm = " + realm + ", componentName = " + this.componentName);
        }
        if ("SAML2".equals(this.componentName)) {
            return entityMap.keySet();
        }
        if ("LIBCOT".equals(this.componentName)) {
            return cotMap.keySet();
        }
        return Collections.EMPTY_SET;
    }

    public String addListener(ConfigurationListener listener) throws ConfigurationException {
        return "NO_OP";
    }

    public void removeListener(String listenerID) throws ConfigurationException {
    }

    static {
        debug = Debug.getInstance((String)"fedletConfiguration");
        cotMap = new HashMap();
        entityMap = new HashMap();
    }
}

