/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.multiprotocol;

import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.multiprotocol.MultiProtocolUtils;
import com.sun.identity.multiprotocol.SingleLogoutHandler;
import com.sun.identity.multiprotocol.SingleLogoutManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import java.net.URLEncoder;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WSFederationSingleLogoutHandler
implements SingleLogoutHandler {
    private Debug debug = null;

    public WSFederationSingleLogoutHandler() {
        SingleLogoutManager.getInstance();
        this.debug = SingleLogoutManager.debug;
    }

    public int doIDPSingleLogout(Set userSession, String userID, HttpServletRequest request, HttpServletResponse response, boolean isSOAPInitiated, boolean isIDPInitiated, String protocol, String realm, String idpEntityID, String spEntityID, String relayState, String singleLogoutRequestXML, String singleLogoutResponseXML, int currentStatus) throws Exception {
        SingleLogoutManager.getInstance();
        SingleLogoutManager.debug.message("WSFederationSingleLogoutHandler.doIDPSingleLogout : start");
        if (!this.isSessionUsedInWSFed(userSession, userID)) {
            this.debug.message("WSFedSingleLogoutHandler.doIDPSLO : no action");
            return 4;
        }
        if (isSOAPInitiated) {
            this.debug.message("WSFedSLOHandler.doIDPSLO : SOAP initiated SLO");
            return 2;
        }
        this.debug.message("WSFedSLOHandler.doIDPSLO : HTTP initiated SLO");
        String metaAlias = this.findIDPMetaAlias(idpEntityID, spEntityID, realm, protocol);
        String redirectURL = MultiProtocolUtils.geServerBaseURL(request) + "/WSFederationServlet/metaAlias" + metaAlias + "?" + "wa" + "=" + "wsignout1.0" + "&" + "wreply" + "=" + URLEncoder.encode(relayState, "UTF-8");
        if (this.debug.messageEnabled()) {
            this.debug.message("WSFedSLOHandler.doIDPSLO: HTTPinit, redirect to " + redirectURL);
        }
        response.sendRedirect(redirectURL);
        return 3;
    }

    private String findIDPMetaAlias(String idpEntityID, String spEntityID, String realm, String protocol) {
        try {
            List<String> hostedIdps = WSFederationMetaManager.getAllHostedIdentityProviderEntities(realm);
            if (this.debug.messageEnabled()) {
                this.debug.message("WSFedSingleLogoutHandler.findIDPMetaAlias:  all hosted WS-Fed IDPs = " + hostedIdps);
            }
            if (hostedIdps == null || hostedIdps.isEmpty()) {
                return null;
            }
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            Set cots = cotManager.getAllActiveCirclesOfTrust(realm);
            int num = hostedIdps.size();
            for (int i = 0; i < num; ++i) {
                String idpId = hostedIdps.get(i);
                for (String cotName : cots) {
                    Set providers;
                    if (this.debug.messageEnabled()) {
                        this.debug.message("WSFedSLOHandler.findIDPMetaAlias:  check COT = " + cotName);
                    }
                    if ((providers = cotManager.listCircleOfTrustMember(realm, cotName, "wsfed")) == null || !providers.contains(idpId) || (providers = cotManager.listCircleOfTrustMember(realm, cotName, protocol)) == null || !providers.contains(idpEntityID) || spEntityID != null && spEntityID.length() != 0 && !providers.contains(spEntityID)) continue;
                    if (SingleLogoutManager.debug.messageEnabled()) {
                        SingleLogoutManager.debug.message("WSFedSingleLogoutHandler.findIDPMetaAlias : found IDP " + idpId + " in COT " + cotName);
                    }
                    IDPSSOConfigElement config = WSFederationMetaManager.getIDPSSOConfig(realm, idpId);
                    return config.getMetaAlias();
                }
            }
        }
        catch (Exception e) {
            SingleLogoutManager.debug.error("WSFederationSingleLogoutHandler.findIDPMetaAlias", (Throwable)e);
        }
        return null;
    }

    private boolean isSessionUsedInWSFed(Set userSession, String userId) {
        if (userSession == null || userSession.isEmpty()) {
            return false;
        }
        Object session = userSession.iterator().next();
        return MultiProtocolUtils.usedInProtocol(session, "wsfed");
    }
}

