/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.multiprotocol;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.message.FSLogoutResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.multiprotocol.MultiProtocolUtils;
import com.sun.identity.multiprotocol.SingleLogoutHandler;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.profile.LogoutUtil;
import com.sun.identity.saml2.protocol.LogoutResponse;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Element;

public class SingleLogoutManager {
    public static final int LOGOUT_SUCCEEDED_STATUS = 0;
    public static final int LOGOUT_PARTIAL_STATUS = 1;
    public static final int LOGOUT_FAILED_STATUS = 2;
    public static final int LOGOUT_REDIRECTED_STATUS = 3;
    public static final int LOGOUT_NO_ACTION_STATUS = 4;
    public static final String SAML2 = "saml2";
    public static final String IDFF = "idff";
    public static final String WS_FED = "wsfed";
    private static final String KEY_PARAM = "key";
    private static final String CLASS_PARAM = "class";
    static final String FEDERATION_PROTOCOLS = "federationprotocols";
    static final String RELAY_SERVLET = "multiprotocolrelay";
    private static final String RELAY_SERVLET_URI = "/multiprotocolrelay/";
    public static final String STATUS_PARAM = "logoutStatus";
    private static String MULTI_PROTOCOL_CONFIG_NAME = "MULTI_PROTOCOL";
    private static String EMPTY_STRING = "";
    private static String DELIMITOR = "|";
    private static String LOCAL_HOST_URL = "http://localhost/idp";
    private static Map handlerMap = new HashMap();
    private static Map relayStateMap = new HashMap();
    private static Map userSessionMap = new HashMap();
    private static Map userIDMap = new HashMap();
    private static Map isSOAPInitiatedMap = new HashMap();
    private static Map isIDPInitiatedMap = new HashMap();
    private static Map origProtocolMap = new HashMap();
    private static Map protocolListMap = new HashMap();
    private static Map realmMap = new HashMap();
    private static Map idpEntityIDMap = new HashMap();
    private static Map spEntityIDMap = new HashMap();
    private static Map sloRequestXMLMap = new HashMap();
    private static Map sloResponseXMLMap = new HashMap();
    private static Map currentStatusMap = new HashMap();
    private static List protocolList = new ArrayList();
    static Debug debug = Debug.getInstance((String)"libMultipleProtocol");
    private static SingleLogoutManager manager = new SingleLogoutManager();

    private SingleLogoutManager() {
        try {
            ConfigurationInstance configInst = ConfigurationManager.getConfigurationInstance(MULTI_PROTOCOL_CONFIG_NAME);
            Map attrs = configInst.getConfiguration(null, null);
            Set handlers = (Set)attrs.get("SingleLogoutHandlerList");
            if (debug.messageEnabled()) {
                debug.message("SingleLogoutManager.constructor: handlers set=" + handlers);
            }
            if (handlers != null && !handlers.isEmpty()) {
                Iterator it = handlers.iterator();
                while (it.hasNext()) {
                    String tmp = (String)it.next();
                    StringTokenizer tokens = new StringTokenizer(tmp, DELIMITOR);
                    if (tokens.countTokens() != 2) {
                        debug.error("SingleLogoutManager.constructor: wrong handler value " + tmp);
                        continue;
                    }
                    String[] params = new String[]{tokens.nextToken(), tokens.nextToken()};
                    String key = null;
                    String className = null;
                    for (int i = 0; i < 2; ++i) {
                        int loc = params[i].indexOf("=");
                        if (i == -1) {
                            debug.error("SingleLogoutManager.constructor: missing = in parameter " + params[i]);
                            break;
                        }
                        String first = params[i].substring(0, loc);
                        if (first.equalsIgnoreCase(KEY_PARAM)) {
                            key = params[i].substring(loc + 1);
                            continue;
                        }
                        if (first.equalsIgnoreCase(CLASS_PARAM)) {
                            className = params[i].substring(loc + 1);
                            continue;
                        }
                        debug.error("SingleLogoutManager.constructor: wrong key in parameter " + params[i]);
                        break;
                    }
                    if (key == null || key.length() == 0 || className == null || className.length() == 0) {
                        debug.error("SingleLogoutManager.constructor: invalid value " + params[0] + "|" + params[1]);
                        continue;
                    }
                    try {
                        if (key.equalsIgnoreCase(SAML2)) {
                            key = SAML2;
                        } else if (key.equalsIgnoreCase(IDFF)) {
                            key = IDFF;
                        } else if (key.equalsIgnoreCase(WS_FED)) {
                            key = WS_FED;
                        } else {
                            debug.error("SingleLogoutManager.constructor: invalid protocol " + key);
                            continue;
                        }
                        SingleLogoutHandler handler = (SingleLogoutHandler)Class.forName(className).newInstance();
                        protocolList.add(key);
                        handlerMap.put(key, handler);
                    }
                    catch (ClassNotFoundException c) {
                        debug.error("SingleLogoutManager.constructor: class not found " + className, (Throwable)c);
                    }
                    catch (InstantiationException i) {
                        debug.error("SingleLogoutManager.constructor: instantiation exception " + className, (Throwable)i);
                    }
                    catch (IllegalAccessException i) {
                        debug.error("SingleLogoutManager.constructor: illegal access exception " + className, (Throwable)i);
                    }
                }
            }
            if (debug.messageEnabled()) {
                debug.message("SingleLogoutManager.constructor: handlers map=" + handlerMap);
            }
        }
        catch (ConfigurationException e) {
            debug.error("Unable to initiate Single Loogut Manager", (Throwable)((Object)e));
        }
    }

    public static SingleLogoutManager getInstance() {
        return manager;
    }

    boolean containKey(String handler) {
        if (handler == null || handler.length() == 0) {
            return false;
        }
        return relayStateMap.containsKey(handler);
    }

    public int doIDPSingleLogout(Set userSession, String userID, HttpServletRequest request, HttpServletResponse response, boolean isSOAPInitiated, boolean isIDPInitiated, String protocol, String realm, String idpEntityID, String spEntityID, String relayState, String singleLogoutRequestXML, String singleLogoutResponseXML, int currentStatus) throws Exception {
        List list;
        if (relayState == null) {
            relayState = EMPTY_STRING;
        }
        if (protocolList.isEmpty()) {
            debug.message("SingleLogoutManager.doIDPSingleLogour : no handler");
            return 4;
        }
        String tmpRelayState = relayState;
        if (!relayStateMap.containsKey(relayState) && (tmpRelayState = this.getShortRelayState(relayState)) != null && !relayStateMap.containsKey(tmpRelayState)) {
            tmpRelayState = null;
        }
        if (debug.messageEnabled()) {
            debug.message("SingleLogoutManager.doIDPSLO: userID=" + userID + ", protocol=" + protocol + ", relay=" + relayState + ", hex relay=" + tmpRelayState);
        }
        if (tmpRelayState == null) {
            tmpRelayState = this.saveParameters(userSession, userID, isSOAPInitiated, isIDPInitiated, protocol, realm, idpEntityID, spEntityID, relayState, singleLogoutRequestXML, singleLogoutResponseXML, currentStatus);
            relayState = this.getRelayStateURL(request, tmpRelayState);
            if (debug.messageEnabled()) {
                debug.message("SingleLogoutManager.doIDPSingleLogout : save " + tmpRelayState + ", new relayState=" + relayState);
            }
        } else {
            this.updateStatus(tmpRelayState, currentStatus);
            if (tmpRelayState.equals(relayState)) {
                relayState = this.getRelayStateURL(request, tmpRelayState);
            }
            if (debug.messageEnabled()) {
                debug.message("SingleLogoutManager.doIDPSingleLogout : read " + tmpRelayState + ", nu relayState=" + relayState);
            }
        }
        if ((list = (List)protocolListMap.get(tmpRelayState)) == null || list.isEmpty()) {
            return (Integer)currentStatusMap.get(tmpRelayState);
        }
        while (!list.isEmpty()) {
            String proto = (String)list.remove(0);
            SingleLogoutHandler handler = (SingleLogoutHandler)handlerMap.get(proto);
            if (handler == null) {
                debug.error("SingleLogoutManager.doIDPSingleLogout: no handler for protocol " + proto);
                continue;
            }
            if (debug.messageEnabled()) {
                debug.message("SingleLogoutManager.doIDPSingleLogout:  handle protocol " + proto);
            }
            userSession = (Set)userSessionMap.get(tmpRelayState);
            userID = (String)userIDMap.get(tmpRelayState);
            isSOAPInitiated = (Boolean)isSOAPInitiatedMap.get(tmpRelayState);
            isIDPInitiated = (Boolean)isIDPInitiatedMap.get(tmpRelayState);
            protocol = (String)origProtocolMap.get(tmpRelayState);
            realm = (String)realmMap.get(tmpRelayState);
            idpEntityID = (String)idpEntityIDMap.get(tmpRelayState);
            spEntityID = (String)spEntityIDMap.get(tmpRelayState);
            singleLogoutRequestXML = (String)sloRequestXMLMap.get(tmpRelayState);
            currentStatus = (Integer)currentStatusMap.get(tmpRelayState);
            int status = 0;
            try {
                status = handler.doIDPSingleLogout(userSession, userID, request, response, isSOAPInitiated, isIDPInitiated, protocol, realm, idpEntityID, spEntityID, relayState, singleLogoutRequestXML, singleLogoutResponseXML, currentStatus);
                if (debug.messageEnabled()) {
                    debug.message("SingleLogoutManager.doIDPSingleLogout:  logout status = " + status + " for " + proto);
                }
            }
            catch (Exception ex) {
                debug.error("SingleLogoutManager.doIDPSingleLogout: error for protocol " + proto, (Throwable)ex);
                status = 2;
            }
            if (status == 3) {
                return status;
            }
            this.updateStatus(tmpRelayState, status);
        }
        int retVal = (Integer)currentStatusMap.get(tmpRelayState);
        if (isSOAPInitiated) {
            this.cleanupParameters(tmpRelayState);
        }
        return retVal;
    }

    private String getShortRelayState(String relayState) {
        if (relayState.length() == 0) {
            return null;
        }
        int loc = relayState.indexOf(RELAY_SERVLET_URI);
        if (loc == -1) {
            return null;
        }
        return relayState.substring(loc + RELAY_SERVLET_URI.length());
    }

    private String saveParameters(Set userSession, String userID, boolean isSOAPInitiated, boolean isIDPInitiated, String protocol, String realm, String idpEntityID, String spEntityID, String relayState, String singleLogoutRequestXML, String singleLogoutResponseXML, int currentStatus) {
        String tmpRelayState = SAML2Utils.generateIDWithServerID();
        relayStateMap.put(tmpRelayState, relayState);
        if (debug.messageEnabled()) {
            debug.message("SingleLogoutManager.saveParameters: userID=" + userID + ", session=" + userSession + ", orig relayState=" + relayState + ", new=" + tmpRelayState + ", isSOAInitiated=" + isSOAPInitiated + ", isIDPInitiated=" + isIDPInitiated + ", protocol=" + protocol + ", relam=" + realm + ", idpEntityID=" + idpEntityID + ", spEntityID=" + spEntityID + ", status=" + currentStatus + "\nlogout Request XML=" + singleLogoutRequestXML + "\nlogout response XML=" + singleLogoutResponseXML);
        }
        if (userSession != null) {
            userSessionMap.put(tmpRelayState, userSession);
        }
        if (userID != null) {
            userIDMap.put(tmpRelayState, userID);
        }
        if (isSOAPInitiated) {
            isSOAPInitiatedMap.put(tmpRelayState, Boolean.TRUE);
        } else {
            isSOAPInitiatedMap.put(tmpRelayState, Boolean.FALSE);
        }
        if (isIDPInitiated) {
            isIDPInitiatedMap.put(tmpRelayState, Boolean.TRUE);
        } else {
            isIDPInitiatedMap.put(tmpRelayState, Boolean.FALSE);
        }
        if (protocol != null) {
            origProtocolMap.put(tmpRelayState, protocol);
            int listSize = protocolList.size();
            ArrayList<String> list = new ArrayList<String>(listSize - 1);
            for (int i = 0; i < listSize; ++i) {
                String proto = (String)protocolList.get(i);
                if (proto.equals(protocol)) continue;
                list.add(proto);
            }
            protocolListMap.put(tmpRelayState, list);
        }
        if (realm != null) {
            realmMap.put(tmpRelayState, realm);
        }
        if (idpEntityID != null) {
            idpEntityIDMap.put(tmpRelayState, idpEntityID);
        }
        if (spEntityID != null) {
            spEntityIDMap.put(tmpRelayState, spEntityID);
        }
        if (singleLogoutRequestXML != null) {
            sloRequestXMLMap.put(tmpRelayState, singleLogoutRequestXML);
        }
        if (singleLogoutResponseXML != null) {
            sloResponseXMLMap.put(tmpRelayState, singleLogoutResponseXML);
        }
        currentStatusMap.put(tmpRelayState, new Integer(currentStatus));
        return tmpRelayState;
    }

    boolean containRelayState(String relayState) {
        return relayStateMap.containsKey(relayState);
    }

    void cleanupParameters(String relayState) {
        if (debug.messageEnabled()) {
            debug.message("SingleLogoutManager.cleanupParameters: new relayState=" + relayState);
        }
        relayStateMap.remove(relayState);
        userSessionMap.remove(relayState);
        userIDMap.remove(relayState);
        isSOAPInitiatedMap.remove(relayState);
        isSOAPInitiatedMap.remove(relayState);
        isIDPInitiatedMap.remove(relayState);
        origProtocolMap.remove(relayState);
        protocolListMap.remove(relayState);
        realmMap.remove(relayState);
        idpEntityIDMap.remove(relayState);
        spEntityIDMap.remove(relayState);
        sloRequestXMLMap.remove(relayState);
        sloResponseXMLMap.remove(relayState);
        currentStatusMap.remove(relayState);
    }

    void sendLogoutResponse(HttpServletRequest request, HttpServletResponse response, String relayState) throws IOException {
        String logoutResponseXML;
        if (debug.messageEnabled()) {
            debug.message("SingleLogoutManager.sendLogoutResponse: relaystate=" + relayState);
        }
        if ((logoutResponseXML = (String)sloResponseXMLMap.get(relayState)) == null) {
            String origRelayState = (String)relayStateMap.get(relayState);
            int logoutStatus = (Integer)currentStatusMap.get(relayState);
            String statusString = MultiProtocolUtils.getLogoutStatus(logoutStatus);
            if (origRelayState == null || origRelayState.length() == 0) {
                response.getWriter().print("Logout DONE. Status = " + statusString);
            } else if (origRelayState.indexOf("?") == -1) {
                response.sendRedirect(origRelayState + "?" + STATUS_PARAM + "=" + statusString);
            } else {
                response.sendRedirect(origRelayState + "&" + STATUS_PARAM + "=" + statusString);
            }
        } else {
            String protocol = (String)origProtocolMap.get(relayState);
            String spEntityID = (String)spEntityIDMap.get(relayState);
            String origRelayState = (String)relayStateMap.get(relayState);
            String realm = (String)realmMap.get(relayState);
            String idpEntityID = (String)idpEntityIDMap.get(relayState);
            int currentStatus = (Integer)currentStatusMap.get(relayState);
            if (protocol.equals(SAML2)) {
                try {
                    LogoutResponse logResp = ProtocolFactory.getInstance().createLogoutResponse(logoutResponseXML);
                    String location = logResp.getDestination();
                    String statusVal = logResp.getStatus().getStatusCode().getValue();
                    String newVal = this.getNewStatusCode(currentStatus, statusVal);
                    if (!statusVal.equals(newVal)) {
                        logResp.getStatus().getStatusCode().setValue(statusVal);
                    }
                    if (debug.messageEnabled()) {
                        debug.message("SingleLogoutManager.sendLogoutRes:(SAML2) location=" + location + " orig status=" + statusVal + ", new status=" + newVal + ", orig relay=" + origRelayState + ", realm=" + realm + ", idpEntityID=" + idpEntityID + ", spEntityID=" + spEntityID);
                    }
                    LogoutUtil.sendSLOResponse(response, logResp, location, origRelayState, realm, idpEntityID, "IDPRole", spEntityID);
                }
                catch (SAML2Exception ex) {
                    debug.error("SingleLogoutManager.sendLogoutResponse:saml2", (Throwable)((Object)ex));
                    throw new IOException(ex.getMessage());
                }
            }
            if (protocol.equals(IDFF)) {
                boolean failed = false;
                String logoutDoneURL = null;
                try {
                    debug.message("SingleLogoutManager.sendLogoutResp: IDFF");
                    IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
                    SPDescriptorType descriptor = metaManager.getSPDescriptor(realm, spEntityID);
                    String retURL = descriptor.getSingleLogoutServiceReturnURL();
                    Element elem = XMLUtils.toDOMDocument((String)logoutResponseXML, (Debug)debug).getDocumentElement();
                    FSLogoutResponse responseLogout = new FSLogoutResponse(elem);
                    IDPDescriptorConfigElement hostedConfig = metaManager.getIDPDescriptorConfig(realm, idpEntityID);
                    logoutDoneURL = FSServiceUtils.getLogoutDonePageURL(request, hostedConfig, null);
                    Status status = responseLogout.getStatus();
                    String statusVal = status.getStatusCode().getValue();
                    String newVal = this.getNewStatusCode(currentStatus, statusVal);
                    if (!statusVal.equals(newVal)) {
                        StatusCode statCode = new StatusCode(newVal);
                        Status stat = new Status(statCode);
                        responseLogout.setStatus(stat);
                    }
                    if (debug.messageEnabled()) {
                        debug.message("SingleLogoutManager.sendLogoutRes:(IDFF) orig status=" + statusVal + ", new status=" + newVal + ", orig relay=" + origRelayState + ", logout done URL=" + logoutDoneURL + ", realm=" + realm + ", idpEntityID=" + idpEntityID + ", spEntityID=" + spEntityID);
                    }
                    String urlEncodedResponse = responseLogout.toURLEncodedQueryString();
                    if (FSServiceUtils.isSigningOn()) {
                        String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "signingCertAlias");
                        if (certAlias == null || certAlias.length() == 0) {
                            if (debug.messageEnabled()) {
                                debug.message("SingleLogoutManager.sendLogoutRes:signSAMLRequest couldn't obtain cert alias.");
                            }
                            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                        }
                        urlEncodedResponse = FSSignatureUtil.signAndReturnQueryString(urlEncodedResponse, certAlias);
                    }
                    StringBuffer redirectURL = new StringBuffer();
                    redirectURL.append(retURL);
                    if (retURL.indexOf(63) == -1) {
                        redirectURL.append('?');
                    } else {
                        redirectURL.append('&');
                    }
                    redirectURL.append(urlEncodedResponse);
                    if (debug.messageEnabled()) {
                        debug.message("SingleLogoutManager.sendResponse for IDFF, url = " + redirectURL.toString());
                    }
                    response.sendRedirect(redirectURL.toString());
                }
                catch (FSMsgException ex) {
                    debug.error("SingleLogoutManager.sendLogoutRes", (Throwable)((Object)ex));
                    failed = true;
                }
                catch (SAMLException ex) {
                    debug.error("SingleLogoutManager.sendLogoutRes", (Throwable)((Object)ex));
                    failed = true;
                }
                catch (IDFFMetaException ex) {
                    debug.error("SingleLogoutManager.sendLogoutRes", (Throwable)((Object)ex));
                    failed = true;
                }
                catch (IOException ex) {
                    debug.error("SingleLogoutManager.sendLogoutRes", (Throwable)ex);
                    failed = true;
                }
                if (failed) {
                    FSServiceUtils.returnLocallyAfterOperation(response, logoutDoneURL, false, "logoutSuccess", "logoutFailure");
                }
            } else if (protocol.equals(WS_FED)) {
                debug.message("SingleLogoutManager.sendLogoutResponse: WSFED");
                if (origRelayState != null) {
                    response.sendRedirect(origRelayState);
                } else {
                    response.getWriter().print("Logout DONE.");
                }
            } else {
                debug.error("SingleLogoutManager.sendLogoutResponse: invalid protocol : " + protocol);
            }
        }
        this.cleanupParameters(relayState);
    }

    private void updateStatus(String relayState, int currentStatus) {
        Integer tmp = (Integer)currentStatusMap.get(relayState);
        if (tmp != null) {
            int previousStatus = tmp;
            switch (previousStatus) {
                case 0: {
                    if (currentStatus <= previousStatus) break;
                    currentStatusMap.put(relayState, new Integer(currentStatus));
                    break;
                }
                case 2: {
                    if (currentStatus >= 2) break;
                    currentStatusMap.put(relayState, new Integer(1));
                    break;
                }
            }
        } else {
            currentStatusMap.put(relayState, new Integer(currentStatus));
        }
    }

    private String getNewStatusCode(int currentStatus, String statusCode) {
        switch (currentStatus) {
            case 0: {
                return statusCode;
            }
            case 1: 
            case 2: {
                return "samlp:Responder";
            }
        }
        return statusCode;
    }

    private String getRelayStateURL(HttpServletRequest request, String handler) {
        if (request == null) {
            return LOCAL_HOST_URL + RELAY_SERVLET_URI + handler;
        }
        String baseURL = MultiProtocolUtils.geServerBaseURL(request);
        return baseURL + RELAY_SERVLET_URI + handler;
    }
}

