/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.soapbinding.Utils;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

public class WSX509KeyManager
implements X509KeyManager {
    private X509KeyManager defaultX509KM = null;
    private String certAlias = null;

    public WSX509KeyManager(X509KeyManager defaultX509KeyManager, String certAlias) {
        this.defaultX509KM = defaultX509KeyManager;
        this.certAlias = certAlias;
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (this.certAlias != null && this.certAlias.length() > 0) {
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("WSX509KeyManager.chooseClientAlias: certAlias = " + this.certAlias);
            }
            return this.certAlias;
        }
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("WSX509KeyManager.chooseClientAlias: using default implementation");
        }
        return this.defaultX509KM.chooseClientAlias(keyType, issuers, socket);
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.defaultX509KM.chooseServerAlias(keyType, issuers, socket);
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.defaultX509KM.getClientAliases(keyType, issuers);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.defaultX509KM.getServerAliases(keyType, issuers);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        return this.defaultX509KM.getCertificateChain(alias);
    }

    public PrivateKey getPrivateKey(String alias) {
        return this.defaultX509KM.getPrivateKey(alias);
    }
}

