/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProviderHeader {
    private String providerID = null;
    private String affiliationID = null;
    private String id = null;
    private Boolean mustUnderstand = null;
    private String actor = null;

    public ProviderHeader(String providerID) throws SOAPBindingException {
        if (providerID == null) {
            String msg = Utils.bundle.getString("missingProviderID");
            Utils.debug.error("ProviderHeader.setProviderID: " + msg);
            throw new SOAPBindingException(msg);
        }
        this.providerID = providerID;
        if (this.id == null) {
            this.id = SAMLUtils.generateID();
        }
        this.actor = "http://schemas.xmlsoap.org/soap/actor/next";
        this.mustUnderstand = Boolean.TRUE;
    }

    ProviderHeader(Element providerElement) throws SOAPBindingException {
        this.providerID = XMLUtils.getNodeAttributeValue((Node)providerElement, (String)"providerID");
        if (this.providerID == null) {
            String msg = Utils.bundle.getString("missingProviderID");
            Utils.debug.error("ProviderHeader.setProviderID: " + msg);
            throw new SOAPBindingException(msg);
        }
        this.affiliationID = XMLUtils.getNodeAttributeValue((Node)providerElement, (String)"affiliationID");
        this.id = XMLUtils.getNodeAttributeValue((Node)providerElement, (String)"id");
        String str = XMLUtils.getNodeAttributeValueNS((Node)providerElement, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand");
        if (str != null && str.length() > 0) {
            try {
                this.mustUnderstand = Utils.StringToBoolean(str);
            }
            catch (Exception pe) {
                String msg = Utils.bundle.getString("invalidMustUnderstand");
                Utils.debug.error("ProviderHeader: " + msg, (Throwable)pe);
                throw new SOAPBindingException(msg);
            }
        }
        this.actor = XMLUtils.getNodeAttributeValueNS((Node)providerElement, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor");
    }

    public String getProviderID() {
        return this.providerID;
    }

    public String getAffiliationID() {
        return this.affiliationID;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public void setProviderID(String providerID) {
        if (providerID != null) {
            this.providerID = providerID;
        }
    }

    public void setAffiliationID(String affiliationID) {
        this.affiliationID = affiliationID;
    }

    public void setMustUnderstand(Boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setSignFlag(boolean signFlag) {
        this.id = signFlag ? SAMLUtils.generateID() : null;
    }

    void addToParent(Element headerE) {
        Document doc = headerE.getOwnerDocument();
        Element providerHeaderE = doc.createElementNS("urn:liberty:sb:2003-08", "sb:Provider");
        headerE.appendChild(providerHeaderE);
        providerHeaderE.setAttributeNS(null, "providerID", this.providerID);
        if (this.affiliationID != null) {
            providerHeaderE.setAttributeNS(null, "affiliationID", this.affiliationID);
        }
        if (this.id != null) {
            providerHeaderE.setAttributeNS(null, "id", this.id);
        }
        if (this.mustUnderstand != null) {
            providerHeaderE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:mustUnderstand", Utils.BooleanToString(this.mustUnderstand));
        }
        if (this.actor != null) {
            providerHeaderE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:actor", this.actor);
        }
    }
}

