/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProcessingContextHeader {
    private String elementValue = null;
    private String id = null;
    private Boolean mustUnderstand = null;
    private String actor = null;

    public ProcessingContextHeader(String elementValue) throws SOAPBindingException {
        if (elementValue == null) {
            String msg = Utils.bundle.getString("missingPCvalue");
            Utils.debug.error("ProcessingContextHeader: " + msg);
            throw new SOAPBindingException(msg);
        }
        this.elementValue = elementValue;
    }

    ProcessingContextHeader(Element processingContextElement) throws SOAPBindingException {
        this.elementValue = XMLUtils.getElementValue((Element)processingContextElement);
        if (this.elementValue == null) {
            String msg = Utils.bundle.getString("missingPCvalue");
            Utils.debug.error("ProcessingContextHeader: " + msg);
            throw new SOAPBindingException(msg);
        }
        if (this.elementValue == null) {
            String msg = Utils.bundle.getString("missingPCvalue");
            Utils.debug.error("ProcessingContextHeader: " + msg);
            throw new SOAPBindingException(msg);
        }
        this.id = XMLUtils.getNodeAttributeValue((Node)processingContextElement, (String)"id");
        String str = XMLUtils.getNodeAttributeValueNS((Node)processingContextElement, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand");
        if (str != null && str.length() > 0) {
            try {
                this.mustUnderstand = Utils.StringToBoolean(str);
            }
            catch (Exception pe) {
                String msg = Utils.bundle.getString("invalidMustUnderstand");
                Utils.debug.error("ProcessingContextHeader: " + msg, (Throwable)pe);
                throw new SOAPBindingException(msg);
            }
        }
        this.actor = XMLUtils.getNodeAttributeValueNS((Node)processingContextElement, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor");
    }

    public String getElementValue() {
        return this.elementValue;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public void setElementValue(String elementValue) {
        if (elementValue != null) {
            this.elementValue = elementValue;
        }
    }

    public void setMustUnderstand(Boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setSignFlag(boolean signFlag) {
        this.id = signFlag ? SAMLUtils.generateID() : null;
    }

    void addToParent(Element headerE) {
        Document doc = headerE.getOwnerDocument();
        Element processingContextHeaderE = doc.createElementNS("urn:liberty:sb:2003-08", "sb:ProcessingContext");
        headerE.appendChild(processingContextHeaderE);
        processingContextHeaderE.appendChild(doc.createTextNode(this.elementValue));
        if (this.id != null) {
            processingContextHeaderE.setAttributeNS(null, "id", this.id);
        }
        if (this.mustUnderstand != null) {
            processingContextHeaderE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:mustUnderstand", Utils.BooleanToString(this.mustUnderstand));
        }
        if (this.actor != null) {
            processingContextHeaderE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:actor", this.actor);
        }
    }
}

