/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CorrelationHeader {
    private String messageID = null;
    private String id = null;
    private String refToMessageID = null;
    private Date timestamp = null;
    private Boolean mustUnderstand = null;
    private String actor = null;

    public CorrelationHeader() {
        this.id = this.messageID = SAMLUtils.generateID();
        this.timestamp = new Date();
        this.actor = "http://schemas.xmlsoap.org/soap/actor/next";
        this.mustUnderstand = Boolean.TRUE;
    }

    CorrelationHeader(Element correlationElement) throws SOAPBindingException {
        this.messageID = XMLUtils.getNodeAttributeValue((Node)correlationElement, (String)"messageID");
        if (this.messageID == null) {
            String msg = Utils.bundle.getString("missingMessageID");
            Utils.debug.error("CorrelationHeader: " + msg);
            throw new SOAPBindingException(msg);
        }
        this.id = XMLUtils.getNodeAttributeValue((Node)correlationElement, (String)"id");
        this.refToMessageID = XMLUtils.getNodeAttributeValue((Node)correlationElement, (String)"refToMessageID");
        String str = XMLUtils.getNodeAttributeValueNS((Node)correlationElement, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand");
        if (str != null && str.length() > 0) {
            try {
                this.mustUnderstand = Utils.StringToBoolean(str);
            }
            catch (Exception pe) {
                String msg = Utils.bundle.getString("invalidMustUnderstand");
                Utils.debug.error("CorrelationHeader: " + msg, (Throwable)pe);
                throw new SOAPBindingException(msg);
            }
        }
        if ((str = XMLUtils.getNodeAttributeValue((Node)correlationElement, (String)"timestamp")) == null || str.length() == 0) {
            String msg = Utils.bundle.getString("missingCorrelationTimestamp");
            Utils.debug.error("CorrelationHeader: " + msg);
            throw new SOAPBindingException(msg);
        }
        try {
            this.timestamp = DateUtils.stringToDate((String)str);
        }
        catch (ParseException pe) {
            String msg = Utils.bundle.getString("invalidTimestamp");
            Utils.debug.error("CorrelationHeader: " + msg, (Throwable)pe);
            throw new SOAPBindingException(msg);
        }
        this.actor = XMLUtils.getNodeAttributeValueNS((Node)correlationElement, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor");
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getRefToMessageID() {
        return this.refToMessageID;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getId() {
        return this.messageID;
    }

    public Boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public void setMustUnderstand(Boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setRefToMessageID(String refToMessageID) {
        this.refToMessageID = refToMessageID;
    }

    public void addToParent(Element headerE) {
        Document doc = headerE.getOwnerDocument();
        Element correlationHeaderE = doc.createElementNS("urn:liberty:sb:2003-08", "sb:Correlation");
        headerE.appendChild(correlationHeaderE);
        correlationHeaderE.setAttributeNS(null, "messageID", this.messageID);
        if (this.refToMessageID != null) {
            correlationHeaderE.setAttributeNS(null, "refToMessageID", this.refToMessageID);
        }
        correlationHeaderE.setAttributeNS(null, "timestamp", DateUtils.toUTCDateFormat((Date)this.timestamp));
        correlationHeaderE.setAttributeNS(null, "id", this.messageID);
        if (this.mustUnderstand != null) {
            correlationHeaderE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:mustUnderstand", Utils.BooleanToString(this.mustUnderstand));
        }
        if (this.actor != null) {
            correlationHeaderE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:actor", this.actor);
        }
    }
}

