/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenException;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.security.SecurityTokenManagerIF;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class SecurityTokenManagerImpl
implements SecurityTokenManagerIF {
    private SecurityTokenManager securityTokenManager;
    private static Object lock = new Object();
    protected static boolean isLocal;

    public void initialization(String sessionID) throws SecurityTokenException {
        try {
            Object session = SessionManager.getProvider().getSession(sessionID);
            this.securityTokenManager = new SecurityTokenManager(session);
        }
        catch (Exception e) {
            SecurityTokenManager.debug.error("SecurityTokenManagerImpl: Unable to get SecurityTokenManager", (Throwable)e);
            throw new SecurityTokenException(e.getMessage());
        }
    }

    public void setCertificate(String cert, boolean alias) throws SecurityTokenException {
        if (alias) {
            this.securityTokenManager.setCertAlias(cert);
        } else {
            this.securityTokenManager.setCertificate(this.getX509Certificate(cert));
        }
    }

    public void checkForLocal() {
        isLocal = true;
    }

    public String getX509CertificateToken() throws SecurityTokenException {
        return this.securityTokenManager.getX509CertificateToken().toString();
    }

    public String getSAMLAuthenticationToken(String senderIdentity) throws SecurityTokenException, SAMLException {
        NameIdentifier ni = new NameIdentifier(XMLUtils.toDOMDocument((String)senderIdentity, (Debug)SecurityTokenManager.debug).getDocumentElement());
        SecurityAssertion assertion = this.securityTokenManager.getSAMLAuthenticationToken(ni);
        return assertion.toString(true, true);
    }

    public String getSAMLAuthorizationToken(String senderIdentity, String invocatorSession, String resourceID, boolean encryptedID, boolean includeAuthN, boolean includeResourceAccessStatement, String recipientProviderID) throws SecurityTokenException, SAMLException {
        NameIdentifier ni = new NameIdentifier(XMLUtils.toDOMDocument((String)senderIdentity, (Debug)SecurityTokenManager.debug).getDocumentElement());
        SessionContext sc = new SessionContext(XMLUtils.toDOMDocument((String)invocatorSession, (Debug)SecurityTokenManager.debug).getDocumentElement());
        SecurityAssertion assertion = null;
        if (!encryptedID) {
            assertion = this.securityTokenManager.getSAMLAuthorizationToken(ni, sc, resourceID, includeAuthN, includeResourceAccessStatement, recipientProviderID);
        }
        return assertion.toString(true, true);
    }

    private X509Certificate getX509Certificate(String certString) {
        X509Certificate cert = null;
        try {
            StringBuffer xml = new StringBuffer(100);
            xml.append("-----BEGIN CERTIFICATE-----\n");
            xml.append(certString);
            xml.append("\n-----END CERTIFICATE-----");
            byte[] barr = null;
            barr = xml.toString().getBytes();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(barr);
            while (bais.available() > 0) {
                cert = (X509Certificate)cf.generateCertificate(bais);
            }
        }
        catch (Exception e) {
            SecurityTokenManager.debug.error("getX509Certificate Exception: ", (Throwable)e);
        }
        return cert;
    }
}

