/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.liberty.ws.security.ResourceAccessStatement;
import com.sun.identity.liberty.ws.security.SessionContextStatement;
import com.sun.identity.saml.assertion.Advice;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SecurityAssertion
extends Assertion {
    private String verifyingCertAlias = null;

    public SecurityAssertion(Element assertionElement) throws SAMLException {
        this.parseAssertionElement(assertionElement);
    }

    public SecurityAssertion(String assertionID, String issuer, Date issueInstant, Set statements) throws SAMLException {
        super(assertionID, issuer, issueInstant, statements);
    }

    public SecurityAssertion(String assertionID, String issuer, Date issueInstant, Conditions conditions, Set statements) throws SAMLException {
        super(assertionID, issuer, issueInstant, conditions, statements);
    }

    public SecurityAssertion(String assertionID, String issuer, Date issueInstant, Conditions conditions, Advice advice, Set statements) throws SAMLException {
        super(assertionID, issuer, issueInstant, conditions, advice, statements);
    }

    public void setVerifyingCertAlias(String certAlias) {
        this.verifyingCertAlias = certAlias;
    }

    public boolean isSignatureValid() {
        if (this.signed & !this.validationDone) {
            try {
                XMLSignatureManager manager = XMLSignatureManager.getInstance();
                this.valid = manager.verifyXMLSignature(this.xmlString, "AssertionID", this.verifyingCertAlias);
            }
            catch (Exception e) {
                if (SAMLUtils.debug.warningEnabled()) {
                    SAMLUtils.debug.warning("SecurityAssertion.isSignatureValid:  signature validation exception", (Throwable)e);
                }
                this.valid = false;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLUtils.checkSignatureValid: valid = " + this.valid);
            }
            this.validationDone = true;
        }
        return this.valid;
    }

    public boolean isBearer() {
        if (this._statements == null || this._statements.isEmpty()) {
            return false;
        }
        Iterator iter = this._statements.iterator();
        while (iter.hasNext()) {
            Set confirmationMethods;
            SubjectConfirmation sc;
            Subject subject;
            Object statement = iter.next();
            if (!(statement instanceof SubjectStatement) || (subject = ((SubjectStatement)statement).getSubject()) == null || (sc = subject.getSubjectConfirmation()) == null || (confirmationMethods = sc.getConfirmationMethod()) == null || confirmationMethods.isEmpty() || !confirmationMethods.contains("urn:oasis:names:tc:SAML:1.0:cm:bearer")) continue;
            return true;
        }
        return false;
    }

    public Subject getBearerSubject() {
        if (this._statements == null || this._statements.isEmpty()) {
            return null;
        }
        Iterator iter = this._statements.iterator();
        while (iter.hasNext()) {
            Set confirmationMethods;
            SubjectConfirmation sc;
            Subject subject;
            Object statement = iter.next();
            if (!(statement instanceof SubjectStatement) || (subject = ((SubjectStatement)statement).getSubject()) == null || (sc = subject.getSubjectConfirmation()) == null || (confirmationMethods = sc.getConfirmationMethod()) == null || confirmationMethods.isEmpty() || !confirmationMethods.contains("urn:oasis:names:tc:SAML:1.0:cm:bearer")) continue;
            return subject;
        }
        return null;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        if (this.signed && this.xmlString != null) {
            return this.xmlString;
        }
        StringBuffer xml = new StringBuffer(3000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        if (includeNS) {
            appendNS = "saml:";
        }
        String dateStr = null;
        if (this._issueInstant != null) {
            dateStr = DateUtils.toUTCDateFormat((Date)this._issueInstant);
        }
        xml.append("<").append(appendNS).append("Assertion").append(" ").append(NS).append(" ").append("MajorVersion").append("=\"").append(this._majorVersion).append("\"").append(" ").append("MinorVersion").append("=\"").append(this._minorVersion).append("\"").append(" ").append("AssertionID=\"").append(this._assertionID.getAssertionIDReference()).append("\"").append(" ").append("Issuer").append("=\"").append(this._issuer).append("\"").append(" ").append("IssueInstant").append("=\"").append(dateStr).append("\"").append(" ").append(">").append("\n");
        if (this._conditions != null) {
            xml.append(this._conditions.toString(includeNS, false));
        }
        if (this._advice != null) {
            xml.append(this._advice.toString(includeNS, false));
        }
        Iterator i = this.getStatement().iterator();
        while (i.hasNext()) {
            Statement st = (Statement)i.next();
            xml.append(st.toString(includeNS, declareNS));
        }
        if (this.signed && this.signatureString != null) {
            xml.append(this.signatureString);
        }
        String o = SAMLUtils.makeEndElementTagXML("Assertion", includeNS);
        xml.append(o);
        return xml.toString();
    }

    protected boolean processUnknownElement(Element element) throws SAMLException {
        String localName;
        if (super.processUnknownElement(element)) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SecurityAssertion.processUnknownElement: super returns true");
            }
            return true;
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SecurityAssertion.processUnknownElement: super returns false");
        }
        if ((localName = element.getLocalName()).equals("ResourceAccessStatement")) {
            this._statements.add(new ResourceAccessStatement(element));
            return true;
        }
        if (localName.equals("SessionContextStatement")) {
            this._statements.add(new SessionContextStatement(element));
            return true;
        }
        return false;
    }

    protected int getMinAssertionMinorVersion() {
        return SAMLConstants.ASSERTION_MINOR_VERSION;
    }

    protected int getMaxAssertionMinorVersion() {
        return SAMLConstants.ASSERTION_MINOR_VERSION;
    }

    public void addToParent(Element headerE) throws Exception {
        Document doc = headerE.getOwnerDocument();
        Element securityE = doc.createElementNS("http://schemas.xmlsoap.org/ws/2003/06/secext", "wsse:Security");
        securityE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://schemas.xmlsoap.org/ws/2003/06/secext");
        headerE.appendChild(securityE);
        Document assertionDoc = XMLUtils.toDOMDocument((String)this.toString(true, true), (Debug)SAMLUtils.debug);
        Element assertionE = assertionDoc.getDocumentElement();
        securityE.appendChild(doc.importNode(assertionE, true));
    }
}

