/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.security.ProxySubject;
import com.sun.identity.liberty.ws.security.ResourceAccessStatement;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityAttributePlugin;
import com.sun.identity.liberty.ws.security.SecurityTokenException;
import com.sun.identity.liberty.ws.security.SecurityTokenProvider;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.liberty.ws.security.SessionContextStatement;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.shared.xml.XMLUtils;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class LibSecurityTokenProvider
implements SecurityTokenProvider {
    protected XMLSignatureManager sigManager = null;
    protected KeyProvider keystore = null;
    private Object ssoToken = null;
    private String certAlias = null;
    private X509Certificate wssCert = null;
    private static String DEFAULT_CERT_ALIAS_KEY = "com.sun.identity.liberty.ws.wsc.certalias";
    private static String DEFAULT_CERT_ALIAS_VALUE = SystemPropertiesManager.get((String)DEFAULT_CERT_ALIAS_KEY);
    private static String DEFAULT_TA_CERT_ALIAS_KEY = "com.sun.identity.liberty.ws.ta.certalias";
    private static String DEFAULT_TA_CERT_ALIAS_VALUE = SystemPropertiesManager.get((String)DEFAULT_TA_CERT_ALIAS_KEY);
    private static String KEYINFO_TYPE = "com.sun.identity.liberty.ws.security.keyinfotype";
    private static final String AUTH_INSTANT = "authInstant";
    private static String keyInfoType = SystemPropertiesManager.get((String)KEYINFO_TYPE);
    private static Debug debug = Debug.getInstance((String)"fmLibertySecurity");
    private static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"fmLibertySecurity");
    protected String authTime = "";
    protected String authType = "";
    protected static SecurityAttributePlugin attributePlugin = null;
    private static final String WS_ATTRIBUTE_PLUGIN = "com.sun.identity.liberty.ws.attributeplugin";

    public void initialize(Object credential, XMLSignatureManager sigManager) throws SecurityTokenException {
        debug.message("LibSecurityTokenProvider.initialize");
        if (sigManager == null) {
            debug.error("AMP: nulll signature manager");
            throw new SecurityTokenException(bundle.getString("nullXMLSigManager"));
        }
        this.keystore = sigManager.getKeyProvider();
        try {
            this.ssoToken = credential;
            SessionProvider provider = SessionManager.getProvider();
            if (!provider.isValid(this.ssoToken)) {
                throw new SecurityTokenException(bundle.getString("invalidSSOToken"));
            }
            String[] tmp = provider.getProperty(this.ssoToken, "authMethod");
            if (tmp != null && tmp.length != 0) {
                this.authType = tmp[0];
            }
            if ((tmp = provider.getProperty(this.ssoToken, AUTH_INSTANT)) != null && tmp.length != 0) {
                this.authTime = tmp[0];
            }
        }
        catch (SessionException e) {
            debug.error("AMP: invalid SSO Token", (Throwable)((Object)e));
            throw new SecurityTokenException(bundle.getString("invalidSSOToken"));
        }
        this.sigManager = sigManager;
    }

    public void setCertAlias(String certAlias) throws SecurityTokenException {
        if (debug.messageEnabled()) {
            debug.message("AMP : certalias=" + certAlias);
        }
        this.certAlias = certAlias;
        this.wssCert = this.getX509Certificate();
    }

    public void setCertificate(X509Certificate cert) throws SecurityTokenException {
        this.certAlias = this.keystore.getCertificateAlias(cert);
        if (debug.messageEnabled()) {
            debug.message("AMP : certalias=" + this.certAlias);
        }
        if (this.certAlias == null) {
            debug.error("AMP: no cert found");
            throw new SecurityTokenException(bundle.getString("noCertAlias"));
        }
        this.wssCert = cert;
    }

    private X509Certificate getX509Certificate() throws SecurityTokenException {
        X509Certificate cert;
        if (this.certAlias == null) {
            if (DEFAULT_CERT_ALIAS_VALUE == null || DEFAULT_CERT_ALIAS_VALUE.trim().length() == 0) {
                debug.error("AMP: no cert found");
                throw new SecurityTokenException(bundle.getString("noCertAlias"));
            }
            this.certAlias = DEFAULT_CERT_ALIAS_VALUE;
        }
        if ((cert = this.keystore.getX509Certificate(this.certAlias)) == null) {
            debug.error("AMP : no cert found in store");
            throw new SecurityTokenException(bundle.getString("noMatchingCert"));
        }
        return cert;
    }

    public BinarySecurityToken getX509CertificateToken() throws SecurityTokenException {
        if (this.wssCert == null) {
            this.wssCert = this.getX509Certificate();
        }
        String value = null;
        try {
            value = Base64.encode((byte[])this.wssCert.getEncoded());
            return new BinarySecurityToken(value, BinarySecurityToken.X509V3, BinarySecurityToken.BASE64BINARY);
        }
        catch (Exception e) {
            debug.error("getX509Token", (Throwable)e);
            throw new SecurityTokenException(e.getMessage());
        }
    }

    public SecurityAssertion getSAMLAuthenticationToken(NameIdentifier senderIdentity) throws SecurityTokenException {
        return this.getSAMLToken(senderIdentity, null, null, true, false, null, false);
    }

    public SecurityAssertion getSAMLAuthorizationToken(NameIdentifier senderIdentity, SessionContext invocatorSession, String resourceID, boolean includeAuthN, boolean includeResourceAccessStatement, String recipientProviderID) throws SecurityTokenException {
        return this.getSAMLToken(senderIdentity, invocatorSession, resourceID, includeAuthN, includeResourceAccessStatement, recipientProviderID, false);
    }

    public SecurityAssertion getSAMLAuthorizationToken(NameIdentifier senderIdentity, SessionContext invocatorSession, EncryptedResourceID encResourceID, boolean includeAuthN, boolean includeResourceAccessStatement, String recipientProviderID) throws SecurityTokenException {
        return this.getSAMLToken(senderIdentity, invocatorSession, encResourceID, includeAuthN, includeResourceAccessStatement, recipientProviderID, false);
    }

    public SecurityAssertion getSAMLBearerToken(NameIdentifier senderIdentity, SessionContext invocatorSession, String resourceID, boolean includeAuthN, boolean includeResourceAccessStatement, String recipientProviderID) throws SecurityTokenException {
        return this.getSAMLToken(senderIdentity, invocatorSession, resourceID, includeAuthN, includeResourceAccessStatement, recipientProviderID, true);
    }

    public SecurityAssertion getSAMLBearerToken(NameIdentifier senderIdentity, SessionContext invocatorSession, EncryptedResourceID encResourceID, boolean includeAuthN, boolean includeResourceAccessStatement, String recipientProviderID) throws SecurityTokenException {
        return this.getSAMLToken(senderIdentity, invocatorSession, encResourceID, includeAuthN, includeResourceAccessStatement, recipientProviderID, true);
    }

    private SecurityAssertion getSAMLToken(NameIdentifier senderIdentity, SessionContext invocatorSession, Object resourceID, boolean includeAuthN, boolean includeResourceAccessStatement, String recipientProviderID, boolean isBear) throws SecurityTokenException {
        AttributeStatement attributeStatement;
        List attributes;
        if (debug.messageEnabled()) {
            debug.message("getSAMLToken: isBear = " + isBear);
        }
        if (senderIdentity == null) {
            debug.error("LibSecurityTokenProvider.getSAMLToken:senderIdentity is null");
            throw new SecurityTokenException(bundle.getString("nullSenderIdentity"));
        }
        boolean statementNotFound = true;
        SecurityAssertion assertion = null;
        HashSet<SubjectStatement> statements = new HashSet<SubjectStatement>();
        if (includeAuthN) {
            AuthenticationStatement authStatement = this.createAuthenticationStatement(senderIdentity, isBear);
            statements.add(authStatement);
            statementNotFound = false;
        }
        if (includeResourceAccessStatement) {
            ResourceAccessStatement ras = this.createResourceAccessStatement(senderIdentity, invocatorSession, resourceID, isBear);
            statements.add(ras);
            statementNotFound = false;
        } else if (invocatorSession != null) {
            SessionContextStatement scs = this.createSessionContextStatement(senderIdentity, invocatorSession, isBear);
            statements.add(scs);
            statementNotFound = false;
        }
        if (statementNotFound) {
            debug.error("getSAMLAuthorizationToken: SAML statement should not be null.");
            throw new SecurityTokenException(bundle.getString("nullStatement"));
        }
        String issuer = DiscoServiceManager.getDiscoProviderID();
        attributePlugin = LibSecurityTokenProvider.getAttributePlugin();
        if (attributePlugin != null && (attributes = attributePlugin.getAttributes(senderIdentity, resourceID, issuer)) != null && attributes.size() != 0 && (attributeStatement = this.createAttributeStatement(senderIdentity, attributes, isBear)) != null) {
            statements.add(attributeStatement);
        }
        Date issueInstant = new Date();
        try {
            if (recipientProviderID != null) {
                ArrayList<String> audience = new ArrayList<String>();
                audience.add(recipientProviderID);
                AudienceRestrictionCondition arc = new AudienceRestrictionCondition(audience);
                Conditions conditions = new Conditions();
                conditions.addAudienceRestrictionCondition(arc);
                assertion = new SecurityAssertion("", issuer, issueInstant, conditions, statements);
            } else {
                assertion = new SecurityAssertion("", issuer, issueInstant, statements);
            }
            assertion.signXML(DEFAULT_TA_CERT_ALIAS_VALUE);
        }
        catch (Exception e) {
            debug.error("getSAMLToken.signXML", (Throwable)e);
            throw new SecurityTokenException(bundle.getString("nullAssertion"));
        }
        return assertion;
    }

    private AuthenticationStatement createAuthenticationStatement(NameIdentifier senderIdentity, boolean isBearer) throws SecurityTokenException {
        AuthenticationStatement authStatement = null;
        try {
            String authMethod = SAMLServiceManager.getAuthMethodURI(this.authType);
            Date authInstant = DateUtils.stringToDate((String)this.authTime);
            Subject subject = null;
            SubjectConfirmation subConfirmation = null;
            if (isBearer) {
                subConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
            } else {
                subConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
                subConfirmation.setKeyInfo(this.createKeyInfo());
            }
            subject = new Subject(senderIdentity, subConfirmation);
            authStatement = new AuthenticationStatement(authMethod, authInstant, subject);
        }
        catch (Exception e) {
            debug.error("createAuthenticationStatement: ", (Throwable)e);
            throw new SecurityTokenException(e.getMessage());
        }
        return authStatement;
    }

    private ResourceAccessStatement createResourceAccessStatement(NameIdentifier senderIdentity, SessionContext invocatorSession, Object resourceID, boolean isBear) throws SecurityTokenException {
        if (debug.messageEnabled()) {
            debug.message("LibSecurityTokenProvider.createResourceAccessStatement: resourceID class = " + resourceID.getClass() + ", value = " + resourceID);
        }
        ResourceAccessStatement ras = null;
        try {
            ProxySubject proxySubject = null;
            Subject subject = null;
            List subjects = this.createSubjectAndProxySubject(senderIdentity, invocatorSession, isBear);
            subject = (Subject)subjects.get(0);
            if (subjects.size() == 2) {
                proxySubject = (ProxySubject)subjects.get(1);
            }
            ras = resourceID instanceof String ? new ResourceAccessStatement((String)resourceID, proxySubject, invocatorSession, subject) : new ResourceAccessStatement((EncryptedResourceID)resourceID, proxySubject, invocatorSession, subject);
            if (debug.messageEnabled()) {
                debug.message("LibSecurityTokenProvider.createResourceAccessStatement: ras = " + ras);
            }
        }
        catch (Exception e) {
            debug.error("createResourceAccessStatement: ", (Throwable)e);
            throw new SecurityTokenException(e.getMessage());
        }
        return ras;
    }

    private List createSubjectAndProxySubject(NameIdentifier senderIdentity, SessionContext invocatorSession, boolean isBear) throws Exception {
        ArrayList<Subject> returnList = new ArrayList<Subject>();
        Subject subject = null;
        SubjectConfirmation subConfirmation = null;
        ProxySubject proxySubject = null;
        NameIdentifier sessIdentity = null;
        if (invocatorSession != null && !(sessIdentity = invocatorSession.getSessionSubject().getNameIdentifier()).equals(senderIdentity)) {
            subConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
            subject = new Subject(sessIdentity, subConfirmation);
            proxySubject = this.createProxySubject(senderIdentity, isBear);
            returnList.add(subject);
            returnList.add(proxySubject);
        } else {
            if (isBear) {
                subConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
            } else {
                subConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
                subConfirmation.setKeyInfo(this.createKeyInfo());
            }
            subject = new Subject(senderIdentity, subConfirmation);
            returnList.add(subject);
        }
        return returnList;
    }

    private SessionContextStatement createSessionContextStatement(NameIdentifier senderIdentity, SessionContext invocatorSession, boolean isBear) throws SecurityTokenException {
        try {
            ProxySubject proxySubject = null;
            Subject subject = null;
            List subjects = this.createSubjectAndProxySubject(senderIdentity, invocatorSession, isBear);
            subject = (Subject)subjects.get(0);
            if (subjects.size() == 2) {
                proxySubject = (ProxySubject)subjects.get(1);
            }
            return new SessionContextStatement(invocatorSession, proxySubject, subject);
        }
        catch (Exception e) {
            debug.error("createSessionContextStatement: ", (Throwable)e);
            throw new SecurityTokenException(e.getMessage());
        }
    }

    private ProxySubject createProxySubject(NameIdentifier senderIdentity, boolean isBear) throws SecurityTokenException, SAMLException {
        SubjectConfirmation subConfirmation = null;
        if (isBear) {
            subConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        } else {
            subConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
            subConfirmation.setKeyInfo(this.createKeyInfo());
        }
        return new ProxySubject(senderIdentity, subConfirmation);
    }

    private Element createKeyInfo() throws SecurityTokenException {
        X509Certificate cert = this.getX509Certificate();
        Document doc = null;
        try {
            doc = XMLUtils.newDocument();
        }
        catch (Exception e) {
            debug.error("createKeyInfo: ", (Throwable)e);
            throw new SecurityTokenException(e.getMessage());
        }
        String keyNameTextString = null;
        String base64CertString = null;
        PublicKey pk = null;
        try {
            pk = cert.getPublicKey();
            keyNameTextString = cert.getSubjectDN().getName();
            base64CertString = Base64.encode((byte[])cert.getEncoded());
        }
        catch (Exception e) {
            debug.error("createKeyInfo: ", (Throwable)e);
            throw new SecurityTokenException(e.getMessage());
        }
        Element keyInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        keyInfo.setAttribute("xmlns", "http://www.w3.org/2000/09/xmldsig#");
        if (keyInfoType != null && keyInfoType.equalsIgnoreCase("certificate")) {
            Element x509Data = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Data");
            Element x509Certificate = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
            Text certText = doc.createTextNode(base64CertString);
            x509Certificate.appendChild(certText);
            keyInfo.appendChild(x509Data).appendChild(x509Certificate);
        } else {
            Element keyName = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyName");
            Text keyNameText = doc.createTextNode(keyNameTextString);
            Element keyvalue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
            if (pk.getAlgorithm().equals("DSA")) {
                DSAPublicKey dsakey = (DSAPublicKey)pk;
                DSAParams dsaParams = dsakey.getParams();
                BigInteger _p = dsaParams.getP();
                BigInteger _q = dsaParams.getQ();
                BigInteger _g = dsaParams.getG();
                BigInteger _y = dsakey.getY();
                Element DSAKeyValue2 = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "DSAKeyValue");
                Element p = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "P");
                Text value_p = doc.createTextNode(Base64.encode((byte[])_p.toByteArray()));
                p.appendChild(value_p);
                DSAKeyValue2.appendChild(p);
                Element q = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Q");
                Text value_q = doc.createTextNode(Base64.encode((byte[])_q.toByteArray()));
                q.appendChild(value_q);
                DSAKeyValue2.appendChild(q);
                Element g = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "G");
                Text value_g = doc.createTextNode(Base64.encode((byte[])_g.toByteArray()));
                g.appendChild(value_g);
                DSAKeyValue2.appendChild(g);
                Element y = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Y");
                Text value_y = doc.createTextNode(Base64.encode((byte[])_y.toByteArray()));
                y.appendChild(value_y);
                DSAKeyValue2.appendChild(y);
                keyvalue.appendChild(DSAKeyValue2);
            } else {
                RSAPublicKey rsakey = (RSAPublicKey)pk;
                BigInteger exponent = rsakey.getPublicExponent();
                BigInteger modulus = rsakey.getModulus();
                Element RSAKeyValue2 = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue");
                Element modulusNode = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Modulus");
                Element exponentNode = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Exponent");
                RSAKeyValue2.appendChild(modulusNode);
                RSAKeyValue2.appendChild(exponentNode);
                Text modulusValue = doc.createTextNode(Base64.encode((byte[])modulus.toByteArray()));
                modulusNode.appendChild(modulusValue);
                Text exponentValue = doc.createTextNode(Base64.encode((byte[])exponent.toByteArray()));
                exponentNode.appendChild(exponentValue);
                keyvalue.appendChild(RSAKeyValue2);
            }
            keyInfo.appendChild(keyName).appendChild(keyNameText);
            keyInfo.appendChild(keyvalue);
        }
        return keyInfo;
    }

    private AttributeStatement createAttributeStatement(NameIdentifier senderIdentity, List attributes, boolean isBearer) {
        Object attributeStatement = null;
        try {
            Subject subject = null;
            SubjectConfirmation subConfirmation = null;
            if (isBearer) {
                subConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
            } else {
                subConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
                subConfirmation.setKeyInfo(this.createKeyInfo());
            }
            subject = new Subject(senderIdentity, subConfirmation);
            return new AttributeStatement(subject, attributes);
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("createAttributeStatement: ", (Throwable)e);
            }
            return null;
        }
    }

    private static SecurityAttributePlugin getAttributePlugin() {
        block4: {
            if (attributePlugin != null) {
                return attributePlugin;
            }
            String pluginName = SystemPropertiesManager.get((String)WS_ATTRIBUTE_PLUGIN);
            if (pluginName == null || pluginName.length() == 0) {
                return null;
            }
            try {
                Class<?> pluginClass = Class.forName(pluginName);
                attributePlugin = (SecurityAttributePlugin)pluginClass.newInstance();
            }
            catch (Exception ex) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("LibSecurityTokenProvider.getAttributePlugin: Exception", (Throwable)ex);
            }
        }
        return attributePlugin;
    }
}

