/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.interaction;

import com.sun.identity.common.PeriodicCleanUpMap;
import com.sun.identity.common.SystemTimerPool;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.interaction.InteractionConfig;
import com.sun.identity.liberty.ws.interaction.InteractionException;
import com.sun.identity.liberty.ws.interaction.InteractionRedirectException;
import com.sun.identity.liberty.ws.interaction.InteractionSOAPFaultException;
import com.sun.identity.liberty.ws.interaction.JAXBObjectFactory;
import com.sun.identity.liberty.ws.interaction.jaxb.InquiryElement;
import com.sun.identity.liberty.ws.interaction.jaxb.InteractionResponseElement;
import com.sun.identity.liberty.ws.interaction.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.interaction.jaxb.RedirectRequestElement;
import com.sun.identity.liberty.ws.interaction.jaxb.StatusElement;
import com.sun.identity.liberty.ws.interaction.jaxb.UserInteractionElement;
import com.sun.identity.liberty.ws.soapbinding.Client;
import com.sun.identity.liberty.ws.soapbinding.CorrelationHeader;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFault;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultDetail;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class InteractionManager {
    public static final String RETURN_TO_URL = "ReturnToURL";
    public static final String REQUEST_ID = "RequestID";
    public static final String IDP = "IDP";
    public static final String RESEND_MESSAGE = "ResendMessage";
    public static final String INTERACTION_NAMESPACE = "urn:liberty:is:2003-08";
    public static final QName QNAME_SERVER = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    public static final QName QNAME_INTERACT_IF_NEEDED = new QName("urn:liberty:is:2003-08", "interactIfNeeded", "is");
    public static final QName QNAME_DO_NOT_INTERACT = new QName("urn:liberty:is:2003-08", "doNotInteract", "is");
    public static final QName QNAME_DO_NOT_INTERACT_FOR_DATA = new QName("urn:liberty:is:2003-08", "doNotInteractForData", "is");
    public static final QName QNAME_INTERACTION_REQUIRED = new QName("urn:liberty:is:2003-08", "interactionRequired");
    public static final QName QNAME_INTERACTION_REQUIRED_FOR_DATA = new QName("urn:liberty:is:2003-08", "forData");
    public static final QName QNAME_INTERACTION_TIME_NOT_SUFFICEINT = new QName("urn:liberty:is:2003-08", "timeNotSufficient");
    public static final QName QNAME_INTERACTION_TIMED_OUT = new QName("urn:liberty:is:2003-08", "timeOut");
    public static final QName QNAME_INTERACTION_CAN_NOT_DETERMINE_REQUEST_HOST = new QName("urn:liberty:is:2003-08", "canNotDetermineRequestHostName");
    public static final String SERVER_ERROR = "Server Error";
    static final String TRANS_ID = "TransID";
    private static InteractionManager interactionManager = null;
    private static Debug debug = Debug.getInstance((String)"libInteraction");
    private static final String REDIRECT_URL = "redirectURL";
    private static final String FAULT_ACTOR = "http://schemas.xmlsoap.org/soap/actor/next";
    private static final String INTERACTION_RB_NAME = "libInteraction";
    private InteractionCache cache = new InteractionCache();
    private ObjectFactory objectFactory = JAXBObjectFactory.getObjectFactory();
    private InteractionConfig interactionConfig = InteractionConfig.getInstance();

    public static synchronized InteractionManager getInstance() {
        if (interactionManager == null) {
            interactionManager = new InteractionManager();
        }
        return interactionManager;
    }

    private InteractionManager() {
        if (debug.messageEnabled()) {
            debug.message("InteractionManager():constructed singleton instance");
        }
    }

    public Message sendRequest(Message requestMessage, String connectTo, String certAlias, String soapAction, String returnToURL, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws InteractionException, InteractionRedirectException, SOAPBindingException, SOAPFaultException {
        String[] objs;
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.sendRequest(): entering with messageID=" + requestMessage.getCorrelationHeader().getMessageID() + ":refToMessageID=" + requestMessage.getCorrelationHeader().getRefToMessageID() + ":requestMessage=" + requestMessage);
        }
        if (this.interactionConfig.wscIncludesUserInteractionHeader()) {
            Enumeration locales = httpRequest.getLocales();
            ArrayList<String> acceptLanguages = new ArrayList<String>();
            while (locales.hasMoreElements()) {
                acceptLanguages.add(locales.nextElement().toString());
            }
            if (debug.messageEnabled()) {
                debug.message("InteractionManager.sendRequest():Accept-Language specified by httpRequest=" + acceptLanguages);
            }
            UserInteractionElement ue = this.createUserInteractionElement(acceptLanguages);
            String id = SAMLUtils.generateID();
            ue.setId(id);
            if (ue != null) {
                try {
                    Element element = Utils.convertJAXBToElement(ue);
                    requestMessage.setOtherSOAPHeader(element, id);
                }
                catch (JAXBException je) {
                    debug.error("InteractionManager.sendRequest():not setting userInteractionHeader:can not convert JAXBObject to Element", (Throwable)je);
                }
            }
        }
        Message responseMessage = null;
        try {
            if (debug.messageEnabled()) {
                debug.message("InteractionManager.sendRequest():invoking soap Client.sendRequest()::requestMessage=" + requestMessage + ":connecTo=" + connectTo);
            }
            if (LogUtil.isLogEnabled()) {
                objs = new String[]{requestMessage.getCorrelationHeader().getMessageID()};
                LogUtil.access(Level.INFO, "IS_Sending_Message", objs);
            }
            responseMessage = Client.sendRequest(requestMessage, connectTo, certAlias, soapAction);
        }
        catch (SOAPFaultException sfe) {
            String redirectURL;
            if (debug.messageEnabled()) {
                debug.message("InteractionManager.sendRequest(): catching SOAPFaultException=" + sfe);
            }
            if ((redirectURL = this.getRedirectURL(sfe)) == null) {
                throw sfe;
            }
            String responseID = this.getResponseID(sfe);
            responseMessage = this.handleRedirectRequest(requestMessage, redirectURL, responseID, connectTo, certAlias, soapAction, returnToURL, httpRequest, httpResponse);
        }
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.sendRequest(): returning response message=" + responseMessage);
        }
        if (LogUtil.isLogEnabled()) {
            objs = new String[]{responseMessage.getCorrelationHeader().getMessageID(), requestMessage.getCorrelationHeader().getMessageID()};
            LogUtil.access(Level.INFO, "IS_Returning_Response_Message", objs);
        }
        return responseMessage;
    }

    public Message resendRequest(String returnToURL, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws InteractionRedirectException, InteractionException, SOAPBindingException, SOAPFaultException {
        return this.resendRequest(returnToURL, httpRequest, httpResponse, null);
    }

    public Message resendRequest(String returnToURL, HttpServletRequest httpRequest, HttpServletResponse httpResponse, Message requestMessage) throws InteractionRedirectException, InteractionException, SOAPBindingException, SOAPFaultException {
        String messageID;
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.resendRequest():entering ");
        }
        if ((messageID = httpRequest.getParameter(RESEND_MESSAGE)) == null) {
            debug.error("InteractionManager.resend(): request without ResendMessage in requestURL=" + httpRequest.getRequestURL().toString());
            Object[] objs = new String[]{RESEND_MESSAGE};
            throw new InteractionException(INTERACTION_RB_NAME, "missing_query_parameter", objs);
        }
        if (messageID == "0" || messageID.equals("false")) {
            debug.error("InteractionManager.resend(): resend not allowed in requestURL=" + httpRequest.getRequestURL().toString());
            throw new InteractionException(INTERACTION_RB_NAME, "wsp_advised_not_to_resend", null);
        }
        messageID = httpRequest.getParameter(REQUEST_ID);
        if (messageID == null) {
            debug.error("InteractionManager.resend(): request without RequestID in requestURL=" + httpRequest.getRequestURL().toString());
            Object[] objs = new String[]{REQUEST_ID};
            throw new InteractionException(INTERACTION_RB_NAME, "request_missing_query_parameter", objs);
        }
        String connectTo = this.getConnectTo(messageID);
        if (connectTo == null) {
            debug.error("InteractionManager.resend(): old connectTo not  found for messageID=" + messageID);
            throw new InteractionException(INTERACTION_RB_NAME, "old_connectTo_not_found", null);
        }
        if (requestMessage == null) {
            Message oldMessage;
            if (debug.messageEnabled()) {
                debug.message("InteractionManager.resendRequest():invoking with null requestMessage:old cached message would be used");
            }
            if ((oldMessage = this.getRequestMessage(messageID)) == null) {
                debug.error("InteractionManager.resend(): old message not  found for messageID=" + messageID);
                throw new InteractionException(INTERACTION_RB_NAME, "old_message_not_found", null);
            }
            requestMessage = oldMessage;
        } else if (debug.messageEnabled()) {
            debug.message("InteractionManager.resendRequest():invoking with non null requestMessage");
        }
        CorrelationHeader ch = new CorrelationHeader();
        ch.setRefToMessageID(InteractionManager.getInstance().getRequestMessageID(messageID));
        requestMessage.setCorrelationHeader(ch);
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.resendRequest():invoking InteractionManager.sendRequest():with requestMessage=" + requestMessage + ":returnToURL=" + returnToURL);
        }
        if (LogUtil.isLogEnabled()) {
            String[] objs = new String[]{messageID, ch.getMessageID()};
            LogUtil.access(Level.INFO, "IS_Resending_Message", objs);
        }
        Message responseMessage = this.sendRequest(requestMessage, connectTo, this.getClientCert(messageID), this.getSoapAction(messageID), returnToURL, httpRequest, httpResponse);
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.resendRequest(): returning responseMessage=" + responseMessage);
        }
        return responseMessage;
    }

    private Message handleRedirectRequest(Message requestMessage, String redirectURL, String messageID, String connectTo, String certAlias, String soapAction, String returnToURL, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws InteractionRedirectException, InteractionException {
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.handleRedirectRequest():entering with redirectURL=" + redirectURL);
        }
        if (redirectURL.indexOf("ReturnToURL=") != -1) {
            debug.error("InteractionManager.handleRedirectRequest():Invalid redirectURL - illegal parameter ReturnToURL in redirectURL=" + redirectURL);
            Object[] objs = new String[]{RETURN_TO_URL, REDIRECT_URL};
            throw new InteractionException(INTERACTION_RB_NAME, "illegal_parameter_in_redirectURL", objs);
        }
        if (redirectURL.indexOf("IDP=") != -1) {
            debug.error("InteractionManager.handleRedirectRequest():Invalid redirectURL - illegal parameter:IDP in redirectURL=" + redirectURL);
            Object[] objs = new String[]{IDP, REDIRECT_URL};
            throw new InteractionException(INTERACTION_RB_NAME, "illegal_parameter_in_redirectURL", objs);
        }
        if (InteractionConfig.getInstance().wscEnforcesHttpsCheck() && redirectURL.indexOf("https") != 0) {
            debug.error("InteractionManager.handleRedirectRequest():Invalid Request redirectURL not https in redirectURL=" + redirectURL);
            throw new InteractionException(INTERACTION_RB_NAME, "redirectURL_not_https", null);
        }
        if (InteractionConfig.getInstance().wspEnforcesReturnToHostEqualsRequestHost() && !this.checkRedirectHost(redirectURL, connectTo)) {
            debug.error("InteractionManager.handleRedirectRequest():Invalid Request redirectToHost differs from  connectToHost: in redirectURL=" + redirectURL + ":connectTo=" + connectTo);
            throw new InteractionException(INTERACTION_RB_NAME, "redirectURL_differs_from_connectTo", null);
        }
        String requestID = requestMessage.getCorrelationHeader().getMessageID();
        this.setRequestMessage(requestID, requestMessage);
        this.setConnectTo(requestID, connectTo);
        this.setSoapAction(requestID, soapAction);
        this.setClientCert(requestID, certAlias);
        this.setRequestMessageID(requestID, messageID);
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.handleRedirectRequest():cached  request message for messageID=" + messageID + ":requestID=" + requestID + ":requestMessage:" + (requestMessage == null));
        }
        returnToURL = returnToURL + "?" + REQUEST_ID + "=" + requestID;
        redirectURL = redirectURL + "&" + RETURN_TO_URL + "=" + URLEncDec.encode((String)returnToURL);
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.handleRedirectRequest():redirecting user agent to redirectURL= " + redirectURL);
        }
        try {
            httpResponse.sendRedirect(redirectURL);
        }
        catch (IOException ioe) {
            debug.error("InteractionManager.handleRedirectRequest(): catching IOException", (Throwable)ioe);
            throw new InteractionException(INTERACTION_RB_NAME, "IOException_in_Interaction_Manager", null);
        }
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.handleRedirectRequest():redirected user agent to redirectURL= " + redirectURL);
        }
        if (LogUtil.isLogEnabled()) {
            String[] objs = new String[]{requestID};
            LogUtil.access(Level.INFO, "IS_Redirected_User_Agent", objs);
        }
        throw new InteractionRedirectException(requestID);
    }

    public Message handleInteraction(Message requestMessage, InquiryElement inquiryElement) throws InteractionException, InteractionSOAPFaultException, SOAPFaultException {
        return this.handleInteraction(requestMessage, inquiryElement, null);
    }

    public Message handleInteraction(Message requestMessage, InquiryElement inquiryElement, String language) throws InteractionException, InteractionSOAPFaultException, SOAPFaultException {
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.handleInteraction():entering");
        }
        if (!this.interactionConfig.wspSupportsRedirect()) {
            if (debug.warningEnabled()) {
                debug.warning("InteractionManager.handleInteraction(): WSP requests for interaction:wspWillRedirect=" + this.interactionConfig.wspSupportsRedirect());
                debug.warning("InteractionManager.handleInteraction():throwing InteractionException");
            }
            throw new InteractionException(INTERACTION_RB_NAME, "wsp_does_not_support_interaction", null);
        }
        UserInteractionElement ue = InteractionManager.getUserInteractionElement(requestMessage);
        if (ue == null) {
            SOAPFaultException sfe = this.newRedirectFaultError(QNAME_INTERACTION_REQUIRED);
            if (debug.warningEnabled()) {
                debug.warning("InteractionManager.handleInteraction(): WSP requests for interaction - WSC did not  provide UserInteractionHeader");
                debug.warning("InteractionManager.handleInteraction():throwing InteractionSOAPFaultException=" + sfe);
            }
            throw new InteractionSOAPFaultException(sfe);
        }
        if (!ue.isRedirect()) {
            SOAPFaultException sfe = this.newRedirectFaultError(QNAME_INTERACTION_REQUIRED);
            if (debug.warningEnabled()) {
                debug.warning("InteractionManager.handleInteraction():WSP rquests for interaction - WSC   says redirect=false");
                debug.warning("InteractionManager.handleInteraction():throwing InteractionSOAPFaultException=" + sfe);
            }
            throw new InteractionSOAPFaultException(sfe);
        }
        if (ue.getInteract().equals(QNAME_DO_NOT_INTERACT)) {
            SOAPFaultException sfe = this.newRedirectFaultError(QNAME_INTERACTION_REQUIRED);
            if (debug.warningEnabled()) {
                debug.warning("InteractionManager.handleInteraction():WSP rquests for interaction - WSC   UserInteractionHeader says doNotInteract");
                debug.warning("InteractionManager.handleInteraction():throwing InteractionSOAPFaultException=" + sfe);
            }
            throw new InteractionSOAPFaultException(sfe);
        }
        if (this.interactionConfig.wspRedirectsForData() && ue.getInteract().equals(QNAME_DO_NOT_INTERACT_FOR_DATA)) {
            SOAPFaultException sfe = this.newRedirectFaultError(QNAME_INTERACTION_REQUIRED_FOR_DATA);
            if (debug.warningEnabled()) {
                debug.warning("InteractionManager.handleInteraction():WSP rquests interaction for data - WSC   UserInteractionHeader says doNotInteractForData");
                debug.warning("InteractionManager.handleInteraction():throwing InteractionSOAPFaultException=" + sfe);
            }
            throw new InteractionSOAPFaultException(sfe);
        }
        BigInteger uemi = ue.getMaxInteractTime();
        if (uemi != null && this.interactionConfig.getWSPRedirectTime() > uemi.intValue()) {
            SOAPFaultException sfe = this.newRedirectFaultError(QNAME_INTERACTION_TIME_NOT_SUFFICEINT);
            if (debug.warningEnabled()) {
                debug.warning("InteractionManager.handleInteraction():WSP inteaction time =" + this.interactionConfig.getWSPRedirectTime() + " exceeds WSC maxInteractTime= " + ue.getMaxInteractTime());
                debug.warning("InteractionManager.handleInteraction():throwing InteractionSOAPFaultException=" + sfe);
            }
            throw new InteractionSOAPFaultException(sfe);
        }
        String requestMessageID = requestMessage.getCorrelationHeader().getMessageID();
        SOAPFaultException sfe = this.newRedirectFault(requestMessageID);
        String redirectResponseID = this.getResponseID(sfe);
        String requestIP = requestMessage.getIPAddress();
        String requestHost = null;
        if (this.interactionConfig.wspEnforcesReturnToHostEqualsRequestHost()) {
            try {
                InetAddress inetAddress = InetAddress.getByName(requestIP);
                requestHost = inetAddress.getHostName();
                if (debug.messageEnabled()) {
                    debug.message("InteractionManager.handleInteraction(): caching requestHost=" + requestHost + ", for redirectResponseID= " + redirectResponseID);
                }
                this.setRequestHost(redirectResponseID, requestHost);
            }
            catch (UnknownHostException uhe) {
                debug.error("InteractionManager.handleInteraction(): can not resolve host name", (Throwable)uhe);
                debug.error("InteractionManager.handleInteraction(): throwing InteractionSOAPFaultException", (Throwable)sfe);
                SOAPFaultException sfe1 = this.newRedirectFaultError(QNAME_INTERACTION_CAN_NOT_DETERMINE_REQUEST_HOST);
                throw new InteractionSOAPFaultException(sfe1);
            }
        }
        this.setInquiryElement(redirectResponseID, inquiryElement);
        this.setRequestMessageID(redirectResponseID, requestMessageID);
        this.setLanguage(redirectResponseID, language);
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.handleInteraction(): throwing InteractionSOAPFaultException  to redirect user agent=" + sfe);
        }
        throw new InteractionSOAPFaultException(sfe);
    }

    private void setInquiryElement(String messageID, InquiryElement inquiryElement) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(messageID);
            this.cache.putCacheEntry(messageID, cacheEntry);
        }
        cacheEntry.setInquiryElement(inquiryElement);
    }

    InquiryElement getInquiryElement(String messageID) {
        InquiryElement inquiryElement = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry != null) {
            inquiryElement = cacheEntry.getInquiryElement();
        }
        return inquiryElement;
    }

    void setInteractionResponseElement(String messageID, InteractionResponseElement interactionResponse) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(messageID);
            this.cache.putCacheEntry(messageID, cacheEntry);
        }
        cacheEntry.setInteractionResponseElement(interactionResponse);
    }

    public InteractionResponseElement getInteractionResponseElement(Message requestMessage) throws InteractionException {
        InteractionResponseElement interactionResponseElement = null;
        CorrelationHeader ch = requestMessage.getCorrelationHeader();
        String messageID = ch.getRefToMessageID();
        CacheEntry cacheEntry = null;
        if (messageID != null) {
            cacheEntry = this.cache.getCacheEntry(messageID);
            if (cacheEntry != null) {
                interactionResponseElement = cacheEntry.getInteractionResponseElement();
            }
            if (debug.messageEnabled()) {
                debug.message("InteractionManager.getInteractionResponseElement():for messageID=" + messageID + ":" + "responseElement=" + (interactionResponseElement != null));
            }
        }
        if (LogUtil.isLogEnabled()) {
            String[] objs = new String[]{ch.getMessageID(), ch.getRefToMessageID(), cacheEntry == null ? "NULL" : "NOT NULL"};
            LogUtil.access(Level.INFO, "IS_Returning_Response_Element", objs);
        }
        return interactionResponseElement;
    }

    private void setRequestMessage(String messageID, Message requestMessage) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(messageID);
            this.cache.putCacheEntry(messageID, cacheEntry);
        }
        cacheEntry.setRequestMessage(requestMessage);
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.setRequestMessage(): cached  request message for messageID=" + messageID + ":requestMessage:" + (requestMessage == null));
        }
    }

    private Message getRequestMessage(String messageID) {
        Message requestMessage = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry != null) {
            requestMessage = cacheEntry.getRequestMessage();
        }
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.getRequestMessage(): looking up request message for messageID=" + messageID + ":requestMessage=" + (requestMessage == null));
        }
        return requestMessage;
    }

    private void setRequestMessageID(String messageID, String requestMessageID) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(messageID);
            this.cache.putCacheEntry(messageID, cacheEntry);
        }
        cacheEntry.setRequestMessageID(requestMessageID);
    }

    String getRequestMessageID(String messageID) {
        String requestMessageID = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry != null) {
            requestMessageID = cacheEntry.getRequestMessageID();
        }
        return requestMessageID;
    }

    void setReturnToURL(String messageID, String returnToURL) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(messageID);
            this.cache.putCacheEntry(messageID, cacheEntry);
        }
        cacheEntry.setReturnToURL(returnToURL);
    }

    String getReturnToURL(String messageID) {
        String returnToURL = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry != null) {
            returnToURL = cacheEntry.getReturnToURL();
        }
        return returnToURL;
    }

    void setRequestHost(String messageID, String requestHost) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(messageID);
            this.cache.putCacheEntry(messageID, cacheEntry);
        }
        cacheEntry.setRequestHost(requestHost);
    }

    String getRequestHost(String messageID) {
        String requestHost = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry != null) {
            requestHost = cacheEntry.getRequestHost();
        }
        return requestHost;
    }

    private void setConnectTo(String messageID, String ConnectTo) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(messageID);
            this.cache.putCacheEntry(messageID, cacheEntry);
        }
        cacheEntry.setConnectTo(ConnectTo);
    }

    private void setSoapAction(String messageID, String soapAction) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(messageID);
            this.cache.putCacheEntry(messageID, cacheEntry);
        }
        cacheEntry.setSoapAction(soapAction);
    }

    private void setClientCert(String messageID, String certAlias) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(messageID);
            this.cache.putCacheEntry(messageID, cacheEntry);
        }
        cacheEntry.setClientCert(certAlias);
    }

    private String getConnectTo(String messageID) {
        String connectTo = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry != null) {
            connectTo = cacheEntry.getConnectTo();
        }
        return connectTo;
    }

    private String getClientCert(String messageID) {
        String clientCert = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry != null) {
            clientCert = cacheEntry.getClientCert();
        }
        return clientCert;
    }

    private String getSoapAction(String messageID) {
        String soapAction = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry != null) {
            soapAction = cacheEntry.getSoapAction();
        }
        return soapAction;
    }

    private void setLanguage(String messageID, String language) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(messageID);
            this.cache.putCacheEntry(messageID, cacheEntry);
        }
        cacheEntry.setLanguage(language);
    }

    String getLanguage(String messageID) {
        String language = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(messageID);
        if (cacheEntry != null) {
            language = cacheEntry.getLanguage();
        }
        return language;
    }

    private UserInteractionElement createUserInteractionElement(List acceptLanguages) {
        UserInteractionElement ue = null;
        try {
            ue = this.objectFactory.createUserInteractionElement();
            ue.setInteract(this.interactionConfig.getWSCSpecifiedInteractionChoice());
            ue.setRedirect(this.interactionConfig.wscSupportsRedirect());
            ue.setMaxInteractTime(BigInteger.valueOf(this.interactionConfig.getWSCSpecifiedMaxInteractionTime()));
            ue.getLanguage().addAll(acceptLanguages);
        }
        catch (JAXBException je) {
            debug.error("InteractionManager.createUserInteractionElement(): can not create UserInteractionElement", (Throwable)je);
        }
        return ue;
    }

    static UserInteractionElement getUserInteractionElement(Message message) {
        UserInteractionElement ue = null;
        List list = message.getOtherSOAPHeaders();
        try {
            list = Utils.convertElementToJAXB(list);
        }
        catch (JAXBException je) {
            debug.error("InteractionManager.getUserInteractionElement():not able to get userInteractionElement:can not convert Element to JAXBObject", (Throwable)je);
            return null;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof UserInteractionElement)) continue;
            ue = (UserInteractionElement)obj;
            break;
        }
        return ue;
    }

    private SOAPFaultException newRedirectFault(String messageID) {
        RedirectRequestElement re = null;
        try {
            re = this.objectFactory.createRedirectRequestElement();
        }
        catch (JAXBException je) {
            debug.error("InteractionManager.newRedirectFault(): can not create RedirectRequestElement", (Throwable)je);
        }
        CorrelationHeader ch = new CorrelationHeader();
        String responseID = ch.getMessageID();
        ch.setRefToMessageID(messageID);
        String redirectUrl = null;
        String lbRedirectUrl = this.interactionConfig.getLbWSPRedirectHandler();
        String wspRedirectUrl = this.interactionConfig.getWSPRedirectHandler();
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.newRedirectURLFault():wspRedirectURL:" + wspRedirectUrl + ", lbRedirectUrl:" + lbRedirectUrl);
        }
        if (lbRedirectUrl == null) {
            redirectUrl = wspRedirectUrl + "?" + TRANS_ID + "=" + responseID;
            if (debug.messageEnabled()) {
                debug.message("InteractionManager.newRedirectURLFault():lbRedirectURL is null, rediectUrl:" + redirectUrl);
            }
        } else {
            redirectUrl = lbRedirectUrl + "?" + TRANS_ID + "=" + responseID + "&" + "HandlerHostId" + "=" + InteractionConfig.getInstance().getLocalServerId();
            if (debug.messageEnabled()) {
                debug.message("InteractionManager.newRedirectURLFault():lbRedirectURL is not null, rediectUrl:" + redirectUrl);
            }
        }
        re.setRedirectURL(redirectUrl);
        ArrayList<Element> details = new ArrayList<Element>();
        try {
            details.add(Utils.convertJAXBToElement(re));
        }
        catch (JAXBException je) {
            debug.error("InteractionManager.newRedirectFault(): can not create newRedirectFault: can not convert JAXBObject to Element", (Throwable)je);
        }
        SOAPFault sf = new SOAPFault(QNAME_SERVER, SERVER_ERROR, FAULT_ACTOR, new SOAPFaultDetail(details));
        Message sfmsg = new Message(sf);
        sfmsg.setCorrelationHeader(ch);
        SOAPFaultException sfe = new SOAPFaultException(sfmsg);
        return sfe;
    }

    private SOAPFaultException newRedirectFaultError(QName errorCode) {
        StatusElement se = null;
        try {
            se = this.objectFactory.createStatusElement();
        }
        catch (JAXBException je) {
            debug.error("InteractionManager.newRedirectFaultError(): can not create StatusElement", (Throwable)je);
        }
        se.setCode(errorCode);
        ArrayList<Element> details = new ArrayList<Element>();
        try {
            details.add(Utils.convertJAXBToElement(se));
        }
        catch (JAXBException je) {
            debug.error("InteractionManager.newRedirectFaultError():can not create new RedirectFaultError:can not convert JAXBObject to Element", (Throwable)je);
        }
        SOAPFault sf = new SOAPFault(QNAME_SERVER, SERVER_ERROR, FAULT_ACTOR, new SOAPFaultDetail(details));
        SOAPFaultException sfe = new SOAPFaultException(new Message(sf));
        return sfe;
    }

    String getRedirectURL(SOAPFaultException sfe) throws SOAPFaultException {
        RedirectRequestElement rre;
        String redirectURL = null;
        List details = null;
        SOAPFaultDetail sfd = sfe.getSOAPFaultMessage().getSOAPFault().getDetail();
        if (sfd != null) {
            details = sfd.getOtherChildren();
        }
        try {
            details = Utils.convertElementToJAXB(details);
        }
        catch (JAXBException je) {
            debug.error("InteractionManager.getRedirectURL(): can not get Redirect URL", (Throwable)je);
        }
        if (details != null && details.size() > 0 && details.get(0) instanceof RedirectRequestElement && (rre = (RedirectRequestElement)details.get(0)) != null) {
            redirectURL = rre.getRedirectURL();
        }
        if (redirectURL == null) {
            throw sfe;
        }
        return redirectURL;
    }

    private boolean checkRedirectHost(String redirectURL, String connectTo) {
        boolean answer = false;
        try {
            URL redirectToURL = new URL(redirectURL);
            URL connectToURL = new URL(connectTo);
            String redirectHost = redirectToURL.getHost();
            String connectToHost = connectToURL.getHost();
            if (redirectHost.equals(connectToHost)) {
                answer = true;
            }
        }
        catch (MalformedURLException mfe) {
            debug.error("InteractionManager.checkRedirectHost():redirectURL not a valid URL :redirectURL=" + redirectURL + " :connectTo=" + connectTo, (Throwable)mfe);
        }
        return answer;
    }

    String getResponseID(SOAPFaultException sfe) throws SOAPFaultException {
        String responseID = null;
        CorrelationHeader ch = sfe.getSOAPFaultMessage().getCorrelationHeader();
        if (ch == null) {
            debug.error("InteractionManager.getResponseID():null CorrelationHeader in SOAPFaultException");
            throw sfe;
        }
        responseID = ch.getMessageID();
        if (responseID == null) {
            debug.error("InteractionManager.getResponseID():null messageID in SOAPFaultException");
            throw sfe;
        }
        return responseID;
    }

    static class CacheEntry {
        String messageID;
        String requestMessageID;
        Message requestMessage;
        InquiryElement inquiryElement;
        InteractionResponseElement interactionResponseElement;
        String connectTo;
        String certAlias;
        String soapAction;
        String returnToURL;
        String requestHost;
        String language;

        CacheEntry(String messageID) {
            this.messageID = messageID;
        }

        CacheEntry(String messageID, Message message) {
            this.messageID = messageID;
            this.requestMessage = message;
        }

        void setRequestMessage(Message requestMessage) {
            this.requestMessage = requestMessage;
        }

        Message getRequestMessage() {
            return this.requestMessage;
        }

        void setRequestMessageID(String requestMessageID) {
            this.requestMessageID = requestMessageID;
        }

        String getRequestMessageID() {
            return this.requestMessageID;
        }

        void setInquiryElement(InquiryElement inquiryElement) {
            this.inquiryElement = inquiryElement;
        }

        InquiryElement getInquiryElement() {
            return this.inquiryElement;
        }

        void setInteractionResponseElement(InteractionResponseElement interactionResponseElement) {
            this.interactionResponseElement = interactionResponseElement;
        }

        InteractionResponseElement getInteractionResponseElement() {
            return this.interactionResponseElement;
        }

        void setConnectTo(String connectTo) {
            this.connectTo = connectTo;
        }

        String getConnectTo() {
            return this.connectTo;
        }

        void setClientCert(String certAlias) {
            this.certAlias = certAlias;
        }

        String getClientCert() {
            return this.certAlias;
        }

        void setSoapAction(String soapAction) {
            this.soapAction = soapAction;
        }

        String getSoapAction() {
            return this.soapAction;
        }

        void setReturnToURL(String returnToURL) {
            this.returnToURL = returnToURL;
        }

        String getReturnToURL() {
            return this.returnToURL;
        }

        void setRequestHost(String requestHost) {
            this.requestHost = requestHost;
        }

        String getRequestHost() {
            return this.requestHost;
        }

        void setLanguage(String language) {
            this.language = language;
        }

        String getLanguage() {
            return this.language;
        }
    }

    static class InteractionCache {
        private static final boolean VERBOSE_MESSAGE = false;
        private static final int SWEEP_INTERVAL = 60000;
        private static final int CACHE_ENTRY_MAX_IDLE_TIME = 120000;
        PeriodicCleanUpMap cache = new PeriodicCleanUpMap(60000L, 120000L);

        InteractionCache() {
            if (debug.messageEnabled()) {
                debug.message("InteactionCache.InteractionCache()  - entering constructor");
            }
            if (debug.messageEnabled()) {
                debug.message("InteactionCache.InteractionCache()  - starting sweeper thread");
                debug.message("InteractionCache.InteractionCache()  SWEEP_INTERVAL = 60000");
                debug.message("InteractionCache.InteractionCache()  CACHE_ENTRY_MAX_IDLE_TIME = 120000");
            }
            SystemTimerPool.getTimerPool().schedule((TaskRunnable)this.cache, new Date((System.currentTimeMillis() + 60000L) / 1000L * 1000L));
            if (debug.messageEnabled()) {
                debug.message("InteactionCache.InteractionCache()  - returning from constructor");
            }
        }

        CacheEntry getCacheEntry(String messageID) {
            CacheEntry entry = (CacheEntry)this.cache.get((Object)messageID);
            if (entry != null) {
                this.cache.removeElement((Object)messageID);
                this.cache.addElement((Object)messageID);
            }
            return entry;
        }

        void putCacheEntry(String messageID, CacheEntry cacheEntry) {
            this.cache.put((Object)messageID, (Object)cacheEntry);
        }
    }
}

