/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.container;

import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.container.IDPPBaseContainer;
import com.sun.identity.liberty.ws.idpp.jaxb.ExtensionElement;
import com.sun.identity.liberty.ws.idpp.jaxb.PPElement;
import com.sun.identity.liberty.ws.idpp.plugin.IDPPExtension;
import com.sun.identity.liberty.ws.idpp.plugin.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.idpp.plugin.jaxb.PPISExtensionElement;
import com.sun.identity.shared.datastruct.CollectionHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;

public class IDPPExtensionContainer
extends IDPPBaseContainer {
    public IDPPExtensionContainer() {
        IDPPUtils.debug.message("IDPPExtensionContainer:constructor:init.");
    }

    public Object getContainerObject(Map userMap) throws IDPPException {
        IDPPUtils.debug.message("IDPPContainers:getContainerObject:Init");
        try {
            PPElement ppType = IDPPUtils.getIDPPFactory().createPPElement();
            ExtensionElement ee = IDPPUtils.getIDPPFactory().createExtensionElement();
            IDPPExtension extension = this.getExtensionContainerClass();
            if (extension != null) {
                ee.getAny().addAll(extension.getExtAttributes());
                ppType.setExtension(ee);
                return ppType;
            }
            Set extensionAttributes = this.getExtensionContainerAttributes();
            if (extensionAttributes == null || extensionAttributes.isEmpty()) {
                ppType.setExtension(ee);
                return ppType;
            }
            Iterator iter = extensionAttributes.iterator();
            while (iter.hasNext()) {
                String extName = (String)iter.next();
                String extValue = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute(extName).toLowerCase());
                if (extValue == null) continue;
                ee.getAny().add(this.getISExtension(extName, extValue));
            }
            ppType.setExtension(ee);
            return ppType;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPExtensionContainer:getContainerObject: JAXB failure", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public Set getContainerAttributes() {
        if (this.getExtensionContainerClass() != null) {
            return new HashSet();
        }
        return this.getMapperAttributeSet(this.getExtensionContainerAttributes());
    }

    public Set getContainerAttributesForSelect(String select) {
        String expContext;
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPExtensionContainer.getContainerAttributesForSelect:Init");
        }
        if ((expContext = IDPPUtils.getExpressionContext(select)) == null) {
            return new HashSet();
        }
        if (expContext.equals("Extension")) {
            return this.getContainerAttributes();
        }
        HashSet<String> set = new HashSet<String>();
        String dsAttribute = this.getExtAttributeName(select);
        if (dsAttribute != null) {
            set.add(dsAttribute);
        }
        return set;
    }

    private String getExtAttributeName(String select) {
        String expContext;
        StringTokenizer st;
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPExtensionContainer.getExtAttributeName:Init");
        }
        if ((st = new StringTokenizer(expContext = IDPPUtils.getExpressionContext(select), "'")).countTokens() != 3) {
            return null;
        }
        st.nextToken();
        return this.getAttributeMapper().getDSAttribute(st.nextToken());
    }

    public Map getDataMapForSelect(String select, List data) throws IDPPException {
        IDPPUtils.debug.message("IDPPExtensionContainer.getDataMapForSelect:");
        HashMap map = new HashMap();
        if (select == null) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPExtensionContainer.getDataMapForSelect: nullInput Paramters");
            }
            return map;
        }
        if (data == null || data.isEmpty()) {
            String attrName = this.getExtAttributeName(select);
            if (attrName != null) {
                map.put(attrName, new HashSet());
            }
            return map;
        }
        Iterator iter = data.iterator();
        while (iter.hasNext()) {
            try {
                PPISExtensionElement extension = (PPISExtensionElement)iter.next();
                String attribute = this.getAttributeMapper().getDSAttribute(extension.getName());
                if (IDPPUtils.debug.messageEnabled()) {
                    IDPPUtils.debug.message("IDPPExtensionContainer.getDataMapForSelect: Attribute name: " + attribute);
                }
                if (attribute == null) continue;
                HashSet<String> set = new HashSet<String>();
                set.add(extension.getValue());
                map.put(attribute, set);
            }
            catch (Exception ce) {
                IDPPUtils.debug.error("IDPPExtensionContainer.getDataMapForSelect:", (Throwable)ce);
                throw new IDPPException(ce);
            }
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPExtensionContainer.getDataMapForSelect: Map to be extracted: " + map);
        }
        return map;
    }

    private PPISExtensionElement getISExtension(String attrName, String attrValue) throws IDPPException {
        IDPPUtils.debug.message("IDPPExtensionContainer.getISExtension:Init");
        try {
            ObjectFactory fac = new ObjectFactory();
            PPISExtensionElement ext = fac.createPPISExtensionElement();
            ext.setName(attrName);
            ext.setValue(attrValue);
            return ext;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPExtensionContainer.getISExtension:Fails in creating PP Extension element.", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public boolean hasBinaryAttributes() {
        return false;
    }
}

