/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.container;

import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.container.IDPPBaseContainer;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTString;
import com.sun.identity.liberty.ws.idpp.jaxb.EmploymentIdentityElement;
import com.sun.identity.liberty.ws.idpp.jaxb.EmploymentIdentityType;
import com.sun.identity.liberty.ws.idpp.jaxb.JobTitleElement;
import com.sun.identity.liberty.ws.idpp.jaxb.OElement;
import com.sun.identity.liberty.ws.idpp.jaxb.PPElement;
import com.sun.identity.shared.datastruct.CollectionHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;

public class IDPPEmploymentIdentity
extends IDPPBaseContainer {
    public IDPPEmploymentIdentity() {
        IDPPUtils.debug.message("IDPPEmploymentIdentity:constructor:init.");
    }

    public Object getContainerObject(Map userMap) throws IDPPException {
        IDPPUtils.debug.message("IDPPEmploymentIdentity:getContainerObj:Init");
        try {
            String org;
            PPElement ppType = IDPPUtils.getIDPPFactory().createPPElement();
            EmploymentIdentityElement ei = IDPPUtils.getIDPPFactory().createEmploymentIdentityElement();
            String jobTitle = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("JobTitle").toLowerCase());
            if (jobTitle != null) {
                DSTString dstString = this.getDSTString(jobTitle);
                ei.setJobTitle(dstString);
            }
            if ((org = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("O").toLowerCase())) != null) {
                DSTString dstString = this.getDSTString(org);
                ei.setO(dstString);
            }
            Set altOs = (Set)userMap.get(this.getAttributeMapper().getDSAttribute("AltO").toLowerCase());
            Iterator iter = altOs.iterator();
            while (iter.hasNext()) {
                DSTString dstString = this.getDSTString((String)iter.next());
                ei.getAltO().add(dstString);
            }
            ppType.setEmploymentIdentity(ei);
            return ppType;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPContainers:getContainerObject: JAXB failure", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public Set getContainerAttributes() {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPEmploymentIdentity:getContainerAttributes:Init");
        }
        HashSet<String> set = new HashSet<String>();
        set.add("JobTitle");
        set.add("O");
        set.add("AltO");
        return this.getMapperAttributeSet(set);
    }

    public Set getContainerAttributesForSelect(String select) {
        String expContext = IDPPUtils.getExpressionContext(select);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPEmploymentIdentity:getContainerAttribSelect:exp context = " + expContext);
        }
        HashSet<String> set = new HashSet<String>();
        if (expContext != null) {
            set.add(expContext);
        }
        return this.getMapperAttributeSet(set);
    }

    public Map getDataMapForSelect(String select, List data) throws IDPPException {
        IDPPUtils.debug.message("IDPPEmploymentIdentity:getDataMapForSelect:");
        Map map = new HashMap();
        String expContext = IDPPUtils.getExpressionContext(select);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPEmploymentIdentity:getDataMapForSelect:exp context = " + expContext);
        }
        int attrType = IDPPUtils.getIDPPElementType(expContext);
        Object dataElement = null;
        if (data != null && !data.isEmpty()) {
            dataElement = data.get(0);
        }
        switch (attrType) {
            case 30: {
                if (dataElement == null || dataElement instanceof JobTitleElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 31: {
                if (dataElement == null || dataElement instanceof OElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 32: {
                map = this.getAltOMap(data, map);
                break;
            }
            case 6: {
                map = this.getEmploymentIdentityMap(dataElement, map);
                break;
            }
            default: {
                IDPPUtils.debug.error("IDPPEmploymentIdentity:getDataMapForSelect. Unsupported element");
            }
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPEmploymentIdentity:getDataMapForSelect:Attr map to be modified." + map);
        }
        return map;
    }

    private Map getEmploymentIdentityMap(Object obj, Map map) throws IDPPException {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPEmploymentIdentity:getEmploymentIdentityMap:Init");
        }
        DSTString jobTitle = null;
        DSTString org = null;
        List altO = null;
        if (obj != null) {
            if (obj instanceof EmploymentIdentityType) {
                EmploymentIdentityType eiType = (EmploymentIdentityType)obj;
                jobTitle = eiType.getJobTitle();
                org = eiType.getO();
                altO = eiType.getAltO();
            } else {
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
        }
        this.getAltOMap(altO, map);
        this.getAttributeMap("JobTitle", jobTitle, map);
        this.getAttributeMap("O", org, map);
        return map;
    }

    private Map getAltOMap(List dataObject, Map map) throws IDPPException {
        IDPPUtils.debug.message("IDPPEmploymentIdentity:getAltOMap:Init");
        if (dataObject == null) {
            map = this.getAttributeMap("AltO", null, map);
            return map;
        }
        return this.getAttributeMap("AltO", dataObject, map);
    }

    public boolean hasBinaryAttributes() {
        return false;
    }
}

