/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.container;

import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.container.IDPPBaseContainer;
import com.sun.identity.liberty.ws.idpp.jaxb.AddressCardElement;
import com.sun.identity.liberty.ws.idpp.jaxb.AddressElement;
import com.sun.identity.liberty.ws.idpp.jaxb.AddressType;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTString;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTURI;
import com.sun.identity.liberty.ws.idpp.jaxb.PPElement;
import com.sun.identity.shared.datastruct.CollectionHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;

public class IDPPAddressCard
extends IDPPBaseContainer {
    private static final String REMOVE_CARD = "RemoveCard";

    public IDPPAddressCard() {
        IDPPUtils.debug.message("IDPPAddressCard:constructor:init.");
    }

    public Object getContainerObject(Map userMap) throws IDPPException {
        IDPPUtils.debug.message("IDPPAddressCard:getContainerObject:Init");
        try {
            PPElement ppType = IDPPUtils.getIDPPFactory().createPPElement();
            Set addressCards = (Set)userMap.get(this.getAttributeMapper().getDSAttribute("AddressCard").toLowerCase());
            if (addressCards == null || addressCards.isEmpty()) {
                throw new IDPPException(IDPPUtils.bundle.getString("nullValues"));
            }
            Iterator iter = addressCards.iterator();
            while (iter.hasNext()) {
                String addrCard = (String)iter.next();
                AddressCardElement ace = this.parseEntry(addrCard, userMap);
                if (ace == null) continue;
                ppType.getAddressCard().add(ace);
            }
            return ppType;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPContainers:getContainerObject: JAXB failure", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    private AddressCardElement parseEntry(String entry, Map userMap) throws JAXBException {
        if (entry == null || entry.length() == 0) {
            return null;
        }
        if (entry.indexOf("|") == -1) {
            IDPPUtils.debug.error("IDPPAddressCard.parsEntry: Invalid Entry " + entry);
            return null;
        }
        AddressCardElement ace = IDPPUtils.getIDPPFactory().createAddressCardElement();
        StringTokenizer st = new StringTokenizer(entry, "|");
        String addrType = null;
        String nick = null;
        String lComment = null;
        String postalAddress = null;
        String postalCode = null;
        String city = null;
        String state = null;
        String country = null;
        String id = null;
        while (st.hasMoreTokens()) {
            StringTokenizer tokenizer;
            String token = st.nextToken();
            if (token.indexOf("=") == -1 || (tokenizer = new StringTokenizer(token, "=")).countTokens() != 2) continue;
            String attribute = tokenizer.nextToken();
            String value = null;
            String mappedAttribute = this.getAttributeMapper().getDSAttribute(attribute);
            value = mappedAttribute == null || mappedAttribute.equals(attribute) ? tokenizer.nextToken() : CollectionHelper.getMapAttr((Map)userMap, (String)mappedAttribute.toLowerCase());
            if (value == null) continue;
            if (attribute.equals("AddrType")) {
                addrType = value;
                continue;
            }
            if (attribute.equals("Nick")) {
                nick = value;
                continue;
            }
            if (attribute.equals("LComment")) {
                lComment = value;
                continue;
            }
            if (attribute.equals("PostalAddress")) {
                postalAddress = value;
                continue;
            }
            if (attribute.equals("PostalCode")) {
                postalCode = value;
                continue;
            }
            if (attribute.equals("L")) {
                city = value;
                continue;
            }
            if (attribute.equals("C")) {
                country = value;
                continue;
            }
            if (attribute.equals("St")) {
                state = value;
                continue;
            }
            if (!attribute.equals("id")) continue;
            id = value;
        }
        if (addrType == null) {
            IDPPUtils.debug.error("IDPPAdressCard.parseEntry: Invalid entry has no AddrType " + entry);
            return null;
        }
        AddressElement ae = IDPPUtils.getIDPPFactory().createAddressElement();
        ae.setC(this.getDSTString(country));
        ae.setSt(this.getDSTString(state));
        ae.setL(this.getDSTString(city));
        ae.setPostalAddress(this.getDSTString(postalAddress));
        ae.setPostalCode(this.getDSTString(postalCode));
        ace.setNick(this.getDSTString(nick));
        ace.getAddrType().add(this.getDSTURI(addrType));
        ace.setAddress(ae);
        ace.setLComment(this.getDSTString(lComment));
        ace.setId(id);
        return ace;
    }

    public Set getContainerAttributes() {
        IDPPUtils.debug.message("IDPPAddressCard:getContainerAttrib:Init");
        HashSet<String> set = new HashSet<String>();
        set.add("AddressCard");
        return this.getMapperAttributeSet(set);
    }

    public Set getContainerAttributesForSelect(String select) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPAddressCard:getContainerAttributesForSelect:Init");
        }
        return this.getContainerAttributes();
    }

    public Map getDataMapForSelect(String select, List data) throws IDPPException {
        IDPPUtils.debug.message("IDPPAddressCard:getDataMapForSelect:Init");
        String expContext = IDPPUtils.getExpressionContext(select);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPAddressCard:getDataMapForSelect:exp context = " + expContext);
        }
        HashMap map = new HashMap();
        if (expContext == null || expContext.length() == 0) {
            return map;
        }
        if (data == null || data.isEmpty()) {
            return this.getDataMap(expContext, null);
        }
        Iterator iter = data.iterator();
        while (iter.hasNext()) {
            Object dataElement = iter.next();
            Map tmpMap = this.getDataMap(expContext, dataElement);
            if (tmpMap == null) continue;
            map.putAll(tmpMap);
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map getDataMap(String expContext, Object dataElement) throws IDPPException {
        String addressType = null;
        String entry = null;
        Map addressMap = this.getAddressMap();
        if (expContext.indexOf("[") != -1) {
            addressType = this.getAddressType(expContext);
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPAddressCard.getDataMap: AddressType=" + addressType);
            }
            if (addressType != null) {
                entry = (String)addressMap.get(addressType);
            }
        }
        if (expContext.startsWith("AddressCard")) {
            List list;
            if (dataElement == null) {
                if (addressType == null) {
                    HashMap removeMap = new HashMap(1);
                    removeMap.put(this.getAttributeMapper().getDSAttribute("AddressCard"), new HashSet());
                    return removeMap;
                }
                HashMap<String, String> tmpMap = new HashMap<String, String>(1);
                tmpMap.put(addressType, REMOVE_CARD);
                return this.setAddressMap(tmpMap);
            }
            if (!(dataElement instanceof AddressCardElement)) throw new IDPPException(IDPPUtils.bundle.getString("invalidElement"));
            AddressCardElement addr = (AddressCardElement)dataElement;
            if ((addressType == null || addressType.length() == 0) && (list = addr.getAddrType()) != null && list.size() != 0) {
                DSTURI addressURI = (DSTURI)list.get(0);
                addressType = addressURI.getValue();
            }
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPAddressCard.getDataMap: AddressType= " + addressType);
            }
            if ((entry = (entry = (String)addressMap.get(addressType)) == null ? this.createAddressCard(addr, addressType) : this.modifyAddressCard(entry, addr)) == null) {
                throw new IDPPException(IDPPUtils.bundle.getString("nullValues"));
            }
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPAddressCard.getDataMap: Entry to be modified." + entry);
            }
            HashMap<String, String> tmpMap = new HashMap<String, String>(1);
            tmpMap.put(addressType, entry);
            return this.setAddressMap(tmpMap);
        }
        if (expContext.equals("Nick") || expContext.equals("PostalAddress") || expContext.equals("LComment") || expContext.equals("L") || expContext.equals("St") || expContext.equals("C") || expContext.equals("PostalCode")) {
            if (dataElement == null) {
                entry = this.modifyEntry(entry, expContext, null);
            } else {
                if (!(dataElement instanceof DSTString)) throw new IDPPException(IDPPUtils.bundle.getString("invalidElement"));
                DSTString dstString = (DSTString)dataElement;
                entry = this.modifyEntry(entry, expContext, dstString);
            }
        } else if (expContext.equals("Address")) {
            if (dataElement == null) {
                entry = this.modifyAddress(entry, null);
            } else {
                if (!(dataElement instanceof AddressElement)) throw new IDPPException(IDPPUtils.bundle.getString("invalidElement"));
                AddressElement ae = (AddressElement)dataElement;
                entry = this.modifyAddress(entry, ae);
            }
        }
        HashMap<String, String> tmpMap = new HashMap<String, String>(1);
        tmpMap.put(addressType, entry);
        return this.setAddressMap(tmpMap);
    }

    private String modifyEntry(String entry, String element, DSTString dstString) {
        StringBuffer sb = new StringBuffer(100);
        StringTokenizer st = new StringTokenizer(entry, "|");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            StringTokenizer tokenizer = new StringTokenizer(token, "=");
            String newToken = tokenizer.nextToken();
            if (element.equals(newToken)) {
                String value = null;
                if (dstString != null) {
                    value = dstString.getValue();
                }
                if (value == null) continue;
                sb.append(element).append("=").append(dstString.getValue()).append("|");
                continue;
            }
            sb.append(token).append("|");
        }
        return sb.toString();
    }

    private String createAddressCard(AddressCardElement ace, String addressType) {
        DSTString comment;
        DSTString nickName;
        StringBuffer sb = new StringBuffer();
        sb.append("AddrType").append("=").append(addressType).append("|");
        AddressType ae = ace.getAddress();
        if (ae == null) {
            IDPPUtils.debug.error("IDPPAddressContainer.createAddressCard:Address Element is null");
            return null;
        }
        String address = this.createAddress(ae);
        if (address != null) {
            sb.append(address);
        }
        if ((nickName = ace.getNick()) != null) {
            sb.append("Nick=").append(nickName.getValue()).append("|");
        }
        if ((comment = ace.getLComment()) != null) {
            sb.append("LComment=").append(comment.getValue());
        }
        return sb.toString();
    }

    private String createAddress(AddressType ae) {
        DSTString country;
        DSTString postalCode;
        DSTString state;
        DSTString city;
        StringBuffer sb = new StringBuffer();
        DSTString postalAddress = ae.getPostalAddress();
        if (postalAddress != null) {
            sb.append("PostalAddress=").append(postalAddress.getValue()).append("|");
        }
        if ((city = ae.getL()) != null) {
            sb.append("L=").append(city.getValue()).append("|");
        }
        if ((state = ae.getSt()) != null) {
            sb.append("St=").append(state.getValue()).append("|");
        }
        if ((postalCode = ae.getPostalCode()) != null) {
            sb.append("PostalCode=").append(postalCode.getValue()).append("|");
        }
        if ((country = ae.getC()) != null) {
            sb.append("C=").append(country.getValue()).append("|");
        }
        return sb.toString();
    }

    private String modifyAddress(String entry, AddressElement ae) {
        StringBuffer sb = new StringBuffer(100);
        StringTokenizer st = new StringTokenizer(entry, "|");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("PostalAddress")) {
                if (ae == null) continue;
                DSTString postalAddress = ae.getPostalAddress();
                if (postalAddress != null) {
                    sb.append("PostalAddress").append("=").append(postalAddress.getValue()).append("|");
                    continue;
                }
                sb.append(token).append("|");
                continue;
            }
            if (token.startsWith("PostalCode")) {
                if (ae == null) continue;
                DSTString postalCode = ae.getPostalCode();
                if (postalCode != null) {
                    sb.append("PostalCode").append("=").append(postalCode.getValue()).append("|");
                    continue;
                }
                sb.append(token).append("|");
                continue;
            }
            if (token.startsWith("L")) {
                if (ae == null) continue;
                DSTString city = ae.getL();
                if (city != null) {
                    sb.append("L").append("=").append(city.getValue()).append("|");
                    continue;
                }
                sb.append(token).append("|");
                continue;
            }
            if (token.startsWith("St")) {
                if (ae == null) continue;
                DSTString state = ae.getSt();
                if (state != null) {
                    sb.append("St").append("=").append(state.getValue()).append("|");
                    continue;
                }
                sb.append(token).append("|");
                continue;
            }
            if (token.startsWith("C")) {
                if (ae == null) continue;
                DSTString country = ae.getC();
                if (country != null) {
                    sb.append("C").append("=").append(country.getValue()).append("|");
                    continue;
                }
                sb.append(token).append("|");
                continue;
            }
            sb.append(token).append("|");
        }
        return sb.toString();
    }

    private String modifyAddressCard(String entry, AddressCardElement ace) {
        StringBuffer sb = new StringBuffer(100);
        AddressElement ae = (AddressElement)ace.getAddress();
        String address = this.modifyAddress(entry, ae);
        StringTokenizer st = new StringTokenizer(address, "|");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("Nick")) {
                DSTString nick = ace.getNick();
                if (nick != null) {
                    sb.append("Nick").append("=").append(nick.getValue()).append("|");
                    continue;
                }
                sb.append(token).append("|");
                continue;
            }
            if (token.startsWith("LComment")) {
                DSTString lComment = ace.getLComment();
                if (lComment != null) {
                    sb.append("LComment").append("=").append(lComment.getValue()).append("|");
                    continue;
                }
                sb.append(token).append("|");
                continue;
            }
            if (token.startsWith("id")) {
                String id = ace.getId();
                if (id == null) continue;
                sb.append("id").append("=").append(id).append("|");
                continue;
            }
            sb.append(token).append("|");
        }
        return sb.toString();
    }

    private Map getAddressMap() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.getAttributeMapper().getDSAttribute("AddressCard"));
        Map map = null;
        try {
            map = IDPPUtils.getUserAttributes(this.userDN, set);
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPAddressCard.getAddressMap: map" + map);
            }
        }
        catch (IDPPException ie) {
            IDPPUtils.debug.error("IDPPAddressCard.getAddressMap: Error", (Throwable)ie);
            return null;
        }
        Set values = (Set)map.get(this.getAttributeMapper().getDSAttribute("AddressCard").toLowerCase());
        HashMap<String, String> addressMap = new HashMap<String, String>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            String value = (String)iter.next();
            addressMap.put(this.getAddressType(value), value);
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPAddressCard.getAddressMap: address map " + addressMap);
        }
        return addressMap;
    }

    private Map setAddressMap(Map modifyMap) {
        Map existingMap = this.getAddressMap();
        Set keys = existingMap.keySet();
        HashSet<String> set = new HashSet<String>();
        if (keys != null && !keys.isEmpty()) {
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (modifyMap.containsKey(key)) {
                    String value = (String)modifyMap.get(key);
                    if (value.equals(REMOVE_CARD)) {
                        existingMap.remove(key);
                        continue;
                    }
                    set.add(value);
                    continue;
                }
                set.add((String)existingMap.get(key));
            }
        } else {
            set.addAll(modifyMap.values());
        }
        HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
        map.put(this.getAttributeMapper().getDSAttribute("AddressCard"), set);
        return map;
    }

    private String getAddressType(String value) {
        int index2;
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPAddressCard.getAddressType:  value=" + value);
        }
        if (value.indexOf("|") != -1) {
            StringTokenizer st = new StringTokenizer(value, "|");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.startsWith("AddrType")) continue;
                StringTokenizer tokenizer = new StringTokenizer(token, "=");
                tokenizer.nextToken();
                return tokenizer.nextToken();
            }
            return null;
        }
        int index = value.indexOf("AddrType");
        if (index != -1 && (index2 = (value = value.substring(index + 9)).indexOf("\"")) != -1) {
            value = value.substring(index2 + 1, value.length());
            value = value.substring(0, value.indexOf("\""));
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPAddressCard.getAddressType: address type:" + value);
            }
            return value;
        }
        return null;
    }

    public boolean hasBinaryAttributes() {
        return false;
    }
}

