/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp;

import com.sun.identity.liberty.ws.dst.DSTModification;
import com.sun.identity.liberty.ws.dst.DSTQueryItem;
import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.container.IDPPAddressCard;
import com.sun.identity.liberty.ws.idpp.container.IDPPCommonName;
import com.sun.identity.liberty.ws.idpp.container.IDPPDemographics;
import com.sun.identity.liberty.ws.idpp.container.IDPPEmergencyContact;
import com.sun.identity.liberty.ws.idpp.container.IDPPEmploymentIdentity;
import com.sun.identity.liberty.ws.idpp.container.IDPPEncryptKey;
import com.sun.identity.liberty.ws.idpp.container.IDPPExtensionContainer;
import com.sun.identity.liberty.ws.idpp.container.IDPPFacade;
import com.sun.identity.liberty.ws.idpp.container.IDPPInformalName;
import com.sun.identity.liberty.ws.idpp.container.IDPPLegalIdentity;
import com.sun.identity.liberty.ws.idpp.container.IDPPMsgContact;
import com.sun.identity.liberty.ws.idpp.container.IDPPSignKey;
import com.sun.identity.liberty.ws.idpp.plugin.IDPPContainer;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PersonalProfile {
    private static final String SLASH = "/";
    private static final String LEFTBR = "[";
    private static final String COLON = ":";
    private static IDPPServiceManager serviceManager = null;

    public PersonalProfile() {
        IDPPUtils.debug.message("PersonalProfile:Init");
    }

    public Map queryData(Object credential, String resourceID, List dstQueryItems, Map interactedData, Document request) throws IDPPException {
        IDPPUtils.debug.message("PersonalProfile: query init");
        if (credential == null || resourceID == null || dstQueryItems == null || request == null) {
            IDPPUtils.debug.error("PersonalProfile:queryData: null input");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        boolean sessionValid = false;
        try {
            sessionValid = SessionManager.getProvider().isValid(credential);
        }
        catch (SessionException se) {
            IDPPUtils.debug.error("PersonalProfile:queryData:Invalid WSCcredentials", (Throwable)((Object)se));
        }
        if (!sessionValid) {
            throw new IDPPException(IDPPUtils.bundle.getString("invalidWSCCredentials"));
        }
        String userDN = this.getUserDN(resourceID);
        if (userDN == null) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile: queryData:userDNis null for a given resourceID.");
            }
            throw new IDPPException(IDPPUtils.bundle.getString("noResourceID"));
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:queryData: userDN=" + userDN);
        }
        Map userMap = null;
        try {
            userMap = this.getUserData(userDN, dstQueryItems);
        }
        catch (IDPPException ie) {
            IDPPUtils.debug.error("PersonalProfile:queryData:Error whileretrieving user data.", (Throwable)ie);
            throw new IDPPException(ie);
        }
        if (userMap == null || userMap.isEmpty()) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile:queryData:no data:for the requested pp attributes.");
            }
            throw new IDPPException(IDPPUtils.bundle.getString("noData"));
        }
        if (interactedData != null && !interactedData.isEmpty()) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile.queryData():  Contents of Interaction Map " + interactedData.toString());
            }
            userMap = this.updateUserDataMap(userMap, interactedData);
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:queryData:requested Data " + userMap);
        }
        HashMap results = new HashMap();
        Iterator iter = dstQueryItems.iterator();
        while (iter.hasNext()) {
            IDPPContainer container;
            DSTQueryItem item = (DSTQueryItem)iter.next();
            ArrayList<Object> queryResults = new ArrayList<Object>();
            String queryExpression = item.getSelect();
            String ppContainer = this.getContainerFromSelect(queryExpression);
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile:queryData: Containerprocessing:" + ppContainer);
            }
            if (ppContainer == null || (container = this.getIDPPContainer(ppContainer, userDN)) == null) continue;
            Document xmlContainer = null;
            try {
                xmlContainer = container.toXMLDocument(userMap);
            }
            catch (IDPPException ie) {
                IDPPUtils.debug.error("PersonalProfile:queryData:Error whileconverting container to an XML document.", (Throwable)ie);
                throw new IDPPException(ie);
            }
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile:queryData: Containerxml doc:" + XMLUtils.print((Node)xmlContainer.getDocumentElement()));
            }
            Element element = request.getDocumentElement();
            element.setAttribute("xmlns:" + serviceManager.getPPExtensionPrefix(), "http://www.sun.com/identity/liberty/pp");
            queryExpression = this.replacePrefix(queryExpression);
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile:queryData: queryexpression before applying Xpath:" + queryExpression);
            }
            NodeList result = null;
            try {
                result = XPathAPI.selectNodeList(xmlContainer, queryExpression, element);
            }
            catch (Exception ex) {
                IDPPUtils.debug.error("PersonalProfile.queryData:Invalid expression.", (Throwable)ex);
                continue;
            }
            if (result == null || result.getLength() == 0) {
                IDPPUtils.debug.message("PersonalProfile.queryData:null result");
                continue;
            }
            for (int i = 0; i < result.getLength(); ++i) {
                Node n = result.item(i);
                try {
                    queryResults.add(IDPPUtils.getUnmarshaller().unmarshal(n));
                    continue;
                }
                catch (JAXBException je) {
                    IDPPUtils.debug.error("PersonalProfile:queryData:JAXBError while unmarshalling the results.", (Throwable)je);
                }
            }
            results.put(item, queryResults);
        }
        return results;
    }

    private String replacePrefix(String select) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:replacePrefix:Select =" + select);
        }
        if (select == null || select.indexOf(SLASH) == -1) {
            IDPPUtils.debug.error("PersonalProfile:replacePrefix:Invalid expression.");
            return select;
        }
        StringBuffer sb = new StringBuffer(100);
        StringTokenizer st = new StringTokenizer(select, SLASH);
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            int i = temp.indexOf(COLON);
            if (i != -1) {
                temp = temp.substring(i + 1);
            }
            if (temp != null && temp.indexOf("PPISExtension") != -1) {
                sb.append(SLASH).append(serviceManager.getPPExtensionPrefix());
                sb.append(COLON).append(temp);
                continue;
            }
            if (temp == null) continue;
            sb.append(SLASH).append(serviceManager.getIDPPPrefix());
            sb.append(COLON).append(temp);
        }
        return sb.toString();
    }

    private String getContainerFromSelect(String selectExpression) {
        StringTokenizer st;
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:getContainerFromSel:Init: selectexpression: " + selectExpression);
        }
        if ((st = new StringTokenizer(selectExpression, SLASH)) == null) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile:getContainerFrom Invalid select expression.");
            }
            return selectExpression;
        }
        if (st.countTokens() == 1) {
            return "PP";
        }
        st.nextToken();
        String container = st.nextToken();
        int i = container.indexOf(LEFTBR);
        if (i != -1) {
            container = container.substring(0, i);
        }
        if (container == null) {
            return selectExpression;
        }
        i = container.indexOf(COLON);
        if (i != -1) {
            container = container.substring(i + 1, container.length());
        }
        return container;
    }

    private IDPPContainer getIDPPContainer(String ppContainer, String userDN) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:getIDPPContainer:Init: ContainerType: " + ppContainer);
        }
        if (ppContainer == null) {
            return null;
        }
        IDPPContainer container = null;
        Map containerClasses = serviceManager.getContainerClasses();
        if (containerClasses.containsKey(ppContainer)) {
            container = (IDPPContainer)containerClasses.get(ppContainer);
            container.setUserDN(userDN);
            return container;
        }
        int containerType = IDPPUtils.getIDPPElementType(ppContainer);
        switch (containerType) {
            case 1: {
                break;
            }
            case 4: {
                container = new IDPPCommonName();
                break;
            }
            case 2: {
                container = new IDPPInformalName();
                break;
            }
            case 5: {
                container = new IDPPLegalIdentity();
                break;
            }
            case 6: {
                container = new IDPPEmploymentIdentity();
                break;
            }
            case 11: {
                container = new IDPPSignKey();
                break;
            }
            case 12: {
                container = new IDPPEncryptKey();
                break;
            }
            case 33: {
                container = new IDPPExtensionContainer();
                break;
            }
            case 7: {
                container = new IDPPAddressCard();
                break;
            }
            case 8: {
                container = new IDPPMsgContact();
                break;
            }
            case 9: {
                container = new IDPPFacade();
                break;
            }
            case 10: {
                container = new IDPPDemographics();
                break;
            }
            case 13: {
                container = new IDPPEmergencyContact();
                break;
            }
            default: {
                IDPPUtils.debug.error("PersonalProfile:getIDPPContainer:Invalid container type");
            }
        }
        container.setUserDN(userDN);
        return container;
    }

    private Map getUserData(String userDN, List dstQueryItems) throws IDPPException {
        if (userDN == null || dstQueryItems == null) {
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        HashMap userMap = new HashMap();
        HashSet querySet = new HashSet();
        Iterator iter = dstQueryItems.iterator();
        while (iter.hasNext()) {
            IDPPContainer container;
            DSTQueryItem item = (DSTQueryItem)iter.next();
            String queryExpression = item.getSelect();
            String ppContainer = this.getContainerFromSelect(queryExpression);
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile:getUserData: Containerprocessing:" + ppContainer);
            }
            if (ppContainer == null || (container = this.getIDPPContainer(ppContainer, userDN)) == null) continue;
            Set attrs = container.getContainerAttributes();
            if (container.hasBinaryAttributes()) {
                try {
                    Map tmpMap = IDPPUtils.getUserAttributes(userDN, attrs);
                    this.addToMapWithLowerCaseKey(userMap, tmpMap);
                    continue;
                }
                catch (Exception ex) {
                    IDPPUtils.debug.error("PersonalProfile.getUserData:: Error in retrieving the data", (Throwable)ex);
                    throw new IDPPException(ex);
                }
            }
            if (attrs == null || attrs.isEmpty()) continue;
            querySet.addAll(attrs);
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:getUserData: Attributes to be retrieved." + querySet);
        }
        if (querySet != null && !querySet.isEmpty()) {
            try {
                Map tmpMap = IDPPUtils.getUserAttributes(userDN, querySet);
                this.addToMapWithLowerCaseKey(userMap, tmpMap);
            }
            catch (Exception ex) {
                IDPPUtils.debug.error("PersonalProfile.getUserData:: Error in retrieving the data", (Throwable)ex);
                throw new IDPPException(ex);
            }
        }
        return userMap;
    }

    public boolean modifyData(Object credential, String resourceID, List dstModifications, Map interactedData, Document request) throws IDPPException {
        if (credential == null || resourceID == null || dstModifications == null || dstModifications.isEmpty()) {
            IDPPUtils.debug.error("PersonalProfile:modifyData:null input");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParamters"));
        }
        boolean sessionValid = false;
        try {
            sessionValid = SessionManager.getProvider().isValid(credential);
        }
        catch (SessionException se) {
            IDPPUtils.debug.error("PersonalProfile:modifyData:Invalid WSCcredentials", (Throwable)((Object)se));
        }
        if (!sessionValid) {
            throw new IDPPException(IDPPUtils.bundle.getString("invalidWSCCredentials"));
        }
        String userDN = this.getUserDN(resourceID);
        if (userDN == null) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile: modifyData:userDNis null for a given resourceID.");
            }
            throw new IDPPException(IDPPUtils.bundle.getString("noResourceID"));
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:modifyData:userDN =" + userDN);
        }
        Map modifyMap = new HashMap();
        Map binaryAttributeMap = new HashMap();
        Iterator iter = dstModifications.iterator();
        while (iter.hasNext()) {
            DSTModification modification = (DSTModification)iter.next();
            String select = modification.getSelect();
            boolean override = modification.isOverrideAllowed();
            List dataObject = modification.getNewDataValue();
            String containerContext = this.getContainerFromSelect(select);
            IDPPContainer container = this.getIDPPContainer(containerContext, userDN);
            if (container == null) {
                if (IDPPUtils.debug.messageEnabled()) {
                    IDPPUtils.debug.message("PersonalProfile:modifyData:The given select expression is not in supported containers");
                }
                return false;
            }
            try {
                if (!override && IDPPUtils.checkForUserAttributes(userDN, container.getContainerAttributesForSelect(select))) {
                    if (IDPPUtils.debug.messageEnabled()) {
                        IDPPUtils.debug.message("PersonalProfile:modifyData:override set to false and data Already exists.");
                    }
                    return false;
                }
                Map map = container.getDataMapForSelect(select, dataObject);
                if (container.hasBinaryAttributes()) {
                    binaryAttributeMap = map;
                    continue;
                }
                if (map != null) {
                    modifyMap.putAll(map);
                }
                if (interactedData == null || interactedData.isEmpty()) continue;
                modifyMap = this.updateUserDataMap(modifyMap, interactedData);
            }
            catch (IDPPException ie) {
                IDPPUtils.debug.error("PersonalProfile:modifyData: error whileconverting the data into a data map.", (Throwable)ie);
                return false;
            }
        }
        if (binaryAttributeMap != null && !binaryAttributeMap.isEmpty()) {
            try {
                IDPPUtils.setUserAttributes(userDN, binaryAttributeMap);
            }
            catch (Exception ie) {
                IDPPUtils.debug.error("PersonalProfile:modifyMap:Error whilemodifying the user data.", (Throwable)ie);
                return false;
            }
        }
        if (modifyMap == null || modifyMap.isEmpty()) {
            IDPPUtils.debug.message("PersonalProfile:modifyData:map is null");
            return !binaryAttributeMap.isEmpty();
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:modifyData:data to be modified" + modifyMap);
        }
        try {
            IDPPUtils.setUserAttributes(userDN, modifyMap);
            return true;
        }
        catch (Exception ie) {
            IDPPUtils.debug.error("PersonalProfile:modifyMap:Error whilemodifying the user data.", (Throwable)ie);
            return false;
        }
    }

    public boolean isSelectDataSupported(String select) {
        IDPPUtils.debug.message("PersonalProfile:isSelectDataSupported:Init");
        String container = this.getContainerFromSelect(select);
        int index = container.indexOf(LEFTBR);
        if (index != -1) {
            container = container.substring(0, index);
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile.isSelectDataSupported:  Accessing container = " + container);
        }
        Set supportedContainers = serviceManager.getSupportedContainers();
        if (container == null || supportedContainers == null || supportedContainers.isEmpty()) {
            return false;
        }
        return supportedContainers.contains(container);
    }

    public boolean isResourceIDValid(String resourceID) {
        IDPPUtils.debug.message("PersonalProfile:isResourceIDValid:Init");
        ResourceIDMapper resourceIDMapper = serviceManager.getResourceIDMapper();
        if (resourceIDMapper == null) {
            if (IDPPUtils.debug.warningEnabled()) {
                IDPPUtils.debug.warning("PersonalProfile.isResourceIDValid.unable to get resoureid mapper");
            }
            return false;
        }
        String userID = resourceIDMapper.getUserID(serviceManager.getProviderID(), resourceID);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile.isResourceIDValid." + userID);
        }
        return IDPPUtils.isUserExists(userID);
    }

    public String getAuthZAction(Object credential, String action, String select, Map env) throws IDPPException {
        IDPPUtils.debug.message("PersonalProfile.getAuthorizationMap:Init");
        if (credential == null || action == null || select == null) {
            IDPPUtils.debug.error("PersonalProfile.getAuthZAction:null vals");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        if (action.equals("QUERY") && !serviceManager.isQueryPolicyEvalRequired()) {
            return "allow";
        }
        if (action.equals("MODIFY") && !serviceManager.isModifyPolicyEvalRequired()) {
            return "allow";
        }
        try {
            Authorizer authorizer = serviceManager.getAuthorizer();
            return (String)authorizer.getAuthorizationDecision(credential, action, select, env);
        }
        catch (Exception e) {
            IDPPUtils.debug.error("PersonalProfile.getAuthZAction:Exception while getting authorization info");
            throw new IDPPException(e);
        }
    }

    public String getUserDN(String resourceID) {
        IDPPUtils.debug.message("PersonalProfile:getUserDN:Init");
        ResourceIDMapper resourceIDMapper = serviceManager.getResourceIDMapper();
        if (resourceIDMapper == null) {
            return null;
        }
        return resourceIDMapper.getUserID(serviceManager.getProviderID(), resourceID);
    }

    private Map updateUserDataMap(Map userMap, Map interactedData) {
        if (interactedData == null || userMap == null || interactedData.isEmpty() || userMap.isEmpty()) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile.updateUserDataMap:Interacted data or the user data map is empty");
            }
            return userMap;
        }
        Iterator iter = interactedData.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!userMap.containsKey(key.toLowerCase())) {
                if (!IDPPUtils.debug.messageEnabled()) continue;
                IDPPUtils.debug.message("PersonalProfile.updateUserDataMap:Interacted key " + key + " isnotPart of the query");
                continue;
            }
            String attrValue = (String)interactedData.get(key);
            HashSet<String> set = new HashSet<String>();
            set.add(attrValue);
            userMap.put(key.toLowerCase(), set);
        }
        return userMap;
    }

    private void addToMapWithLowerCaseKey(Map dstMap, Map srcMap) {
        if (dstMap == null || srcMap == null || srcMap.isEmpty()) {
            return;
        }
        Iterator iter = srcMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            dstMap.put(key.toLowerCase(), srcMap.get(key));
        }
    }

    static {
        try {
            serviceManager = IDPPServiceManager.getInstance();
        }
        catch (Exception ex) {
            IDPPUtils.debug.error("PersonalProfile:Initialization failed", (Throwable)ex);
        }
    }
}

