/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp;

import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTModification;
import com.sun.identity.liberty.ws.dst.DSTQueryItem;
import com.sun.identity.liberty.ws.dst.service.DSTRequestHandler;
import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.PPInteractionHelper;
import com.sun.identity.liberty.ws.idpp.PersonalProfile;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.jaxb.ModifyElement;
import com.sun.identity.liberty.ws.idpp.jaxb.ModifyResponseElement;
import com.sun.identity.liberty.ws.idpp.jaxb.ModifyType;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryElement;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryResponseElement;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryResponseType;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryType;
import com.sun.identity.liberty.ws.idpp.jaxb.StatusType;
import com.sun.identity.liberty.ws.interaction.InteractionManager;
import com.sun.identity.liberty.ws.interaction.InteractionSOAPFaultException;
import com.sun.identity.liberty.ws.interaction.InteractionUtils;
import com.sun.identity.liberty.ws.interaction.JAXBObjectFactory;
import com.sun.identity.liberty.ws.interaction.jaxb.InquiryElement;
import com.sun.identity.liberty.ws.interaction.jaxb.InquiryType;
import com.sun.identity.liberty.ws.interaction.jaxb.InteractionResponseElement;
import com.sun.identity.liberty.ws.interaction.jaxb.TextElement;
import com.sun.identity.liberty.ws.interfaces.ServiceInstanceUpdate;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.NamespacePrefixMapperImpl;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFault;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultDetail;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.ServiceInstanceUpdateHeader;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PPRequestHandler
extends DSTRequestHandler {
    private PersonalProfile pp = new PersonalProfile();
    private String logMsg = null;

    public Object processDSTRequest(Object request, Message requestMsg, Message responseMsg) throws SOAPFaultException, DSTException {
        IDPPUtils.debug.message("PPRequestHandler:processRequest:Init");
        try {
            IDPPServiceManager serviceManager = IDPPServiceManager.getInstance();
            String providerID = serviceManager.getProviderID();
            ProviderHeader ph = new ProviderHeader(providerID);
            responseMsg.setProviderHeader(ph);
            if (serviceManager.isServiceInstanceUpdateEnabled()) {
                ServiceInstanceUpdateHeader siuHeader = this.getServiceInstanceUpdateHeader();
                responseMsg.setServiceInstanceUpdateHeader(siuHeader);
            }
            if (request instanceof QueryElement) {
                QueryElement query = (QueryElement)request;
                Document doc = IDPPUtils.getDocumentBuilder().newDocument();
                IDPPUtils.getMarshaller().setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
                IDPPUtils.getMarshaller().marshal((Object)query, (Node)doc);
                return this.processQueryRequest(query, providerID, requestMsg, doc);
            }
            if (request instanceof ModifyElement) {
                ModifyElement modify = (ModifyElement)request;
                Document doc = IDPPUtils.getDocumentBuilder().newDocument();
                IDPPUtils.getMarshaller().setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
                IDPPUtils.getMarshaller().marshal((Object)modify, (Node)doc);
                return this.processModifyRequest(modify, providerID, requestMsg, doc);
            }
            IDPPUtils.debug.error("PPRequestHandler:processRequest:invalid Request.");
            throw new DSTException(IDPPUtils.bundle.getString("invalidRequest"));
        }
        catch (IDPPException ie) {
            IDPPUtils.debug.error("PPRequestHandler:processRequest fail", (Throwable)ie);
            throw new DSTException(ie);
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("PPRequestHandler:processRequest fail", (Throwable)je);
            throw new DSTException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
        catch (SOAPBindingException sbe) {
            IDPPUtils.debug.error("PPRequestHandler:processRequest fail", (Throwable)sbe);
            throw new DSTException(sbe);
        }
    }

    public QueryResponseElement processQueryRequest(QueryElement query, String providerID, Message requestMsg, Document request) throws IDPPException, SOAPFaultException {
        Map queryResults;
        List data;
        List queryItems;
        Object resObj;
        IDPPUtils.debug.message("PPRequestHandler:processQueryRequest:Init");
        if (query == null || request == null) {
            IDPPUtils.debug.error("PPRequestHandler:processQueryRequest:null values ");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler:processQueryRequest:request received:" + XMLUtils.print((Node)request.getDocumentElement()));
        }
        if ((resObj = query.getResourceID()) == null) {
            resObj = query.getEncryptedResourceID();
        }
        QueryResponseElement response = this.getQueryResponse(query);
        String resourceID = this.getResourceID(resObj, providerID, "urn:liberty:id-sis-pp:2003-08");
        if (resourceID == null || !this.pp.isResourceIDValid(resourceID)) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPRequestHandler:processQueryRequest: resource id is invalid.");
            }
            response.setStatus(this.setStatusType(false, "InvalidResourceID", IDPPUtils.bundle.getString("invalidResourceID"), null));
            return response;
        }
        if (LogUtil.isLogEnabled()) {
            this.logMsg = IDPPUtils.bundle.getString("messageID") + "=" + requestMsg.getCorrelationHeader().getMessageID() + " " + IDPPUtils.bundle.getString("providerID") + "=" + providerID + " " + IDPPUtils.bundle.getString("resourceID") + "=" + resourceID + " " + IDPPUtils.bundle.getString("securityMechID") + "=" + requestMsg.getAuthenticationMechanism() + " ";
        }
        if ((queryItems = query.getQueryItem()).size() == 0) {
            if (IDPPUtils.debug.warningEnabled()) {
                IDPPUtils.debug.warning("PPRequestHandler:processQueryRequest: The request does not have any query items.");
            }
            response.setStatus(this.setStatusType(false, "UnexpectedError", IDPPUtils.bundle.getString("nullQueryItems"), null));
            return response;
        }
        HashMap<String, String> interactQueries = new HashMap<String, String>();
        HashMap interactedData = new HashMap();
        ArrayList<DSTQueryItem> dstQueryItems = new ArrayList<DSTQueryItem>();
        int queryItemsSize = queryItems.size();
        for (int i = 0; i < queryItemsSize; ++i) {
            String[] data2;
            boolean isQueryItemValid = true;
            QueryType.QueryItemType item = (QueryType.QueryItemType)queryItems.get(i);
            String select = item.getSelect();
            String ref = item.getItemID();
            if (ref == null || ref.length() == 0) {
                ref = item.getId();
            }
            if (select == null || select.length() == 0) {
                if (IDPPUtils.debug.warningEnabled()) {
                    IDPPUtils.debug.warning("PPRequestHandler:processQueryRequest: There is no Select in the request.");
                }
                response.setStatus(this.setStatusType(false, "MissingSelect", IDPPUtils.bundle.getString("missingSelect"), ref));
                isQueryItemValid = false;
            }
            if (!this.pp.isSelectDataSupported(select)) {
                if (IDPPUtils.debug.warningEnabled()) {
                    IDPPUtils.debug.warning("PPRequestHandler:processQueryRequest: Data not supported");
                }
                response.setStatus(this.setStatusType(false, "InvalidSelect", IDPPUtils.bundle.getString("invalidSelect"), ref));
                isQueryItemValid = false;
            }
            String resource = IDPPUtils.getResourceExpression(select);
            String authZAction = this.pp.getAuthZAction(requestMsg.getToken(), "QUERY", resource, this.getPolicyEnvMap(resourceID, requestMsg));
            if (authZAction == null || authZAction.equalsIgnoreCase("deny")) {
                response.setStatus(this.setStatusType(false, "ActionNotAuthorized", IDPPUtils.bundle.getString("notAuthorized"), ref));
                if (!LogUtil.isLogEnabled()) continue;
                data2 = new String[]{resourceID};
                LogUtil.error(Level.INFO, "PP_Query_Failure", data2);
                continue;
            }
            if (authZAction.equalsIgnoreCase("interactForConsent")) {
                if (this.isInteractionResponseExists(requestMsg)) {
                    if (!this.processInteractionConsentResponse(true, requestMsg, select)) {
                        if (LogUtil.isLogEnabled()) {
                            data2 = new String[]{resourceID};
                            LogUtil.error(Level.INFO, "PP_Interaction_Failure", data2);
                        }
                        response.setStatus(this.setStatusType(false, "ActionNotAuthorized", IDPPUtils.bundle.getString("interactionFailed"), ref));
                        isQueryItemValid = false;
                    }
                } else {
                    interactQueries.put(resource, authZAction);
                }
            } else if (authZAction.equalsIgnoreCase("interactForValue")) {
                if (this.isInteractionResponseExists(requestMsg)) {
                    Map intrData = this.processInteractionValueResponse(true, requestMsg, select);
                    if (intrData == null || intrData.isEmpty()) {
                        if (LogUtil.isLogEnabled()) {
                            String[] data3 = new String[]{resourceID};
                            LogUtil.error(Level.INFO, "PP_Interaction_Failure", data3);
                        }
                        response.setStatus(this.setStatusType(false, "ActionNotAuthorized", IDPPUtils.bundle.getString("interactionFailed"), ref));
                        isQueryItemValid = false;
                    } else {
                        interactedData.putAll(intrData);
                    }
                } else {
                    interactQueries.put(resource, authZAction);
                }
            }
            if (!isQueryItemValid) continue;
            Calendar changedSince = item.getChangedSince();
            Date date = null;
            if (changedSince != null) {
                date = changedSince.getTime();
            }
            DSTQueryItem dstQueryItem = new DSTQueryItem(select, item.isIncludeCommonAttributes(), date, null);
            dstQueryItem.setId(item.getId());
            dstQueryItem.setItemID(item.getItemID());
            dstQueryItems.add(dstQueryItem);
        }
        if (interactQueries != null && !interactQueries.isEmpty()) {
            this.initInteraction(true, interactQueries, requestMsg);
        }
        if ((data = this.getData(queryResults = this.pp.queryData(requestMsg.getToken(), resourceID, dstQueryItems, interactedData, request))) != null && !data.isEmpty()) {
            response.getData().addAll(data);
        }
        if (LogUtil.isLogEnabled()) {
            String[] msgData = new String[]{resourceID};
            LogUtil.access(Level.INFO, "PP_Query_Success", msgData);
        }
        return response;
    }

    private List getData(Map queryResults) throws IDPPException {
        IDPPUtils.debug.message("PPRequestHandler:getData:Init");
        ArrayList<QueryResponseType.DataType> dataResults = new ArrayList<QueryResponseType.DataType>();
        Set queryItems = queryResults.keySet();
        Iterator iter = queryItems.iterator();
        while (iter.hasNext()) {
            QueryResponseType.DataType data = null;
            try {
                data = IDPPUtils.getIDPPFactory().createQueryResponseTypeDataType();
            }
            catch (JAXBException je) {
                IDPPUtils.debug.error("PPRequestHandler:getData:jaxb fail", (Throwable)je);
                throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
            }
            DSTQueryItem dstQueryItem = (DSTQueryItem)iter.next();
            List values = (List)queryResults.get(dstQueryItem);
            if (values.isEmpty()) continue;
            data.getAny().addAll(values);
            data.setItemIDRef(dstQueryItem.getItemID());
            data.setId(dstQueryItem.getId());
            dataResults.add(data);
        }
        return dataResults;
    }

    private StatusType setStatusType(boolean success, String statusCode, String comment, String ref) throws IDPPException {
        IDPPUtils.debug.message("PPRequestHandler:setStatusType:Init");
        if (statusCode == null) {
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            StatusType status = IDPPUtils.getIDPPFactory().createStatusType();
            if (success) {
                QName qName = new QName("urn:liberty:id-sis-pp:2003-08", statusCode);
                status.setCode(qName);
            } else {
                QName qName = new QName("urn:liberty:id-sis-pp:2003-08", "Failed");
                status.setCode(qName);
                StatusType secondStatus = IDPPUtils.getIDPPFactory().createStatusType();
                QName secondQ = new QName("urn:liberty:id-sis-pp:2003-08", statusCode);
                secondStatus.setCode(secondQ);
                if (comment != null) {
                    secondStatus.setComment(comment);
                }
                if (ref != null) {
                    secondStatus.setRef(ref);
                }
                status.getStatus().add(secondStatus);
            }
            return status;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("PPRequestHandler:setStatusType:jaxb failure:", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public ModifyResponseElement processModifyRequest(ModifyElement modify, String providerID, Message requestMsg, Document request) throws IDPPException, SOAPFaultException {
        List modificationElements;
        String resourceID;
        IDPPUtils.debug.message("PPRequestHandler:processModifyRequest:Init");
        if (modify == null) {
            IDPPUtils.debug.error("PPRequestHandler:processModifyRequest. null values");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler:processModifyRequest:request received:" + XMLUtils.print((Node)request.getDocumentElement()));
        }
        HashMap interactedData = new HashMap();
        ModifyResponseElement response = this.getModifyResponse(modify);
        Object resObj = modify.getResourceID();
        if (resObj == null) {
            resObj = modify.getEncryptedResourceID();
        }
        if ((resourceID = this.getResourceID(resObj, providerID, "urn:liberty:id-sis-pp:2003-08")) == null || !this.pp.isResourceIDValid(resourceID)) {
            if (IDPPUtils.debug.warningEnabled()) {
                IDPPUtils.debug.warning("PPRequestHandler:processModifyRequest: resource id is invalid.");
            }
            response.setStatus(this.setStatusType(false, "InvalidResourceID", IDPPUtils.bundle.getString("invalidResourceID"), null));
            return response;
        }
        if (LogUtil.isLogEnabled()) {
            this.logMsg = IDPPUtils.bundle.getString("messageID") + "=" + requestMsg.getCorrelationHeader().getMessageID() + " " + IDPPUtils.bundle.getString("providerID") + "=" + providerID + " " + IDPPUtils.bundle.getString("resourceID") + "=" + resourceID + " " + IDPPUtils.bundle.getString("securityMechID") + "=" + requestMsg.getAuthenticationMechanism() + " ";
        }
        if ((modificationElements = modify.getModification()).size() == 0) {
            IDPPUtils.debug.error("PPRequestHandler:processModifyRequest: Modification elements are null");
            response.setStatus(this.setStatusType(false, "UnexpectedError", IDPPUtils.bundle.getString("nullModifications"), null));
            return response;
        }
        HashMap<String, String> interactSelects = new HashMap<String, String>();
        ArrayList<DSTModification> dstModifications = new ArrayList<DSTModification>();
        int size = modificationElements.size();
        for (int i = 0; i < size; ++i) {
            ModifyType.ModificationType modificationType = (ModifyType.ModificationType)modificationElements.get(i);
            String select = modificationType.getSelect();
            String ref = modificationType.getId();
            if (select == null || select.length() == 0) {
                if (IDPPUtils.debug.warningEnabled()) {
                    IDPPUtils.debug.warning("PersonalProfileService:processModifyRequest: select is null");
                }
                response.setStatus(this.setStatusType(false, "MissingSelect", IDPPUtils.bundle.getString("missingSelect"), ref));
                return response;
            }
            if (!this.pp.isSelectDataSupported(select)) {
                if (IDPPUtils.debug.warningEnabled()) {
                    IDPPUtils.debug.warning("PersonalProfileService:processModifyRequest: Data not supported");
                }
                response.setStatus(this.setStatusType(false, "InvalidSelect", IDPPUtils.bundle.getString("invalidSelect"), ref));
                return response;
            }
            String resource = IDPPUtils.getResourceExpression(select);
            String authZAction = this.pp.getAuthZAction(requestMsg.getToken(), "MODIFY", resource, this.getPolicyEnvMap(resourceID, requestMsg));
            if (authZAction == null || authZAction.equalsIgnoreCase("deny")) {
                response.setStatus(this.setStatusType(false, "ActionNotAuthorized", IDPPUtils.bundle.getString("notAuthorized"), ref));
                if (LogUtil.isLogEnabled()) {
                    String[] data = new String[]{resourceID};
                    LogUtil.error(Level.INFO, "PP_Modify_Failure", data);
                }
                return response;
            }
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPRequestHandler.processModifyRequest: Authorization action" + authZAction);
            }
            if (authZAction.equalsIgnoreCase("interactForConsent")) {
                if (this.isInteractionResponseExists(requestMsg)) {
                    if (!this.processInteractionConsentResponse(false, requestMsg, select)) {
                        if (LogUtil.isLogEnabled()) {
                            String[] data = new String[]{resourceID};
                            LogUtil.error(Level.INFO, "PP_Interaction_Failure", data);
                        }
                        response.setStatus(this.setStatusType(false, "ActionNotAuthorized", IDPPUtils.bundle.getString("interactionFailed"), ref));
                        return response;
                    }
                } else {
                    interactSelects.put(resource, authZAction);
                }
            } else if (authZAction.equalsIgnoreCase("interactForValue")) {
                if (this.isInteractionResponseExists(requestMsg)) {
                    Map intrData = this.processInteractionValueResponse(false, requestMsg, select);
                    if (intrData == null || intrData.isEmpty()) {
                        if (LogUtil.isLogEnabled()) {
                            String[] data = new String[]{resourceID};
                            LogUtil.error(Level.INFO, "PP_Interaction_Failure", data);
                        }
                        response.setStatus(this.setStatusType(false, "ActionNotAuthorized", IDPPUtils.bundle.getString("interactionFailed"), ref));
                        return response;
                    }
                    interactedData.putAll(intrData);
                } else {
                    interactSelects.put(resource, authZAction);
                }
            }
            boolean override = modificationType.isOverrideAllowed();
            ModifyType.ModificationType.NewDataType newData = modificationType.getNewData();
            DSTModification dstModification = new DSTModification();
            dstModification.setSelect(select);
            dstModification.setOverrideAllowed(override);
            dstModification.setId(modificationType.getId());
            dstModifications.add(dstModification);
            if (newData == null || newData.getAny() == null || newData.getAny().size() == 0) continue;
            dstModification.setNewDataValue(newData.getAny());
        }
        if (interactSelects != null && !interactSelects.isEmpty()) {
            this.initInteraction(false, interactSelects, requestMsg);
        }
        if (this.pp.modifyData(requestMsg.getToken(), resourceID, dstModifications, interactedData, request)) {
            if (LogUtil.isLogEnabled()) {
                String[] data = new String[]{resourceID};
                LogUtil.access(Level.INFO, "PP_Modify_Success", data);
            }
            return response;
        }
        response.setStatus(this.setStatusType(false, "UnexpectedError", IDPPUtils.bundle.getString("modifyFailed"), null));
        if (LogUtil.isLogEnabled()) {
            String[] data = new String[]{this.logMsg};
            LogUtil.error(Level.INFO, "PP_Modify_Failure", data);
        }
        return response;
    }

    private Map getPolicyEnvMap(String resourceID, Message requestMsg) {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("message", requestMsg);
        env.put("userID", this.pp.getUserDN(resourceID));
        env.put("authType", requestMsg.getAuthenticationMechanism());
        return env;
    }

    public QueryResponseElement getQueryResponse(QueryElement query) throws IDPPException {
        if (query == null) {
            IDPPUtils.debug.error("PPRequestHandler:getQueryResponse:Query is null.");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            QueryResponseElement response = IDPPUtils.getIDPPFactory().createQueryResponseElement();
            response.setStatus(this.setStatusType(true, "OK", null, null));
            response.setId(SAMLUtils.generateID());
            response.setItemIDRef(query.getItemID());
            return response;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("PPRequestHandler:getQueryResponse:JAXB failure.", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public ModifyResponseElement getModifyResponse(ModifyElement modify) throws IDPPException {
        if (modify == null) {
            IDPPUtils.debug.error("PPRequestHandler:getModifyResponse:Modify is null.");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            ModifyResponseElement response = IDPPUtils.getIDPPFactory().createModifyResponseElement();
            response.setStatus(this.setStatusType(true, "OK", null, null));
            response.setId(SAMLUtils.generateID());
            response.setItemIDRef(modify.getItemID());
            return response;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("PPRequestHandler:getModifyResponse:JAXB failure.", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    private boolean isInteractionResponseExists(Message msg) {
        try {
            return InteractionManager.getInstance().getInteractionResponseElement(msg) != null;
        }
        catch (Exception e) {
            IDPPUtils.debug.error("PPRequestHandler.isInteractionResponseExists: Exception while getting interaction response.", (Throwable)e);
            return false;
        }
    }

    private void initInteraction(boolean isQuery, Map interactResourceMap, Message msg) throws SOAPFaultException, IDPPException {
        IDPPUtils.debug.message("PPRequestHandler.initInteraction:Init");
        if (msg == null || interactResourceMap == null || interactResourceMap.isEmpty()) {
            IDPPUtils.debug.error("PPRequestHandler.initInteraction:NullInput parameters");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            InquiryElement inquiry = JAXBObjectFactory.getObjectFactory().createInquiryElement();
            inquiry.setTitle(IDPPUtils.bundle.getString("interactionTitle"));
            List selectElements = inquiry.getSelectOrConfirmOrText();
            Set inquirySelects = interactResourceMap.keySet();
            Iterator iter = inquirySelects.iterator();
            while (iter.hasNext()) {
                String resource = (String)iter.next();
                String interactionType = (String)interactResourceMap.get(resource);
                if (interactionType.equals("interactForConsent")) {
                    selectElements.add(this.getInteractConfirmElement(isQuery, resource, msg));
                    continue;
                }
                if (!interactionType.equals("interactForValue")) continue;
                selectElements.addAll(this.getInteractTextElements(isQuery, resource, msg));
            }
            String lang = this.getLanguage(msg);
            if (LogUtil.isLogEnabled()) {
                String[] data = new String[]{this.logMsg};
                LogUtil.access(Level.INFO, "PP_Interaction_Success", data);
            }
            InteractionManager.getInstance().handleInteraction(msg, inquiry, lang);
        }
        catch (InteractionSOAPFaultException ise) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPRequestHandler.initInteraction:Interact redirection happened");
            }
            throw ise.getSOAPFaultException();
        }
        catch (Exception ex) {
            IDPPUtils.debug.error("PPRequestHandler.initInteraction:Failed");
            throw new IDPPException(ex);
        }
    }

    private InquiryType.Confirm getInteractConfirmElement(boolean isQuery, String resource, Message msg) throws IDPPException {
        if (resource == null) {
            IDPPUtils.debug.error("PPRequestHandler.getInteractConfirmElement:Null input:");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        resource = IDPPUtils.getExpressionContext(resource);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.getInteractConfirm:Resource Context:" + resource);
        }
        try {
            InquiryType.Confirm confirmElement = JAXBObjectFactory.getObjectFactory().createInquiryTypeConfirm();
            PPInteractionHelper helper = new PPInteractionHelper(this.getLanguage(msg));
            confirmElement.setName(resource);
            confirmElement.setLabel(helper.getInteractForConsentQuestion(isQuery, resource));
            confirmElement.setHint(helper.getInteractForConsentQuestion(isQuery, resource));
            return confirmElement;
        }
        catch (Exception e) {
            IDPPUtils.debug.error("PPRequestHandler.getInteractConfirm:Exception while creating interact select.", (Throwable)e);
            throw new IDPPException(e);
        }
    }

    private List getInteractTextElements(boolean isQuery, String resource, Message msg) throws IDPPException {
        if (resource == null) {
            IDPPUtils.debug.error("PPRequestHandler.getInteractText:Null input:");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        resource = IDPPUtils.getExpressionContext(resource);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.getInteractText:Resource Context:" + resource);
        }
        try {
            ArrayList<TextElement> textElements = new ArrayList<TextElement>();
            PPInteractionHelper helper = new PPInteractionHelper(this.getLanguage(msg));
            Map interactQueries = helper.getInteractForValueQuestions(isQuery, resource);
            Iterator iter = interactQueries.keySet().iterator();
            while (iter.hasNext()) {
                String resourceKey = (String)iter.next();
                TextElement textElement = JAXBObjectFactory.getObjectFactory().createTextElement();
                textElement.setName(resourceKey);
                textElement.setLabel((String)interactQueries.get(resourceKey));
                textElement.setMinChars(helper.getTextMinChars(resourceKey));
                textElement.setMaxChars(helper.getTextMaxChars(resourceKey));
                textElements.add(textElement);
            }
            return textElements;
        }
        catch (Exception e) {
            IDPPUtils.debug.error("PPRequestHandler.getInteractText:Exception while creating interact text element.", (Throwable)e);
            throw new IDPPException(e);
        }
    }

    private boolean processInteractionConsentResponse(boolean isQuery, Message msg, String resource) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.processInteractionResponse:Init");
        }
        if (msg == null || resource == null) {
            IDPPUtils.debug.error("PPRequestHandler:processInteractionResponse:null input params");
            return false;
        }
        resource = IDPPUtils.getExpressionContext(resource);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler:processInteractionPP Element that was trying to access:" + resource);
        }
        try {
            InteractionResponseElement ire = InteractionManager.getInstance().getInteractionResponseElement(msg);
            if (ire == null) {
                return false;
            }
            Map responses = InteractionUtils.getParameters(ire);
            if (responses == null || responses.isEmpty()) {
                return false;
            }
            String value = (String)responses.get(resource);
            if (value == null || value.equals("false")) {
                if (IDPPUtils.debug.messageEnabled()) {
                    IDPPUtils.debug.message("PPRequestHandler.processInteraction: response is deny");
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            IDPPUtils.debug.error("PPRequestHandler.processInteractionResponse: Exception occured.", (Throwable)e);
            return false;
        }
    }

    private Map processInteractionValueResponse(boolean isQuery, Message msg, String resource) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.processInteractionResponse:Init");
        }
        if (msg == null || resource == null) {
            IDPPUtils.debug.error("PPRequestHandler:processInteractionResponse:null input params");
            return null;
        }
        resource = IDPPUtils.getExpressionContext(resource);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler:processInteractionPP Element that was trying to access:" + resource);
        }
        try {
            HashMap<String, String> interactedData = new HashMap<String, String>();
            InteractionResponseElement ire = InteractionManager.getInstance().getInteractionResponseElement(msg);
            if (ire == null) {
                return null;
            }
            Map responses = InteractionUtils.getParameters(ire);
            if (responses == null || responses.isEmpty()) {
                return null;
            }
            String lang = this.getLanguage(msg);
            PPInteractionHelper interactionHelper = new PPInteractionHelper(lang);
            Map queries = interactionHelper.getInteractForValueQuestions(isQuery, resource);
            Iterator iter = queries.keySet().iterator();
            while (iter.hasNext()) {
                String query = (String)iter.next();
                String value = (String)responses.get(query);
                if (value == null || value.length() == 0) continue;
                interactedData.put(interactionHelper.getPPAttribute(query), value);
            }
            return interactedData;
        }
        catch (Exception e) {
            IDPPUtils.debug.error("PPRequestHandler.processInteractionResponse: Exception occured.", (Throwable)e);
            return null;
        }
    }

    private String getLanguage(Message requestMsg) {
        List langHeaders = InteractionUtils.getInteractionLangauge(requestMsg);
        if (langHeaders == null || langHeaders.isEmpty()) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPRequestHandler.setLanguage: LanguageHeaders are empty in the interaction message.");
            }
            return null;
        }
        String lang = (String)langHeaders.iterator().next();
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.setLanguage:Lang:" + lang);
        }
        return lang;
    }

    private ServiceInstanceUpdateHeader getServiceInstanceUpdateHeader() throws SOAPFaultException {
        ServiceInstanceUpdate siu = IDPPServiceManager.getInstance().getServiceInstanceUpdate();
        ServiceInstanceUpdateHeader siuHeader = siu.getServiceInstanceUpdateHeader();
        if (siu.isSOAPFaultNeeded()) {
            QName faultCodeServer = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
            SOAPFaultDetail detail = new SOAPFaultDetail(SOAPFaultDetail.ENDPOINT_MOVED, null, null);
            SOAPFault sf = new SOAPFault(faultCodeServer, IDPPUtils.bundle.getString("endPointMoved"), null, detail);
            Message sfmsg = new Message(sf);
            sfmsg.setServiceInstanceUpdateHeader(siuHeader);
            SOAPFaultException sfe = new SOAPFaultException(sfmsg);
            throw sfe;
        }
        return siuHeader;
    }
}

