/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp;

import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.plugin.AttributeMapper;
import com.sun.identity.shared.locale.Locale;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class PPInteractionHelper {
    private ResourceBundle props = null;
    private static final String TEXT_MIN_CHARS = "textMinChars";
    private static final String TEXT_MAX_CHARS = " textMaxChars";
    private static String defaultMinChars = null;
    private static String defaultMaxChars = null;
    private static String idppProps = "libPersonalProfile";

    public PPInteractionHelper(String lang) {
        this.props = lang != null ? ResourceBundle.getBundle(idppProps, Locale.getLocaleObjFromAcceptLangHeader((String)lang)) : IDPPUtils.bundle;
        try {
            defaultMinChars = this.props.getString("defaultMinTextChars");
            defaultMaxChars = this.props.getString("defaultMaxTextChars");
        }
        catch (MissingResourceException mre) {
            IDPPUtils.debug.error("PPInteractHelper.Static: Could not find min or maximum text characters.", (Throwable)mre);
        }
    }

    public String getInteractForConsentQuestion(boolean isQuery, String ppElement) {
        try {
            if (isQuery) {
                return this.props.getString(ppElement + "_" + "Query" + "_" + "Consent" + "_" + "Question");
            }
            return this.props.getString(ppElement + "_" + "Modify" + "_" + "Consent" + "_" + "Question");
        }
        catch (MissingResourceException mre) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPRequestHandler.getInquiryQuestion:can not find question for:" + ppElement);
            }
            if (isQuery) {
                return this.props.getString("commonQueryConsentQuestion");
            }
            return this.props.getString("commonModifyConsentQuestion");
        }
    }

    public Map getInteractForValueQuestions(boolean isQuery, String ppElement) {
        HashMap<String, String> queries = new HashMap<String, String>();
        Set ppElements = this.getPPLeafElements(ppElement);
        if (ppElements == null || ppElements.size() == 0) {
            return queries;
        }
        if (ppElements.size() == 1) {
            String question = this.getInteractForValueQuestion(isQuery, ppElement);
            if (question == null) {
                return queries;
            }
            queries.put(ppElement, question);
            return queries;
        }
        Iterator iter = ppElements.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            String question = this.getInteractForValueQuestion(isQuery, element);
            if (question == null) continue;
            queries.put(element, question);
        }
        return queries;
    }

    public String getPPAttribute(String key) {
        AttributeMapper mapper = IDPPServiceManager.getInstance().getAttributeMapper();
        return mapper.getDSAttribute(key);
    }

    public BigInteger getTextMinChars(String resource) throws NumberFormatException {
        String minChars = null;
        try {
            minChars = this.props.getString(resource + "_" + TEXT_MIN_CHARS);
        }
        catch (MissingResourceException mre) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPInteractionHelper.getTextMinChars:Could not find min chars for " + resource);
            }
            minChars = defaultMinChars;
        }
        return new BigInteger(minChars);
    }

    public BigInteger getTextMaxChars(String resource) throws NumberFormatException {
        String maxChars = null;
        try {
            maxChars = this.props.getString(resource + "_" + TEXT_MAX_CHARS);
        }
        catch (MissingResourceException mre) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPInteractionHelper.getTextMinChars:Could not find min chars for " + resource);
            }
            maxChars = defaultMaxChars;
        }
        return new BigInteger(maxChars);
    }

    private String getInteractForValueQuestion(boolean isQuery, String ppElement) {
        try {
            if (isQuery) {
                return this.props.getString(ppElement + "_" + "Query" + "_" + "Value" + "_" + "Question");
            }
            return this.props.getString(ppElement + "_" + "Modify" + "_" + "Value" + "_" + "Question");
        }
        catch (MissingResourceException mre) {
            IDPPUtils.debug.error("PPInteractionHelper.getInteractForValueQuestion: No question found for " + ppElement, (Throwable)mre);
            return null;
        }
    }

    private Set getPPLeafElements(String ppElement) {
        HashSet<String> set = new HashSet<String>();
        if (ppElement == null) {
            return set;
        }
        if (ppElement.equals("CommonName")) {
            return PPInteractionHelper.getCommonNameElements();
        }
        if (ppElement.equals("InformalName")) {
            return PPInteractionHelper.getInformalNameElements();
        }
        if (ppElement.equals("EmploymentIdentity")) {
            return PPInteractionHelper.getEmploymentIdentityElements();
        }
        if (ppElement.equals("LegalIdentity")) {
            return PPInteractionHelper.getLegalIdentityElements();
        }
        if (ppElement.equals("Extension")) {
            return PPInteractionHelper.getExtensionElements();
        }
        set.add(ppElement);
        return set;
    }

    private static Set getCommonNameElements() {
        Set set = PPInteractionHelper.getAnalyzedNameElements();
        set.add("CN");
        set.add("AltCN");
        return set;
    }

    private static Set getAnalyzedNameElements() {
        HashSet<String> set = new HashSet<String>();
        set.add("FN");
        set.add("MN");
        set.add("SN");
        set.add("PersonalTitle");
        return set;
    }

    private static Set getInformalNameElements() {
        HashSet<String> set = new HashSet<String>();
        set.add("InformalName");
        return set;
    }

    private static Set getEmploymentIdentityElements() {
        HashSet<String> set = new HashSet<String>();
        set.add("JobTitle");
        set.add("O");
        set.add("AltO");
        return set;
    }

    private static Set getLegalIdentityElements() {
        Set set = PPInteractionHelper.getAnalyzedNameElements();
        set.add("LegalName");
        set.add("AltIDType");
        set.add("AltIDValue");
        set.add("Gender");
        set.add("DOB");
        set.add("MaritalStatus");
        set.add("IDType");
        set.add("IDValue");
        return set;
    }

    private static Set getExtensionElements() {
        return IDPPServiceManager.getInstance().getExtensionAttributes();
    }
}

