/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst.service;

import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptedResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.RequestHandler;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class DSTRequestHandler
implements RequestHandler {
    protected DSTRequestHandler() {
    }

    public Message processRequest(Message msg) throws SOAPFaultException, Exception {
        if (DSTUtils.debug.messageEnabled()) {
            DSTUtils.debug.message("DSTRequestHandler:processRequest:Request received: " + msg.toString());
        }
        List requestBodies = msg.getBodies();
        if ((requestBodies = Utils.convertElementToJAXB(requestBodies)) == null || requestBodies.size() == 0) {
            DSTUtils.debug.error("DSTRequestHandler:processRequest:SOAPBodies are null");
            throw new Exception(DSTUtils.bundle.getString("nullInputParams"));
        }
        Message response = null;
        int securityProfile = msg.getSecurityProfileType();
        response = securityProfile == 1 || securityProfile == 2 || securityProfile == 3 ? new Message(null, this.generateBinarySecurityToken(msg)) : new Message();
        response.setCorrelationHeader(msg.getCorrelationHeader());
        response.setWSFVersion(msg.getWSFVersion());
        List responseBodies = this.processSOAPBodies(requestBodies, msg, response);
        responseBodies = Utils.convertJAXBToElement(responseBodies);
        response.setSOAPBodies(responseBodies);
        if (DSTUtils.debug.messageEnabled()) {
            DSTUtils.debug.message("DSTRequestHandler:processRequest:returned response: " + response.toString());
        }
        return response;
    }

    private List processSOAPBodies(List requestBodies, Message msg, Message response) throws SOAPFaultException, DSTException {
        DSTUtils.debug.message("DSTRequestHandler:processSOAPBodies:Init");
        ArrayList<Object> responseBodies = new ArrayList<Object>();
        int size = requestBodies.size();
        for (int i = 0; i < size; ++i) {
            Object request = requestBodies.get(i);
            responseBodies.add(this.processDSTRequest(request, msg, response));
        }
        return responseBodies;
    }

    private BinarySecurityToken generateBinarySecurityToken(Message msg) throws DSTException {
        try {
            SecurityTokenManager manager = new SecurityTokenManager(msg.getToken());
            BinarySecurityToken binaryToken = manager.getX509CertificateToken();
            binaryToken.setWSFVersion(msg.getWSFVersion());
            return binaryToken;
        }
        catch (Exception e) {
            DSTUtils.debug.error("DSTRequestHandler:generateBinarySecurityToken: Error in generating binary security token.", (Throwable)e);
            throw new DSTException(e);
        }
    }

    public abstract Object processDSTRequest(Object var1, Message var2, Message var3) throws SOAPFaultException, DSTException;

    protected String getResourceID(Object resourceIDType, String providerID, String serviceType) {
        DSTUtils.debug.message("PPRequestHandler:getResourceID:Init");
        if (resourceIDType == null) {
            if (DSTUtils.debug.messageEnabled()) {
                DSTUtils.debug.message("PPRequestHandler:getResourceID:ResourceIDType is null");
            }
            return null;
        }
        if (resourceIDType instanceof ResourceIDType) {
            ResourceIDType resID = (ResourceIDType)resourceIDType;
            return resID.getValue();
        }
        if (resourceIDType instanceof EncryptedResourceIDType) {
            EncryptedResourceIDType encID = (EncryptedResourceIDType)resourceIDType;
            try {
                Document encDoc = XMLUtils.newDocument();
                DiscoUtils.getDiscoMarshaller().marshal((Object)encID, (Node)encDoc);
                if (DSTUtils.debug.messageEnabled()) {
                    DSTUtils.debug.message("PPRequestHandler.getResourceID:Encrypted ResourceID = " + XMLUtils.print((Node)encDoc));
                }
                EncryptedResourceID encryptedId = new EncryptedResourceID(encDoc.getDocumentElement(), serviceType);
                String resIDStr = EncryptedResourceID.getDecryptedResourceID(encryptedId, providerID).getResourceID();
                if (DSTUtils.debug.messageEnabled()) {
                    DSTUtils.debug.message("PPRequestHandler.getResourceID: ResourceID Value after decryption" + resIDStr);
                }
                return resIDStr;
            }
            catch (Exception ex) {
                DSTUtils.debug.error("PPRequestHandler.getResourceID:error", (Throwable)ex);
                return null;
            }
        }
        DSTUtils.debug.error("PPRequestHandler:getResourceID:invalidresource ID type.");
        return null;
    }
}

