/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.shared.DateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSTModifyResponse {
    private Status status;
    private Date timeStamp;
    private String id;
    private String itemIDRef;
    private List extension = new ArrayList();
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTModifyResponse() {
    }

    public DSTModifyResponse(Element element) throws DSTException {
        NodeList list;
        if (element == null) {
            DSTUtils.debug.error("DSTModifyResponse(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String elementName = element.getLocalName();
        if (elementName == null || !elementName.equals("ModifyResponse")) {
            DSTUtils.debug.error("DSTModifyResponse(element):Invalid element name");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTModifyResponse(element): NameSpace is not defined");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.prefix = element.getPrefix();
        this.id = element.getAttribute("id");
        this.itemIDRef = element.getAttribute("itemIDRef");
        String attrib = element.getAttribute("timeStamp");
        if (attrib != null && attrib.length() != 0) {
            try {
                this.timeStamp = DateUtils.stringToDate((String)attrib);
            }
            catch (ParseException ex) {
                DSTUtils.debug.error("DSTModifyResponse(element): can not parse the date", (Throwable)ex);
            }
        }
        if ((list = element.getChildNodes()) == null || list.getLength() == 0) {
            DSTUtils.debug.error("DSTModifyResponse(element): Response doesnot have status element.");
            throw new DSTException(DSTUtils.bundle.getString("noStatus"));
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            String nodeName = node.getLocalName();
            if (nodeName != null && nodeName.equals("Status")) {
                this.status = DSTUtils.parseStatus((Element)node);
                continue;
            }
            DSTUtils.debug.error("DSTModifyResponse(element): Response doeshave invalid element.");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        if (this.status == null) {
            DSTUtils.debug.error("DSTModifyResponse(element): Response doesnot have status element.");
            throw new DSTException(DSTUtils.bundle.getString("noStatus"));
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Date date) {
        this.timeStamp = date;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getItemIDRef() {
        return this.itemIDRef;
    }

    public void setItemIDRef(String value) {
        this.itemIDRef = value;
    }

    List getExtension() {
        return this.extension;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String nameSpace) {
        this.nameSpaceURI = nameSpace;
    }

    public void setNameSpacePrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        String tempPrefix = "";
        if (includeNS) {
            if (this.prefix == null) {
                this.prefix = "sis";
            }
            tempPrefix = this.prefix + ":";
        }
        if (declareNS && this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTModifyResponse.toString: NameSpace is not defined");
            return "";
        }
        StringBuffer sb = new StringBuffer(300);
        sb.append("<").append(tempPrefix).append("ModifyResponse");
        if (this.id != null && this.id.length() != 0) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        if (this.itemIDRef != null && this.itemIDRef.length() != 0) {
            sb.append(" itemIDRef=\"").append(this.itemIDRef).append("\"");
        }
        if (this.timeStamp != null) {
            sb.append(" timeStamp=\"").append(DateUtils.toUTCDateFormat((Date)this.timeStamp)).append("\"");
        }
        if (declareNS) {
            sb.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"").append(" xmlns=\"").append(this.nameSpaceURI).append("\"");
        }
        sb.append(">").append(this.status.toString()).append("</").append(tempPrefix).append("ModifyResponse").append(">");
        return sb.toString();
    }
}

