/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSTModification {
    private String id;
    private String select;
    private Date notChangedSince;
    private boolean overrideAllowed = false;
    private List newData = new ArrayList();
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTModification() {
    }

    public DSTModification(String select, Date notChangedSince, String serviceNS) {
        this.select = select;
        this.notChangedSince = notChangedSince;
        this.nameSpaceURI = serviceNS;
    }

    public DSTModification(Element element) throws DSTException {
        NodeList list;
        if (element == null) {
            DSTUtils.debug.error("DSTModification(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String elementName = element.getLocalName();
        if (elementName == null || !elementName.equals("Modification")) {
            DSTUtils.debug.error("DSTModification(element):Invalid elementName");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        this.prefix = element.getPrefix();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTModification(element): Namespace is null");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.id = element.getAttribute("id");
        String attr = element.getAttribute("overrideAllowed");
        if (attr != null) {
            this.overrideAllowed = Boolean.valueOf(attr);
        }
        if ((attr = element.getAttribute("notChangedSince")) != null && attr.length() != 0) {
            try {
                this.notChangedSince = DateUtils.stringToDate((String)attr);
            }
            catch (ParseException ex) {
                DSTUtils.debug.error("DSTModification(element): date can not be parsed.", (Throwable)ex);
            }
        }
        if ((list = element.getElementsByTagNameNS(this.nameSpaceURI, "Select")).getLength() != 1) {
            DSTUtils.debug.error("DSTModification(element): Select is null or more than one select found.");
            throw new DSTException(DSTUtils.bundle.getString("invalidSelect"));
        }
        this.select = XMLUtils.getElementValue((Element)((Element)list.item(0)));
        if (this.select == null) {
            DSTUtils.debug.error("DSTModification(element): Select is null");
            throw new DSTException(DSTUtils.bundle.getString("invalidSelect"));
        }
        NodeList newDataElements = element.getElementsByTagNameNS(this.nameSpaceURI, "NewData");
        if (newDataElements.getLength() != 1) {
            DSTUtils.debug.error("DSTModification(element): Modification cannot have more than one new data elements.");
            throw new DSTException(DSTUtils.bundle.getString("invalidNewData"));
        }
        Node newDataElement = newDataElements.item(0);
        NodeList dataElements = newDataElement.getChildNodes();
        int size = dataElements.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = dataElements.item(0);
            if (node.getNodeType() != 1) continue;
            this.newData.add((Element)node);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List getNewDataValue() {
        return this.newData;
    }

    public void setNewDataValue(List value) {
        if (value != null && !value.isEmpty()) {
            this.newData.addAll(value);
        }
    }

    public boolean isOverrideAllowed() {
        return this.overrideAllowed;
    }

    public void setOverrideAllowed(boolean value) {
        this.overrideAllowed = value;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String value) {
        this.select = value;
    }

    public Date getNotChangedSince() {
        return this.notChangedSince;
    }

    public void setNotChangedSince(Date value) {
        this.notChangedSince = value;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String nameSpace) {
        this.nameSpaceURI = nameSpace;
    }

    public void setNameSpacePrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        String tempPrefix = "";
        if (includeNS) {
            if (this.prefix == null) {
                this.prefix = "sis";
            }
            tempPrefix = this.prefix + ":";
        }
        if (declareNS && this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTModification.toString: Name Space is not defined");
            return "";
        }
        StringBuffer sb = new StringBuffer(300);
        sb.append("<").append(tempPrefix).append("Modification");
        if (this.id != null && this.id.length() != 0) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(" overrideAllowed=\"");
        if (this.overrideAllowed) {
            sb.append("true").append("\"");
        } else {
            sb.append("false").append("\"");
        }
        if (this.notChangedSince != null) {
            sb.append(" notChangedSince=\"").append(DateUtils.toUTCDateFormat((Date)this.notChangedSince)).append("\"");
        }
        if (declareNS) {
            sb.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"").append(" xmlns=\"").append(this.nameSpaceURI).append("\"");
        }
        sb.append(">").append("<").append(tempPrefix).append("Select").append(">").append(this.appendPrefix(this.select, this.prefix)).append("</").append(tempPrefix).append("Select").append(">").append("<").append(tempPrefix).append("NewData").append(">");
        Iterator iter = this.newData.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            sb.append(XMLUtils.print((Node)node));
        }
        sb.append("</").append(tempPrefix).append("NewData").append(">").append("</").append(tempPrefix).append("Modification").append(">");
        return sb.toString();
    }

    private String appendPrefix(String select, String prefix) {
        if (select.indexOf(":") != -1) {
            return select;
        }
        StringBuffer sb = new StringBuffer(100);
        StringTokenizer st = new StringTokenizer(select, "/");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            temp = "/" + prefix + ":" + temp;
            sb.append(temp);
        }
        return sb.toString();
    }
}

