/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSTData {
    private List dstData = new ArrayList();
    private String itemIDRef = null;
    private String id = null;
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTData(List data, String serviceNS) {
        if (data != null) {
            this.dstData.addAll(data);
        }
        this.nameSpaceURI = serviceNS;
    }

    public DSTData(Element element) throws DSTException {
        if (element == null) {
            DSTUtils.debug.error("DSTData(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String elementName = element.getLocalName();
        if (elementName == null || !elementName.equals("Data")) {
            DSTUtils.debug.error("DSTData(element):Invalid element name");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTData(element): NameSpace is not defined");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.prefix = element.getPrefix();
        this.id = element.getAttribute("id");
        this.itemIDRef = element.getAttribute("itemIDRef");
        NodeList list = element.getChildNodes();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node dataNode = list.item(i);
            if (dataNode.getNodeType() != 1) continue;
            this.dstData.add((Element)dataNode);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getItemIDRef() {
        return this.itemIDRef;
    }

    public void setItemIDRef(String ref) {
        this.itemIDRef = ref;
    }

    public List getData() {
        return this.dstData;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String nameSpace) {
        this.nameSpaceURI = nameSpace;
    }

    public void setNameSpacePrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        String tempPrefix = "";
        if (includeNS) {
            if (this.prefix == null) {
                this.prefix = "sis";
            }
            tempPrefix = this.prefix + ":";
        }
        if (declareNS && this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTData.toString: Name Space is not defined");
            return "";
        }
        StringBuffer sb = new StringBuffer(300);
        sb.append("<").append(tempPrefix).append("Data");
        if (this.id != null && this.id.length() != 0) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        if (this.itemIDRef != null && this.itemIDRef.length() != 0) {
            sb.append(" itemIDRef=\"").append(this.itemIDRef).append("\"");
        }
        if (declareNS) {
            sb.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"").append(" xmlns=\"").append(this.nameSpaceURI).append("\"");
        }
        sb.append(">");
        Iterator iter = this.dstData.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            sb.append(XMLUtils.print((Node)node));
        }
        sb.append("</").append(tempPrefix).append("Data").append(">");
        return sb.toString();
    }
}

