/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.common;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.liberty.ws.disco.plugins.Default64ResourceIDMapper;
import com.sun.identity.liberty.ws.disco.plugins.DiscoEntryHandler;
import com.sun.identity.liberty.ws.disco.plugins.NameIdentifierMapper;
import com.sun.identity.liberty.ws.disco.plugins.jaxb.DiscoEntryElement;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.plugin.configuration.ConfigurationActionEvent;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationListener;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class DiscoServiceManager
implements ConfigurationListener {
    private static final String DISCO_SERVICE = "sunIdentityServerDiscoveryService";
    private static final String ATTR_PROVIDER_ID = "sunIdentityServerDiscoProviderID";
    private static final String ATTR_SUPPORTED_AUTHN_MECHS = "sunIdentityServerDiscoSupportedAuthnMechs";
    private static final String ATTR_SUPPORTED_DIRECTIVE = "sunIdentityServerDiscoSupportedDirectives";
    private static final String ATTR_LOOKUP_NEED_POLICY = "sunIdentityServerDiscoLookupNeedPolicyEval";
    private static final String LOOKUP_NEED_POLICY_DEFAULT = "false";
    private static final String ATTR_UPDATE_NEED_POLICY = "sunIdentityServerDiscoUpdateNeedPolicyEval";
    private static final String UPDATE_NEED_POLICY_DEFAULT = "false";
    private static final String ATTR_AUTHORIZER = "sunIdentityServerDiscoAuthorizer";
    private static final String ATTR_ENTRY_HANDLER = "sunIdentityServerDiscoEntryHandler";
    private static final String ATTR_GLOBAL_ENTRY_HANDLER = "sunIdentityServerGlobalDiscoEntryHandler";
    private static final String ATTR_ID_MAPPER = "sunIdentityServerDiscoProviderResourceIDMapper";
    private static final String KEY_PROVIDER_ID = "providerid";
    private static final String KEY_IDMAPPER = "idmapper";
    private static final String ATTR_BOOTSTRAPPING_DISCO_ENTRY = "sunIdentityServerBootstrappingDiscoEntry";
    private static final String ATTR_BOOTSTRAPPING_SESSION_CONTEXT = "sunIdentityServerBootstrappingSessionContext";
    private static final String NEED_SESSION_CONTEXT_DEFAULT = "false";
    private static final String ATTR_BOOTSTRAPPING_ENCRYPT_NI = "sunIdentityServerBootstrappingEncryptNIinSessionContext";
    private static final String ENCRYPT_NI_DEFAULT = "false";
    private static final String ATTR_BOOTSTRAPPING_IMPLIED_RESOURCE = "sunIdentityServerBootstrappingImpliedResource";
    private static final String USE_IMPLIED_RESOURCE_DEFAULT = "false";
    private static final String ATTR_OPTION_SECURITY_RESPONSE = "sunIdentityServerDiscoOptionSecurityResponse";
    private static final String USE_RESPONSE_AUTHENTICATION_DEFAULT = "false";
    private static final String ATTR_NAMEID_MAPPER = "sunIdentityServerDiscoNameIdentifierMapper";
    private static Debug debug = Debug.getInstance((String)"libDisco");
    private static ConfigurationInstance ci = null;
    private static JAXBContext jc = null;
    private static String selfProviderID = null;
    private static Set authnMechs = null;
    private static Set supportedDirectives = null;
    private static boolean policyEvalLookup = false;
    private static boolean policyEvalUpdate = false;
    private static Authorizer authorizer = null;
    private static DiscoEntryHandler entryHandler = null;
    private static DiscoEntryHandler globalEntryHandler = null;
    private static Map idMappers = null;
    private static String bootDiscoEntryStr = null;
    private static boolean requireSessionContextStmt = false;
    private static boolean encryptNI = false;
    private static boolean useImpliedRes = false;
    private static boolean useRespAuth = false;
    private static NameIdentifierMapper nameIdMapper = null;

    private DiscoServiceManager() {
    }

    public void configChanged(ConfigurationActionEvent e) {
        debug.message("DiscoServiceManager.configChanged.");
        DiscoServiceManager.setValues();
    }

    public static synchronized String getDiscoProviderID() {
        return selfProviderID;
    }

    public static Set getSupportedAuthenticationMechanisms() {
        return authnMechs;
    }

    public static Set getSupportedDirectives() {
        return supportedDirectives;
    }

    public static boolean needPolicyEvalLookup() {
        return policyEvalLookup;
    }

    public static boolean needPolicyEvalUpdate() {
        return policyEvalUpdate;
    }

    public static Authorizer getAuthorizer() {
        return authorizer;
    }

    public static synchronized NameIdentifierMapper getNameIdentifierMapper() {
        return nameIdMapper;
    }

    public static synchronized DiscoEntryHandler getDiscoEntryHandler() {
        return entryHandler;
    }

    public static synchronized DiscoEntryHandler getGlobalEntryHandler() {
        return globalEntryHandler;
    }

    public static synchronized ResourceIDMapper getResourceIDMapper(String providerID) {
        if (idMappers == null || providerID == null) {
            return null;
        }
        return (ResourceIDMapper)idMappers.get(providerID);
    }

    public static ResourceIDMapper getDefaultResourceIDMapper() {
        return new Default64ResourceIDMapper();
    }

    public static synchronized DiscoEntryElement getBootstrappingDiscoEntry() {
        DiscoEntryElement bootDiscoEntry = null;
        if (bootDiscoEntryStr != null && bootDiscoEntryStr.length() != 0) {
            try {
                Unmarshaller u = jc.createUnmarshaller();
                bootDiscoEntry = (DiscoEntryElement)u.unmarshal((Source)new StreamSource(new StringReader(bootDiscoEntryStr)));
            }
            catch (Exception e) {
                debug.error("DiscoServiceManager.setValues: Exception when creating Disco Resource Offering:", (Throwable)e);
                bootDiscoEntry = null;
            }
        } else {
            if (debug.messageEnabled()) {
                debug.message("DiscoServiceManager.setValues: no Discovery Resource Offering specified.");
            }
            bootDiscoEntry = null;
        }
        return bootDiscoEntry;
    }

    private static synchronized void setValues() {
        try {
            Map attrsMap;
            block33: {
                String niMapperName;
                block32: {
                    String globalHandler;
                    block31: {
                        String handlerName;
                        block30: {
                            attrsMap = ci.getConfiguration(null, null);
                            selfProviderID = CollectionHelper.getMapAttr((Map)attrsMap, (String)ATTR_PROVIDER_ID);
                            authnMechs = (Set)attrsMap.get(ATTR_SUPPORTED_AUTHN_MECHS);
                            supportedDirectives = (Set)attrsMap.get(ATTR_SUPPORTED_DIRECTIVE);
                            policyEvalLookup = Boolean.valueOf(CollectionHelper.getMapAttr((Map)attrsMap, (String)ATTR_LOOKUP_NEED_POLICY, (String)"false"));
                            policyEvalUpdate = Boolean.valueOf(CollectionHelper.getMapAttr((Map)attrsMap, (String)ATTR_UPDATE_NEED_POLICY, (String)"false"));
                            authorizer = null;
                            String authorizerName = CollectionHelper.getMapAttr((Map)attrsMap, (String)ATTR_AUTHORIZER);
                            if (authorizerName != null && authorizerName.length() != 0) {
                                try {
                                    authorizer = (Authorizer)Class.forName(authorizerName).newInstance();
                                }
                                catch (Exception e) {
                                    if (!debug.messageEnabled()) break block30;
                                    debug.error("DiscoServiceManager.setValues: Exception when instantiating authorizer. Using default Authorizer. Exception", (Throwable)e);
                                }
                            }
                        }
                        if ((handlerName = CollectionHelper.getMapAttr((Map)attrsMap, (String)ATTR_ENTRY_HANDLER)) != null && handlerName.length() != 0) {
                            try {
                                entryHandler = (DiscoEntryHandler)Class.forName(handlerName).newInstance();
                            }
                            catch (Exception e) {
                                if (!debug.messageEnabled()) break block31;
                                debug.error("DiscoServiceManager.setValues: Exception when instantiating entry handler:", (Throwable)e);
                            }
                        }
                    }
                    if ((globalHandler = CollectionHelper.getMapAttr((Map)attrsMap, (String)ATTR_GLOBAL_ENTRY_HANDLER)) != null && globalHandler.length() != 0) {
                        try {
                            globalEntryHandler = (DiscoEntryHandler)Class.forName(globalHandler).newInstance();
                        }
                        catch (Exception e) {
                            if (!debug.messageEnabled()) break block32;
                            debug.error("DiscoServiceManager.setValues: Exception when instantiating global entry handler:", (Throwable)e);
                        }
                    }
                }
                if ((niMapperName = CollectionHelper.getMapAttr((Map)attrsMap, (String)ATTR_NAMEID_MAPPER)) != null && niMapperName.length() != 0) {
                    try {
                        if (debug.messageEnabled()) {
                            debug.message("DiscoServiceManager.setValues: disco name id mapper=" + niMapperName);
                        }
                        nameIdMapper = (NameIdentifierMapper)Class.forName(niMapperName).newInstance();
                    }
                    catch (Exception e) {
                        if (!debug.messageEnabled()) break block33;
                        debug.error("DiscoServiceManager.setValues: Exception when instantiating nameid mapper:", (Throwable)e);
                    }
                }
            }
            Set values = (Set)attrsMap.get(ATTR_ID_MAPPER);
            HashMap<String, ResourceIDMapper> newIDMapper = new HashMap<String, ResourceIDMapper>();
            if (values != null) {
                Iterator iter = values.iterator();
                while (iter.hasNext()) {
                    String value = (String)iter.next();
                    StringTokenizer stz = new StringTokenizer(value, "|");
                    if (stz.countTokens() == 2) {
                        String providerID = null;
                        ResourceIDMapper mapper = null;
                        while (stz.hasMoreTokens()) {
                            String token = stz.nextToken();
                            int pos = -1;
                            pos = token.indexOf("=");
                            if (pos == -1) {
                                debug.error("DiscoServiceManager.setValues: illegal format for ResourceIDMapper:" + token);
                                break;
                            }
                            int nextpos = pos + 1;
                            if (nextpos >= token.length()) {
                                debug.error("DiscoServiceManager.setValues: illegal format of ResourceIDMapper:" + token);
                                break;
                            }
                            String key = token.substring(0, pos);
                            if (key.equalsIgnoreCase(KEY_PROVIDER_ID)) {
                                providerID = token.substring(nextpos);
                                continue;
                            }
                            if (key.equalsIgnoreCase(KEY_IDMAPPER)) {
                                try {
                                    mapper = (ResourceIDMapper)Class.forName(token.substring(nextpos)).newInstance();
                                    continue;
                                }
                                catch (Exception e) {
                                    debug.error("DiscoServiceManager.setValues: couldn't instantiate ResourceIDMapper: " + token + ":", (Throwable)e);
                                    break;
                                }
                            }
                            debug.error("DiscoServiceManager.setValues: illegal format of ResourceIDMapper:" + token);
                            break;
                        }
                        if (providerID == null || mapper == null) {
                            debug.error("DiscoServiceManager.setValues: Invalid syntax for ResourceIDMapper:" + value);
                            continue;
                        }
                        newIDMapper.put(providerID, mapper);
                        continue;
                    }
                    if (!debug.warningEnabled()) continue;
                    debug.warning("DiscoServiceManager.setValues: Invalid syntax for ResourceIDMapper:" + value);
                }
            }
            idMappers = newIDMapper;
            bootDiscoEntryStr = CollectionHelper.getMapAttr((Map)attrsMap, (String)ATTR_BOOTSTRAPPING_DISCO_ENTRY);
            DiscoServiceManager.tagswapBootDiscoEntry();
            requireSessionContextStmt = Boolean.valueOf(CollectionHelper.getMapAttr((Map)attrsMap, (String)ATTR_BOOTSTRAPPING_SESSION_CONTEXT, (String)"false"));
            if (debug.messageEnabled()) {
                debug.message("DiscoServiceManager.setValues: need Session Context Statement?" + requireSessionContextStmt);
            }
            encryptNI = Boolean.valueOf(CollectionHelper.getMapAttr((Map)attrsMap, (String)ATTR_BOOTSTRAPPING_ENCRYPT_NI, (String)"false"));
            if (debug.messageEnabled()) {
                debug.message("DiscoServiceManager.setValues: encrypt NI in Session Context?" + encryptNI);
            }
            useImpliedRes = Boolean.valueOf(CollectionHelper.getMapAttr((Map)attrsMap, (String)ATTR_BOOTSTRAPPING_IMPLIED_RESOURCE, (String)"false"));
            if (debug.messageEnabled()) {
                debug.message("DiscoServiceManager.setValues: use implied resource?" + useImpliedRes);
            }
            useRespAuth = Boolean.valueOf(CollectionHelper.getMapAttr((Map)attrsMap, (String)ATTR_OPTION_SECURITY_RESPONSE, (String)"false"));
            if (debug.messageEnabled()) {
                debug.message("DiscoServiceManager.setValues: use response authentication?" + useRespAuth);
            }
        }
        catch (Exception e) {
            debug.error("DiscoServiceManager.setValues: Exception", (Throwable)e);
        }
    }

    private static void tagswapBootDiscoEntry() {
        bootDiscoEntryStr = bootDiscoEntryStr.replaceAll("%SERVER_PROTO%", SystemConfigurationUtil.getProperty("com.iplanet.am.server.protocol"));
        bootDiscoEntryStr = bootDiscoEntryStr.replaceAll("%SERVER_HOST%", SystemConfigurationUtil.getProperty("com.iplanet.am.server.host"));
        bootDiscoEntryStr = bootDiscoEntryStr.replaceAll("%SERVER_PORT%", SystemConfigurationUtil.getProperty("com.iplanet.am.server.port"));
        bootDiscoEntryStr = bootDiscoEntryStr.replaceAll("%SERVER_URI%", SystemConfigurationUtil.getProperty("com.iplanet.am.services.deploymentDescriptor"));
    }

    public static boolean needSessionContextStatement() {
        return requireSessionContextStmt;
    }

    public static boolean encryptNIinSessionContext() {
        return encryptNI;
    }

    public static boolean useResponseAuthentication() {
        return useRespAuth;
    }

    public static boolean useImpliedResource() {
        return useImpliedRes;
    }

    static {
        try {
            ci = ConfigurationManager.getConfigurationInstance("DISCO");
            ci.addListener(new DiscoServiceManager());
            jc = JAXBContext.newInstance((String)Utils.getJAXBPackages());
            DiscoServiceManager.setValues();
        }
        catch (ConfigurationException ce) {
            debug.error("DiscoServiceManager.static:", (Throwable)((Object)ce));
        }
        catch (JAXBException jex) {
            debug.error("DiscoServiceManager.static: Unable to get JAXBContext:", (Throwable)jex);
        }
    }
}

