/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.protocol;

import com.sun.identity.liberty.ws.authnsvc.AuthnSvcException;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.protocol.GenericTransform;
import com.sun.identity.liberty.ws.authnsvc.protocol.LowercaseTransform;
import com.sun.identity.liberty.ws.authnsvc.protocol.Parameter;
import com.sun.identity.liberty.ws.authnsvc.protocol.SelectTransform;
import com.sun.identity.liberty.ws.authnsvc.protocol.TruncationTransform;
import com.sun.identity.liberty.ws.authnsvc.protocol.UppercaseTransform;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Transform {
    public static final String TRUNCATION_URI = "urn:liberty:sa:pw:truncate";
    public static final String LOWERCASE_URI = "urn:liberty:sa:pw:lowercase";
    public static final String UPPERCASE_URI = "urn:liberty:sa:pw:uppercase";
    public static final String SELECT_URI = "urn:liberty:sa:pw:select";
    private static final String TRANSFORM_CLASSES = "com.sun.identity.liberty.ws.authnsvc.transformClasses";
    private static Map transformClasses = new HashMap();
    protected String name = null;
    protected String id = null;
    protected List parameters = null;

    static Transform getTransform(Element element) throws AuthnSvcException {
        String name = XMLUtils.getNodeAttributeValue((Node)element, (String)"name");
        if (name == null || name.length() == 0) {
            throw new AuthnSvcException("missingNameTF");
        }
        Transform tf = null;
        String className = (String)transformClasses.get(name);
        if (className != null) {
            try {
                tf = (Transform)Class.forName(className).newInstance();
            }
            catch (Throwable t) {
                if (AuthnSvcUtils.debug.warningEnabled()) {
                    AuthnSvcUtils.debug.warning("Transform.getTransform class = " + className, t);
                }
                transformClasses.remove(name);
            }
        }
        if (tf == null) {
            tf = name.equals(TRUNCATION_URI) ? new TruncationTransform() : (name.equals(LOWERCASE_URI) ? new LowercaseTransform() : (name.equals(UPPERCASE_URI) ? new UppercaseTransform() : (name.equals(SELECT_URI) ? new SelectTransform() : new GenericTransform(name))));
        }
        String id = XMLUtils.getNodeAttributeValue((Node)element, (String)"id");
        tf.setId(id);
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        ArrayList<Parameter> parameters = null;
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            Element childElement = (Element)child;
            String localName = childElement.getLocalName();
            String namespaceURI = childElement.getNamespaceURI();
            if ("urn:liberty:sa:2004-04".equals(namespaceURI) && "Parameter".equals(localName)) {
                Parameter parameter = new Parameter(childElement);
                if (parameters == null) {
                    parameters = new ArrayList<Parameter>();
                }
                parameters.add(parameter);
                continue;
            }
            throw new AuthnSvcException("invalidChildTF");
        }
        tf.setParameters(parameters);
        return tf;
    }

    public abstract String transform(String var1);

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public List getParameters() {
        return this.parameters;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParameters(List parameters) {
        this.parameters = parameters;
    }

    void addToParent(Element ptE) throws AuthnSvcException {
        if (this.name == null || this.name.length() == 0) {
            throw new AuthnSvcException("missingNameTF");
        }
        Document doc = ptE.getOwnerDocument();
        Element tfE = doc.createElementNS("urn:liberty:sa:2004-04", "sa:Transform");
        ptE.appendChild(tfE);
        tfE.setAttributeNS(null, "name", this.name);
        if (this.id != null) {
            tfE.setAttributeNS(null, "id", this.id);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            Iterator iter = this.parameters.iterator();
            while (iter.hasNext()) {
                Parameter parameter = (Parameter)iter.next();
                parameter.addToParent(tfE);
            }
        }
    }

    static {
        String tmpstr = SystemPropertiesManager.get((String)TRANSFORM_CLASSES);
        if (tmpstr != null && tmpstr.length() > 0) {
            StringTokenizer stz = new StringTokenizer(tmpstr, ",");
            while (stz.hasMoreTokens()) {
                String token = stz.nextToken().trim();
                int index = token.indexOf(124);
                if (index != -1 && index != 0 && index != token.length() - 1) {
                    String name = token.substring(0, index);
                    String className = token.substring(index + 1);
                    if (AuthnSvcUtils.debug.messageEnabled()) {
                        AuthnSvcUtils.debug.message("Transform.static: add " + token);
                    }
                    transformClasses.put(name, className);
                    continue;
                }
                if (!AuthnSvcUtils.debug.warningEnabled()) continue;
                AuthnSvcUtils.debug.warning("Transform.static: Invalid syntax for Transform Classes List: " + token);
            }
        }
    }
}

