/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.util;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.util.FSSignatureException;
import com.sun.identity.federation.services.util.FSSignatureManager;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;

public class FSSignatureUtil {
    public static String signAndReturnQueryString(String queryString, String certAlias) {
        FSUtils.debug.message("FSSignatureUtil.signAndReturnQueryString: Called");
        if (queryString == null || queryString.length() == 0) {
            FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: " + FSUtils.bundle.getString("nullInput"));
            return null;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSignatureUtil.signAndReturnQueryString: queryString: " + queryString);
        }
        if (certAlias == null || certAlias.length() == 0) {
            FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: " + FSUtils.bundle.getString("nullInput"));
            return null;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSignatureUtil.signAndReturnQueryString: certAlias: " + certAlias);
        }
        FSSignatureManager manager = FSSignatureManager.getInstance();
        String sigAlg = "SHA1withRSA";
        if (manager.getKeyProvider().getPrivateKey(certAlias).getAlgorithm().equals("RSA")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSignatureUtil.signAndReturnQueryString: private key algorithm is: RSA");
            }
            sigAlg = "SHA1withRSA";
        } else if (manager.getKeyProvider().getPrivateKey(certAlias).getAlgorithm().equals("DSA")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSignatureUtil.signAndReturnQueryString: private key algorithm is: DSA");
            }
            sigAlg = "SHA1withDSA";
        } else {
            FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: private key algorithm is not supported");
            return null;
        }
        byte[] signature = null;
        if (queryString.charAt(queryString.length() - 1) != '&') {
            queryString = queryString + "&";
        }
        String algoId = null;
        if (sigAlg.equals("SHA1withDSA")) {
            algoId = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        } else if (sigAlg.equals("SHA1withRSA")) {
            algoId = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else {
            FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: Invalid signature algorithim");
            return null;
        }
        queryString = queryString + "SigAlg=" + URLEncDec.encode((String)algoId);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSignatureUtil.signAndReturnQueryString: Querystring to be signed: " + queryString);
        }
        try {
            signature = manager.signBuffer(queryString, certAlias, sigAlg);
        }
        catch (FSSignatureException se) {
            FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: FSSignatureException occured while signing query string: ", (Throwable)((Object)se));
            return null;
        }
        if (signature == null) {
            FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: Signature generated is null");
            return null;
        }
        String encodedSig = Base64.encode((byte[])signature);
        queryString = queryString + "&" + "Signature=" + URLEncDec.encode((String)encodedSig);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSignatureUtil.signAndReturnQueryString:Signed Querystring: " + queryString);
        }
        return queryString;
    }

    public static boolean verifyRequestSignature(HttpServletRequest request, X509Certificate cert) {
        FSUtils.debug.message("FSSignatureUtil.verifyRequestSignature: Called");
        try {
            if (cert == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSignatureUtil.verifyRequestSignature: couldn't obtain this site's cert.");
                }
                return false;
            }
            String sigAlg = request.getParameter("SigAlg");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("sigAlg : " + sigAlg);
            }
            String encSig = request.getParameter("Signature");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("encSig : " + encSig);
            }
            if (sigAlg == null || sigAlg.length() == 0 || encSig == null || encSig.length() == 0) {
                return false;
            }
            String algoId = null;
            if (sigAlg.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                algoId = "SHA1withDSA";
            } else if (sigAlg.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                algoId = "SHA1withRSA";
            } else {
                FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: Invalid signature algorithim");
                return false;
            }
            String queryString = request.getQueryString();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSignatureUtil.verifyRequestSignature:queryString to be verifed:" + queryString);
            }
            int sigIndex = queryString.indexOf("&Signature");
            String newQueryString = queryString.substring(0, sigIndex);
            byte[] signature = null;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSignatureUtil.verifyRequestSignature: Signature: " + encSig);
            }
            signature = Base64.decode((String)encSig);
            FSSignatureManager fsmanager = FSSignatureManager.getInstance();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSignatureUtil.verifyRequestSignature: String to be verified: " + newQueryString);
            }
            return fsmanager.verifySignature(newQueryString, signature, algoId, cert);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSignatureUtil.verifyRequestSignature: Exception occured while verifying SP's signature:", (Throwable)e);
            return false;
        }
    }
}

