/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.util;

import com.sun.identity.common.SystemConfigurationException;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.plugins.FederationSPAdapter;
import com.sun.identity.federation.services.FSSPAuthenticationContextInfo;
import com.sun.identity.liberty.ws.meta.jaxb.AffiliationDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FSServiceUtils {
    private static IDFFMetaManager metaManager = null;
    private static MessageFactory fac = null;
    private static List cookieList = null;
    private static boolean signingOn = false;
    private static boolean signingOptional = false;
    private static final String templatePath = "/config/federation";

    private FSServiceUtils() {
    }

    public static boolean isSigningOn() {
        return signingOn;
    }

    public static boolean isSigningOptional() {
        return signingOptional;
    }

    public static String getCommonLoginPageURL(String metaAlias, String resourceUrl, String requestId, HttpServletRequest request, String baseURL) {
        if (metaAlias == null || metaAlias.equals("")) {
            FSUtils.debug.error("FSServiceUtils.getCommonLoginPageURL: metaAlias is null");
            return null;
        }
        String realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
        BaseConfigType hostConfig = null;
        try {
            String role = metaManager.getProviderRoleByMetaAlias(metaAlias);
            String entityId = metaManager.getEntityIDByMetaAlias(metaAlias);
            if (role != null) {
                if (role.equalsIgnoreCase("SP")) {
                    hostConfig = metaManager.getSPDescriptorConfig(realm, entityId);
                } else if (role.equalsIgnoreCase("IDP")) {
                    hostConfig = metaManager.getIDPDescriptorConfig(realm, entityId);
                }
            }
        }
        catch (Exception e) {
            FSUtils.debug.error("FSServiceUtils.getCommonLoginPageURL: Could not obtain local config");
            return null;
        }
        if (hostConfig == null) {
            FSUtils.debug.error("FSServiceUtils.getCommonLoginPageURL: Could not obtain hosted extended meta.");
            return null;
        }
        String loginPageUrl = FSServiceUtils.getCommonLoginPageURL(request, hostConfig);
        StringBuffer commonLoginPageUrl = new StringBuffer(loginPageUrl);
        if (loginPageUrl.indexOf(63) == -1) {
            commonLoginPageUrl.append("?");
        } else {
            commonLoginPageUrl.append("&");
        }
        commonLoginPageUrl.append("metaAlias").append("=").append(metaAlias).append("&");
        String postloginUrl = baseURL + "/postLogin";
        StringBuffer gotoBuffer = new StringBuffer(postloginUrl);
        if (postloginUrl.indexOf(63) == -1) {
            gotoBuffer.append("?");
        } else {
            gotoBuffer.append("&");
        }
        gotoBuffer.append("metaAlias").append("=").append(metaAlias).append("&");
        if (resourceUrl == null || resourceUrl.length() == 0) {
            resourceUrl = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostConfig, "providerHomePageURL");
        }
        if (resourceUrl != null && !resourceUrl.equals("")) {
            gotoBuffer.append("RelayState").append("=").append(URLEncDec.encode((String)resourceUrl));
            commonLoginPageUrl.append("RelayState").append("=").append(URLEncDec.encode((String)resourceUrl)).append("&");
        }
        commonLoginPageUrl.append("goto").append("=").append(URLEncDec.encode((String)gotoBuffer.toString()));
        String org = FSUtils.getAuthDomainURL(realm);
        if (org != null && org.length() != 0) {
            commonLoginPageUrl.append("&").append("org").append("=").append(URLEncDec.encode((String)org));
        }
        if (requestId != null && !requestId.equals("")) {
            commonLoginPageUrl.append("&").append("RequestID").append("=").append(URLEncDec.encode((String)requestId));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSServiceUtils.getCommonLoginPageURL: List LoginPage: " + commonLoginPageUrl.toString());
        }
        return commonLoginPageUrl.toString();
    }

    public static String getBaseURL() {
        String deployDesc = SystemConfigurationUtil.getProperty("com.iplanet.am.services.deploymentDescriptor");
        String protocol = SystemConfigurationUtil.getProperty("com.iplanet.am.server.protocol");
        String host = SystemConfigurationUtil.getProperty("com.iplanet.am.server.host");
        String port = SystemConfigurationUtil.getProperty("com.iplanet.am.server.port");
        return protocol + "://" + host + ":" + port + deployDesc;
    }

    public static String getMetaAlias(HttpServletRequest request) {
        int index;
        String uri = request.getRequestURI();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSServiceUtil.getMetaAlias request uri = " + uri);
        }
        if ((index = uri.indexOf("metaAlias")) == -1 || index + "metaAlias".length() == uri.length()) {
            FSUtils.debug.message("FSServiceUtil.getMetaAlias no metaAlias in request");
            return null;
        }
        return uri.substring(index + "metaAlias".length());
    }

    public static String getLocale(HttpServletRequest request) {
        if (request == null) {
            FSUtils.debug.error("FSServiceUtil.getLocale: Request param is null, returning null");
            return null;
        }
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object ISSSOToken = sessionProvider.getSession(request);
            String[] returnStr = sessionProvider.getProperty(ISSSOToken, "Locale");
            if (returnStr != null && returnStr.length > 0) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSServiceUtil.getLocale returning locale from token " + returnStr[0]);
                }
                return returnStr[0];
            }
        }
        catch (SessionException ssoe) {
            FSUtils.debug.error("FSServiceUtil::getLocale():SessionException:", (Throwable)((Object)ssoe));
        }
        catch (UnsupportedOperationException ex) {
            FSUtils.debug.error("FSServiceUtil::getLocale():Exception:", (Throwable)ex);
        }
        Locale locale = request.getLocale();
        if (locale != null) {
            String returnStr = locale.toString();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSServiceUtil.getLocale returning :locale from request:" + returnStr);
            }
            return returnStr;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSServiceUtil.getLocale Not able to get locale from request either from token or header. returning null ");
        }
        return null;
    }

    public static String getServicesBaseURL(HttpServletRequest request) {
        String protocol = request.getScheme();
        String host = request.getServerName();
        int port = request.getServerPort();
        String deployDesc = SystemConfigurationUtil.getProperty("com.iplanet.am.services.deploymentDescriptor");
        String amserverURI = protocol + "://" + host + ":" + port + deployDesc;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSServiceUtil.getServicesBaseURL hostString is " + amserverURI);
        }
        return amserverURI;
    }

    public static String getBaseURL(HttpServletRequest request) {
        int endIndex;
        int startIndex;
        if (request == null) {
            return FSServiceUtils.getBaseURL();
        }
        String protocol = request.getScheme();
        String hostStr = protocol + "://" + request.getHeader("Host") + "/";
        String requestURL = request.getRequestURL().toString();
        String tmpurl = null;
        tmpurl = protocol.equals("http") ? requestURL.substring(8) : requestURL.substring(9);
        String tmpStr = tmpurl.substring(startIndex = tmpurl.indexOf("/") + 1);
        String deployDesc = tmpStr.substring(0, endIndex = tmpStr.indexOf("/"));
        if (deployDesc != null && deployDesc != "") {
            String returnStr = hostStr + deployDesc;
            return returnStr;
        }
        return hostStr;
    }

    public static String printDocument(Node root) throws TransformerException, TransformerConfigurationException, FileNotFoundException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(root), new StreamResult(writer));
        return writer.getBuffer().toString();
    }

    public static Node createSOAPDOM(SOAPMessage message) {
        try {
            ByteArrayOutputStream str = new ByteArrayOutputStream();
            message.writeTo((OutputStream)str);
            String xml = str.toString();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSU.createSOAPDOM, Intermediate xml: " + xml);
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(xml.getBytes()));
            return doc;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSServiceUtils.createSOAPDOM: Exception: ", (Throwable)e);
            return null;
        }
    }

    public static SOAPMessage convertDOMToSOAP(Document doc) {
        try {
            MimeHeaders headers = new MimeHeaders();
            headers.addHeader("Content-Type", "text/xml");
            return fac.createMessage(headers, (InputStream)new ByteArrayInputStream(FSServiceUtils.printDocument(doc).getBytes()));
        }
        catch (Exception e) {
            FSUtils.debug.error("FSServiceUtils.convertDOMToSOAP: Exception: " + e.getMessage());
            return null;
        }
    }

    public static boolean isLECPProfile(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String hn = headerNames.nextElement().toString();
            String hv = request.getHeader(hn);
            if (!FSUtils.debug.messageEnabled()) continue;
            FSUtils.debug.message("header " + hn + " val " + hv);
        }
        String lecpHeaderValue = request.getHeader("Liberty-Enabled");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message(" value of lecp in header " + lecpHeaderValue);
        }
        if (lecpHeaderValue == null) {
            lecpHeaderValue = request.getHeader("Liberty-Enabled".toLowerCase());
        }
        return lecpHeaderValue != null;
    }

    public static synchronized List getCookieDomainList() {
        return cookieList;
    }

    public static String getAffiliationID(String realm, String entityID) {
        Set affiliations;
        if (metaManager != null && (affiliations = metaManager.getAffiliateEntity(realm, entityID)) != null && !affiliations.isEmpty()) {
            AffiliationDescriptorType affiliateDescriptor = (AffiliationDescriptorType)affiliations.iterator().next();
            return affiliateDescriptor.getAffiliationID();
        }
        return null;
    }

    public static Map parseAttributeConfig(List list) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (list == null || list.isEmpty()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSServiceUtils.parseAttributeConfig: Input put list is empty");
            }
            return map;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String entry = (String)iter.next();
            if (entry.indexOf("=") == -1) continue;
            StringTokenizer st = new StringTokenizer(entry, "=");
            map.put(st.nextToken(), st.nextToken());
        }
        return map;
    }

    public static void showErrorPage(HttpServletResponse response, String commonErrorPage, String errorLocaleString, String remarkLocaleString) {
        StringBuffer errorPage = new StringBuffer();
        errorPage.append(commonErrorPage);
        char delimiter = commonErrorPage.indexOf(63) < 0 ? (char)'?' : '&';
        errorPage.append(delimiter).append("federror").append('=').append(URLEncDec.encode((String)FSUtils.bundle.getString(errorLocaleString))).append('&').append("fedremark").append('=').append(URLEncDec.encode((String)FSUtils.bundle.getString(remarkLocaleString)));
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Redirecting to Error page : " + errorPage.toString());
        }
        try {
            response.sendRedirect(errorPage.toString());
        }
        catch (IOException e) {
            FSUtils.debug.error("Failed to redirect to error page");
        }
    }

    public static void redirectForAuthentication(HttpServletRequest request, HttpServletResponse response, String hostedProviderAlias) throws IOException {
        FSUtils.debug.message("Entered FSServiceUtils::redirectForAuthentication");
        try {
            StringBuffer authURL = new StringBuffer();
            authURL.append(FSServiceUtils.getBaseURL(request)).append("/preLogin");
            char authDelimiter = authURL.toString().indexOf(63) < 0 ? (char)'?' : '&';
            authURL.append(authDelimiter).append("metaAlias").append('=').append(hostedProviderAlias);
            String parameterString = FSServiceUtils.getParameterString(request);
            if (parameterString != null && parameterString.length() > 0) {
                authURL.append('&').append(parameterString);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Redirecting for authentication to: " + authURL.toString());
            }
            response.sendRedirect(authURL.toString());
            return;
        }
        catch (IOException e) {
            FSUtils.debug.error("Error when redirecting : ", (Throwable)e);
            return;
        }
    }

    private static String getParameterString(HttpServletRequest request) {
        StringBuffer parameterString = new StringBuffer();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String paramName = e.nextElement().toString();
            String[] values = request.getParameterValues(paramName);
            for (int i = 0; values != null && i < values.length; ++i) {
                parameterString.append(paramName).append('=').append(values[i]).append('&');
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Parameter String: " + parameterString);
        }
        return parameterString.toString();
    }

    public static void returnLocallyAfterOperation(HttpServletResponse response, String opDoneURL, boolean isSuccess, String successString, String failureString) {
        try {
            StringBuffer finalReturnURL = new StringBuffer();
            finalReturnURL.append(opDoneURL);
            char delimiter = opDoneURL.indexOf(63) < 0 ? (char)'?' : '&';
            finalReturnURL.append(delimiter).append("logoutStatus").append('=');
            if (isSuccess) {
                finalReturnURL.append(successString);
            } else {
                finalReturnURL.append(failureString);
            }
            response.sendRedirect(finalReturnURL.toString());
            return;
        }
        catch (IOException e) {
            FSUtils.debug.error("Redirect failed. Control halted:", (Throwable)e);
            return;
        }
    }

    public static void returnToSource(HttpServletResponse response, String retURL, String commonErrorPage, String errorLocaleString, String remarkLocaleString) {
        try {
            if (retURL == null || retURL.length() < 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("returnToSource returns sendErroras source provider is unknown");
                }
                FSServiceUtils.showErrorPage(response, commonErrorPage, errorLocaleString, remarkLocaleString);
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("returnToSource returns URL : " + retURL);
            }
            response.sendRedirect(retURL);
            return;
        }
        catch (IOException exx) {
            FSUtils.debug.error("Redirect/sendError failed. Control halted:", (Throwable)exx);
            return;
        }
    }

    public static String getConsentPageURL(HttpServletRequest request, BaseConfigType hostedConfig) {
        String tempUrl = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "listOfCOTsPageURL");
        if (tempUrl == null || tempUrl.length() == 0) {
            tempUrl = FSServiceUtils.getDefaultPageURL(request, "ListOfCOTs.jsp");
        }
        return tempUrl;
    }

    public static String getCommonLoginPageURL(HttpServletRequest request, BaseConfigType hostedConfig) {
        String tempUrl = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "ssoFailureRedirectURL");
        if (tempUrl == null || tempUrl.length() == 0) {
            tempUrl = FSServiceUtils.getDefaultPageURL(request, "CommonLogin.jsp");
        }
        return tempUrl;
    }

    public static String getErrorPageURL(HttpServletRequest request, BaseConfigType hostedConfig, String metaAlias) {
        String tempUrl = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "errorPageURL");
        if (tempUrl == null || tempUrl.length() == 0) {
            tempUrl = FSServiceUtils.getDefaultPageURL(request, "Error.jsp");
        }
        return FSServiceUtils.addMetaAlias(tempUrl, metaAlias);
    }

    public static String getTerminationDonePageURL(HttpServletRequest request, BaseConfigType hostedConfig, String metaAlias) {
        String tempUrl = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "terminationDoneURL");
        if (tempUrl == null || tempUrl.length() == 0) {
            tempUrl = FSServiceUtils.getDefaultPageURL(request, "TerminationDone.jsp");
        }
        return FSServiceUtils.addMetaAlias(tempUrl, metaAlias);
    }

    public static String getRegistrationDonePageURL(HttpServletRequest request, BaseConfigType hostedConfig, String metaAlias) {
        String tempUrl = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "registrationDoneURL");
        if (tempUrl == null || tempUrl.length() == 0) {
            tempUrl = FSServiceUtils.getDefaultPageURL(request, "NameRegistrationDone.jsp");
        }
        return FSServiceUtils.addMetaAlias(tempUrl, metaAlias);
    }

    public static String getLogoutDonePageURL(HttpServletRequest request, BaseConfigType hostedConfig, String metaAlias) {
        String tempUrl = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "logoutDoneURL");
        if (tempUrl == null || tempUrl.length() == 0) {
            tempUrl = FSServiceUtils.getDefaultPageURL(request, "LogoutDone.jsp");
        }
        return FSServiceUtils.addMetaAlias(tempUrl, metaAlias);
    }

    public static String getFederationDonePageURL(HttpServletRequest request, BaseConfigType hostedConfig, String metaAlias) {
        String tempUrl = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "federationDoneURL");
        if (tempUrl == null || tempUrl.length() == 0) {
            tempUrl = FSServiceUtils.getDefaultPageURL(request, "FederationDone.jsp");
        }
        return FSServiceUtils.addMetaAlias(tempUrl, metaAlias);
    }

    public static String getDoFederatePageURL(HttpServletRequest request, BaseConfigType hostedConfig) {
        String tempUrl = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "doFederatePageURL");
        if (tempUrl == null || tempUrl.length() == 0) {
            tempUrl = FSServiceUtils.getDefaultPageURL(request, "Federate.jsp");
        }
        return tempUrl;
    }

    public static String getDefaultPageURL(HttpServletRequest request, String pageName) {
        return FSServiceUtils.getBaseURL(request) + templatePath + "/" + "default" + "/" + pageName;
    }

    public static String addMetaAlias(String url, String metaAlias) {
        if (url == null || url.length() == 0 || metaAlias == null || metaAlias.length() == 0) {
            return url;
        }
        if (url.indexOf(63) == -1) {
            return url + '?' + "metaAlias" + '=' + metaAlias;
        }
        return url + '&' + "metaAlias" + '=' + metaAlias;
    }

    public static String getAssertionConsumerServiceURL(SPDescriptorType spDescriptor, String id) {
        if (spDescriptor == null) {
            return null;
        }
        Object matching = null;
        String defaultValue = null;
        String first = null;
        List urls = spDescriptor.getAssertionConsumerServiceURL();
        if (urls != null && !urls.isEmpty()) {
            Iterator iter = urls.iterator();
            SPDescriptorType.AssertionConsumerServiceURLType curUrl = null;
            while (iter.hasNext()) {
                curUrl = (SPDescriptorType.AssertionConsumerServiceURLType)iter.next();
                String curId = curUrl.getId();
                String curValue = curUrl.getValue();
                if (id != null && curId != null && curId.equals(id)) {
                    return curValue;
                }
                if (curUrl.isIsDefault()) {
                    defaultValue = curValue;
                }
                if (first != null) continue;
                first = curValue;
            }
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return first;
    }

    public static String getFirstProtocolProfile(List profiles) {
        String retVal = "";
        if (profiles == null || profiles.isEmpty()) {
            return retVal;
        }
        return (String)profiles.iterator().next();
    }

    public static Map getSPAuthContextInfo(BaseConfigType hostConfig) {
        if (hostConfig == null) {
            return null;
        }
        HashMap<String, FSSPAuthenticationContextInfo> retMap = new HashMap<String, FSSPAuthenticationContextInfo>();
        List mappings = IDFFMetaUtils.getAttributeValueFromConfig(hostConfig, "spAuthnContextMapping");
        if (mappings != null && !mappings.isEmpty()) {
            Iterator iter = mappings.iterator();
            while (iter.hasNext()) {
                String mapping = (String)iter.next();
                try {
                    FSSPAuthenticationContextInfo info = new FSSPAuthenticationContextInfo(mapping);
                    retMap.put(info.getAuthenticationContext(), info);
                }
                catch (FSException fe) {
                    FSUtils.debug.error("FSServiceUtils.getSPAuthContextInfo: wrong mapping:" + mapping + " with exception:", (Throwable)((Object)fe));
                }
            }
        }
        return retMap;
    }

    public static boolean isRegisProfileSOAP(String userID, String remoteEntityId, SPDescriptorType remoteDescriptor, String metaAlias, IDPDescriptorType hostedDescriptor) {
        FSAccountFedInfo acctInfo = null;
        try {
            acctInfo = FSAccountManager.getInstance(metaAlias).readAccountFedInfo(userID, remoteEntityId);
        }
        catch (FSAccountMgmtException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("in exception:", (Throwable)((Object)e));
            }
            return true;
        }
        String hostedProfile = FSServiceUtils.getFirstProtocolProfile(hostedDescriptor.getRegisterNameIdentifierProtocolProfile());
        String remoteProfile = FSServiceUtils.getFirstProtocolProfile(remoteDescriptor.getRegisterNameIdentifierProtocolProfile());
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("host profile is:" + hostedProfile + "\nremote profile is " + remoteProfile);
        }
        if (acctInfo.isRoleIDP()) {
            if (hostedProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || hostedProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
                return true;
            }
            if (hostedProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") || hostedProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
                return false;
            }
            FSUtils.debug.error("FSServiceUtils.isRegisProfileSOAP:Invalid registration profile.");
            return true;
        }
        if (remoteProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || remoteProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
            return true;
        }
        if (remoteProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") || remoteProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
            return false;
        }
        FSUtils.debug.error("FSServiceUtils.isRegisProfileSOAP:Invalid registration profile.");
        return true;
    }

    public static int getMinorVersion(List protocolEnum) {
        int ver = 0;
        if (protocolEnum == null || protocolEnum.isEmpty()) {
            FSUtils.debug.message("FSServiceUtils.getMinorVersion:null protocolEnum");
        } else {
            String minorVersion = (String)protocolEnum.iterator().next();
            if (minorVersion.equalsIgnoreCase("urn:liberty:iff:2002-12")) {
                ver = 0;
            } else if (minorVersion.equalsIgnoreCase("urn:liberty:iff:2003-08")) {
                ver = 2;
            }
        }
        return ver;
    }

    public static FederationSPAdapter getSPAdapter(String hostEntityID, BaseConfigType hostSPConfig) {
        FSUtils.debug.message("FSServiceUtils.getSPAdapter");
        if (hostSPConfig == null) {
            FSUtils.debug.message("FSServiceUtils.getSPAdapter:null");
            return null;
        }
        try {
            String adapterName = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostSPConfig, "federationSPAdapter");
            List adapterEnv = IDFFMetaUtils.getAttributeValueFromConfig(hostSPConfig, "federationSPAdapterEnv");
            String realm = IDFFMetaUtils.getRealmByMetaAlias(hostSPConfig.getMetaAlias());
            if (adapterName != null && adapterName.length() != 0) {
                Class<?> adapterClass = Class.forName(adapterName.trim());
                FederationSPAdapter adapterInstance = (FederationSPAdapter)adapterClass.newInstance();
                HashSet<String> newEnv = new HashSet<String>();
                if (adapterEnv != null && !adapterEnv.isEmpty()) {
                    newEnv.addAll(adapterEnv);
                }
                newEnv.add("REALM=" + realm);
                adapterInstance.initialize(hostEntityID, newEnv);
                return adapterInstance;
            }
        }
        catch (Exception e) {
            FSUtils.debug.error("FSServiceUtils.getSPAdapter: Unable to get provider", (Throwable)e);
        }
        return null;
    }

    static {
        try {
            fac = MessageFactory.newInstance();
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSServiceUtils::static block) could not get factory instance");
            ex.printStackTrace();
        }
        try {
            cookieList = SystemConfigurationUtil.getCookieDomains();
        }
        catch (SystemConfigurationException se) {
            FSUtils.debug.error("FSServiceUtils::staticBlock SystemConfigurationException while reading", (Throwable)((Object)se));
        }
        String signing = SystemConfigurationUtil.getProperty("com.sun.identity.federation.services.signingOn", "optional");
        if (signing.equalsIgnoreCase("true")) {
            signingOn = true;
        } else if (signing.equalsIgnoreCase("optional")) {
            signingOptional = true;
        }
        metaManager = FSUtils.getIDFFMetaManager();
    }
}

