/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.util;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.liberty.INameIdentifier;

public class FSNameIdentifierHelper {
    INameIdentifier generator = null;

    public FSNameIdentifierHelper(BaseConfigType hostedConfig) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSNameIdentifierGeneratorHelper constructor called");
        }
        try {
            String className = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "nameIDImplementationClass");
            this.generator = (INameIdentifier)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException exp) {
            FSUtils.debug.error("FSNameIdentifierGeneratorHelper constructor.Not able to create instance of Generator Impl", (Throwable)exp);
        }
        catch (Exception exp) {
            FSUtils.debug.error("FSNameIdentifierGeneratorHelper constructor.Not able to create instance of Generator Impl", (Throwable)exp);
        }
    }

    public String createNameIdentifier() {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSNameIdentifierGeneratorHelper.createNameIdentifier called");
        }
        if (this.generator != null) {
            return this.generator.createNameIdentifier();
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSNameIdentifierGeneratorHelper.createNameIdentifier returning null as generator is null");
        }
        return null;
    }
}

